/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.rap.controller.ICognosServiceRequest;
import com.cognos.rap.controller.RAPReport;
import com.cognos.rap.controller.ReportActionController;
import com.cognos.rap.exceptions.ActionControllerException;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.preprocessor.GODashboardPrepropcessor;
import com.cognos.viewer.action.ActionHelper;
import com.cognos.viewer.action.BuxSubAction;
import com.cognos.viewer.action.ModifyReportAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerBlankResponse;
import com.cognos.viewer.model.CognosServiceRequest;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.SOAPResponse;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class BuxExtractReportPartSubAction
extends BuxSubAction {
    public BuxExtractReportPartSubAction(ICognosViewerState state, CognosViewerServiceFactory factory) {
        this.initialize(state, factory);
    }

    @Override
    public SOAPResponse executeRequest() throws CognosViewerException {
        this.setupRunOptions();
        try {
            this.applyReportActionProcessorChanges();
        }
        catch (ActionControllerException e) {
            return ActionHelper.handleActionControllerException(e, this.m_state);
        }
        catch (Exception e) {
            this.m_state.getIPFLogger().error(e.getMessage(), e, this.getClass().getName());
            this.m_state.setFormFieldFromString("ui.spec", ModifyReportAction.getEmptyReportSpec());
        }
        return new CMServerBlankResponse(this.m_state);
    }

    @Override
    protected void handleResponse() throws CognosViewerException {
    }

    public ICognosServiceRequest getCognosServiceRequest() {
        return new CognosServiceRequest(this.m_state, this.m_serviceFactory);
    }

    public boolean applyReportActionProcessorChanges() throws ActionControllerException, Exception {
        String reportSpec = this.m_state.getFormFieldAsString("ui.spec");
        boolean bRunModifiedSpec = true;
        Element reportActionsNode = this.createActions();
        ReportActionController rap = new ReportActionController(this.getCognosServiceRequest());
        rap.setViewerDebugLogger(this.m_state.getDebugLogger());
        RAPReport rapReport = new RAPReport(reportSpec);
        rapReport.setDefaultLocale(CognosViewerDispatcherHandlerState.getContentLocale(this.m_state));
        rapReport.setProductLocale(CognosViewerDispatcherHandlerState.getProductLocale(this.m_state));
        if (this.m_state.getDebugLogger().isDebugEnabled()) {
            this.m_state.getDebugLogger().logXML(reportActionsNode.asXML(), "rapAction.xml", true, "rapAction");
        }
        rap.applyActions(rapReport, reportActionsNode.asXML());
        ModifyReportAction.saveReportInfoToState(this.m_state, rapReport);
        bRunModifiedSpec = !rap.getCallerSetRunFalse();
        return bRunModifiedSpec;
    }

    private Element createActions() throws CognosViewerException, ActionException {
        String reportPartId = this.m_state.getFormFieldAsString("reportpart_id");
        String flexParamProperties = this.m_state.getFormFieldAsString("flexParamProperties");
        Element reportActionsNode = DocumentHelper.createElement((String)"reportActions");
        reportActionsNode.add(BuxExtractReportPartSubAction.createSetReportPropertiesAction());
        Element extractReportActionNode = reportActionsNode.addElement("reportAction").addAttribute("name", "ExtractReportPart");
        extractReportActionNode.addElement("id").setText(reportPartId);
        if (flexParamProperties != null && flexParamProperties.length() > 0) {
            String objectClass = this.m_state.getFormFieldAsString("ui.objectClass");
            String reportSpec = this.m_state.getFormFieldAsString("ui.spec");
            GODashboardPrepropcessor gdPreprocessor = new GODashboardPrepropcessor(this.m_state, flexParamProperties, reportPartId, reportSpec);
            reportActionsNode = gdPreprocessor.evaluate(reportActionsNode);
            if ("analysis".equals(objectClass)) {
                Element ansUpgradeElement = extractReportActionNode.addElement("ANSUpgrade");
                ansUpgradeElement.setText(gdPreprocessor.isCrosstab() ? "crosstab" : "chart");
            }
        }
        if (this.m_changedContentLocale) {
            reportActionsNode.addElement("reportAction").addAttribute("name", "ChangeLocale");
        }
        Element processLockedFiltersAction = reportActionsNode.addElement("reportAction");
        processLockedFiltersAction.addAttribute("name", "ProcessLockedFilters");
        ActionHelper.addFilters(this.m_state, reportActionsNode);
        Element getInfoReportAction = reportActionsNode.addElement("reportAction");
        getInfoReportAction.addAttribute("name", "GetInfo");
        return reportActionsNode;
    }

    private void setupRunOptions() throws CognosViewerException {
        if (this.m_state.getFormFieldAsString("gdPromptAnswers").length() == 0 && this.m_state.getObject("globalPromptMatched") != Boolean.TRUE && this.m_state.getOptionManager().getOption("prompt") == null) {
            this.m_state.getOptionManager().addOption("run.prompt", this.m_state.getFormFieldAsString("executionPrompt"));
        }
    }
}

