/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.rap.actions.ReportInfo;
import com.cognos.viewer.action.BuxSubAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerRequest;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.ParameterValueManager;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.Protect;
import com.cognos.viewer.view.GetTransientsOutput;
import com.cognos.xts.ext.XTSExt;
import com.ibm.json.java.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class BuxGetParametersSubAction
extends BuxSubAction {
    public static String WIDGET_GLOBAL_PROMPT_XPATH = "widget/CognosViewerTransientSpecification/reportParameters/reportParameter";
    private HashMap<String, ParameterValueManager> m_parameterValueManagers = new HashMap();
    private JSONObject m_reportInfoProperties = null;
    private boolean m_bCanHandleWorkingResponse = true;

    public BuxGetParametersSubAction(ICognosViewerState state, CognosViewerServiceFactory factory) {
        this.initialize(state, factory);
    }

    @Override
    public SOAPResponse executeRequest() throws CognosViewerException {
        boolean useSpec = this.m_state.getSpecification() != null;
        try {
            String rapReportInfo = this.m_state.getFormFieldAsString("rap.reportInfo");
            JSONObject reportInfoProperties = ReportInfo.getReportLevelProperties(rapReportInfo);
            if (reportInfoProperties != null && ReportInfo.isPromptWidget(reportInfoProperties)) {
                this.m_reportInfoProperties = reportInfoProperties;
                useSpec = false;
            }
        }
        catch (Exception e) {
            throw new CognosViewerException(this.m_state.getBusEnvelope(), e.getMessage(), e);
        }
        SOAPResponse result = null;
        ICognosViewerRequest rsRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.REPORTSERVICEREQUEST);
        IArgumentMarshaller[] arguments = this.getGetParameterArguments(useSpec, this.m_bCanHandleWorkingResponse);
        if (useSpec) {
            CognosViewerRequest request = new CognosViewerRequest("getParametersSpecification", this.m_state, arguments, "high", this.m_state.isBUX());
            result = rsRequest.executeRequest(request);
        } else {
            result = rsRequest.executeRequest("getParameters", this.m_state, arguments, "high");
        }
        return result;
    }

    @Override
    public void handleResponse() throws CognosViewerException {
        Element soapBody = this.soapResponse.getBusEnvelope().getBody();
        Element reportPrompts = null;
        if (soapBody.selectSingleNode("./*/*[local-name()='result']/*[local-name()='details']/*[local-name()='item'][@xsi:type='bus:asynchDetailParameters']/*[local-name()='parameters']/item") != null) {
            GetTransientsOutput transientsOutput = new GetTransientsOutput();
            transientsOutput.parseReportSecification(this.soapResponse);
            if (this.m_reportInfoProperties != null) {
                Set<String> includeParameters = ReportInfo.getPromptWidgetParameters(this.m_reportInfoProperties);
                reportPrompts = transientsOutput.generateTransientSpec(this.soapResponse, includeParameters);
            } else {
                reportPrompts = transientsOutput.generateTransientSpec(this.soapResponse);
            }
            if (this.getParameterValuesFromGlobalPrompts(reportPrompts)) {
                this.m_state.getOptionManager().addOption("run.prompt", "false");
            }
            this.m_state.setFormFieldFromString("reportPrompts", reportPrompts.asXML());
        }
        this.m_state.setFormFieldFromString("widget.promptParametersRetrievedOnDrop", "true");
    }

    public void setReportInfoProperties(JSONObject reportInfoProperties) {
        this.m_reportInfoProperties = reportInfoProperties;
    }

    public boolean getParameterValuesFromGlobalPrompts(Element reportPrompts) {
        boolean matchFound = false;
        String sWidgetGlobalPrompts = this.m_state.getFormFieldAsString("widget.globalPromptInfo");
        if (sWidgetGlobalPrompts.length() == 0) {
            return false;
        }
        Element widgetGlobalPromptsRoot = null;
        try {
            widgetGlobalPromptsRoot = DocumentHelper.parseText((String)sWidgetGlobalPrompts).getRootElement();
        }
        catch (DocumentException e) {
            IPFLogger.getInstance().error("Could no parse the gloabl prompt information", this.getClass().getName());
            return false;
        }
        List reportParameters = reportPrompts.selectNodes("reportParameters/reportParameter");
        if (reportParameters != null) {
            for (int index = 0; index < reportParameters.size(); ++index) {
                ParameterValue parameterValue;
                Element reportPromptsParameter = (Element)reportParameters.get(index);
                String parameterName = reportPromptsParameter.attributeValue("parameterName");
                String modelItem = reportPromptsParameter.attributeValue("modelItem");
                Element matched = this.findMatchFromParameterName(parameterName, widgetGlobalPromptsRoot);
                if (matched == null) {
                    matched = this.findMatchFromModelItem(modelItem, widgetGlobalPromptsRoot);
                }
                if (matched == null) continue;
                String matchedParameterName = matched.attributeValue("parameterName");
                ParameterValueManager parameterValueManager = this.getParameterValueManagerForWidget(matched);
                if (parameterValueManager == null || (parameterValue = parameterValueManager.getParameterValue(matchedParameterName)) == null) continue;
                parameterValue.setName(parameterName);
                if (!"true".equals(reportPromptsParameter.attributeValue("multivalued")) && parameterValue.getValue().length > 1) {
                    parameterValue.setValue(new ParmValueItem[]{parameterValue.getValue()[0]});
                }
                this.m_state.getParameterValueManager().removeParameterValue(parameterName);
                this.m_state.getParameterValueManager().addParameterValue(parameterValue);
                matchFound = true;
            }
        }
        return matchFound;
    }

    public ParameterValueManager getParameterValueManagerForWidget(Element matched) {
        Element parameterValues = (Element)matched.selectSingleNode("../../../parameterValues");
        if (parameterValues != null) {
            String uniquePath = parameterValues.getParent().getUniquePath();
            if (this.m_parameterValueManagers.get(uniquePath) != null) {
                return this.m_parameterValueManagers.get(uniquePath);
            }
            ParameterValueManager parameters = new ParameterValueManager();
            String sParameterValues = parameterValues.getText();
            try {
                parameters.addParameterValues(sParameterValues);
                if (parameters.toArray().length == 0) {
                    if (!sParameterValues.startsWith("<")) {
                        sParameterValues = XTSExt.web64decode((String)Protect.cafaction("sign_unwrap", sParameterValues), (boolean)true);
                    }
                    parameters.addParameterValues(sParameterValues);
                }
                this.m_parameterValueManagers.put(uniquePath, parameters);
                return parameters;
            }
            catch (CognosViewerException e) {
                IPFLogger.getInstance().error("Could no parse the gloabl prompt information", this.getClass().getName());
                return null;
            }
        }
        return null;
    }

    public Element findMatchFromParameterName(String parameterName, Element widgetGlobalPromptsRoot) {
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        String delimiter = parameterName.indexOf("'") == -1 ? "'" : "\"";
        Element match = (Element)widgetGlobalPromptsRoot.selectSingleNode(WIDGET_GLOBAL_PROMPT_XPATH + "[@parameterName=" + delimiter + parameterName + delimiter + "]");
        if (match != null) {
            return match;
        }
        return null;
    }

    public Element findMatchFromModelItem(String modelItem, Element widgetGlobalPromptsRoot) {
        if (modelItem == null || modelItem.length() == 0) {
            return null;
        }
        String delimiter = modelItem.indexOf("'") == -1 ? "'" : "\"";
        Element match = (Element)widgetGlobalPromptsRoot.selectSingleNode(WIDGET_GLOBAL_PROMPT_XPATH + "[@modelItem=" + delimiter + modelItem + delimiter + "]");
        if (match != null) {
            return match;
        }
        return null;
    }

    public void setCanHandleWorkingResponse(boolean flag) {
        this.m_bCanHandleWorkingResponse = flag;
    }
}

