/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.viewer.action.ActionHelper;
import com.cognos.viewer.action.BuxSubAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.OptionManager;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.OptionMarshaller;
import com.cognos.viewer.model.marshallers.ParameterValuesMarshaller;
import com.cognos.viewer.model.marshallers.SingleSearchPathMarshaller;

public class BuxQueryReportSpecSubAction
extends BuxSubAction {
    private String reportSearchPath;
    private boolean m_bCanHandleWorkingResponse = true;

    public BuxQueryReportSpecSubAction(ICognosViewerState state, CognosViewerServiceFactory factory) {
        this.initialize(state, factory);
        String objectClass = this.m_state.getFormFieldAsString("ui.objectClass");
        this.reportSearchPath = "reportView".equals(objectClass) ? this.m_state.getFormFieldAsString("baseReportSearchPath") : this.m_state.getFormFieldAsString("ui.object");
        String searchPath = null;
        searchPath = state.getObject("searchPath") != null && ((String)state.getObject("searchPath")).length() > 0 ? (String)state.getObject("searchPath") : this.reportSearchPath;
        state.getBusEnvelope().setFormField("_originSearchPath", searchPath);
    }

    @Override
    public SOAPResponse executeRequest() throws CognosViewerException {
        IArgumentMarshaller[] arguments = new IArgumentMarshaller[3];
        SearchPathSingleObject searchPath = new SearchPathSingleObject(this.reportSearchPath);
        arguments[0] = new SingleSearchPathMarshaller(searchPath);
        arguments[1] = new ParameterValuesMarshaller(this.m_state.getParameterValueManager().toArray());
        OptionManager optionMgr = new OptionManager();
        optionMgr.addOption("reportServiceQuery.specificationFormat", "report");
        optionMgr.addOption("reportServiceQuery.upgrade", "true");
        if (!this.m_bCanHandleWorkingResponse) {
            optionMgr.addOption("asynch.primaryWaitThreshold", "0");
        }
        ActionHelper.addBUXAsynchOptions(this.m_state, optionMgr);
        ActionHelper.addReturnOutputWhenAvailableOption(optionMgr);
        this.addPromptOptions(optionMgr);
        arguments[2] = new OptionMarshaller(optionMgr.toArray());
        ICognosViewerRequest rsRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.REPORTSERVICEREQUEST);
        this.soapResponse = rsRequest.executeRequest("query", this.m_state, arguments, "session");
        return this.soapResponse;
    }

    @Override
    public void handleResponse() throws CognosViewerException {
        ActionHelper.setReportSpecification(this.m_state, this.soapResponse);
    }

    public void setCanHandleWorkingResponse(boolean flag) {
        this.m_bCanHandleWorkingResponse = flag;
    }
}

