/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.viewer.action.ActionFactory;
import com.cognos.viewer.action.BuxSubAction;
import com.cognos.viewer.action.ICognosViewerAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerBlankResponse;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.utility.ExceptionUtility;
import org.dom4j.Element;

public class BuxRunReportSubAction
extends BuxSubAction {
    public BuxRunReportSubAction(ICognosViewerState state, CognosViewerServiceFactory factory) {
        this.initialize(state, factory);
    }

    @Override
    public SOAPResponse executeRequest() throws CognosViewerException {
        String objectPermissions = this.m_state.getFormFieldAsString("cv.objectPermissions");
        boolean hasReadPermission = objectPermissions.indexOf("read") != -1;
        boolean hasExecutePermission = objectPermissions.indexOf("execute") != -1;
        String originalAction = this.m_state.getFormFieldAsString("ui.action");
        this.m_state.setFormFieldFromString("ui.primaryAction", "");
        try {
            if (!this.m_bRunReport) {
                this.soapResponse = new CMServerBlankResponse(this.m_state);
                return this.soapResponse;
            }
            String action = "runBux";
            if (hasReadPermission && hasExecutePermission && this.checkDoRunSpecification()) {
                Element parametersElem = (Element)this.m_state.getObject("parameters");
                if (parametersElem != null) {
                    this.m_state.getParameterValueManager().addParametersValues(parametersElem, false);
                }
                action = "buxRunSpec";
            }
            this.m_state.setFormFieldFromString("ui.action", action);
            ActionFactory actionFactory = new ActionFactory(this.m_serviceFactory);
            ICognosViewerAction runnableAction = actionFactory.load(action, this.m_state);
            this.soapResponse = runnableAction.execute();
        }
        catch (CognosViewerException e) {
            if (!this.hasReportSpec() && ExceptionUtility.isMissingMemberError(e)) {
                this.invokeBuxQueryReportSpecSubAction();
            }
            this.m_state.setFormFieldFromString("ui.action", originalAction);
            throw e;
        }
        return this.soapResponse;
    }

    private boolean checkDoRunSpecification() {
        if ("true".equals(this.m_state.getFormFieldAsString("limitedInteractiveMode"))) {
            return false;
        }
        return this.m_droppingReport || this.m_changedContentLocale || this.m_openReportFromClipboard;
    }

    @Override
    public void handleResponse() throws CognosViewerException {
    }
}

