/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.developer.schemas.bibus._3.OrderEnum;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.viewer.action.CognosViewerAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.PropEnumMarshaller;
import com.cognos.viewer.model.marshallers.SearchPathMultipleObjectMarshaller;
import com.cognos.viewer.model.marshallers.SortMarshaller;
import com.cognos.viewer.utility.XMLUtility;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class CMRequestAction
extends CognosViewerAction {
    @Override
    public void prepareRequest() throws CognosViewerException {
        if (this.m_state.getFormFieldAsString("CMRequest") != null && this.m_state.getFormFieldAsString("CMRequest").length() > 0) {
            this.m_arguments = null;
            try {
                List sortItems;
                Document document = XMLUtility.createXMLDocument(this.m_state.getFormFieldAsString("CMRequest"));
                Element sortBy = (Element)document.selectSingleNode("CMRequest/sortBy");
                this.m_arguments = sortBy != null ? new IArgumentMarshaller[3] : new IArgumentMarshaller[2];
                Element searchPath = (Element)document.selectSingleNode("CMRequest/searchPath");
                this.m_arguments[0] = new SearchPathMultipleObjectMarshaller(new SearchPathMultipleObject(searchPath.getText()));
                List propertyList = document.selectNodes("CMRequest/properties/property");
                PropEnum[] properties = new PropEnum[propertyList.size()];
                for (int iIndex = 0; iIndex < propertyList.size(); ++iIndex) {
                    Element property = (Element)propertyList.get(iIndex);
                    properties[iIndex] = PropEnum.fromValue((String)property.getText());
                }
                this.m_arguments[1] = new PropEnumMarshaller(properties);
                if (sortBy != null && (sortItems = sortBy.selectNodes("./sortItem")).size() > 0) {
                    Sort[] sortByArray = new Sort[sortItems.size()];
                    for (int sortIndex = 0; sortIndex < sortItems.size(); ++sortIndex) {
                        Element sortElement = (Element)sortItems.get(sortIndex);
                        Element sortOrder = (Element)sortElement.selectSingleNode("order");
                        Element sortProp = (Element)sortElement.selectSingleNode("property");
                        if (sortOrder == null || sortProp == null) continue;
                        Sort sort = new Sort();
                        sort.setOrder(OrderEnum.fromString((String)sortOrder.getText()));
                        sort.setPropName(PropEnum.fromString((String)sortProp.getText()));
                        sortByArray[sortIndex] = sort;
                    }
                    this.m_arguments[2] = new SortMarshaller(sortByArray);
                }
            }
            catch (Exception e) {
                this.m_state.getIPFLogger().error(e.getMessage(), e, this.getClass().getName());
            }
        }
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        ICognosViewerRequest cmRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.CMSERVICEREQUEST);
        SOAPResponse cmResponse = cmRequest.executeRequest("query", this.m_state, this.m_arguments, "");
        return cmResponse;
    }
}

