/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.viewer.action.ActionFactory;
import com.cognos.viewer.action.PageAction;
import com.cognos.viewer.action.RunIconAction;
import com.cognos.viewer.action.SecondaryRequestAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.ConversationMarshaller;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.utility.XMLUtility;
import org.dom4j.Document;
import org.dom4j.Element;

public class CancelAction
extends SecondaryRequestAction {
    @Override
    public void prepareRequest() throws CognosViewerException {
        this.m_arguments = new IArgumentMarshaller[1];
        this.m_arguments[0] = new ConversationMarshaller(this.m_state.getConversation());
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        ICognosViewerRequest rsRequest = this.getSecondaryRequestService();
        SOAPResponse soapResponse = rsRequest.executeRequest(this.m_state.getAction(), this.m_state, this.m_arguments, "control");
        String previousSession = this.m_state.getFormFieldAsString("cv.previousSession");
        ActionFactory actionFactory = new ActionFactory(this.m_serviceFactory);
        if (previousSession.length() > 0) {
            try {
                Document document = XMLUtility.createXMLDocument(previousSession);
                Element rootNode = document.getRootElement();
                this.m_state.clearConversation();
                Element conversation = rootNode.element("conversation");
                this.m_state.setFormFieldFromString("ui.conversation", conversation.getText());
                this.m_state.setFormFieldFromString("ui.action", "currentPage");
                this.clearTrackingFromState();
            }
            catch (Exception exception) {
                CognosViewerException cognosViewerException = new CognosViewerException(this.m_state.getBusEnvelope(), exception.getMessage(), exception);
                throw cognosViewerException;
            }
            PageAction pageAction = (PageAction)actionFactory.load("currentPage", this.m_state);
            soapResponse = pageAction.execute();
        } else if ("fragment".equals(this.m_state.getFormFieldAsString("cv.responseFormat"))) {
            RunIconAction runIconAction = (RunIconAction)actionFactory.load("runIcon", this.m_state);
            soapResponse = runIconAction.execute();
        }
        return soapResponse;
    }
}

