/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.GenericOptionAnyURI;
import com.cognos.developer.schemas.bibus._3.GenericOptionXMLEncodedXML;
import com.cognos.developer.schemas.bibus._3.NameValue;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.util.NameValuePair;
import com.cognos.viewer.action.ActionFactory;
import com.cognos.viewer.action.ActionHelper;
import com.cognos.viewer.action.BuxQueryReportSpecSubAction;
import com.cognos.viewer.action.ICognosViewerAction;
import com.cognos.viewer.action.PageAction;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerBlankResponse;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ContentManagerQueryObject;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.OptionManager;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.AsynchSpecificationMarshaller;
import com.cognos.viewer.model.marshallers.ConversationMarshaller;
import com.cognos.viewer.model.marshallers.EntriesMarshaller;
import com.cognos.viewer.model.marshallers.GenericOptionXMLEncodedXMLAsAttachment;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.OptionMarshaller;
import com.cognos.viewer.model.marshallers.ParameterValuesMarshaller;
import com.cognos.viewer.model.marshallers.SearchTypeMarshaller;
import com.cognos.viewer.model.marshallers.SingleSearchPathMarshaller;
import com.cognos.viewer.utility.CAMFactoryPool;
import com.cognos.viewer.utility.ExceptionUtility;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.NameValuePairArrayList;
import com.cognos.viewer.utility.Protect;
import com.cognos.viewer.utility.XMLUtility;
import com.cognos.xts.ext.XTSExt;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.mail.internet.InternetHeaders;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class CognosViewerAction
implements ICognosViewerAction {
    protected ICognosViewerState m_state = null;
    protected CognosViewerServiceFactory m_serviceFactory = null;
    protected IArgumentMarshaller[] m_arguments = null;
    private InternetHeaders headers = null;

    @Override
    public void initialize(ICognosViewerState state, CognosViewerServiceFactory serviceFactory) {
        this.m_state = state;
        this.m_serviceFactory = serviceFactory;
        this.setPrimaryAction();
    }

    private void setPrimaryAction() {
        if (this.m_state != null) {
            String sAction = this.m_state.getFormFieldAsString("ui.action");
            String sPrimaryAction = this.m_state.getFormFieldAsString("ui.primaryAction");
            if (sPrimaryAction.length() == 0) {
                sPrimaryAction = sAction;
                this.m_state.setFormFieldFromString("ui.primaryAction", sPrimaryAction);
            }
        }
    }

    public ICognosViewerRequest getSecondaryRequestService() throws CognosViewerException {
        String sPrimaryRequest = this.m_state.getFormFieldAsString("ui.primaryAction");
        if (sPrimaryRequest.equals("runPowerPlay")) {
            return this.m_serviceFactory.getService(CognosViewerServiceFactory.POWERPLAYSERVICEREQUEST);
        }
        if (this.m_state.getFormFieldAsString("ui.objectClass").length() > 0) {
            return this.m_serviceFactory.getServiceFromObjectClass(this.m_state.getFormFieldAsString("ui.objectClass"));
        }
        return this.m_serviceFactory.getService(CognosViewerServiceFactory.REPORTSERVICEREQUEST);
    }

    public IArgumentMarshaller[] getArguments() {
        return this.m_arguments;
    }

    public void prepareRequest() throws CognosViewerException {
    }

    protected abstract SOAPResponse executeRequest() throws CognosViewerException;

    protected SOAPResponse resumeExecution(SOAPResponse soapInteruptResponse) throws CognosViewerException {
        return soapInteruptResponse;
    }

    protected void saveActionState() throws CognosViewerException {
        NameValuePairArrayList arrayList = new NameValuePairArrayList();
        this.saveState(arrayList);
        try {
            Element cvActionState = DocumentHelper.createElement((String)"cvActionState");
            CognosViewerAction.serializeActionState(cvActionState, arrayList, this.m_state.getFormFields());
            CAMPassport passport = this.m_state.getCAMPassport();
            if (this.m_state.getDebugLogger() != null && this.m_state.getDebugLogger().isDebugEnabled()) {
                this.m_state.getDebugLogger().logXML(cvActionState.asXML(), "savedActionState.xml", true, "actionState");
            }
            this.m_state.setFormFieldFromString("cv.actionState", CognosViewerAction.signAndEncodeXML(cvActionState, passport));
        }
        catch (Exception exception) {
            this.m_state.getIPFLogger().error(exception.getMessage(), exception, this.getClass().getName());
            throw new CognosViewerException(this.m_state.getBusEnvelope(), "CV-0007 The action could not be completed. Please contact your administrator.", exception);
        }
    }

    public static void serializeActionState(Element element, NameValuePairArrayList arrayList, NameValuePair[] formFields) {
        Element savedParameters = element.addElement("savedState");
        if (arrayList != null) {
            int size = arrayList.size();
            for (int index = 0; index < size; ++index) {
                Element param = savedParameters.addElement("param");
                NameValuePair nameValuePair = arrayList.getNameValuePairItem(index);
                param.addAttribute("name", nameValuePair.getName());
                param.setText(nameValuePair.getValue());
            }
        }
        Element cachedFormFields = element.addElement("formFields");
        if (formFields != null) {
            for (int iIndex = 0; iIndex < formFields.length; ++iIndex) {
                Element formFieldItem = cachedFormFields.addElement("item");
                Element name = formFieldItem.addElement("name");
                name.setText(formFields[iIndex].getName());
                Element value = formFieldItem.addElement("value");
                value.setText(formFields[iIndex].getValue());
            }
        }
    }

    public static String signAndEncodeXML(Element element, CAMPassport passport) {
        return Protect.cafaction("sign_wrap_setpassportid_" + passport.getId(), XTSExt.web64encode((String)element.asXML(), (boolean)true));
    }

    protected void saveState(NameValuePairArrayList actionState) throws CognosViewerException {
    }

    protected void loadActionState(boolean missingMemberCheck) throws CognosViewerException {
        HashMap actionState = new HashMap();
        try {
            String sActionState = this.m_state.getFormFieldAsString("cv.actionState");
            if (sActionState.length() > 0) {
                this.m_state.setFormFieldFromString("cv.actionState", "");
                sActionState = CognosViewerAction.decodeSignedXML(sActionState);
                if (!missingMemberCheck && this.m_state.getDebugLogger() != null && this.m_state.getDebugLogger().isDebugEnabled()) {
                    this.m_state.getDebugLogger().logXML(sActionState, "loadedActionState.xml", true, "actionState");
                }
                CognosViewerAction.deserializeActionState(sActionState, actionState, this.m_state.getBusEnvelope(), this.m_state);
                this.loadState(actionState);
            }
        }
        catch (Exception exception) {
            this.m_state.getIPFLogger().error(exception.getMessage(), exception, this.getClass().getName());
            throw new CognosViewerException(this.m_state.getBusEnvelope(), "CV-0007 The action could not be completed. Please contact your administrator.", exception);
        }
    }

    public static String decodeSignedXML(String blob) {
        return XTSExt.web64decode((String)Protect.cafaction("sign_unwrap", blob), (boolean)true);
    }

    public static void deserializeActionState(String serial, HashMap actionState, BIBusEnvelope busEnvelope, ICognosViewerState state) {
        Element cachedFormFields;
        Element savedParams;
        Document xmlDocument = XMLUtility.createXMLDocument(serial);
        Element element = xmlDocument.getRootElement();
        if (actionState != null && (savedParams = (Element)element.selectSingleNode("./savedState")) != null) {
            Iterator paramNodes = savedParams.elementIterator();
            while (paramNodes.hasNext()) {
                Element paramNode = (Element)paramNodes.next();
                actionState.put(paramNode.attributeValue("name"), paramNode.getText());
            }
        }
        if ((cachedFormFields = (Element)element.selectSingleNode("./formFields")) != null) {
            Iterator formFieldIterator = cachedFormFields.elementIterator();
            while (formFieldIterator.hasNext()) {
                Element formFieldItem = (Element)formFieldIterator.next();
                Element name = formFieldItem.element("name");
                Element value = formFieldItem.element("value");
                String formFieldName = name.getText();
                if (busEnvelope.getFormValue(formFieldName) != null && !"ui.action".equals(formFieldName)) continue;
                busEnvelope.setFormField(formFieldName, value.getText());
                state.setFormFieldFromString(formFieldName, value.getText());
            }
        }
    }

    protected void loadState(HashMap actionState) throws CognosViewerException {
    }

    protected boolean insertAsynchReportOutput() {
        return true;
    }

    protected void postExecution(SOAPResponse soapResponse) throws CognosViewerException {
    }

    protected SOAPResponse doFailover() throws CognosViewerException {
        SOAPResponse soapResponse;
        this.m_state.getIPFLogger().enter("doFailover", this.getClass().getName());
        this.m_state.getBusEnvelope().clearConversationContext();
        this.m_state.setFormFieldFromString("m_tracking", "");
        this.m_state.setFormFieldFromString("cv.actionState", "");
        this.m_state.setFormFieldFromString("ui.action", "currentPage");
        try {
            ActionFactory actionFactory = new ActionFactory(this.m_serviceFactory);
            PageAction pageAction = (PageAction)actionFactory.load("currentPage", this.m_state);
            soapResponse = pageAction.execute();
        }
        catch (CognosViewerException exception) {
            this.m_state.getIPFLogger().info("doFailover : Current page didn't work, try executing the primaryAction ... ", this.getClass().getName());
            if (this.m_state.getDebugLogger() != null) {
                this.m_state.getDebugLogger().log(exception.getFaultEnvelope(), "fault.xml", false, null);
            }
            if (this.m_state.getFormFieldAsString("ui.primaryAction").length() > 0) {
                this.m_state.setFormFieldFromString("ui.action", this.m_state.getFormFieldAsString("ui.primaryAction"));
            }
            AsynchRequest conversation = this.m_state.getConversation();
            this.m_state.setFormFieldFromString("ui.object", conversation.getObjectPath().get_value());
            this.m_state.getParameterValueManager().setParameterValues(conversation.getParameters());
            this.m_state.getOptionManager().clear();
            try {
                this.m_state.getOptionManager().addOptions(conversation.getOptions(), true);
            }
            catch (CognosViewerException e) {
                this.m_state.getIPFLogger().error(e.getMessage(), e, this.getClass().getName());
            }
            this.prepareRequest();
            soapResponse = this.executeRequest();
        }
        this.m_state.getIPFLogger().exit("doFailover", this.getClass().getName());
        return soapResponse;
    }

    protected SOAPResponse handleAsynchException(CognosViewerException cognosViewerException) throws CognosViewerException {
        this.m_state.getIPFLogger().info("Invoked handleAsynchException ...", this.getClass().getName());
        if ("wait".equals(this.m_state.getAction()) && CognosViewerDispatcherHandler.getConfigValues().getBoolean("enableFailover")) {
            if (this.m_state.getDebugLogger() != null) {
                this.m_state.getDebugLogger().log(cognosViewerException.getFaultEnvelope(), "fault.xml", false, null);
            }
            return this.doFailover();
        }
        throw cognosViewerException;
    }

    @Override
    public SOAPResponse execute() throws CognosViewerException {
        SOAPResponse soapResponse;
        IPFLogger.PerfData curPerfData = this.startLog();
        String sAction = this.m_state.getAction();
        if ("wait".equals(sAction) || "back".equals(sAction) || "forward".equals(sAction)) {
            if ("forward".equals(sAction) && "fragment".equals(this.m_state.getFormFieldAsString("cv.responseFormat"))) {
                this.queryContentManager();
            }
            try {
                soapResponse = this.doInteruptRequest(sAction);
                if (this.isActionRequestComplete(soapResponse)) {
                    this.loadActionState(false);
                    soapResponse = this.resumeExecution(soapResponse);
                }
            }
            catch (CognosViewerException cognosViewerException) {
                this.m_state.getIPFLogger().error(cognosViewerException.getMessage(), cognosViewerException, this.getClass().getName());
                if (this.m_state.isBUX() && !this.hasReportSpec() && ExceptionUtility.isMissingMemberError(cognosViewerException)) {
                    this.loadActionState(true);
                    this.invokeBuxQueryReportSpecSubAction();
                }
                soapResponse = this.handleAsynchException(cognosViewerException);
            }
        } else {
            this.prepareRequest();
            soapResponse = this.executeRequest();
        }
        if (!this.isActionRequestComplete(soapResponse)) {
            if (this.m_state.getFormFieldAsString("cv.actionState").length() == 0) {
                this.saveActionState();
            }
            if (this.insertAsynchReportOutput()) {
                this.m_state.setFormFieldFromString("cv.useAsynchReportOutput", "true");
            }
        }
        this.postExecution(soapResponse);
        this.endLog(curPerfData);
        return soapResponse;
    }

    private SOAPResponse doInteruptRequest(String sAction) throws CognosViewerException {
        ActionHelper.setContextBlockSize(this.m_state);
        IArgumentMarshaller[] arguments = new IArgumentMarshaller[]{new ConversationMarshaller(this.m_state.getConversation()), new ParameterValuesMarshaller(this.m_state.getParameterValueManager().toArray()), new OptionMarshaller(this.m_state.getOptionManager().toArray())};
        String sAffinity = "wait".equals(sAction) ? "absolute" : "high";
        ICognosViewerRequest rsRequest = this.getSecondaryRequestService();
        return rsRequest.executeRequest(this.m_state.getAction(), this.m_state, arguments, sAffinity);
    }

    public boolean isActionRequestComplete(SOAPResponse soapResponse) {
        String sStatus = soapResponse.getStatus();
        return !"working".equals(sStatus) && !"stillWorking".equals(sStatus) && !"prompting".equals(sStatus);
    }

    private IPFLogger.PerfData startLog() {
        CognosViewerDispatcherHandlerState originalState = null;
        IPFLogger logger = null;
        IPFLogger.PerfData curPerfData = null;
        if (this.m_state instanceof CognosViewerDispatcherHandlerState) {
            originalState = (CognosViewerDispatcherHandlerState)this.m_state;
            logger = originalState.getIPFLogger();
            curPerfData = logger.startPerf(10000, "Perf.VIEWER", "Entering " + this.getClass().getName() + " execute", "ENTER");
        }
        return curPerfData;
    }

    private void endLog(IPFLogger.PerfData curPerfData) {
        CognosViewerDispatcherHandlerState originalState = null;
        IPFLogger logger = null;
        if (this.m_state instanceof CognosViewerDispatcherHandlerState && (logger = (originalState = (CognosViewerDispatcherHandlerState)this.m_state).getIPFLogger()) != null && curPerfData != null) {
            logger.stopPerf(curPerfData, "Leaving " + this.getClass().getName() + " execute", "EXIT");
        }
    }

    public HashMap getActionState() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String sActionState = this.m_state.getFormFieldAsString("cv.actionState");
            if (sActionState.length() > 0) {
                this.m_state.setFormFieldFromString("cv.actionState", "");
                sActionState = XTSExt.web64decode((String)Protect.cafaction("sign_unwrap", sActionState), (boolean)true);
                Document xmlDocument = XMLUtility.createXMLDocument(sActionState);
                Element cvActionState = xmlDocument.getRootElement();
                List paramNodes = cvActionState.elements();
                int size = paramNodes.size();
                for (int index = 0; index < size; ++index) {
                    Element paramNode = (Element)paramNodes.get(index);
                    hashMap.put(paramNode.attributeValue("name"), paramNode.getText());
                }
            }
        }
        catch (Exception exception) {
            this.m_state.getIPFLogger().error(exception.getMessage(), exception, this.getClass().getName());
        }
        return hashMap;
    }

    public boolean getWaitForPromptValues() {
        return "true".equals(this.m_state.getFormFieldAsString("fragment.waitForPromptValues"));
    }

    public boolean showBlankInteractiveFragmentPage() {
        return this.getWaitForPromptValues() && !this.m_state.getTransientSpec().hasAllNeededParameters(this.m_state.getParameterValueManager());
    }

    public SOAPResponse generateBlankFragmentResponse() {
        this.m_state.setFormFieldFromString("fragment.outputHint", "blankPage");
        CMServerBlankResponse blankResponse = new CMServerBlankResponse(this.m_state);
        return blankResponse;
    }

    public void queryContentManager() throws CognosViewerException {
        block16: {
            try {
                if (CognosViewerDispatcherHandler.isCMCacheServiceEnabled()) {
                    IArgumentMarshaller[] arguments = new IArgumentMarshaller[]{new SingleSearchPathMarshaller(this.m_state.getObjectPath()), new SearchTypeMarshaller(ClassEnum.fromString((String)"report")), new EntriesMarshaller(new ClassEnum[]{ClassEnum.fromString((String)"report"), ClassEnum.fromString((String)"model"), ClassEnum.fromString((String)"modelView"), ClassEnum.fromString((String)"package"), ClassEnum.fromString((String)"packageConfiguration"), ClassEnum.fromString((String)"account"), ClassEnum.fromString((String)"session"), ClassEnum.fromString((String)"dataSourceSignon"), ClassEnum.fromString((String)"reportCache"), ClassEnum.fromString((String)"reportMetadata")}), this.m_state.getOptionManager().getOption("http://developer.cognos.com/ceba/constants/contentManagerCacheOptionEnum#context") != null ? new OptionMarshaller(new Option[]{this.m_state.getOptionManager().getOption("http://developer.cognos.com/ceba/constants/contentManagerCacheOptionEnum#context")}) : new OptionMarshaller(new Option[0])};
                    ICognosViewerRequest cmServerRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.CMCACHESERVICEREQUEST);
                    SOAPResponse cmCacheResponse = null;
                    try {
                        cmCacheResponse = cmServerRequest.executeRequest("queryCache", this.m_state, arguments, "");
                    }
                    catch (CognosViewerException cognosViewerException) {
                        this.m_state.getIPFLogger().error(cognosViewerException.getMessage(), cognosViewerException, this.getClass().getName());
                    }
                    if (cmCacheResponse == null) break block16;
                    CMServerResponse cmResponse = new CMServerResponse(this.m_state, cmCacheResponse.getBusEnvelope());
                    cmResponse.setRootXPath("*[local-name()='queryCacheResult']/result/objects/item");
                    ActionHelper.addObjectPropertiesToState(this.m_state, cmResponse);
                    Element cacheOption = (Element)cmResponse.getBusEnvelope().getBody().selectSingleNode("*[local-name()='queryCacheResult']/result/*[local-name()='options']/item[./*[local-name()='name'] = 'http://developer.cognos.com/ceba/constants/contentManagerCacheOptionEnum#context']");
                    if (cacheOption == null || cacheOption.selectSingleNode("./*[local-name()='value']") == null) break block16;
                    GenericOptionXMLEncodedXML genericOptionXMLEncodedXML = new GenericOptionXMLEncodedXML();
                    genericOptionXMLEncodedXML.setName(cacheOption.selectSingleNode("./*[local-name()='name']").getText());
                    genericOptionXMLEncodedXML.setValue(new XmlEncodedXML(cacheOption.selectSingleNode("./*[local-name()='value']").getText()));
                    boolean bAttachmentSigned = false;
                    GenericOptionXMLEncodedXMLAsAttachment dataOption = null;
                    GenericOptionAnyURI signatureOption = null;
                    String currentAciton = this.m_state.getFormFieldAsString("ui.action");
                    if (!"runPowerPlay".equals(this.m_state.getFormFieldAsString("ui.action")) && CognosViewerServiceFactory.REPORTSERVICEREQUEST.equals(this.m_serviceFactory.getServerIDFromObjectClass(this.m_state.getFormFieldAsString("ui.objectClass"))) && !"forward".equals(currentAciton) && !"mobileSchedule".equals(currentAciton)) {
                        dataOption = new GenericOptionXMLEncodedXMLAsAttachment();
                        dataOption.setName("http://developer.cognos.com/ceba/constants/contentManagerCacheOptionEnum#data");
                        signatureOption = new GenericOptionAnyURI();
                        signatureOption.setName("http://developer.cognos.com/ceba/constants/contentManagerCacheOptionEnum#signature");
                        cmResponse.getBusEnvelope().getBIBusHeader().getParent().detach();
                        try {
                            SigningSession signingSession = CAMFactoryPool.createSigningSession();
                            if (signingSession != null) {
                                byte[] documentBytes = cmResponse.getBusEnvelope().getAsDocument().getRootElement().asXML().getBytes("UTF-8");
                                CRC32 crc32 = new CRC32();
                                crc32.update(documentBytes);
                                long documentKey = crc32.getValue() ^ (long)documentBytes.length;
                                byte[] documentKeyBytes = Long.toString(documentKey).getBytes("UTF-8");
                                byte[] signature = signingSession.hmac(documentKeyBytes);
                                if (signature.length > 0) {
                                    signatureOption.setValue(this.bytesToHex(signature));
                                    bAttachmentSigned = true;
                                }
                            }
                        }
                        catch (CAMCryptoException ex) {
                            this.m_state.getIPFLogger().warn(ex.getMessage(), this.getClass().getCanonicalName());
                        }
                        catch (IOException ex) {
                            this.m_state.getIPFLogger().warn(ex.getMessage(), this.getClass().getCanonicalName());
                        }
                    }
                    if (bAttachmentSigned) {
                        dataOption.setAttachment("cacheData", cmResponse.getBusEnvelope().getAsDocument().getRootElement().asXML());
                        this.m_state.getOptionManager().addOptions(new Option[]{genericOptionXMLEncodedXML, dataOption, signatureOption}, true);
                    } else {
                        this.m_state.getOptionManager().addOptions(new Option[]{genericOptionXMLEncodedXML}, true);
                    }
                    break block16;
                }
                ContentManagerQueryObject queryObject = new ContentManagerQueryObject(this.m_state, this.m_serviceFactory.getService(CognosViewerServiceFactory.CMSERVICEREQUEST));
                SearchPathMultipleObject searchPath = new SearchPathMultipleObject(this.m_state.getFormFieldAsString("ui.object"));
                try {
                    CMServerResponse response = queryObject.execute(searchPath);
                    if (response != null) {
                        ActionHelper.addObjectPropertiesToState(this.m_state, response);
                    }
                }
                catch (CognosViewerException cognosViewerException) {
                    this.m_state.getIPFLogger().error(cognosViewerException.getMessage(), cognosViewerException, this.getClass().getName());
                }
            }
            catch (CognosViewerException ex) {
                this.m_state.getIPFLogger().error(ex.getMessage(), ex, this.getClass().getName());
                CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
                throw cognosViewerException;
            }
        }
    }

    private String bytesToHex(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    protected void clearTrackingFromState() {
        this.m_state.setFormFieldFromString("m_tracking", "");
        BIBusEnvelope busEnvelope = this.m_state.getBusEnvelope();
        if (busEnvelope != null) {
            busEnvelope.clearConversationContext();
        }
    }

    protected void addPromptOptions(OptionManager optionManager) throws CognosViewerException {
        optionManager.addOption("run.promptFormat", "HTMLFragment");
        optionManager.addOption("run.outputFormat", "HTMLFragment");
        optionManager.addOption("run.xslURL", "sa.xsl");
        optionManager.addOption("run.prompt", "false");
        String sCVId = this.m_state.getFormFieldAsString("cv.id");
        if (sCVId.length() != 0) {
            NameValue nameValue = new NameValue();
            nameValue.setName("CognosViewerID");
            nameValue.setValue(sCVId);
            optionManager.newRunOptionNameValueArray(RunOptionEnum.xslParameters, new NameValue[]{nameValue});
        }
    }

    protected IArgumentMarshaller[] getGetParameterArguments(boolean useReportSpecification) throws CognosViewerException {
        return this.getGetParameterArguments(useReportSpecification, true);
    }

    protected IArgumentMarshaller[] getGetParameterArguments(boolean useReportSpecification, boolean canHandleAsynch) throws CognosViewerException {
        String sCVId;
        IArgumentMarshaller[] arguments = new IArgumentMarshaller[3];
        arguments[0] = useReportSpecification && this.m_state.getSpecification() != null ? new AsynchSpecificationMarshaller(this.m_state.getSpecification(), this.m_state.isBUX()) : new SingleSearchPathMarshaller(this.m_state.getObjectPath());
        arguments[1] = new ParameterValuesMarshaller(this.m_state.getParameterValueManager().toArray());
        OptionManager getParameterOptions = new OptionManager();
        this.addPromptOptions(getParameterOptions);
        getParameterOptions.addOption("run.layoutParameters", "true");
        if (CognosViewerDispatcherHandlerState.isMasters() || !canHandleAsynch) {
            getParameterOptions.addOption("asynch.primaryWaitThreshold", "0");
        }
        if ((sCVId = this.m_state.getFormFieldAsString("cv.id")).length() != 0) {
            NameValue nameValue = new NameValue();
            nameValue.setName("CognosViewerID");
            nameValue.setValue(sCVId);
            getParameterOptions.newRunOptionNameValueArray(RunOptionEnum.xslParameters, new NameValue[]{nameValue});
        }
        arguments[2] = new OptionMarshaller(getParameterOptions.toArray());
        return arguments;
    }

    protected boolean hasReportSpec() {
        String sSpec = this.m_state.getFormFieldAsString("ui.spec");
        return sSpec != null && !"".equals(sSpec);
    }

    protected void invokeBuxQueryReportSpecSubAction() throws CognosViewerException {
        BuxQueryReportSpecSubAction subAction = new BuxQueryReportSpecSubAction(this.m_state, this.m_serviceFactory);
        subAction.setCanHandleWorkingResponse(false);
        subAction.executeRequest();
        subAction.handleResponse();
    }

    @Override
    public void setHeaders(InternetHeaders headers) {
        this.headers = headers;
    }

    @Override
    public InternetHeaders getHeaders() {
        return this.headers;
    }
}

