/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.viewer.action.SecondaryRequestAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.OptionManager;
import com.cognos.viewer.utility.MessageManager;
import com.cognos.viewer.utility.XMLUtility;
import org.dom4j.Document;
import org.dom4j.Element;

public class DrillAction
extends SecondaryRequestAction {
    @Override
    public void prepareRequest() throws CognosViewerException {
        this.generateOptions();
        super.prepareRequest();
    }

    public void generateOptions() throws CognosViewerException {
        String sDrillOptionName = this.m_state.getFormFieldAsString("rv_drillOption");
        if (sDrillOptionName.length() == 0) {
            throw new CognosViewerException(this.m_state.getBusEnvelope(), MessageManager.convert("RV_DRILL_ACTION_ERROR", CognosViewerDispatcherHandlerState.getProductLocale(this.m_state)), null);
        }
        String sDrillParameters = this.m_state.getFormFieldAsString("rv_drillparams");
        if (sDrillParameters.length() == 0) {
            throw new CognosViewerException(this.m_state.getBusEnvelope(), MessageManager.convert("RV_DRILL_ACTION_ERROR", CognosViewerDispatcherHandlerState.getProductLocale(this.m_state)), null);
        }
        String sDrillRefQuery = this.m_state.getFormFieldAsString("rv_drillRefQuery");
        if (sDrillRefQuery.length() == 0) {
            throw new CognosViewerException(this.m_state.getBusEnvelope(), MessageManager.convert("RV_DRILL_ACTION_ERROR", CognosViewerDispatcherHandlerState.getProductLocale(this.m_state)), null);
        }
        Element drillParameters = null;
        try {
            Document document = XMLUtility.createXMLDocument(sDrillParameters);
            drillParameters = (Element)document.selectSingleNode("./DrillParameters");
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
        if (drillParameters == null) {
            this.m_state.getIPFLogger().error("drillParameters is null. The drill request is invalid!!! ", this.getClass().getName());
            throw new CognosViewerException(this.m_state.getBusEnvelope(), "CV-009 The drill request is invalid.\n", null);
        }
        OptionManager optionManager = this.m_state.getOptionManager();
        optionManager.addDrillOption(sDrillOptionName, drillParameters, sDrillRefQuery);
        optionManager.addOption("run.prompt", "false");
        optionManager.addOption("run.outputFormat", "HTMLFragment");
        optionManager.addOption("run.outputEncapsulation", "none");
    }
}

