/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.viewer.action.ActionFactory;
import com.cognos.viewer.action.ActionHelper;
import com.cognos.viewer.action.CognosViewerAction;
import com.cognos.viewer.action.ICognosViewerAction;
import com.cognos.viewer.action.ObjectDefaultAction;
import com.cognos.viewer.action.OutputAction;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerBlankResponse;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ContentManagerQueryObject;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.utility.MessageManager;

public abstract class DrillThroughAction
extends CognosViewerAction {
    @Override
    protected abstract SOAPResponse executeRequest() throws CognosViewerException;

    public SOAPResponse invokeTarget() throws CognosViewerException {
        SOAPResponse soapResponse;
        String sDrillAction = this.m_state.getFormFieldAsString("ui.action");
        String sObjectPath = this.m_state.getFormFieldAsString("ui.object");
        ActionFactory actionFactory = new ActionFactory(this.m_serviceFactory);
        if ("".equals(sDrillAction) || "default".equals(sDrillAction)) {
            ObjectDefaultAction objectDefault = (ObjectDefaultAction)actionFactory.load("objectDefault", this.m_state);
            soapResponse = objectDefault.execute();
        } else if (sDrillAction.indexOf("edit") != -1) {
            ContentManagerQueryObject queryObject = new ContentManagerQueryObject(this.m_state, this.m_serviceFactory.getService(CognosViewerServiceFactory.CMSERVICEREQUEST));
            SearchPathMultipleObject searchPath = new SearchPathMultipleObject(sObjectPath);
            CMServerResponse response = queryObject.execute(searchPath);
            ActionHelper.addObjectPropertiesToState(this.m_state, response);
            this.m_state.setFormFieldFromString("cv.responseFormat", "studioLaunch");
            soapResponse = new CMServerBlankResponse(this.m_state);
        } else if ("view".equals(sDrillAction)) {
            OutputAction outputAction = (OutputAction)actionFactory.load(this.getOutputActionName(), this.m_state);
            soapResponse = outputAction.execute();
        } else {
            DrillThroughAction.checkCapabilityForDrillThroughFormat(this.m_state);
            ICognosViewerAction runAction = actionFactory.load("run", this.m_state);
            soapResponse = runAction.execute();
        }
        return soapResponse;
    }

    public static void checkCapabilityForDrillThroughFormat(ICognosViewerState state) throws CognosViewerException {
        String format;
        if (state.getObject("drillThroughFormat") != null && !CognosViewerDispatcherHandler.hasFormatCapability(state, format = (String)state.getObject("drillThroughFormat"))) {
            throw new CognosViewerException(state.getBusEnvelope(), MessageManager.convert("CANNOT_GENERATE_OUTPUT_FORMAT", CognosViewerDispatcherHandlerState.getFaultLocale(state.getBusEnvelope()), new Object[]{format}), null);
        }
    }

    protected String getOutputActionName() {
        return "output";
    }
}

