/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.viewer.action.ActionHelper;
import com.cognos.viewer.action.ReportOutputAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerBlankResponse;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.ActionMarshaller;
import com.cognos.viewer.model.marshallers.AsynchSpecificationMarshaller;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.OptionMarshaller;
import com.cognos.viewer.model.marshallers.ParameterValuesMarshaller;
import com.cognos.viewer.model.marshallers.SingleSearchPathMarshaller;
import org.dom4j.Element;

public class EditAction
extends ReportOutputAction {
    @Override
    public void prepareRequest() throws CognosViewerException {
        if (this.m_state.getFormFieldAsString("ui.conversation").length() > 0 && "true".equals(this.m_state.getFormFieldAsString("qs.dorelease"))) {
            this.releaseConversation();
        }
        ActionHelper.setDefaultOptions(this.m_state);
        ActionHelper.addParameterValues(this.m_state);
        ActionHelper.setPromptOption(this.m_state);
        if ("true".equals(this.m_state.getFormFieldAsString("qs.addParameterValues"))) {
            ActionHelper.addParameterValuesFromConversation(this.m_state);
        }
        AsynchSpecification asynchSpecification = this.m_state.getSpecification();
        this.m_arguments = new IArgumentMarshaller[4];
        this.m_arguments[0] = asynchSpecification != null ? new AsynchSpecificationMarshaller(asynchSpecification) : new SingleSearchPathMarshaller(this.m_state.getObjectPath());
        this.m_arguments[1] = new ActionMarshaller(this.m_state.getFormFieldAsString("ui.command"));
        this.m_arguments[2] = new ParameterValuesMarshaller(this.m_state.getParameterValueManager().toArray());
        this.m_arguments[3] = new OptionMarshaller(this.m_state.getOptionManager().toArray());
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        AsynchSpecification asynchSpecification = this.m_state.getSpecification();
        String sRequestType = "editQuerySpecification";
        if (asynchSpecification == null) {
            sRequestType = "editQuery";
        }
        ICognosViewerRequest rsRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.REPORTSERVICEREQUEST);
        try {
            return rsRequest.executeRequest(sRequestType, this.m_state, this.m_arguments, "session");
        }
        catch (CognosViewerException cve) {
            this.m_state.getIPFLogger().error(cve.getMessage(), cve, this.getClass().getName());
            return this.handleAsynchException(cve);
        }
    }

    @Override
    public SOAPResponse handleAsynchException(CognosViewerException cognosViewerException) throws CognosViewerException {
        Element exceptionNumElement;
        this.m_state.getIPFLogger().enter("handleAsynchException", this.getClass().getName());
        CMServerBlankResponse exceptionSOAPResponse = null;
        Element faultBody = cognosViewerException.getFaultEnvelope().getBody();
        if (faultBody != null && "true".equals(this.m_state.getFormFieldAsString("qs.firstRun")) && (exceptionNumElement = (Element)faultBody.selectSingleNode("//*[local-name()='exception']/*[local-name()='errorCode']")) != null) {
            try {
                Integer exceptionNum = new Integer(exceptionNumElement.getTextTrim());
                if (exceptionNum == 901 || exceptionNum >= -500104 && exceptionNum <= -500101) {
                    this.m_state.setFormFieldFromString("cv.responseFormat", "qsUpgrade");
                    exceptionSOAPResponse = new CMServerBlankResponse(this.m_state);
                }
            }
            catch (NumberFormatException nfe) {
                this.m_state.getIPFLogger().error(nfe.getMessage(), nfe, this.getClass().getName());
                throw cognosViewerException;
            }
        }
        if (exceptionSOAPResponse == null) {
            this.m_state.getIPFLogger().debug("exceptionSOAPResponse is null !!!", this.getClass().getName());
            throw cognosViewerException;
        }
        this.m_state.getIPFLogger().exit("handleAsynchException", this.getClass().getName());
        return exceptionSOAPResponse;
    }
}

