/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.viewer.action.SecondaryRequestAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.ConversationMarshaller;
import com.cognos.viewer.model.marshallers.ElementMarshaller;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.ParameterValuesMarshaller;
import com.cognos.viewer.model.marshallers.SingleSearchPathMarshaller;
import com.cognos.viewer.utility.Protect;
import com.cognos.viewer.utility.XMLUtility;
import com.cognos.xts.ext.XTSExt;
import org.dom4j.Document;
import org.dom4j.Element;

public class EmailAction
extends SecondaryRequestAction {
    @Override
    public void prepareRequest() throws CognosViewerException {
        this.m_state.setFormFieldFromString("m_tracking", "");
        this.m_arguments = new IArgumentMarshaller[3];
        String sMethod = this.getEmailMethod();
        this.m_arguments[0] = "run".equals(sMethod) ? new SingleSearchPathMarshaller(this.m_state.getObjectPath()) : new ConversationMarshaller(this.m_state.getConversation());
        this.m_arguments[1] = new ParameterValuesMarshaller(this.m_state.getParameterValueManager().toArray());
        this.m_arguments[2] = this.getEmailOptionsMarshaller();
    }

    public IArgumentMarshaller getEmailOptionsMarshaller() throws CognosViewerException {
        ElementMarshaller elementMarshaller = null;
        try {
            String sEmailOptions = this.m_state.getFormFieldAsString("email.options");
            sEmailOptions = XTSExt.web64decode((String)Protect.cafaction("sign_unwrap", sEmailOptions), (boolean)true);
            Document document = XMLUtility.createXMLDocument(sEmailOptions);
            Element emailOptionsNode = document.getRootElement();
            elementMarshaller = new ElementMarshaller(emailOptionsNode);
        }
        catch (Exception exception) {
            throw new CognosViewerException(this.m_state.getBusEnvelope(), exception.getLocalizedMessage(), exception);
        }
        return elementMarshaller;
    }

    public String getEmailMethod() {
        return this.m_state.getFormFieldAsString("email.method");
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        String sMethod = this.getEmailMethod();
        SOAPResponse soapResponse = null;
        if ("run".equals(sMethod)) {
            ICognosViewerRequest request = this.m_serviceFactory.getService(CognosViewerServiceFactory.DELIVERYSERVICEREQUEST);
            soapResponse = request.executeRequest("run", this.m_state, this.m_arguments, "session");
        } else {
            ICognosViewerRequest request = this.getSecondaryRequestService();
            soapResponse = request.executeRequest("email", this.m_state, this.m_arguments, "high");
        }
        return soapResponse;
    }
}

