/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.rap.controller.RAPReport;
import com.cognos.rap.controller.ReportActionController;
import com.cognos.rap.exceptions.ActionControllerException;
import com.cognos.rap.exceptions.CognosServiceRequestAuthException;
import com.cognos.rap.exceptions.CognosServiceRequestWorkingStatusException;
import com.cognos.rap.exceptions.UnsupportedSpecificationException;
import com.cognos.viewer.action.ModifyReportAction;
import com.cognos.viewer.action.ObjectDefaultAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosServiceRequest;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.utility.MessageManager;
import org.dom4j.Element;

public class GetInfoFromReportSpecAction
extends ModifyReportAction {
    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        ObjectDefaultAction defaultAction = new ObjectDefaultAction();
        defaultAction.initialize(this.m_state, null);
        SOAPResponse result = defaultAction.buildNoOpResponse();
        try {
            this.setPropertiesFromConversation();
            this.getInfoFromRAP();
        }
        catch (CognosServiceRequestWorkingStatusException statusExeption) {
            SOAPResponse soapResponse = (SOAPResponse)statusExeption.getCustomValue();
            return soapResponse;
        }
        return result;
    }

    @Override
    protected SOAPResponse resumeExecution(SOAPResponse soapResponse) throws CognosViewerException {
        Element asyncSpec = null;
        if (soapResponse.getBusEnvelope() != null) {
            Element soapBody = soapResponse.getBusEnvelope().getBody();
            asyncSpec = (Element)soapBody.selectSingleNode(".//*[local-name()='queryResponse']//*[local-name()='specification']/*[local-name()='value']");
        }
        if (asyncSpec != null) {
            this.m_state.setReportSpecification(asyncSpec.getText());
            this.m_state.setFormFieldFromString("ui.primaryAction", "");
            try {
                this.getInfoFromRAP();
            }
            catch (CognosServiceRequestWorkingStatusException statusExeption) {
                SOAPResponse soapResponseWorkingStatus = (SOAPResponse)statusExeption.getCustomValue();
                return soapResponseWorkingStatus;
            }
        } else {
            this.m_state.setFormFieldFromString("ui.spec", GetInfoFromReportSpecAction.getEmptyReportSpec());
        }
        return soapResponse;
    }

    private void getInfoFromRAP() throws CognosViewerException, CognosServiceRequestWorkingStatusException {
        String reportSpec = this.m_state.getFormFieldAsString("ui.spec");
        try {
            CognosServiceRequest cognosServiceRequest = new CognosServiceRequest(this.m_state, this.m_serviceFactory);
            ReportActionController rap = new ReportActionController(cognosServiceRequest);
            rap.setViewerDebugLogger(this.m_state.getDebugLogger());
            RAPReport rapReport = new RAPReport(reportSpec);
            rapReport.setDefaultLocale(CognosViewerDispatcherHandlerState.getContentLocale(this.m_state));
            rapReport.setProductLocale(CognosViewerDispatcherHandlerState.getProductLocale(this.m_state));
            rap.getInfo(rapReport, this.m_state.getFormFieldAsString("cv.actionContext"));
            this.m_state.addObject("JSONOutput", rapReport.getReportInfo().toJSON());
        }
        catch (ActionControllerException actionException) {
            if (actionException.getCause() instanceof CognosServiceRequestAuthException) {
                CognosViewerException viewerExeption = (CognosViewerException)actionException.getCause().getCause();
                throw viewerExeption;
            }
            if (actionException.getCause() instanceof CognosServiceRequestWorkingStatusException) {
                this.m_state.addObject("JSONOutput", "");
                CognosServiceRequestWorkingStatusException statusExeption = (CognosServiceRequestWorkingStatusException)actionException.getCause();
                throw statusExeption;
            }
            if (actionException.getCause() instanceof UnsupportedSpecificationException) {
                CognosViewerException exception = new CognosViewerException(this.m_state.getBusEnvelope(), MessageManager.convert("IDS_CONTENT_INSERT_ERROR", CognosViewerDispatcherHandlerState.getProductLocale(this.m_state)), null);
                throw exception;
            }
            this.m_state.getIPFLogger().error(actionException.getMessage(), actionException.getClass().getName());
        }
        catch (Exception e) {
            this.m_state.getIPFLogger().error(e.getMessage(), e, this.getClass().getName());
        }
    }
}

