/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.developer.schemas.bibus._3.DeleteOptions;
import com.cognos.developer.schemas.bibus._3.OrderEnum;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.viewer.action.CognosViewerAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.DeleteRequestMarshaller;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.PropEnumMarshaller;
import com.cognos.viewer.model.marshallers.SearchPathMultipleObjectMarshaller;
import com.cognos.viewer.model.marshallers.SortMarshaller;
import com.cognos.xts.ext.XTSExt;
import java.util.List;
import org.dom4j.Element;

public class GetJSONLogsAction
extends CognosViewerAction {
    @Override
    public void prepareRequest() throws CognosViewerException {
        this.m_state.getDebugLogger().setGenerateJSONLogs(false);
        this.m_arguments = new IArgumentMarshaller[3];
        this.m_arguments[0] = new SearchPathMultipleObjectMarshaller(new SearchPathMultipleObject("~~/runTimeState[starts-with(@name,'ViewerJSONLogs')]"));
        this.m_arguments[1] = new PropEnumMarshaller(new PropEnum[]{PropEnum.state, PropEnum.searchPath, PropEnum.creationTime});
        Sort sort = new Sort();
        sort.setOrder(OrderEnum.ascending);
        sort.setPropName(PropEnum.creationTime);
        this.m_arguments[2] = new SortMarshaller(new Sort[]{sort});
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        ICognosViewerRequest cmRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.CMSERVICEREQUEST);
        CMServerResponse cmResponse = (CMServerResponse)cmRequest.executeRequest("query", this.m_state, this.m_arguments, "");
        DeleteOptions deleteOptions = new DeleteOptions();
        deleteOptions.setForce(true);
        deleteOptions.setRecursive(true);
        List items = cmResponse.getNodes("./*[local-name()='queryResponse']/*[local-name()='result']/*[local-name()='item']");
        int size = items.size();
        StringBuilder jsonOutput = new StringBuilder("[ ");
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                jsonOutput.append(",");
            }
            Element item = (Element)items.get(i);
            String searchPath = item.selectSingleNode("./searchPath/value").getText();
            IArgumentMarshaller[] deleteArguments = new IArgumentMarshaller[]{new DeleteRequestMarshaller(new String[]{searchPath}, new String[]{"runTimeState"}, deleteOptions)};
            cmRequest.executeRequest("delete", this.m_state, deleteArguments, "");
            String stateData = XTSExt.web64decode((String)item.selectSingleNode("./state/value").getText(), (boolean)true);
            jsonOutput.append(stateData);
        }
        jsonOutput.append("]");
        try {
            this.m_state.addObject("JSONOutput", jsonOutput.toString());
        }
        catch (Exception exception) {
            throw new CognosViewerException(this.m_state.getBusEnvelope(), exception.getMessage(), exception);
        }
        return cmResponse;
    }
}

