/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.viewer.action.ActionFactory;
import com.cognos.viewer.action.ActionHelper;
import com.cognos.viewer.action.CognosViewerAction;
import com.cognos.viewer.action.ReleaseAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.OptionMarshaller;
import com.cognos.viewer.model.marshallers.ParameterValuesMarshaller;
import com.cognos.viewer.model.marshallers.SingleSearchPathMarshaller;
import com.cognos.viewer.view.OutputResponseHelper;

public class GetObjectContextAction
extends CognosViewerAction {
    @Override
    public void prepareRequest() throws CognosViewerException {
        ActionHelper.addContextOptions(this.m_state);
        this.m_arguments = new IArgumentMarshaller[3];
        this.m_arguments[0] = new SingleSearchPathMarshaller(this.m_state.getObjectPath());
        this.m_arguments[1] = new ParameterValuesMarshaller(this.m_state.getParameterValueManager().toArray());
        this.m_arguments[2] = new OptionMarshaller(this.m_state.getOptionManager().toArray());
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        ICognosViewerRequest rsRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.REPORTSERVICEREQUEST);
        SOAPResponse soapResponse = rsRequest.executeRequest("getObjectContext", this.m_state, this.m_arguments, "");
        return this.resumeExecution(soapResponse);
    }

    @Override
    protected SOAPResponse resumeExecution(SOAPResponse soapResponse) throws CognosViewerException {
        String status = soapResponse.getStatus();
        if (!"complete".equals(status) && !"conversationComplete".equals(status)) {
            return soapResponse;
        }
        if ("complete".equals(status)) {
            String originalActionName = this.m_state.getFormFieldAsString("ui.action");
            try {
                String trackingString = OutputResponseHelper.getTracking(soapResponse);
                this.m_state.setFormFieldFromString("m_tracking", trackingString);
                ActionFactory actionFactory = new ActionFactory(this.m_serviceFactory);
                this.m_state.setFormFieldFromString("ui.primaryAction", "release");
                this.m_state.setFormFieldFromString("ui.action", "release");
                ReleaseAction releaseAction = (ReleaseAction)actionFactory.load("release", this.m_state);
                releaseAction.execute();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_state.setFormFieldFromString("ui.action", originalActionName);
        }
        return soapResponse;
    }

    @Override
    protected boolean insertAsynchReportOutput() {
        return false;
    }
}

