/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.viewer.action.ActionHelper;
import com.cognos.viewer.action.CognosViewerAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerRequest;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.view.GetTransientsOutput;
import org.dom4j.Element;

public class GetParametersAction
extends CognosViewerAction {
    @Override
    public void prepareRequest() throws CognosViewerException {
        ActionHelper.addParameterValues(this.m_state);
        this.m_arguments = this.getGetParameterArguments(this.m_state.getSpecification() != null);
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        SOAPResponse soapResponse = null;
        ICognosViewerRequest rsRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.REPORTSERVICEREQUEST);
        if (this.m_state.getSpecification() != null) {
            CognosViewerRequest request = new CognosViewerRequest("getParametersSpecification", this.m_state, this.m_arguments, "high", this.m_state.isBUX());
            soapResponse = rsRequest.executeRequest(request);
        } else {
            soapResponse = rsRequest.executeRequest("getParameters", this.m_state, this.m_arguments, "high");
        }
        return this.resumeExecution(soapResponse);
    }

    @Override
    protected SOAPResponse resumeExecution(SOAPResponse soapResponse) throws CognosViewerException {
        String status = soapResponse.getStatus();
        if (!"complete".equals(status) && !"conversationComplete".equals(status)) {
            return soapResponse;
        }
        Element soapBody = soapResponse.getBusEnvelope().getBody();
        if (soapBody.selectSingleNode("./*/*[local-name()='result']/*[local-name()='details']/*[local-name()='item'][@xsi:type='bus:asynchDetailParameters']/*[local-name()='parameters']/item") != null) {
            GetTransientsOutput transientsOutput = new GetTransientsOutput();
            transientsOutput.parseReportSecification(soapResponse);
            Element reportPrompts = transientsOutput.generateTransientSpec(soapResponse);
            soapResponse.addObject("JSONOutput", "{ xml : '" + EncodingUtility.xmlencode(reportPrompts.asXML()) + "'}");
        }
        return soapResponse;
    }

    @Override
    protected boolean insertAsynchReportOutput() {
        return false;
    }
}

