/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.viewer.action.ActionHelper;
import com.cognos.viewer.action.CognosViewerAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerBlankResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.CognosViewerReportSpecificationFactory;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.OptionManager;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.AsynchSpecificationMarshaller;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.OptionMarshaller;
import com.cognos.viewer.model.marshallers.ParameterValuesMarshaller;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.XMLUtility;
import java.util.Hashtable;
import org.dom4j.Document;
import org.dom4j.Element;

public class GetQualityOfServiceAction
extends CognosViewerAction {
    private static Hashtable<String, QualityOfServiceCacheValue> qualityOfServiceCache = new Hashtable();

    public static String getCachedQoSValue(ICognosViewerState state) {
        String metadataModel = state.getFormFieldAsString("modelPath");
        String metadataModelModificationTime = state.getFormFieldAsString("metaDataModelModificationTime");
        QualityOfServiceCacheValue qualityOfServiceCacheValue = qualityOfServiceCache.get(metadataModel);
        if (qualityOfServiceCacheValue != null && !"".equals(metadataModelModificationTime) && metadataModelModificationTime.equals(qualityOfServiceCacheValue.m_modificationTime)) {
            return qualityOfServiceCacheValue.m_supportedFunctionsString;
        }
        return null;
    }

    public void setQualityOfService(String sModelPath, String sModificationTime, String sSupportedFunctions) {
        qualityOfServiceCache.put(sModelPath, new QualityOfServiceCacheValue(sModificationTime, sSupportedFunctions));
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        String metadataModel = this.m_state.getFormFieldAsString("modelPath");
        String metadataModelModificationTime = this.m_state.getFormFieldAsString("metaDataModelModificationTime");
        QualityOfServiceCacheValue qualityOfServiceCacheValue = qualityOfServiceCache.get(metadataModel);
        if (qualityOfServiceCacheValue != null && !"".equals(metadataModelModificationTime) && metadataModelModificationTime.equals(qualityOfServiceCacheValue.m_modificationTime)) {
            this.m_state.addObject("JSONOutput", qualityOfServiceCacheValue.m_supportedFunctionsString);
            return new CMServerBlankResponse(this.m_state);
        }
        if (qualityOfServiceCacheValue != null) {
            qualityOfServiceCache.remove(metadataModel);
        }
        IArgumentMarshaller[] arguments = new IArgumentMarshaller[3];
        arguments[0] = new AsynchSpecificationMarshaller(this.buildMAQuerySpec());
        ActionHelper.addParameterValues(this.m_state);
        arguments[1] = new ParameterValuesMarshaller(this.m_state.getParameterValueManager().toArray());
        OptionManager optionManager = new OptionManager();
        ActionHelper.addAsynchOptions(this.m_state, 30, 30, false);
        this.addPromptOptions(optionManager);
        optionManager.addOption("run.continueConversation", "false");
        arguments[2] = new OptionMarshaller(optionManager.toArray());
        ICognosViewerRequest rsRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.REPORTSERVICEREQUEST);
        SOAPResponse soapResponse = rsRequest.executeRequest("runSpecification", this.m_state, arguments, "session");
        return this.resumeExecution(soapResponse);
    }

    @Override
    protected boolean insertAsynchReportOutput() {
        return false;
    }

    @Override
    protected SOAPResponse resumeExecution(SOAPResponse soapResponse) throws CognosViewerException {
        if (this.isActionRequestComplete(soapResponse)) {
            this.setQualityOfServiceResponseHandler(soapResponse);
        }
        return soapResponse;
    }

    public void setQualityOfServiceResponseHandler(SOAPResponse soapResponse) throws CognosViewerException {
        Element soapBody = soapResponse.getBusEnvelope().getBody();
        Element metadataElement = (Element)soapBody.selectSingleNode(".//*[local-name() = 'metadata']");
        if (metadataElement != null) {
            this.setQualityOfServiceValue(metadataElement.getText());
        }
    }

    private AsynchSpecification buildMAQuerySpec() throws CognosViewerException {
        String contentLocale = CognosViewerDispatcherHandlerState.getContentLocale(this.m_state);
        String maQueryTemplate = "<metadataRequest connection=\"modelPath\"><Functions Depth=\"\" authoringLocale=\"" + contentLocale + "\" start_at=\"\">" + "<Properties>" + "<Property name=\"./group\"/> " + "<Property name=\"group/@\"/>" + "<Property name=\"./function\"/>" + "<Property name=\"function/@id\"/>" + "<Property name=\"function/@name\"/>" + "<Property name=\"function/@qosLevel\"/>" + "</Properties>" + "</Functions>" + "</metadataRequest>";
        String modelPath = this.m_state.getFormFieldAsString("modelPath");
        String maQuerySpec = maQueryTemplate.replaceFirst("modelPath", EncodingUtility.encodeXMLAttribute(modelPath));
        CognosViewerReportSpecificationFactory specificationFactory = new CognosViewerReportSpecificationFactory();
        AsynchSpecification asynchSpecification = specificationFactory.load("reportServiceMetadataSpecification");
        Specification specification = new Specification();
        specification.set_value(maQuerySpec);
        asynchSpecification.setValue(specification);
        return asynchSpecification;
    }

    private void setQualityOfServiceValue(String qosString) throws CognosViewerException {
        try {
            boolean isDivideSupported;
            boolean isSubtractSupported;
            StringBuffer supportedFunctionsBuffer = new StringBuffer();
            Document xmlDocument = XMLUtility.createXMLDocument(qosString);
            Element qosElement = xmlDocument.getRootElement();
            supportedFunctionsBuffer.append("[ ");
            if (this.isSupportedFunction(qosElement, "ces_add")) {
                supportedFunctionsBuffer.append("\"");
                supportedFunctionsBuffer.append("AdditionCalculation");
                supportedFunctionsBuffer.append("\",");
            }
            if (isSubtractSupported = this.isSupportedFunction(qosElement, "ces_subtract")) {
                supportedFunctionsBuffer.append("\"");
                supportedFunctionsBuffer.append("SubtractionCalculation");
                supportedFunctionsBuffer.append("\",");
                supportedFunctionsBuffer.append("\"");
                supportedFunctionsBuffer.append("SubtractionCalculationSwapOrder");
                supportedFunctionsBuffer.append("\",");
            }
            if (this.isSupportedFunction(qosElement, "ces_multiply")) {
                supportedFunctionsBuffer.append("\"");
                supportedFunctionsBuffer.append("MultiplicationCalculation");
                supportedFunctionsBuffer.append("\",");
            }
            if (isDivideSupported = this.isSupportedFunction(qosElement, "ces_divide")) {
                supportedFunctionsBuffer.append("\"");
                supportedFunctionsBuffer.append("DivisionCalculation");
                supportedFunctionsBuffer.append("\",");
                supportedFunctionsBuffer.append("\"");
                supportedFunctionsBuffer.append("DivisionCalculationSwapOrder");
                supportedFunctionsBuffer.append("\",");
            }
            if (isDivideSupported && isSubtractSupported) {
                supportedFunctionsBuffer.append("\"");
                supportedFunctionsBuffer.append("PercentDifferenceCalculation");
                supportedFunctionsBuffer.append("\",");
                supportedFunctionsBuffer.append("\"");
                supportedFunctionsBuffer.append("PercentDifferenceCalculationSwapOrder");
                supportedFunctionsBuffer.append("\",");
            }
            if (this.isSupportedFunction(qosElement, "MULTIPLE_MEASURE_DIMENSION_CALCULATIONS")) {
                supportedFunctionsBuffer.append("\"");
                supportedFunctionsBuffer.append("MULTIPLE_MEASURE_DIMENSION_CALCULATIONS");
                supportedFunctionsBuffer.append("\",");
            }
            if (this.isSupportedFunction(qosElement, "VALUE_EXPRESSIONS_REF_MULTIPLE_HIERARCHIES_OF_SAME_DIMENSION")) {
                supportedFunctionsBuffer.append("\"");
                supportedFunctionsBuffer.append("VALUE_EXPRESSIONS_REF_MULTIPLE_HIERARCHIES_OF_SAME_DIMENSION");
                supportedFunctionsBuffer.append("\"");
            }
            supportedFunctionsBuffer.append(" ]");
            String supportedFunctionsString = supportedFunctionsBuffer.toString();
            String modelPath = this.m_state.getFormFieldAsString("modelPath");
            String metaDataModelModificationTime = this.m_state.getFormFieldAsString("metaDataModelModificationTime");
            if (!"".equals(modelPath) && metaDataModelModificationTime != null) {
                qualityOfServiceCache.put(modelPath, new QualityOfServiceCacheValue(metaDataModelModificationTime, supportedFunctionsString));
            }
            this.m_state.addObject("JSONOutput", supportedFunctionsString);
        }
        catch (Exception e) {
            throw new CognosViewerException(this.m_state.getBusEnvelope(), e.getMessage(), e);
        }
    }

    private boolean isSupportedFunction(Element qosElement, String functionId) {
        Element functionElement = (Element)qosElement.selectSingleNode(".//*[local-name() = 'function'][@id = '" + functionId + "']");
        return functionElement != null && "OK".equals(functionElement.attribute("qosLevel").getValue());
    }

    class QualityOfServiceCacheValue {
        public String m_modificationTime;
        public String m_supportedFunctionsString;

        public QualityOfServiceCacheValue(String modificationTime, String supportedFunctionsString) {
            this.m_modificationTime = modificationTime;
            this.m_supportedFunctionsString = supportedFunctionsString;
        }
    }
}

