/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.rap.controller.RAPReport;
import com.cognos.rap.controller.ReportActionController;
import com.cognos.rap.exceptions.ActionControllerException;
import com.cognos.viewer.action.ActionFactory;
import com.cognos.viewer.action.ActionHelper;
import com.cognos.viewer.action.ICognosViewerAction;
import com.cognos.viewer.action.ObjectDefaultAction;
import com.cognos.viewer.action.RunSpecificationAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.controller.CognosViewerRAPException;
import com.cognos.viewer.model.CognosServiceRequest;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.utility.Protect;
import com.cognos.xts.ext.XTSExt;

public class ModifyReportAction
extends RunSpecificationAction {
    private boolean m_bCallForward = false;
    private boolean m_bSafeForSecondaryRequest = true;

    @Override
    public void prepareRequest() throws CognosViewerException {
    }

    @Override
    protected void cleanViewerState() throws CognosViewerException {
        super.cleanViewerState();
        ActionHelper.applyRAPParameterUpdates(this.m_state);
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        boolean bRunTheModifiedSpec = true;
        try {
            boolean usedConversationForOptions = false;
            if ("true".equals(this.m_state.getFormFieldAsString("widget.forceRunSpec"))) {
                this.m_bSafeForSecondaryRequest = false;
            }
            bRunTheModifiedSpec = this.applyReportActionProcessorChanges();
            if (this.m_bSafeForSecondaryRequest && this.m_state.getParameterValueManager().containsRAPParameterValues() && this.m_state.getFormFieldAsString("m_tracking").length() > 0 && this.m_state.getFormFieldAsString("ui.conversation").length() > 0) {
                this.m_bCallForward = true;
            } else {
                if (this.m_state.getFormFieldAsString("ui.conversation").length() > 0) {
                    usedConversationForOptions = true;
                    this.setPropertiesFromConversation();
                }
                this.m_state.setFormFieldFromString("ui.conversation", "");
                this.setupRunOptions();
                if (bRunTheModifiedSpec && !usedConversationForOptions && "true".equals(this.m_state.getFormFieldAsString("bux"))) {
                    this.m_state.initializeXslRunOptions();
                    ActionHelper.prepareForBUXRunRequest(this.m_state);
                }
            }
        }
        catch (ActionControllerException e) {
            return ActionHelper.handleActionControllerException(e, this.m_state);
        }
        if (bRunTheModifiedSpec) {
            return this.runReport();
        }
        ObjectDefaultAction defaultAction = new ObjectDefaultAction();
        this.m_state.addObject("XMLOutput_reportSpec", this.m_state.getFormFieldAsString("ui.spec"));
        defaultAction.initialize(this.m_state, null);
        return defaultAction.buildNoOpResponse();
    }

    public SOAPResponse runReport() throws CognosViewerException {
        if (this.m_bCallForward) {
            ActionHelper.applyRAPParameterUpdates(this.m_state);
            this.m_state.setFormFieldFromString("ui.primaryAction", "");
            this.m_state.setFormFieldFromString("ui.action", "forward");
            ActionFactory actionFactory = new ActionFactory(this.m_serviceFactory);
            ICognosViewerAction forwardAction = actionFactory.load("forward", this.m_state);
            return forwardAction.execute();
        }
        this.doPrepareRequest();
        return this.doExecuteRequest();
    }

    public boolean applyReportActionProcessorChanges() throws CognosViewerException, ActionControllerException {
        String reportSpec = this.m_state.getFormFieldAsString("ui.spec");
        RAPReport rapReport = new RAPReport(reportSpec);
        boolean bRunModifiedSpec = true;
        try {
            CognosServiceRequest cognosServiceRequest = new CognosServiceRequest(this.m_state, this.m_serviceFactory);
            ReportActionController rap = new ReportActionController(cognosServiceRequest);
            rap.setViewerDebugLogger(this.m_state.getDebugLogger());
            String rapState = this.m_state.getFormFieldAsString("rap.state");
            if (rapState.length() > 0 && !rapState.startsWith("<")) {
                rapState = XTSExt.web64decode((String)Protect.cafaction("sign_unwrap", rapState), (boolean)true);
            }
            rap.setReportActionStateFromString(rapState);
            rapReport.setParameterUpdateMap(ActionHelper.getRAPParameterUpdateMap(this.m_state));
            rapReport.setDefaultLocale(CognosViewerDispatcherHandlerState.getContentLocale(this.m_state));
            rapReport.setProductLocale(CognosViewerDispatcherHandlerState.getProductLocale(this.m_state));
            if (this.m_state.getDebugLogger().isDebugEnabled()) {
                this.m_state.getDebugLogger().logXML(this.m_state.getFormFieldAsString("cv.actionContext"), "rapAction.xml", true, "rapAction");
            }
            rap.applyActions(rapReport, this.m_state.getFormFieldAsString("cv.actionContext"));
            ModifyReportAction.saveReportInfoToState(this.m_state, rapReport);
            this.m_state.setFormFieldFromString("rap.state", rap.getReportActionStateAsString());
            boolean bl = bRunModifiedSpec = !rap.getCallerSetRunFalse();
            if (!rapReport.isReportModificationSafeForSecondaryRequest()) {
                this.m_bSafeForSecondaryRequest = false;
            }
        }
        catch (ActionControllerException e) {
            throw e;
        }
        catch (Exception e) {
            this.m_state.getIPFLogger().error(e.getMessage(), e, this.getClass().getName());
            throw new CognosViewerRAPException(this.m_state, e, this.m_state.getFormFieldAsString("cv.actionContext"));
        }
        return bRunModifiedSpec;
    }

    protected void setupRunOptions() throws CognosViewerException {
        this.m_state.setFormFieldFromString("ui.action", "runSpecification");
    }

    public static void saveReportInfoToState(ICognosViewerState state, RAPReport rapReport) throws Exception {
        state.updateSpecificationContents(rapReport.getDOM().asXML());
        if (rapReport.getReportInfo() != null) {
            String json = rapReport.getReportInfo().updateJSON(state.getFormFieldAsString("rap.reportInfo"));
            state.setFormFieldFromString("rap.reportInfo", json);
            state.addObject("JSONOutput", json);
            if (rapReport.getReportInfo().getShouldDisableReuseResults()) {
                state.setFormFieldFromString("reuseResults", "false");
                state.getBusEnvelope().setFormField("reuseResults", "false");
            }
        }
    }

    public static String getEmptyReportSpec() {
        return "<report xmlns=\"http://developer.cognos.com/schemas/report/6.0/\" expressionLocale=\"en-us\"><layouts><layout/></layouts></report>";
    }

    @Override
    protected boolean doTrustedRequest() {
        return super.doTrustedRequest() || this.m_state.getAllowSpecModification();
    }
}

