/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.ReportSpecProtectionSession;
import com.cognos.accman.jcam.crypto.SecureStateSession;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.ReportServiceQuerySpecification;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.viewer.action.ActionHelper;
import com.cognos.viewer.action.ReportOutputAction;
import com.cognos.viewer.configuration.CognosViewerSystemParams;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerBlankResponse;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.ActionMarshaller;
import com.cognos.viewer.model.marshallers.AsynchSpecificationMarshaller;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.OptionMarshaller;
import com.cognos.viewer.model.marshallers.ParameterValuesMarshaller;
import com.cognos.viewer.utility.CAMFactoryPool;
import com.cognos.viewer.utility.EncodingUtility;
import java.io.UnsupportedEncodingException;
import org.dom4j.Element;

public class NewAction
extends ReportOutputAction {
    @Override
    public void prepareRequest() throws CognosViewerException {
        if (this.m_state.getFormFieldAsString("ui.conversation").length() > 0 && "true".equals(this.m_state.getFormFieldAsString("qs.dorelease"))) {
            try {
                this.releaseConversation();
            }
            catch (Exception exception) {
                this.m_state.getIPFLogger().info("Caught exception when trying to release conversation: " + exception.getMessage(), this.getClass().getName());
            }
        }
        ActionHelper.setDefaultOptions(this.m_state);
        ActionHelper.addParameterValues(this.m_state);
        ActionHelper.setPromptOption(this.m_state);
        if ("true".equals(this.m_state.getFormFieldAsString("qs.addParameterValues"))) {
            ActionHelper.addParameterValuesFromConversation(this.m_state);
        }
        StringBuffer sbNewMiniQuery = this.generateNewMiniQuery();
        String sCommand = "";
        boolean bSignSpecification = this.signSpecification();
        byte[] protectedSpec = null;
        if (bSignSpecification) {
            protectedSpec = this.getProtectedSpecification(sbNewMiniQuery);
        }
        ReportServiceQuerySpecification asynchSpecification = new ReportServiceQuerySpecification();
        Specification specification = new Specification();
        String sMiniQuery = null;
        try {
            sMiniQuery = protectedSpec != null ? new String(protectedSpec, "UTF-8") : sbNewMiniQuery.toString();
        }
        catch (UnsupportedEncodingException e) {
            this.m_state.getIPFLogger().error(e.getMessage(), e, this.getClass().getName());
        }
        specification.set_value(sMiniQuery);
        asynchSpecification.setValue(specification);
        this.m_arguments = new IArgumentMarshaller[4];
        this.m_arguments[0] = new AsynchSpecificationMarshaller((AsynchSpecification)asynchSpecification);
        this.m_arguments[1] = new ActionMarshaller(sCommand);
        this.m_arguments[2] = new ParameterValuesMarshaller(this.m_state.getParameterValueManager().toArray());
        this.m_arguments[3] = new OptionMarshaller(this.m_state.getOptionManager().toArray());
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        ICognosViewerRequest rsRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.REPORTSERVICEREQUEST);
        try {
            return rsRequest.executeRequest("editQuerySpecification", this.m_state, this.m_arguments, "session");
        }
        catch (CognosViewerException cve) {
            this.m_state.getIPFLogger().error(cve.getMessage(), cve, this.getClass().getName());
            return this.handleAsynchException(cve);
        }
    }

    public byte[] getProtectedSpecification(StringBuffer sbNewMiniQuery) {
        ReportSpecProtectionSession rsps = null;
        try {
            rsps = CAMFactoryPool.createReportSpecProtectionSession();
        }
        catch (Exception e) {
            this.m_state.getIPFLogger().error(e.getMessage(), e, this.getClass().getName());
            return null;
        }
        try {
            rsps.setSpec(sbNewMiniQuery.toString().getBytes("UTF-8"));
        }
        catch (Exception e) {
            this.m_state.getIPFLogger().error(e.getMessage(), this.getClass().getName());
            return null;
        }
        byte[] protectedSpec = null;
        try {
            protectedSpec = rsps.protectData();
        }
        catch (Exception e) {
            this.m_state.getIPFLogger().error(e.getMessage(), this.getClass().getName());
            return null;
        }
        return protectedSpec;
    }

    public boolean signSpecification() {
        boolean signSpecification = false;
        boolean validSecureState = false;
        SecureStateSession sss = null;
        try {
            Element searchPathValue;
            Element soapHeader;
            CAMPassport passport = this.m_state.getCAMPassport();
            BIBusEnvelope busResponse = this.m_state.getBusEnvelope();
            String secureState = "";
            if (busResponse != null && (soapHeader = busResponse.getHeader()) != null && (searchPathValue = (Element)soapHeader.selectSingleNode("./*[local-name()='biBusHeader']/*[local-name()='CAF']/secureState")) != null && !"".equals(searchPathValue.getText().trim())) {
                secureState = searchPathValue.getText().trim();
            }
            String passportId = null;
            if (passport != null) {
                passportId = passport.getId();
            }
            if (passportId != null && secureState != null && !"".equals(secureState) && (sss = CAMFactoryPool.createSecureStateSession(passportId.getBytes("UTF-8"), secureState.getBytes("UTF-8"))) != null) {
                validSecureState = sss.verifySecureStateToken();
            }
        }
        catch (CAMCryptoException e) {
            this.m_state.getIPFLogger().error("CAM secure state verify failed - " + e.getMessage(), this.getClass().getName());
        }
        catch (UnsupportedEncodingException e) {
            this.m_state.getIPFLogger().error(e.getMessage(), this.getClass().getName());
        }
        if (validSecureState && sss != null) {
            try {
                signSpecification = sss.getRequestExternal();
            }
            catch (CAMCryptoException e) {
                this.m_state.getIPFLogger().error("CAM request external failed - " + e.getMessage(), this.getClass().getName());
            }
        }
        return signSpecification;
    }

    public StringBuffer generateNewMiniQuery() {
        String sLimitedDataMode;
        StringBuffer sbNewMiniQuery = new StringBuffer();
        sbNewMiniQuery.append("<CRQReport majorVersion=\"\" minorVersion=\"\" expressionLocale=\"");
        String sContentLocale = this.m_state.getUserPreference("contentLocale");
        if (sContentLocale != null) {
            sbNewMiniQuery.append(sContentLocale);
        }
        sbNewMiniQuery.append("\"");
        sbNewMiniQuery.append(" srcModel=\"");
        String sCmLastModelSearchPath = this.m_state.getFormFieldAsString("cmLastModelSearchPath");
        if ("".equals(sCmLastModelSearchPath)) {
            String sUiObject = EncodingUtility.xmlencode(this.m_state.getFormFieldAsString("ui.object"));
            sbNewMiniQuery.append(sUiObject);
        } else {
            sbNewMiniQuery.append(EncodingUtility.xmlencode(sCmLastModelSearchPath));
        }
        sbNewMiniQuery.append("\"");
        String sQsTemplate = this.m_state.getFormFieldAsString("qs.template");
        if (!sQsTemplate.equals("") && !sQsTemplate.equals("null")) {
            sbNewMiniQuery.append(" template=\"");
            sbNewMiniQuery.append(EncodingUtility.xmlencode(sQsTemplate));
            sbNewMiniQuery.append("\"");
        }
        if ((sLimitedDataMode = CognosViewerSystemParams.getSystemParam("limitedDataMode")).equals("")) {
            sLimitedDataMode = this.m_state.getFormFieldAsString("qs.limitedDataMode");
        }
        if (!sLimitedDataMode.equals("")) {
            if (sLimitedDataMode.equals("nodata")) {
                sLimitedDataMode = "none";
            }
            if (sLimitedDataMode.equals("none") || sLimitedDataMode.equals("partial")) {
                sbNewMiniQuery.append(" limitData=\"");
                sbNewMiniQuery.append(sLimitedDataMode);
                sbNewMiniQuery.append("\"");
            }
        }
        sbNewMiniQuery.append("></CRQReport>");
        return sbNewMiniQuery;
    }

    @Override
    public SOAPResponse handleAsynchException(CognosViewerException cognosViewerException) throws CognosViewerException {
        Element exceptionNumElement;
        this.m_state.getIPFLogger().enter("handleAsynchException", this.getClass().getName());
        CMServerBlankResponse exceptionSOAPResponse = null;
        Element faultBody = cognosViewerException.getFaultEnvelope().getBody();
        if (faultBody != null && (exceptionNumElement = (Element)faultBody.selectSingleNode("//*[local-name()='exception']/*[local-name()='errorCode']")) != null) {
            try {
                Integer exceptionNum = new Integer(exceptionNumElement.getTextTrim());
                if (exceptionNum == -901 || exceptionNum >= -500104 && exceptionNum <= -500101) {
                    this.m_state.setFormFieldFromString("cv.responseFormat", "qs");
                    this.m_state.setFormFieldFromString("qs.needsUpdate", "true");
                    exceptionSOAPResponse = new CMServerBlankResponse(this.m_state);
                }
            }
            catch (NumberFormatException nfe) {
                this.m_state.getIPFLogger().error(nfe.getMessage(), nfe, this.getClass().getName());
                throw cognosViewerException;
            }
        }
        if (exceptionSOAPResponse == null) {
            this.m_state.getIPFLogger().debug("exceptionSOAPResponse is null !!!", this.getClass().getName());
            throw cognosViewerException;
        }
        this.m_state.getIPFLogger().exit("handleAsynchException", this.getClass().getName());
        return exceptionSOAPResponse;
    }
}

