/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.viewer.action.ActionFactory;
import com.cognos.viewer.action.ActionHelper;
import com.cognos.viewer.action.DrillThroughAction;
import com.cognos.viewer.action.ICognosViewerAction;
import com.cognos.viewer.action.ReportOutputAction;
import com.cognos.viewer.action.ViewAction;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerBlankResponse;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.ParameterValueManager;
import com.cognos.viewer.model.SOAPResponse;
import java.util.List;
import org.dom4j.Element;

public class OutputAction
extends ReportOutputAction {
    private boolean m_bBurstedReport = false;
    private boolean m_bHasAllBurstParameters = false;
    private String m_sOriginalSearchPath = "";

    @Override
    public void prepareRequest() throws CognosViewerException {
        if (this.m_state != null) {
            this.m_bBurstedReport = this.m_state.getTransientSpec().hasBurstSpec();
            this.m_bHasAllBurstParameters = this.m_state.getTransientSpec().hasAllNeededBurstParameters(this.m_state.getParameterValueManager());
            this.m_sOriginalSearchPath = this.m_state.getFormFieldAsString("ui.object");
        }
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        SOAPResponse actionResponse = null;
        if (this.m_bBurstedReport && this.m_bHasAllBurstParameters && (actionResponse = this.getBurstOutput()) != null) {
            this.releaseConversation();
            return actionResponse;
        }
        this.m_state.setFormFieldFromString("ui.object", this.m_sOriginalSearchPath);
        actionResponse = this.getDefaultOutput();
        if (actionResponse != null) {
            this.releaseConversation();
            return this.viewingOutput(actionResponse);
        }
        return this.runningReport();
    }

    public SOAPResponse runningReport() throws CognosViewerException {
        this.m_state.setFormFieldFromString("fragment.transientSpecMap", "parameter");
        if (this.showBlankInteractiveFragmentPage()) {
            this.queryContentManager(this.m_sOriginalSearchPath);
            return this.generateBlankFragmentResponse();
        }
        this.m_state.setFormFieldFromString("ui.primaryAction", "");
        this.m_state.setFormFieldFromString("ui.object", this.m_sOriginalSearchPath);
        if ("runIcon".equals(this.m_state.getFormFieldAsString("ui.subaction"))) {
            this.queryContentManager(this.m_sOriginalSearchPath);
            this.m_state.setFormFieldFromString("ui.action", "runIcon");
            CMServerBlankResponse blankResponse = new CMServerBlankResponse(this.m_state);
            return blankResponse;
        }
        return this.runObject();
    }

    public SOAPResponse viewingOutput(SOAPResponse actionResponse) {
        actionResponse.setFormFieldFromString("fragment.transientSpecMap", "burst");
        String burstKey = ((CMServerResponse)actionResponse).getProperty("burstKey");
        if (this.m_bBurstedReport && burstKey.length() > 0) {
            if (!this.m_bHasAllBurstParameters && this.getWaitForPromptValues()) {
                actionResponse.setFormFieldFromString("fragment.outputHint", "blankPage");
            } else if (this.m_bHasAllBurstParameters) {
                actionResponse.setFormFieldFromString("fragment.outputHint", "missingBurstOutput");
            }
        }
        return actionResponse;
    }

    public String getDefaultOutputSearchPath() {
        String sDefaultOutputSearchPath;
        String sObjectPath = this.m_state.getFormFieldAsString("ui.object");
        if (sObjectPath.startsWith("defaultOutput(")) {
            sDefaultOutputSearchPath = sObjectPath;
        } else {
            String sOutputLocale = this.m_state.getFormFieldAsString("ui.outputLocale");
            sDefaultOutputSearchPath = "defaultOutput(" + sObjectPath + ",'" + this.getOutputFormat() + "','" + sOutputLocale + "','" + this.getSupportedOutputFormats() + "')";
        }
        return sDefaultOutputSearchPath;
    }

    protected String getOutputFormat() {
        return this.m_state.getFormFieldAsString("ui.format");
    }

    protected String getSupportedOutputFormats() {
        return "CSV HTML HTMLFragment MHT PDF spreadsheetML XHTML XLWA XML singleXLS XLS";
    }

    protected SOAPResponse runObject() throws CognosViewerException {
        DrillThroughAction.checkCapabilityForDrillThroughFormat(this.m_state);
        ActionFactory actionFactory = new ActionFactory(this.m_serviceFactory);
        this.m_state.setFormFieldFromString("ui.action", "run");
        ICognosViewerAction runAction = actionFactory.load("run", this.m_state);
        return runAction.execute();
    }

    public void setExecutionFormat() {
        if (!"PDF".equals(this.m_state.getFormFieldAsString("run.outputFormat")) && !"XML".equals(this.m_state.getFormFieldAsString("run.outputFormat"))) {
            this.m_state.setFormFieldFromString("run.outputFormat", "HTMLFragment");
        }
    }

    public SOAPResponse getDefaultOutput() throws CognosViewerException {
        String sDefaultOutputSearchPath = this.getDefaultOutputSearchPath();
        return this.executeViewRequest(sDefaultOutputSearchPath);
    }

    public SOAPResponse getBurstOutput() throws CognosViewerException {
        String sBurstedOutputSearchPath = this.getBurstedOutputSearchPath();
        if (sBurstedOutputSearchPath == null || sBurstedOutputSearchPath.length() == 0) {
            return null;
        }
        return this.executeViewRequest(sBurstedOutputSearchPath);
    }

    private SOAPResponse executeViewRequest(String sSearchPath) throws CognosViewerException {
        this.m_state.setFormFieldFromString("ui.object", sSearchPath);
        this.m_state.setFormFieldFromString("ui.action", "view");
        ActionFactory actionFactory = new ActionFactory(this.m_serviceFactory);
        ViewAction viewAction = (ViewAction)actionFactory.load("view", this.m_state);
        SOAPResponse response = viewAction.execute();
        if (response != null && ActionHelper.hasQueryResult(response.getBusEnvelope())) {
            return response;
        }
        return null;
    }

    public String getBurstedOutputSearchPath() {
        String sBurstKey = this.getBurstKey();
        if (sBurstKey.length() == 0) {
            return "";
        }
        String sSearchPath = this.m_state.getFormFieldAsString("fragment.object") + "/reportVersion[@name=\"" + this.m_state.getFormFieldAsString("ui.reportVersion") + "\"]/output[";
        sSearchPath = "true".equals(CognosViewerDispatcherHandler.getConfigValues().get("matchOnBurstKey")) ? sSearchPath + "@burstKey='" : sSearchPath + "@burstID='";
        sSearchPath = sSearchPath + sBurstKey + "']";
        return sSearchPath;
    }

    public String getBurstKey() {
        StringBuilder sBurstKey = new StringBuilder("");
        ParameterValueManager parameterValueManager = this.m_state.getParameterValueManager();
        List burstItemsList = this.m_state.getTransientSpec().getBurstItemList();
        if (burstItemsList == null || burstItemsList.size() == 0) {
            return "";
        }
        for (int iBurstIndex = 0; iBurstIndex < burstItemsList.size(); ++iBurstIndex) {
            Element burstItem = (Element)burstItemsList.get(iBurstIndex);
            if (burstItem.attributeValue("burstName") == null) {
                return "";
            }
            ParameterValue parameterValue = parameterValueManager.getParameterValue(burstItem.attributeValue("burstName"));
            if (parameterValue == null) {
                return "";
            }
            ParmValueItem[] parmValueItems = parameterValue.getValue();
            if (parmValueItems == null || parmValueItems.length != 1) {
                return "";
            }
            SimpleParmValueItem simpleParmValueItem = (SimpleParmValueItem)parmValueItems[0];
            if (sBurstKey.length() > 0) {
                sBurstKey.append(":");
            }
            sBurstKey.append(simpleParmValueItem.getUse());
        }
        return sBurstKey.toString();
    }
}

