/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.rap.controller.RAPReport;
import com.cognos.rap.controller.ReportActionController;
import com.cognos.rap.exceptions.ActionControllerException;
import com.cognos.viewer.action.ActionHelper;
import com.cognos.viewer.action.BuxAction;
import com.cognos.viewer.action.BuxSubAction;
import com.cognos.viewer.action.ObjectDefaultAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.controller.CognosViewerRAPException;
import com.cognos.viewer.model.CognosServiceRequest;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.utility.Protect;
import com.cognos.xts.ext.XTSExt;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class RAPPreProcessReportSubAction
extends BuxSubAction {
    public RAPPreProcessReportSubAction(ICognosViewerState state, CognosViewerServiceFactory factory) {
        this.initialize(state, factory);
    }

    @Override
    public void prepareRequest() throws CognosViewerException {
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        try {
            Element parametersElem = (Element)this.m_state.getObject("parameters");
            if (parametersElem != null) {
                this.m_state.getParameterValueManager().addParametersValues(parametersElem, false);
            }
            ActionHelper.addParameterValuesFromConversation(this.m_state);
            this.setupRunOptions();
            this.buildPreProcessCommand(this.m_state, this.m_serviceFactory);
            this.applyReportActionProcessorChanges();
        }
        catch (ActionControllerException e) {
            return ActionHelper.handleActionControllerException(e, this.m_state);
        }
        ObjectDefaultAction defaultAction = new ObjectDefaultAction();
        this.m_state.addObject("XMLOutput_reportSpec", this.m_state.getFormFieldAsString("ui.spec"));
        defaultAction.initialize(this.m_state, null);
        return defaultAction.buildNoOpResponse();
    }

    private void buildPreProcessCommand(ICognosViewerState state, CognosViewerServiceFactory serviceFactory) throws CognosViewerException {
        String sSpec = state.getFormFieldAsString("ui.spec");
        String preserveTags = state.getFormFieldAsString("ui.preserveRapTags");
        if (state.isBUX() && sSpec.length() > 0) {
            Element reportActions = DocumentHelper.createElement((String)"reportActions");
            reportActions.addAttribute("run", "false");
            reportActions.add(BuxAction.createSetReportPropertiesAction());
            String reportAction = "reportAction";
            String name = "name";
            Element processLockedFiltersAction = reportActions.addElement(reportAction);
            processLockedFiltersAction.addAttribute(name, "ProcessLockedFilters");
            ActionHelper.addFilters(state, reportActions);
            Element processSortLabelsAction = reportActions.addElement(reportAction);
            processSortLabelsAction.addAttribute(name, "ProcessSortLabels");
            if (state instanceof CognosViewerDispatcherHandlerState && ((CognosViewerDispatcherHandlerState)state).isAddLocalizeLabelsAction()) {
                reportActions.addElement("LocalizeLabels");
            }
            Element getInfoReportAction = reportActions.addElement(reportAction);
            getInfoReportAction.addAttribute(name, "GetInfo");
            if (preserveTags != null && preserveTags.equals("true")) {
                getInfoReportAction.addElement("preserveTags");
            }
            state.setFormFieldFromString("cv.actionContext", reportActions.asXML());
        }
    }

    public boolean applyReportActionProcessorChanges() throws CognosViewerException, ActionControllerException {
        String reportSpec = this.m_state.getFormFieldAsString("ui.spec");
        boolean bRunModifiedSpec = true;
        try {
            CognosServiceRequest cognosServiceRequest = new CognosServiceRequest(this.m_state, this.m_serviceFactory);
            ReportActionController rap = new ReportActionController(cognosServiceRequest);
            rap.setViewerDebugLogger(this.m_state.getDebugLogger());
            String rapState = this.m_state.getFormFieldAsString("rap.state");
            if (rapState.length() > 0 && !rapState.startsWith("<")) {
                rapState = XTSExt.web64decode((String)Protect.cafaction("sign_unwrap", rapState), (boolean)true);
            }
            rap.setReportActionStateFromString(rapState);
            RAPReport rapReport = new RAPReport(reportSpec);
            rapReport.setParameterUpdateMap(ActionHelper.getRAPParameterUpdateMap(this.m_state));
            rapReport.setDefaultLocale(CognosViewerDispatcherHandlerState.getContentLocale(this.m_state));
            rapReport.setProductLocale(CognosViewerDispatcherHandlerState.getProductLocale(this.m_state));
            if (this.m_state.getDebugLogger().isDebugEnabled()) {
                this.m_state.getDebugLogger().logXML(this.m_state.getFormFieldAsString("cv.actionContext"), "rapAction.xml", true, "rapAction");
            }
            rap.applyActions(rapReport, this.m_state.getFormFieldAsString("cv.actionContext"));
            RAPPreProcessReportSubAction.setRAPReportToFormField(this.m_state, rapReport);
            this.m_state.setFormFieldFromString("rap.state", rap.getReportActionStateAsString());
            bRunModifiedSpec = !rap.getCallerSetRunFalse();
        }
        catch (ActionControllerException e) {
            throw e;
        }
        catch (Exception e) {
            this.m_state.getIPFLogger().error(e.getMessage(), e, this.getClass().getName());
            throw new CognosViewerRAPException(this.m_state, e, this.m_state.getFormFieldAsString("cv.actionContext"));
        }
        return bRunModifiedSpec;
    }

    protected void setupRunOptions() throws CognosViewerException {
        this.m_state.setFormFieldFromString("ui.action", "runSpecification");
    }

    public static void setRAPReportToFormField(ICognosViewerState state, RAPReport rapReport) throws Exception {
        state.updateSpecificationContents(rapReport.getDOM().asXML());
        if (rapReport.getReportInfo() != null) {
            String json = rapReport.getReportInfo().updateJSON(state.getFormFieldAsString("rap.reportInfo"));
            state.setFormFieldFromString("rap.reportInfo", json);
            state.addObject("JSONOutput", json);
        }
    }

    @Override
    public void handleResponse() throws CognosViewerException {
        block2: {
            try {
                ActionHelper.addParameterValuesFromConversation(this.m_state);
                this.setupRunOptions();
                this.buildPreProcessCommand(this.m_state, this.m_serviceFactory);
                this.applyReportActionProcessorChanges();
            }
            catch (ActionControllerException e) {
                if (this.m_state.getFormFieldAsString("rapWait").length() <= 0) break block2;
                this.m_state.setFormFieldFromString("rapWait", "");
            }
        }
    }
}

