/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.viewer.action.ActionFactory;
import com.cognos.viewer.action.ActionHelper;
import com.cognos.viewer.action.CognosViewerAction;
import com.cognos.viewer.action.ReleaseAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.ReportServerRequest;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.ConversationMarshaller;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.OptionMarshaller;
import com.cognos.viewer.model.marshallers.ParameterValuesMarshaller;
import com.cognos.viewer.model.marshallers.PropEnumMarshaller;
import com.cognos.viewer.model.marshallers.SearchPathMultipleObjectMarshaller;
import org.dom4j.Element;

public abstract class ReportOutputAction
extends CognosViewerAction {
    @Override
    protected boolean insertAsynchReportOutput() {
        return false;
    }

    @Override
    protected SOAPResponse resumeExecution(SOAPResponse soapInteruptResponse) throws CognosViewerException {
        Element soapBody;
        BIBusEnvelope busEnvelope = soapInteruptResponse.getBusEnvelope();
        if (busEnvelope != null && (soapBody = busEnvelope.getBody()) != null) {
            Element asynchDetailReportStatus;
            ICognosViewerRequest rsRequest = this.getSecondaryRequestService();
            Boolean returnOutput = Boolean.FALSE;
            Element hasOutput = (Element)soapBody.selectSingleNode("./*/*[local-name()='result']/*[local-name()='primaryRequest']/*[local-name()='options']/*[local-name()='item']/*[local-name()='name'][@xsi:type='bus:runOptionEnum'][text() = '" + RunOptionEnum.returnOutputWhenAvailable.getValue() + "']/../*[local-name()='value']");
            if (hasOutput != null) {
                returnOutput = Boolean.valueOf(hasOutput.getText());
            }
            if (!(rsRequest.getClass().equals(ReportServerRequest.class) && returnOutput.booleanValue() || (asynchDetailReportStatus = (Element)soapBody.selectSingleNode("./*/*[local-name()='result']/*[local-name()='details']/*[local-name()='item'][@xsi:type='bus:asynchDetailReportStatus']/*[local-name()='status']")) == null || !"responseReady".equals(asynchDetailReportStatus.getText()))) {
                IArgumentMarshaller[] arguments = new IArgumentMarshaller[]{new ConversationMarshaller(this.m_state.getConversation()), new ParameterValuesMarshaller(new ParameterValue[0]), new OptionMarshaller(new Option[0])};
                soapInteruptResponse = rsRequest.executeRequest("getOutput", soapInteruptResponse, arguments, "absolute");
                if ("fragment".equals(this.m_state.getFormFieldAsString("cv.responseFormat"))) {
                    this.m_state.setFormFieldFromString("ui.action", "getOutput");
                    soapInteruptResponse.setState(this.m_state);
                }
            }
        }
        return soapInteruptResponse;
    }

    protected void releaseConversation() {
        if (this.m_state.getFormFieldAsString("m_tracking").length() > 0) {
            try {
                ActionFactory actionFactory = new ActionFactory(this.m_serviceFactory);
                ReleaseAction release = (ReleaseAction)actionFactory.load("release", this.m_state);
                release.execute();
            }
            catch (Exception exception) {
                this.m_state.getIPFLogger().info("Caught exception in releaseConversation: " + exception.getMessage(), this.getClass().getName());
            }
        }
    }

    protected void queryContentManager(String sSearchPath) throws CognosViewerException {
        if (this.m_state.getFormFieldAsString("ui.name").length() <= 0) {
            try {
                IArgumentMarshaller[] arguments = new IArgumentMarshaller[]{new SearchPathMultipleObjectMarshaller(new SearchPathMultipleObject(sSearchPath)), new PropEnumMarshaller(new PropEnum[]{PropEnum.defaultName})};
                ICognosViewerRequest cmRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.CMSERVICEREQUEST);
                try {
                    CMServerResponse cmResponse = (CMServerResponse)cmRequest.executeRequest("query", this.m_state, arguments, "");
                    if (cmResponse != null) {
                        ActionHelper.addObjectPropertiesToState(this.m_state, cmResponse);
                    }
                }
                catch (CognosViewerException cognosViewerException) {
                    this.m_state.getIPFLogger().warn(cognosViewerException.getMessage(), this.getClass().getName());
                }
            }
            catch (CognosViewerException ex) {
                this.m_state.getIPFLogger().error(ex.getMessage(), ex, this.getClass().getName());
                throw ex;
            }
        }
    }

    protected void cleanViewerState() throws CognosViewerException {
        if (this.canReleaseExistingConversation()) {
            this.releaseConversation();
            this.clearTrackingFromState();
        }
        this.setPropertiesFromConversation();
    }

    public boolean canReleaseExistingConversation() {
        return !"true".equals(this.m_state.getFormFieldAsString("cv.reuseConversation")) && !"true".equals(this.m_state.getFormFieldAsString("reuseResults")) && this.m_state.getFormFieldAsString("m_tracking").length() > 0;
    }

    public void setPropertiesFromConversation() throws CognosViewerException {
        if (this.m_state.getFormFieldAsString("ui.conversation").length() > 0) {
            if (!"false".equals(this.m_state.getFormFieldAsString("cv.reUseConversationParameterValues"))) {
                ActionHelper.addParameterValuesFromConversation(this.m_state);
            }
            try {
                ActionHelper.addOptionsFromConversation(this.m_state);
            }
            catch (CognosViewerException e) {
                this.m_state.getIPFLogger().error(e.getMessage(), e, this.getClass().getName());
            }
        }
    }
}

