/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.rap.controller.RAPReport;
import com.cognos.rap.controller.ReportActionController;
import com.cognos.rap.exceptions.ActionControllerException;
import com.cognos.rap.exceptions.UnsupportedSpecificationException;
import com.cognos.viewer.action.ActionHelper;
import com.cognos.viewer.action.RAPPreProcessReportSubAction;
import com.cognos.viewer.action.ReportOutputAction;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.controller.CognosViewerRAPException;
import com.cognos.viewer.model.CognosServiceRequest;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.CognosViewerRequest;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.AsynchSpecificationMarshaller;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.OptionMarshaller;
import com.cognos.viewer.model.marshallers.ParameterValuesMarshaller;
import com.cognos.viewer.model.marshallers.PropEnumMarshaller;
import com.cognos.viewer.model.marshallers.SearchPathMultipleObjectMarshaller;
import org.dom4j.Element;

public class RunSpecificationAction
extends ReportOutputAction {
    @Override
    public void prepareRequest() throws CognosViewerException {
        String reportSpec;
        if (CognosViewerDispatcherHandler.isExpandCollapseEnabled() && "RS".equals(this.m_state.getFormFieldAsString("cv.id")) && (reportSpec = this.m_state.getFormFieldAsString("ui.spec")).length() > 0) {
            this.addRAPReportInfoToFormField(reportSpec);
        }
        this.doPrepareRequest();
    }

    protected void doPrepareRequest() throws CognosViewerException {
        this.cleanViewerState();
        if (!"rs".equals(this.m_state.getResponseFormat()) && this.m_state.getFormFieldAsString("modelPath").length() > 0 && this.m_state.getFormFieldAsString("packageBase").length() == 0) {
            IArgumentMarshaller[] arguments = new IArgumentMarshaller[2];
            PropEnum[] properties = new PropEnum[]{PropEnum.parent};
            arguments[0] = new SearchPathMultipleObjectMarshaller(new SearchPathMultipleObject(this.m_state.getFormFieldAsString("modelPath")));
            arguments[1] = new PropEnumMarshaller(properties);
            ICognosViewerRequest cmRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.CMSERVICEREQUEST);
            SOAPResponse cmResponse = cmRequest.executeRequest("query", this.m_state, arguments, "");
            this.getPackageBase(cmResponse);
        }
        ActionHelper.setDefaultOptions(this.m_state);
        ActionHelper.addParameterValues(this.m_state);
        ActionHelper.setPromptOption(this.m_state);
        if (CognosViewerDispatcherHandlerState.isIROTReport(this.m_state)) {
            ActionHelper.addIROTOptions(this.m_state);
        }
        ActionHelper.addOutputLocationOption(this.m_state);
        this.m_arguments = new IArgumentMarshaller[3];
        this.m_arguments[0] = new AsynchSpecificationMarshaller(this.m_state.getSpecification());
        this.m_arguments[1] = new ParameterValuesMarshaller(this.m_state.getParameterValueManager().toArray());
        this.m_arguments[2] = new OptionMarshaller(this.m_state.getOptionManager().toArray());
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        return this.doExecuteRequest();
    }

    protected SOAPResponse doExecuteRequest() throws CognosViewerException {
        ICognosViewerRequest rsRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.REPORTSERVICEREQUEST);
        CognosViewerRequest request = new CognosViewerRequest("runSpecification", this.m_state, this.m_arguments, "session", this.doTrustedRequest());
        return rsRequest.executeRequest(request);
    }

    protected boolean doTrustedRequest() {
        return this.m_state.getCapabilities().hasCapability("canUseDashboardViewer");
    }

    public void getPackageBase(SOAPResponse cmResponse) {
        Element packageSearchPathItem;
        Element soapBody;
        BIBusEnvelope responseEnvelope = cmResponse.getBusEnvelope();
        if (responseEnvelope != null && (soapBody = responseEnvelope.getBody()) != null && (packageSearchPathItem = (Element)soapBody.selectSingleNode("./*[local-name()='queryResponse']/*[local-name()='result']/*[local-name()='item']/*[local-name()='parent']/*[local-name()='value']/*[local-name()='item'][@xsi:type='cm:package']/*[local-name()='searchPath']/*[local-name()='value']")) != null) {
            this.m_state.setFormFieldFromString("packageBase", packageSearchPathItem.getText());
        }
    }

    protected void addRAPReportInfoToFormField(String reportSpec) throws CognosViewerException {
        try {
            CognosServiceRequest cognosServiceRequest = new CognosServiceRequest(this.m_state, this.m_serviceFactory);
            ReportActionController rap = new ReportActionController(cognosServiceRequest);
            rap.setViewerDebugLogger(this.m_state.getDebugLogger());
            RAPReport rapReport = new RAPReport(reportSpec);
            StringBuilder actionContext = new StringBuilder();
            actionContext.append("<reportActions>");
            if (CognosViewerDispatcherHandler.isExpandCollapseEnabled()) {
                actionContext.append("<reportAction name=\"GetInfo\"></reportAction>");
            } else if (CognosViewerDispatcherHandler.isSortEnabled(this.m_state)) {
                actionContext.append("<reportAction name=\"ProcessSortLabels\"></reportAction><reportAction name=\"GetInfo\"><include><sort/><displayTypeId/></include></reportAction>");
            }
            actionContext.append("</reportActions>");
            if (this.m_state.getDebugLogger().isDebugEnabled()) {
                this.m_state.getDebugLogger().logXML(actionContext.toString(), "rapAction.xml", true, "rapAction");
            }
            rap.applyActions(rapReport, actionContext.toString());
            RAPPreProcessReportSubAction.setRAPReportToFormField(this.m_state, rapReport);
        }
        catch (ActionControllerException e) {
            if (e.getCause() instanceof UnsupportedSpecificationException) {
                this.m_state.removeFormField("ui.spec");
                this.m_state.setFormFieldFromString("limitedInteractiveMode", "true");
            }
            throw (CognosViewerException)e.getCause().getCause();
        }
        catch (Exception e) {
            this.m_state.getIPFLogger().error(e.getMessage(), e, this.getClass().getName());
            throw new CognosViewerRAPException(this.m_state, e, this.m_state.getFormFieldAsString("cv.actionContext"));
        }
    }
}

