/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParameterValueArrayProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.Report;
import com.cognos.developer.schemas.bibus._3.ReportView;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.action.SaveDashboardAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerRequest;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.AddOptionsMarshaller;
import com.cognos.viewer.model.marshallers.AddRequestMarshaller;
import com.cognos.viewer.model.marshallers.ElementMarshaller;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.PropEnumMarshaller;
import com.cognos.viewer.model.marshallers.ReportServerAddRequestMarshaller;
import com.cognos.viewer.model.marshallers.ReportViewMarshaller;
import com.cognos.viewer.model.marshallers.SearchPathMultipleObjectMarshaller;
import com.cognos.viewer.model.marshallers.SingleSearchPathMarshaller;
import com.cognos.viewer.utility.Protect;
import com.cognos.viewer.utility.XMLUtility;
import com.cognos.xts.ext.XTSExt;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class SaveInDashboardAction
extends SaveDashboardAction {
    CMServerResponse m_CMServerResponse = null;
    private static PropEnum[] m_ContentManagerQueryProperties = new PropEnum[]{PropEnum.executionLocale, PropEnum.defaultName, PropEnum.policies, PropEnum.options};
    private Element m_newReport;
    private String m_dashboard;
    private boolean m_bCreateReportView;
    private String m_sourceReport;
    private static AddOptions m_addOptions = new AddOptions();

    @Override
    public void prepareRequest() throws CognosViewerException {
        this.initialize();
        if (this.m_sourceReport.length() > 0) {
            if (this.m_bCreateReportView) {
                this.prepareRequestForReportView();
            } else {
                this.prepareRequestForReport();
            }
        }
    }

    private void initialize() {
        this.setSourceReport();
        this.setCreateReportView();
        this.m_dashboard = "storeID(\"" + this.m_state.getFormFieldAsString("dashboard-id") + "\")";
        this.m_arguments = new IArgumentMarshaller[1];
    }

    private void setCreateReportView() {
        String limitedInteractiveMode = this.m_state.getFormFieldAsString("limitedInteractiveMode");
        this.m_bCreateReportView = "true".equals(limitedInteractiveMode);
    }

    private void setSourceReport() {
        String sOriginalReport = this.m_state.getFormFieldAsString("originalReport");
        String sCurrentReport = this.m_state.getFormFieldAsString("ui.object");
        String sCurrentReportObjectClass = this.m_state.getFormFieldAsString("ui.objectClass");
        boolean bCurrentReportIsReportView = sCurrentReportObjectClass.equals("reportView");
        String sSavedReportName = this.m_state.getFormFieldAsString("savedReportName");
        boolean bIsSaveAs = sSavedReportName.length() > 0;
        this.m_sourceReport = bIsSaveAs && !bCurrentReportIsReportView ? sCurrentReport : sOriginalReport;
    }

    public String getSourceReport() {
        return this.m_sourceReport;
    }

    private void prepareRequestForReport() throws CognosViewerException {
        this.m_newReport = this.createNewReport();
        this.m_arguments[0] = this.getReportServerAddRequestMarshaller();
    }

    private void prepareRequestForReportView() throws CognosViewerException {
        this.m_newReport = this.createNewReportView();
        this.m_arguments[0] = new AddRequestMarshaller(this.m_dashboard, this.getAddRequestArguments(), m_addOptions);
    }

    private IArgumentMarshaller[] getAddRequestArguments() {
        IArgumentMarshaller[] addRequestArgumentMarshaller = new IArgumentMarshaller[]{new ElementMarshaller(this.m_newReport)};
        return addRequestArgumentMarshaller;
    }

    private ReportServerAddRequestMarshaller getReportServerAddRequestMarshaller() {
        return new ReportServerAddRequestMarshaller(new SingleSearchPathMarshaller(new SearchPathSingleObject(this.m_dashboard), SingleSearchPathMarshaller.BUS_PARENT_PATH), new ElementMarshaller(this.m_newReport), new AddOptionsMarshaller(m_addOptions));
    }

    private Element createNewReport() throws CognosViewerException {
        this.queryCMForReport(this.m_sourceReport);
        Element responseBody = this.m_CMServerResponse.getBusEnvelope().getBody();
        this.updateReportProperties(responseBody);
        return (Element)SaveInDashboardAction.getReport(responseBody).clone();
    }

    private Element createNewReportView() throws CognosViewerException {
        ReportView reportView = new ReportView();
        StringProp searchPath = new StringProp();
        searchPath.setValue(this.m_dashboard);
        TokenProp name = new TokenProp();
        name.setValue(this.m_state.getFormFieldAsString("ui.name"));
        reportView.setDefaultName(name);
        reportView.setSearchPath(searchPath);
        Report baseReport = new Report();
        StringProp originalReportSearchPath = new StringProp();
        originalReportSearchPath.setValue(this.m_sourceReport);
        baseReport.setSearchPath(originalReportSearchPath);
        BaseClassArrayProp base = new BaseClassArrayProp();
        BaseClass[] values = new BaseClass[]{baseReport};
        base.setValue(values);
        reportView.setBase(base);
        String sExecutionParameters = this.m_state.getFormFieldAsString("executionParameters");
        if (sExecutionParameters != null && sExecutionParameters.length() > 0) {
            ParameterValue[] parmValues = this.m_state.getParameterValueManager().parseXMLSpecification(sExecutionParameters);
            ParameterValueArrayProp parameters = new ParameterValueArrayProp();
            parameters.setValue(parmValues);
            reportView.setParameters(parameters);
        }
        ReportViewMarshaller marshaller = new ReportViewMarshaller(reportView);
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("root");
        marshaller.marshall(root);
        Element report = root.element("item");
        return (Element)report.clone();
    }

    public Element getReport() {
        return this.m_newReport;
    }

    private static Element getReport(Element responseBody) {
        return (Element)responseBody.selectSingleNode("*[local-name()='queryResponse']/result/*");
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        SOAPResponse response = null;
        if (this.m_arguments == null) {
            return response;
        }
        int reportNameSuffix = 2;
        boolean bDoAddRequest = true;
        while (bDoAddRequest) {
            try {
                Integer service = this.m_bCreateReportView ? CognosViewerServiceFactory.CMSERVICEREQUEST : CognosViewerServiceFactory.REPORTSERVICEREQUEST;
                ICognosViewerRequest serverRequest = this.m_serviceFactory.getService(service);
                boolean trustedRequest = !this.m_bCreateReportView && this.m_state.isBUX();
                CognosViewerRequest request = new CognosViewerRequest("add", this.m_state, this.m_arguments, "", trustedRequest);
                response = serverRequest.executeRequest(request);
                bDoAddRequest = false;
                String jsonString = this.buildJsonStringResultForSaveAction(response, this.m_bCreateReportView ? "reportView" : "report");
                if (jsonString == null) {
                    jsonString = "";
                }
                this.m_state.addObject("JSONOutput", jsonString);
            }
            catch (CognosViewerException e) {
                if (this.m_state.getDebugLogger() != null) {
                    this.m_state.getDebugLogger().log(e.getFaultEnvelope(), "fault.xml", false, null);
                }
                this.processError(e, reportNameSuffix++);
            }
        }
        return response;
    }

    private void processError(CognosViewerException e, int reportNameSuffix) throws CognosViewerException {
        String sErrorCode;
        Element errorCode;
        Element fault;
        if (e.getFaultEnvelope() != null && (fault = e.getFaultEnvelope().getFault()) != null && (errorCode = (Element)fault.selectSingleNode("*[local-name()='detail']/*[local-name()='exception']/*[local-name()='errorCode']")) != null && (sErrorCode = errorCode.getText()).equals("cmDuplicateName")) {
            this.prepareNewRequest(reportNameSuffix);
            return;
        }
        throw e;
    }

    public void prepareNewRequest(int i) {
        this.m_newReport = (Element)this.m_newReport.clone();
        String reportName = this.m_state.getFormFieldAsString("ui.name");
        Element defaultName = (Element)this.m_newReport.selectSingleNode("defaultName/value");
        if (reportName == null || reportName.length() == 0) {
            reportName = defaultName.getText();
        }
        String sNewReportName = reportName + " (" + i + ")";
        defaultName.setText(sNewReportName);
        if (this.m_arguments == null) {
            this.m_arguments = new IArgumentMarshaller[1];
        }
        if (this.m_bCreateReportView) {
            IArgumentMarshaller[] arguments = this.getAddRequestArguments();
            this.m_arguments[0] = new AddRequestMarshaller(this.m_dashboard, arguments, m_addOptions);
        } else {
            this.m_arguments[0] = this.getReportServerAddRequestMarshaller();
        }
    }

    public void updateReportProperties(Element responseBody) throws CognosViewerException {
        Element itemNode = SaveInDashboardAction.getReport(responseBody);
        itemNode.setName("object");
        itemNode.addNamespace("cm", "http://developer.cognos.com/schemas/bibus/3/");
        Attribute typeAttribute = itemNode.attribute("type");
        typeAttribute.setValue("bus:report");
        this.updateSpecification(itemNode);
        this.updateDefaultName(itemNode);
        this.updateParameters(itemNode);
    }

    private void updateDefaultName(Element itemNode) {
        String reportName = this.m_state.getFormFieldAsString("ui.name");
        if (reportName != null && reportName.length() > 0) {
            Element defaultNameValueNode = (Element)itemNode.selectSingleNode("defaultName/value");
            defaultNameValueNode.setText(reportName);
        }
    }

    private void updateSpecification(Element itemNode) {
        Element specificationProperty = itemNode.addElement(PropEnum.specification.getValue());
        specificationProperty.addAttribute(SOAPEnvelope.XSI_TYPE, "cm:anyTypeProp");
        Element specificationValue = specificationProperty.addElement("value");
        specificationValue.addAttribute(SOAPEnvelope.XSI_TYPE, "xsd:string");
        specificationValue.setText(this.m_state.getFormFieldAsString("ui.spec"));
    }

    public void updateParameters(Element itemNode) throws CognosViewerException {
        String sExecutionParameters = this.m_state.getFormFieldAsString("executionParameters");
        if (sExecutionParameters == null || sExecutionParameters.length() == 0) {
            return;
        }
        if (!sExecutionParameters.startsWith("<")) {
            sExecutionParameters = XTSExt.web64decode((String)Protect.cafaction("sign_unwrap", sExecutionParameters), (boolean)true);
        }
        sExecutionParameters = "<root xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">" + sExecutionParameters + "</root>";
        try {
            Document document = XMLUtility.createXMLDocument(sExecutionParameters);
            Element rootNode = document.getRootElement();
            Element sourceParameters = rootNode.element("parameters");
            if (sourceParameters == null) {
                return;
            }
            Element parameters = itemNode.addElement("parameters").addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":parameterValueArrayProp").addNamespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/").addNamespace(BIBusEnvelope.NS_BUS.getPrefix(), BIBusEnvelope.NS_BUS.getURI()).addNamespace("xs", "http://www.w3.org/2001/XMLSchema");
            Element parameterValue = parameters.addElement("value").addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY).addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, "bus:parameterValue[]");
            Iterator i = sourceParameters.elementIterator();
            while (i.hasNext()) {
                Element item = (Element)i.next();
                parameterValue.add((Element)item.clone());
            }
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
    }

    private void queryCMForReport(String sSearchPath) throws CognosViewerException {
        if (this.m_CMServerResponse == null) {
            IArgumentMarshaller[] arguments = new IArgumentMarshaller[]{new SearchPathMultipleObjectMarshaller(new SearchPathMultipleObject(sSearchPath)), new PropEnumMarshaller(m_ContentManagerQueryProperties)};
            ICognosViewerRequest cmRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.CMSERVICEREQUEST);
            this.m_CMServerResponse = (CMServerResponse)cmRequest.executeRequest("query", this.m_state, arguments, "");
        }
    }

    public void setCMServerResponse(CMServerResponse mockCMServerResponse) {
        this.m_CMServerResponse = mockCMServerResponse;
    }

    public CMServerResponse getCMServerResponse() {
        return this.m_CMServerResponse;
    }

    public void setReport(Element report) {
        this.m_newReport = report;
    }

    public void setAddUsingContentManager(boolean bAddUsingContentManager) {
        this.m_bCreateReportView = bAddUsingContentManager;
    }

    static {
        m_addOptions.setUpdateAction(UpdateActionEnum.fail);
    }
}

