/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.cognos.viewer.action.CognosViewerAction;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerBlankResponse;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerCachedState;
import com.cognos.viewer.model.CognosViewerRequest;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.AddRequestMarshaller;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.PropEnumMarshaller;
import com.cognos.viewer.model.marshallers.SearchPathMultipleObjectMarshaller;
import com.cognos.xts.ext.XTSExt;
import java.util.List;
import java.util.UUID;

public class SaveJSONLogsAction
extends CognosViewerAction {
    private boolean shouldSaveLogs = false;

    @Override
    public void prepareRequest() throws CognosViewerException {
        if (!CognosViewerDispatcherHandler.getConfigValues().getBoolean("VIEWER_LOGS")) {
            return;
        }
        if (this.m_state.getDebugLogger().isJsonLoggingOn()) {
            CognosViewerCachedState cognosViewerCachedState = new CognosViewerCachedState(this.m_serviceFactory);
            String jsonLogs = this.m_state.getFormFieldAsString("cv.jsonLogs").length() > 0 ? XTSExt.web64encode((String)this.m_state.getFormFieldAsString("cv.jsonLogs"), (boolean)true) : XTSExt.web64encode((String)this.m_state.getDebugLogger().getLogsAsJSON(this.m_state.getBusEnvelope()).toString(), (boolean)true);
            IArgumentMarshaller[] addObjectsMarshaller = cognosViewerCachedState.getAddObjects("ViewerJSONLogs" + UUID.randomUUID(), jsonLogs);
            AddOptions addOptions = new AddOptions();
            addOptions.setUpdateAction(UpdateActionEnum.update);
            this.m_arguments = new IArgumentMarshaller[]{new AddRequestMarshaller("~~", addObjectsMarshaller, addOptions)};
            this.shouldSaveLogs = true;
        }
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        if (this.shouldSaveLogs) {
            this.m_state.getDebugLogger().setGenerateJSONLogs(false);
            IArgumentMarshaller[] arguments = new IArgumentMarshaller[]{new SearchPathMultipleObjectMarshaller(new SearchPathMultipleObject("~~/runTimeState[starts-with(@name,'ViewerJSONLogs')]")), new PropEnumMarshaller(new PropEnum[]{PropEnum.searchPath})};
            ICognosViewerRequest cmRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.CMSERVICEREQUEST);
            CMServerResponse cmResponse = (CMServerResponse)cmRequest.executeRequest("query", this.m_state, arguments, "");
            List items = cmResponse.getNodes("./*[local-name()='queryResponse']/*[local-name()='result']/*[local-name()='item']");
            int size = items.size();
            if (size > 30) {
                throw new CognosViewerException(this.m_state.getBusEnvelope(), "Too many logs in CM.", null);
            }
            CognosViewerRequest request = new CognosViewerRequest("add", this.m_state, this.m_arguments, "");
            SOAPResponse response = cmRequest.executeRequest(request);
            this.m_state.getDebugLogger().setGenerateJSONLogs(true);
            this.m_state.getDebugLogger().clearJsonLogs(this.m_state.getBusEnvelope());
            return response;
        }
        return new CMServerBlankResponse(this.m_state);
    }
}

