/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.developer.schemas.bibus._3.AnyTypeProp;
import com.cognos.developer.schemas.bibus._3.GenericOptionBoolean;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OptionArrayProp;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParameterValueArrayProp;
import com.cognos.developer.schemas.bibus._3.Report;
import com.cognos.developer.schemas.bibus._3.ReportView;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.UpdateOptions;
import com.cognos.viewer.action.SaveDashboardAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerRequest;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.ParametersMarshaller;
import com.cognos.viewer.model.marshallers.ReportMarshaller;
import com.cognos.viewer.model.marshallers.ReportServerUpdateRequestMarshaller;
import com.cognos.viewer.model.marshallers.ReportViewMarshaller;
import com.cognos.viewer.model.marshallers.UpdateOptionsMarshaller;
import com.cognos.viewer.model.marshallers.UpdateRequestMarshaller;
import com.cognos.viewer.utility.Protect;
import com.cognos.viewer.utility.XMLUtility;
import com.cognos.xts.ext.XTSExt;
import org.dom4j.Document;
import org.dom4j.Element;

public class UpdateSavedReportAction
extends SaveDashboardAction {
    @Override
    public void prepareRequest() throws CognosViewerException {
        StringProp searchPath = new StringProp();
        searchPath.setValue(this.m_state.getFormFieldAsString("ui.object"));
        if ("reportView".equals(this.m_state.getFormFieldAsString("ui.objectClass"))) {
            ReportView reportView = new ReportView();
            reportView.setSearchPath(searchPath);
            ParameterValueArrayProp parameters = this.getParameters();
            if (parameters != null) {
                reportView.setParameters(parameters);
            }
            this.m_arguments = new IArgumentMarshaller[1];
            this.m_arguments[0] = new UpdateRequestMarshaller(new IArgumentMarshaller[]{new ReportViewMarshaller(reportView)});
        } else {
            ParameterValueArrayProp parameters;
            Report report = new Report();
            report.setSearchPath(searchPath);
            if (this.m_state.getFormFieldAsString("ui.spec").length() > 0) {
                report.setSpecification(this.getSpecification());
            }
            if ((parameters = this.getParameters()) != null) {
                report.setParameters(parameters);
            }
            this.m_arguments = new IArgumentMarshaller[2];
            this.m_arguments[0] = new ReportServerUpdateRequestMarshaller(new IArgumentMarshaller[]{new ReportMarshaller(report, ReportMarshaller.ROOT_ELEMENT_OBJECT)});
            this.m_arguments[1] = new UpdateOptionsMarshaller(new UpdateOptions());
        }
    }

    public ParameterValueArrayProp getParameters() throws CognosViewerException {
        String sExecutionParameters = this.m_state.getFormFieldAsString("executionParameters");
        if (sExecutionParameters == null || sExecutionParameters.length() == 0) {
            return null;
        }
        try {
            Document document;
            Element rootNode;
            Element parametersNode;
            if (!sExecutionParameters.startsWith("<")) {
                sExecutionParameters = XTSExt.web64decode((String)Protect.cafaction("sign_unwrap", sExecutionParameters), (boolean)true);
            }
            if ((parametersNode = (rootNode = (document = XMLUtility.createXMLDocument(sExecutionParameters = "<root xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">" + sExecutionParameters + "</root>")).getRootElement()).element("parameters")) == null) {
                return null;
            }
            ParametersMarshaller parametersMarshaller = new ParametersMarshaller(null);
            ParameterValue[] parmValues = parametersMarshaller.unmarshall(parametersNode);
            ParameterValueArrayProp parameters = new ParameterValueArrayProp();
            parameters.setValue(parmValues);
            return parameters;
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
    }

    private AnyTypeProp getSpecification() {
        AnyTypeProp specification = new AnyTypeProp();
        specification.setValue(this.m_state.getFormFieldAsString("ui.spec"));
        return specification;
    }

    public OptionArrayProp getOptions() {
        String flashChartOptionValue = this.m_state.getFormFieldAsString("system.flashChart");
        if (flashChartOptionValue.length() == 0) {
            flashChartOptionValue = "true";
        }
        GenericOptionBoolean genericOptionBoolean = new GenericOptionBoolean();
        genericOptionBoolean.setName("http://developer.cognos.com/ceba/constants/systemOptionEnum#flashCharts");
        genericOptionBoolean.setValue(Boolean.parseBoolean(flashChartOptionValue));
        Option[] options = new Option[]{genericOptionBoolean};
        OptionArrayProp optionArrayProp = new OptionArrayProp();
        optionArrayProp.setValue(options);
        return optionArrayProp;
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        boolean trustedRequest;
        CognosViewerRequest request;
        SOAPResponse response = null;
        if (this.m_arguments == null) {
            return response;
        }
        boolean bIsReportView = "reportView".equals(this.m_state.getFormFieldAsString("ui.objectClass"));
        Integer service = bIsReportView ? CognosViewerServiceFactory.CMSERVICEREQUEST : CognosViewerServiceFactory.REPORTSERVICEREQUEST;
        ICognosViewerRequest serverRequest = this.m_serviceFactory.getService(service);
        response = serverRequest.executeRequest(request = new CognosViewerRequest("update", this.m_state, this.m_arguments, "", trustedRequest = !bIsReportView && this.m_state.isBUX()));
        String jsonString = this.buildJsonStringResult(response);
        if (jsonString == null) {
            jsonString = "";
        }
        this.m_state.addObject("JSONOutput", jsonString);
        return response;
    }
}

