/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.RefProp;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.action.ActionHelper;
import com.cognos.viewer.action.CognosViewerAction;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.PropEnumMarshaller;
import com.cognos.viewer.model.marshallers.QueryOptionsMarshaller;
import com.cognos.viewer.model.marshallers.QueryRequestMarshaller;
import com.cognos.viewer.model.marshallers.SearchPathMultipleObjectMarshaller;
import com.cognos.viewer.utility.BrowserUtility;
import java.util.HashMap;
import org.dom4j.Element;

public class ViewAction
extends CognosViewerAction {
    private QueryRequest[] m_aExtraQueryRequests = new QueryRequest[0];
    private static final PropEnum[] m_contentManagerQueryProperties = new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath, PropEnum.storeID, PropEnum.permissions, PropEnum.defaultOutputFormat, PropEnum.format, PropEnum.burstKey, PropEnum.locale, PropEnum.ancestors, PropEnum.objectClass, PropEnum.burstID, PropEnum.parent, PropEnum.creationTime, PropEnum.dataPathInfo, PropEnum.dataDescriptor};
    private static HashMap m_outputMap = new HashMap();

    @Override
    public void prepareRequest() throws CognosViewerException {
        this.m_arguments = new IArgumentMarshaller[1];
        QueryRequest query = new QueryRequest();
        query.setSearch(this.m_state.getFormFieldAsString("ui.object"));
        query.setProperties(m_contentManagerQueryProperties);
        RefProp[] contentManagerRefProperties = new RefProp[1];
        RefProp parentRefProp = new RefProp();
        parentRefProp.setRefPropName(PropEnum.parent);
        parentRefProp.setProperties(new PropEnum[]{PropEnum.metadataModelPackage, PropEnum.metadataModel, PropEnum.parent, PropEnum.creationTime, PropEnum.parameters});
        contentManagerRefProperties[0] = parentRefProp;
        QueryOptions queryOptions = new QueryOptions();
        queryOptions.setRefProps(contentManagerRefProperties);
        query.setOptions(queryOptions);
        QueryRequest[] queryRequests = new QueryRequest[this.m_aExtraQueryRequests.length + 1];
        queryRequests[0] = query;
        for (int i = 0; i < this.m_aExtraQueryRequests.length; ++i) {
            queryRequests[i + 1] = this.m_aExtraQueryRequests[i];
        }
        this.m_arguments[0] = new QueryRequestMarshaller(queryRequests);
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        ICognosViewerRequest cmRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.CMSERVICEREQUEST);
        SOAPResponse cmResponse = cmRequest.executeRequest("queryMultiple", this.m_state, this.m_arguments, "");
        if (!CognosViewerDispatcherHandler.useRestAPI()) {
            this.updateDataPropertyForXML(cmResponse);
        }
        this.addPropertiesToState((CMServerResponse)cmResponse);
        this.setExecutePermissions((CMServerResponse)cmResponse);
        if (this.m_state instanceof CognosViewerDispatcherHandlerState) {
            this.addIPFLogs((CMServerResponse)cmResponse);
        }
        return cmResponse;
    }

    public void updateDataPropertyForXML(SOAPResponse cmResponse) throws CognosViewerException {
        String contentFormat = cmResponse.getContentFormat();
        String browserType = this.m_state.getEnvironmentVariable("HTTP_USER_AGENT");
        if ("XML".equals(contentFormat) && !BrowserUtility.isInternetExplorer(browserType)) {
            SOAPResponse cmDataOutput = this.getDataProperty();
            Element dataProperty = (Element)cmDataOutput.getBusEnvelope().getBody().selectSingleNode("*[local-name()='queryResponse']/result/item/data");
            Element queryItem = (Element)cmResponse.getBusEnvelope().getBody().selectSingleNode("*[local-name()='queryResponse']/returns/item/queryResult/item");
            if (queryItem != null && dataProperty != null) {
                queryItem.add(dataProperty.createCopy());
            }
        }
    }

    public void addExtraQueryRequests(QueryRequest[] queryRequests) {
        this.m_aExtraQueryRequests = queryRequests;
    }

    public void addPropertiesToState(CMServerResponse cmResponse) throws CognosViewerException {
        String sMetaDataModelPackage;
        String sMetadataModel;
        if (this.m_state.getFormFieldAsString("ui.name").length() <= 0) {
            this.setReportName(cmResponse);
        }
        if ((sMetadataModel = cmResponse.getStringValue("*[local-name()='queryResponse']/returns/item/queryResult/item/parent/value/item/metadataModel/value/item/searchPath/value")) != null && sMetadataModel.length() != 0) {
            this.m_state.setFormFieldFromString("modelPath", sMetadataModel);
        }
        if ((sMetaDataModelPackage = cmResponse.getStringValue("*[local-name()='queryResponse']/returns/item/queryResult/item/parent/value/item/metadataModelPackage/value/item/searchPath/value")) != null && sMetaDataModelPackage.length() > 0) {
            this.m_state.setFormFieldFromString("packageBase", sMetaDataModelPackage);
            if (sMetadataModel == null || sMetadataModel.length() == 0) {
                this.m_state.setFormFieldFromString("modelPath", sMetaDataModelPackage + "/model[last()]");
            }
        }
        this.setResponseFormat(cmResponse);
    }

    public void setResponseFormat(CMServerResponse cmResponse) throws CognosViewerException {
        String typeAttribute;
        Element reportVersionParent;
        Element outputParent = cmResponse.getComplexProperty("parent");
        if (outputParent != null && (reportVersionParent = (Element)outputParent.selectSingleNode("./value/item/parent/value/item")) != null && (typeAttribute = reportVersionParent.attributeValue(SOAPEnvelope.XSI_TYPE)) != null) {
            String runnableObjectClass = "";
            runnableObjectClass = typeAttribute.indexOf(":") == -1 ? typeAttribute : typeAttribute.substring(typeAttribute.indexOf(":") + 1);
            if (m_outputMap.containsKey(runnableObjectClass)) {
                if ("fragment".equals(this.m_state.getFormFieldAsString("cv.responseFormat"))) {
                    cmResponse.setFormFieldFromString("ui.objectClass", runnableObjectClass);
                } else {
                    String outputClass = (String)m_outputMap.get(runnableObjectClass);
                    cmResponse.setFormFieldFromString("cv.responseFormat", outputClass);
                }
            }
            if ("interactiveReport".equals(runnableObjectClass)) {
                cmResponse.setFormFieldFromString("ui.objectClass", runnableObjectClass);
            } else if ("reportView".equals(runnableObjectClass) && "XHTML".equals(cmResponse.getContentFormat())) {
                this.queryReportViewBase(reportVersionParent);
            }
        }
    }

    private void queryReportViewBase(Element reportView) throws CognosViewerException {
        Element reportViewSearchPath;
        if (reportView != null && (reportViewSearchPath = (Element)reportView.selectSingleNode("./searchPath/value")) != null) {
            IArgumentMarshaller[] arguments = new IArgumentMarshaller[3];
            arguments[0] = new SearchPathMultipleObjectMarshaller(new SearchPathMultipleObject(reportViewSearchPath.getText()));
            arguments[1] = new PropEnumMarshaller(new PropEnum[]{PropEnum.base});
            RefProp[] contentManagerRefProperties = new RefProp[1];
            RefProp parentRefProp = new RefProp();
            parentRefProp.setRefPropName(PropEnum.base);
            parentRefProp.setProperties(new PropEnum[]{PropEnum.objectClass});
            contentManagerRefProperties[0] = parentRefProp;
            QueryOptions queryOptions = new QueryOptions();
            queryOptions.setRefProps(contentManagerRefProperties);
            arguments[2] = new QueryOptionsMarshaller(queryOptions);
            ICognosViewerRequest cmRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.CMSERVICEREQUEST);
            CMServerResponse cmResponse = (CMServerResponse)cmRequest.executeRequest("query", this.m_state, arguments, "");
            ActionHelper.addBaseObjectClass(this.m_state, cmResponse);
        }
    }

    private void addIPFLogs(CMServerResponse cmResponse) {
        try {
            LogAuditAccessIndication logAuditAccessIndication;
            LogTypedLogger logAuditIndication;
            if (ActionHelper.hasQueryResult(cmResponse.getBusEnvelope()) && (logAuditIndication = LogTypedLogger.getInstance((String)"Audit.RTUsage.VIEWER", LogAuditIndication.class)) != null && (logAuditAccessIndication = this.getLogAuditData(cmResponse)) != null) {
                logAuditIndication.log((Object)logAuditAccessIndication);
            }
        }
        catch (Exception exception) {
            this.m_state.getIPFLogger().error(exception.getMessage(), exception, this.getClass().getName());
        }
    }

    public void setReportName(CMServerResponse cmResponse) throws CognosViewerException {
        String sObjectClass = cmResponse.getProperty("objectClass");
        String sSearchPath = cmResponse.getProperty("searchPath");
        if ("output".equals(sObjectClass)) {
            String defaultName = cmResponse.getProperty(PropEnum.defaultName.getValue(), 2);
            if (defaultName.length() > 0) {
                this.m_state.setFormFieldFromString("ui.name", defaultName);
            } else if (sSearchPath.length() > 0) {
                IArgumentMarshaller[] reportArguments = new IArgumentMarshaller[3];
                PropEnum[] reportProperties = new PropEnum[]{PropEnum.defaultName};
                reportArguments[0] = new SearchPathMultipleObjectMarshaller(new SearchPathMultipleObject(sSearchPath + "/../.."));
                reportArguments[1] = new PropEnumMarshaller(reportProperties);
                reportArguments[2] = new QueryOptionsMarshaller(new QueryOptions());
                ICognosViewerRequest cmRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.CMSERVICEREQUEST);
                SOAPResponse cmReportResponse = cmRequest.executeRequest("query", this.m_state, reportArguments, "");
                this.m_state.setFormFieldFromString("ui.name", ((CMServerResponse)cmReportResponse).getProperty(PropEnum.defaultName.getValue()));
            }
        } else {
            this.m_state.setFormFieldFromString("ui.name", cmResponse.getProperty("defaultName"));
        }
    }

    public LogAuditAccessIndication getLogAuditData(CMServerResponse cmResponse) {
        LogAuditAccessIndication logAuditAccessIndication = new LogAuditAccessIndication("VIEWER", 1);
        logAuditAccessIndication.setLevel(30000);
        Element tracking = this.m_state.getBusEnvelope().getTracking();
        if (tracking != null) {
            Element sessionContextElement;
            Element requestContextElement = tracking.element("requestContext");
            if (requestContextElement != null) {
                logAuditAccessIndication.setRequestID(requestContextElement.getText());
            }
            if ((sessionContextElement = tracking.element("sessionContext")) != null) {
                logAuditAccessIndication.setSessionID(sessionContextElement.getText());
            }
        }
        logAuditAccessIndication.setLogData(this.generateAuditLogData(cmResponse));
        logAuditAccessIndication.setOperation("VIEW");
        String sObjectPath = this.m_state.getFormFieldAsString("ui.object");
        String sOutputSearchPath = cmResponse.getProperty("searchPath");
        if (sOutputSearchPath == null || sOutputSearchPath.length() == 0) {
            sOutputSearchPath = sObjectPath;
        }
        logAuditAccessIndication.setObjectPath(sOutputSearchPath);
        String sObjectClass = this.getObjectClassFromSearchPath(sOutputSearchPath);
        logAuditAccessIndication.setObjectType(sObjectClass);
        logAuditAccessIndication.setStatus("Success");
        return logAuditAccessIndication;
    }

    public String getObjectClassFromSearchPath(String sSearchPath) {
        String sObjectClass = "";
        sObjectClass = sSearchPath.indexOf("/reportView") != -1 ? "REPORTVIEW" : (sSearchPath.indexOf("/query") != -1 ? "QUERY" : (sSearchPath.indexOf("/analysis") != -1 ? "ANALYSIS" : "REPORT"));
        return sObjectClass;
    }

    public void setExecutePermissions(CMServerResponse cmResponse) {
        Element permissions = cmResponse.getComplexProperty("permissions");
        if (permissions != null && permissions.selectSingleNode("./*[local-name()='value']/*[local-name()='item'][.='execute']") != null) {
            this.m_state.setFormFieldFromString("cv.executePermission", "true");
        }
    }

    private String generateAuditLogData(CMServerResponse cmResponse) {
        String sMetaDataModelPackage = cmResponse.getStringValue("*[local-name()='queryResponse']/returns/item/queryResult/item/parent/value/item/metadataModelPackage/value/item/searchPath/value");
        String sMetadataModel = cmResponse.getStringValue("*[local-name()='queryResponse']/returns/item/queryResult/item/parent/value/item/metadataModel/value/item/searchPath/value");
        if (sMetadataModel.length() == 0 && sMetaDataModelPackage.length() > 0) {
            sMetadataModel = sMetaDataModelPackage + "/model[last()]";
        }
        StringBuffer logData = new StringBuffer("<parameters>");
        this.addLogDataItem(logData, "model", sMetadataModel);
        this.addLogDataItem(logData, "package", sMetaDataModelPackage);
        this.addLogDataItem(logData, "reportFormat", cmResponse.getContentFormat());
        this.addLogDataItem(logData, "storeID", cmResponse.getProperty(PropEnum.storeID.getValue()));
        logData.append("</parameters>");
        return logData.toString();
    }

    private void addLogDataItem(StringBuffer sbLogData, String sName, String sValue) {
        sbLogData.append("<item name=\"" + sName + "\">");
        sbLogData.append("<![CDATA[" + sValue + "]]>");
        sbLogData.append("</item>");
    }

    private SOAPResponse getDataProperty() throws CognosViewerException {
        IArgumentMarshaller[] arguments = new IArgumentMarshaller[3];
        PropEnum[] properties = new PropEnum[]{PropEnum.data};
        QueryOptions queryOptions = new QueryOptions();
        queryOptions.setDataEncoding(EncodingEnum.base64);
        arguments[0] = new SearchPathMultipleObjectMarshaller(new SearchPathMultipleObject(this.m_state.getFormFieldAsString("ui.object")));
        arguments[1] = new PropEnumMarshaller(properties);
        arguments[2] = new QueryOptionsMarshaller(queryOptions);
        ICognosViewerRequest cmRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.CMSERVICEREQUEST);
        return cmRequest.executeRequest("query", this.m_state, arguments, "");
    }

    static {
        m_outputMap.put("powerPlay8Report", "powerPlay");
        m_outputMap.put("powerPlay8ReportView", "powerPlay");
    }
}

