/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.batchviewer.controller;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.NameValuePair;
import com.cognos.viewer.batchviewer.controller.BatchRequestMessageContext;
import com.cognos.viewer.batchviewer.controller.BatchUtility;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.utility.EncodingUtility;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BatchRequest {
    private Map<String, String> requestHeaders = null;
    private List<NameValuePair> formFields = new ArrayList<NameValuePair>(10);
    private static long idCounter = 0L;
    private long reqId = BatchRequest.getNextId();

    public List<NameValuePair> getFormFields() {
        return this.formFields;
    }

    private static synchronized long getNextId() {
        return ++idCounter;
    }

    public long getId() {
        return this.reqId;
    }

    public void extractBatchRequest(BufferedReader inStream) throws IOException, ClassNotFoundException {
        String[] fields;
        String message = BatchUtility.readBatchRequest(inStream);
        if (null != message && null != (fields = message.split("&"))) {
            for (String field : fields) {
                String[] nvpair = field.split("=");
                if (null == nvpair || nvpair.length != 2) continue;
                nvpair[0] = nvpair[0].trim();
                nvpair[1] = EncodingUtility.urldecode(nvpair[1]).trim();
                NameValuePair nv = new NameValuePair(nvpair[0], nvpair[1]);
                this.formFields.add(nv);
            }
        }
    }

    public InputStream invokeViewerDispHandler(MessageContext mc, CognosViewerDispatcherHandler viewerDispatcherHandler) throws IOException {
        InputStream returnStream = null;
        if (null != viewerDispatcherHandler) {
            BatchRequestMessageContext newMessageContext = new BatchRequestMessageContext(mc, this.formFields);
            viewerDispatcherHandler.invokeImpl(newMessageContext);
            returnStream = this.handleResponse(newMessageContext);
        }
        return returnStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream handleResponse(BatchRequestMessageContext newMessageContext) throws IOException {
        SequenceInputStream returnStream = null;
        BIBusEnvelope responseEnvelope = null;
        try {
            if (!newMessageContext.isFaulted()) {
                responseEnvelope = (BIBusEnvelope)newMessageContext.getProperty("response.envelope");
                String statusCode = (String)newMessageContext.getProperty("response.status_code");
                if (null != statusCode) {
                    Iterator attachments = (Iterator)newMessageContext.getProperty("response.attachments");
                    InputStream attachment = null;
                    if (null != attachments && attachments.hasNext()) {
                        attachment = (InputStream)attachments.next();
                        InputStream headerStream = BatchUtility.createInputStream("X-Status-Code: " + statusCode + "\r\n");
                        returnStream = new SequenceInputStream(headerStream, attachment);
                    }
                }
            }
        }
        finally {
            if (null != responseEnvelope) {
                newMessageContext.setProperty("response.envelope", null);
                responseEnvelope = null;
            }
        }
        return returnStream;
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(Map<String, String> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }
}

