/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.batchviewer.controller;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.viewer.batchviewer.controller.BatchUtility;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class BatchRequestHandler {
    public static final String NL = "\r\n";
    public static final String PART_STATUS_CODE = "X-Status-Code: ";
    private static final String CONTENT_TYPE_TEXT_PLAIN_CHARSET_UTF_8 = "Content-Type: text/plain; charset=utf-8\r\n\r\n";
    private static final String BOUNDARY = "{EB2F8DA2-5B2C-F66A-CDD0-A2D42143F5AC}";
    private static final String START_B = "--{EB2F8DA2-5B2C-F66A-CDD0-A2D42143F5AC}";
    private static final String QUOTE = "\"";
    private static final String FAKEHEADER = "X-C:multipart/mixed;boundary=\"{EB2F8DA2-5B2C-F66A-CDD0-A2D42143F5AC}\"\r\n";
    private static final String END_B = "--{EB2F8DA2-5B2C-F66A-CDD0-A2D42143F5AC}--";
    private static byte[] startResponse = null;
    private static byte[] startPart = null;
    private static byte[] endPart = null;

    public void initialize() throws IOException {
        startResponse = BatchUtility.getStreamBytes("X-C:multipart/mixed;boundary=\"{EB2F8DA2-5B2C-F66A-CDD0-A2D42143F5AC}\"\r\nContent-Type: text/plain; charset=utf-8\r\n\r\n");
        startPart = BatchUtility.getStreamBytes("\r\n--{EB2F8DA2-5B2C-F66A-CDD0-A2D42143F5AC}\r\n");
        endPart = BatchUtility.getStreamBytes("\r\n--{EB2F8DA2-5B2C-F66A-CDD0-A2D42143F5AC}--");
    }

    public abstract void handleRequest(MessageContext var1) throws IOException, ClassNotFoundException;

    public void sendResponse(MessageContext mc, List<InputStream> responses) throws IOException {
        InputStream inputStream1;
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        mc.setResponseName("response");
        mc.setProperty("response.envelope", (Object)requestEnvelope);
        mc.setProperty("response.status_code", (Object)"200");
        InputStream collectorStream = inputStream1 = BatchUtility.createInputStream(startResponse);
        for (InputStream response : responses) {
            InputStream inputStream2 = BatchUtility.createInputStream(startPart);
            collectorStream = new SequenceInputStream(collectorStream, inputStream2);
            if (null == response) continue;
            collectorStream = new SequenceInputStream(collectorStream, response);
        }
        InputStream inputStream3 = BatchUtility.createInputStream(endPart);
        collectorStream = new SequenceInputStream(collectorStream, inputStream3);
        ArrayList<InputStream> attachmentList = new ArrayList<InputStream>(10);
        attachmentList.add(collectorStream);
        Iterator attachments = attachmentList.iterator();
        mc.setProperty("response.attachments", attachments);
        mc.setProperty("response.boundary", (Object)CognosViewerDispatcherHandler.getBoundryValue());
    }
}

