/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.batchviewer.controller;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.viewer.batchviewer.controller.Batch;
import com.cognos.viewer.batchviewer.controller.BatchRequestExecutor;
import com.cognos.viewer.batchviewer.controller.BatchRequestHandler;
import com.cognos.viewer.batchviewer.controller.BatchUtility;
import com.cognos.viewer.batchviewer.controller.RunnableBatchRequest;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BatchRequestInvoker
extends BatchRequestHandler {
    private CognosViewerDispatcherHandler viewerDispatcherHandler;
    private BatchRequestExecutor executor;
    private List<RunnableBatchRequest> resultList;

    public BatchRequestInvoker(CognosViewerDispatcherHandler viewerHandler, BatchRequestExecutor theExecutor, List<RunnableBatchRequest> resultList1) {
        this.viewerDispatcherHandler = viewerHandler;
        this.executor = theExecutor;
        this.resultList = resultList1;
    }

    @Override
    public void handleRequest(MessageContext mc) throws IOException, ClassNotFoundException {
        if (null != mc) {
            Batch batch;
            BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
            Iterator attachmentsIterator = (Iterator)mc.getProperty("request.attachments");
            if (null != requestEnvelope && null != attachmentsIterator && null != (batch = this.readBatchRequests(mc, attachmentsIterator))) {
                List<InputStream> responses = this.executor.executeBatchRequests(mc, batch, this.viewerDispatcherHandler);
                this.sendResponse(mc, responses);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Batch readBatchRequests(MessageContext mc, Iterator<InputStream> attachmentsIterator) throws IOException, ClassNotFoundException {
        Batch batch = new Batch(this.resultList);
        ArrayList<RunnableBatchRequest> requestList = null;
        if (null != attachmentsIterator) {
            requestList = new ArrayList<RunnableBatchRequest>(5);
            while (attachmentsIterator.hasNext()) {
                InputStream reqStream = attachmentsIterator.next();
                if (null == reqStream) continue;
                BufferedReader in = null;
                try {
                    in = new BufferedReader(new InputStreamReader(reqStream, "UTF-8"));
                    Map<String, String> reqHeaders = BatchUtility.readHeaders(in);
                    RunnableBatchRequest req = new RunnableBatchRequest(mc, this.viewerDispatcherHandler);
                    req.extractBatchRequest(in);
                    req.setRequestHeaders(reqHeaders);
                    requestList.add(req);
                    req.setBatch(batch);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
        }
        batch.setRequestList(requestList);
        return batch;
    }
}

