/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.batchviewer.controller;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.TreeMap;

public class BatchUtility {
    public static InputStream createInputStream(String data) throws IOException {
        byte[] attachmentBytes = BatchUtility.getStreamBytes(data);
        return new ByteArrayInputStream(attachmentBytes);
    }

    public static InputStream createInputStream(byte[] attachmentBytes) throws IOException {
        return new ByteArrayInputStream(attachmentBytes);
    }

    public static byte[] getStreamBytes(String data) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(outStream);
        writer.write(data);
        writer.flush();
        return outStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readBatchRequest(BufferedReader in) throws IOException {
        String output = null;
        if (null != in) {
            StringBuilder out = new StringBuilder();
            try {
                char[] buffer = new char[4096];
                int read = 0;
                do {
                    if ((read = in.read(buffer, 0, buffer.length)) <= 0) continue;
                    out.append(buffer, 0, read);
                } while (read >= 0);
            }
            finally {
                output = out.toString();
            }
        }
        return output;
    }

    public static Map<String, String> readHeaders(BufferedReader in) throws IOException {
        TreeMap<String, String> headers = new TreeMap<String, String>();
        if (null != in) {
            String line = in.readLine();
            while (null != line && line.length() != 0) {
                String[] nvpair = line.split(":");
                if (null != nvpair) {
                    nvpair[0] = nvpair[0].trim();
                    if (nvpair.length == 2) {
                        nvpair[1] = nvpair[1].trim();
                        headers.put(nvpair[0], nvpair[1]);
                    } else {
                        headers.put(nvpair[0], null);
                    }
                }
                line = in.readLine();
            }
        }
        return headers;
    }
}

