/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.batchviewer.controller;

import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.viewer.batchviewer.controller.BatchRequestExecutor;
import com.cognos.viewer.batchviewer.controller.BatchRequestHandler;
import com.cognos.viewer.batchviewer.controller.BatchRequestInvoker;
import com.cognos.viewer.batchviewer.controller.ConcurrentBatchExecutor;
import com.cognos.viewer.batchviewer.controller.RunnableBatchRequest;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.utility.IPFLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class BatchViewerServiceHandler
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(BatchViewerServiceHandler.class.getName());
    private BatchRequestHandler handler;
    private CognosViewerDispatcherHandler viewerDispatcherHandler;
    private BatchRequestExecutor executor;
    private List<RunnableBatchRequest> resultList;
    private int threadPoolSize = 10;

    public BatchViewerServiceHandler() throws IOException {
        super(cat);
        this.init(new CognosViewerDispatcherHandler());
    }

    protected BatchViewerServiceHandler(CognosViewerDispatcherHandler handler1) throws IOException {
        super(cat);
        this.init(handler1);
    }

    protected void init(CognosViewerDispatcherHandler handler1) throws IOException {
        this.viewerDispatcherHandler = handler1;
        this.resultList = new ArrayList<RunnableBatchRequest>();
        ConcurrentBatchExecutor.init();
        this.executor = new ConcurrentBatchExecutor(this.threadPoolSize);
        this.handler = new BatchRequestInvoker(this.viewerDispatcherHandler, this.executor, this.resultList);
        this.handler.initialize();
    }

    public void configure(Configuration configuration) {
        super.configure(configuration);
        this.viewerDispatcherHandler.configure(configuration);
    }

    public void reconfigure(Configuration configuration) {
        super.reconfigure(configuration);
        this.viewerDispatcherHandler.reconfigure(configuration);
    }

    public void invokeImpl(MessageContext mc) throws PogoException {
        IPFLogger logger = IPFLogger.getInstance();
        try {
            this.handler.handleRequest(mc);
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), e, BatchViewerServiceHandler.class.getName());
            Fault aFault = new Fault("cognosViewer_fault", (Exception)e);
            mc.setFault(aFault);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getLocalizedMessage(), e, BatchViewerServiceHandler.class.getName());
            Fault aFault = new Fault("cognosViewer_fault", (Exception)e);
            mc.setFault(aFault);
        }
    }

    public void start() {
        this.executor.start();
        super.start();
    }

    public void stop() {
        this.executor.stop();
        super.stop();
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }
}

