/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.batchviewer.controller;

import com.cognos.pogo.pdk.MessageContext;
import com.cognos.viewer.batchviewer.controller.Batch;
import com.cognos.viewer.batchviewer.controller.BatchRequestExecutor;
import com.cognos.viewer.batchviewer.controller.BatchUtility;
import com.cognos.viewer.batchviewer.controller.RunnableBatchRequest;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ConcurrentBatchExecutor
implements BatchRequestExecutor {
    private static final String RETRY_HEADER = "X-Status-Code: 502\r\n";
    private static final int MIN_HI_PRI_THREADS = 10;
    private static final int MAX_HI_PRI_THREADS = 65535;
    private int threadPoolSize;
    private ThreadPoolExecutor highPriorityThreadPool = null;
    private ThreadPoolExecutor threadPool = null;
    private ArrayBlockingQueue<Runnable> queue = null;
    private LinkedBlockingQueue<Runnable> hiPriQueue;
    private static byte[] retryResponse = null;

    public static void init() throws IOException {
        retryResponse = BatchUtility.getStreamBytes(RETRY_HEADER);
    }

    public ConcurrentBatchExecutor(int theThreadPoolSize) {
        this.threadPoolSize = theThreadPoolSize;
        this.hiPriQueue = new LinkedBlockingQueue();
        this.highPriorityThreadPool = new ThreadPoolExecutor(10, 65535, 60L, TimeUnit.SECONDS, this.hiPriQueue);
        if (theThreadPoolSize > 0) {
            this.queue = new ArrayBlockingQueue(theThreadPoolSize);
            this.threadPool = new ThreadPoolExecutor(theThreadPoolSize, theThreadPoolSize, 60L, TimeUnit.SECONDS, this.queue);
        }
    }

    @Override
    public List<InputStream> executeBatchRequests(MessageContext mc, Batch batch, CognosViewerDispatcherHandler viewerDispatcherHandler) throws IOException {
        ArrayList<InputStream> responses = new ArrayList<InputStream>();
        List<RunnableBatchRequest> requestList = batch.getRequestList();
        if (null != requestList) {
            this.fireRequestsToPool(requestList);
            try {
                batch.waitTillDone();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.processResults(batch, responses);
        }
        return responses;
    }

    private void fireRequestsToPool(List<RunnableBatchRequest> requestList) {
        for (RunnableBatchRequest req : requestList) {
            if (this.addedToPool(req)) continue;
            req.markedForRetry();
        }
    }

    private void processResults(Batch batch, List<InputStream> responses) throws IOException {
        List<RunnableBatchRequest> reqlist = batch.getRequestList();
        for (RunnableBatchRequest req : reqlist) {
            if (null == req) continue;
            RunnableBatchRequest.State state = req.getState();
            switch (state) {
                case FORCE_CLIENT_TO_RETRY: 
                case NOT_STARTED: {
                    responses.add(this.getRetryResponse());
                    break;
                }
                case IN_PROGRESS: {
                    responses.add(this.getInProgressResponse(req.getId()));
                    break;
                }
                case PROCESSED: {
                    responses.add(req.getResult());
                }
            }
            req.setBatch(null);
        }
    }

    private InputStream getInProgressResponse(long id) throws IOException {
        byte[] response = BatchUtility.getStreamBytes("X-REQUEST-ID:" + id + "\r\n");
        return BatchUtility.createInputStream(response);
    }

    private InputStream getRetryResponse() throws IOException {
        return BatchUtility.createInputStream(retryResponse);
    }

    protected boolean addedToPool(RunnableBatchRequest req) {
        req.setState(RunnableBatchRequest.State.IN_PROGRESS);
        if (req.isHighPriority()) {
            this.highPriorityThreadPool.execute(req);
        } else {
            if (0 == this.threadPoolSize) {
                req.run();
                return true;
            }
            try {
                this.threadPool.execute(req);
            }
            catch (RejectedExecutionException rejected) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void start() {
        if (null != this.threadPool) {
            this.threadPool.prestartAllCoreThreads();
        }
        if (null != this.highPriorityThreadPool) {
            this.highPriorityThreadPool.prestartAllCoreThreads();
        }
    }

    @Override
    public void stop() {
        if (null != this.threadPool) {
            this.threadPool.shutdown();
        }
        if (null != this.highPriorityThreadPool) {
            this.highPriorityThreadPool.shutdown();
        }
    }
}

