/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.batchviewer.controller;

import com.cognos.pogo.pdk.MessageContext;
import com.cognos.viewer.batchviewer.controller.Batch;
import com.cognos.viewer.batchviewer.controller.BatchRequest;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class RunnableBatchRequest
extends BatchRequest
implements Runnable {
    private InputStream result;
    private Batch batch = null;
    private MessageContext mc;
    private CognosViewerDispatcherHandler viewerDispatcherHandler;
    private State state = State.NOT_STARTED;

    public RunnableBatchRequest(MessageContext mc1, CognosViewerDispatcherHandler viewerDispatcherHandler1) {
        this.mc = mc1;
        this.viewerDispatcherHandler = viewerDispatcherHandler1;
    }

    public synchronized void setBatch(Batch theBatch) {
        this.batch = theBatch;
    }

    public synchronized Batch getBatch() {
        return this.batch;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            this.result = this.invokeViewerDispHandler(this.mc, this.viewerDispatcherHandler);
            if (this.markCompleted()) return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private synchronized boolean markCompleted() {
        return this.markProcessed(State.PROCESSED);
    }

    public synchronized boolean markedForRetry() {
        return this.markProcessed(State.FORCE_CLIENT_TO_RETRY);
    }

    private boolean markProcessed(State reqState) {
        boolean returnVal = false;
        if (null != this.batch) {
            this.setState(reqState);
            this.batch.markCompleted(this);
            returnVal = true;
        }
        return returnVal;
    }

    public synchronized State getState() {
        return this.state;
    }

    public synchronized void setState(State state1) {
        this.state = state1;
    }

    public InputStream getResult() {
        return this.result;
    }

    public boolean isHighPriority() {
        Map<String, String> headers = this.getRequestHeaders();
        return null != headers && headers.containsKey("X-IMP");
    }

    public static enum State {
        NOT_STARTED,
        IN_PROGRESS,
        FORCE_CLIENT_TO_RETRY,
        PROCESSED;

    }
}

