/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.configuration;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.viewer.configuration.CWMenuItem;
import com.cognos.viewer.configuration.SystemReportFormat;
import com.cognos.viewer.model.Capabilities;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.toolbar.ToolbarFactory;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.JSONObject;
import com.cognos.viewer.utility.Protect;
import com.cognos.viewer.utility.XMLUtility;
import com.cognos.xts.ext.XTSExt;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class CognosViewerBlacklist {
    public static final String CRN_HEADER = "CRN_HEADER";
    public static final String CRN_HEADER_TITLE = "CRN_HEADER_TITLE";
    public static final String CRN_HEADER_OPTIONS = "CRN_HEADER_OPTIONS";
    public static final String CRN_HEADER_OPTIONS_CC = "CRN_HEADER_OPTIONS_CC";
    public static final String CRN_HEADER_OPTIONS_QS = "CRN_HEADER_OPTIONS_QS";
    public static final String CRN_HEADER_OPTIONS_PS = "CRN_HEADER_OPTIONS_PS";
    public static final String CRN_HEADER_OPTIONS_RS = "CRN_HEADER_OPTIONS_RS";
    public static final String RV_HEADER = "RV_HEADER";
    public static final String RV_HEADER_TITLE = "RV_HEADER_TITLE";
    public static final String RV_HEADER_AUTHENTICATION = "RV_HEADER_AUTHENTICATION";
    public static final String RV_HEADER_MENU_LOGON = "RV_HEADER_MENU_LOGON";
    public static final String RV_HEADER_MENU_LOGOFF = "RV_HEADER_MENU_LOGOFF";
    public static final String RV_HEADER_MENU = "RV_HEADER_MENU";
    public static final String RV_HEADER_MENU_HOME = "RV_HEADER_MENU_HOME";
    public static final String RV_HEADER_MENU_RETURN = "RV_HEADER_MENU_RETURN";
    public static final String RV_HEADER_MENU_ABOUT = "RV_HEADER_MENU_ABOUT";
    public static final String RV_TOOLBAR_BUTTONS = "RV_TOOLBAR_BUTTONS";
    public static final String RV_TOOLBAR_BUTTONS_DOWNLOAD = "RV_TOOLBAR_BUTTONS_DOWNLOAD";
    public static final String RV_TOOLBAR_BUTTONS_SEND = "RV_TOOLBAR_BUTTONS_SEND";
    public static final String RV_TOOLBAR_BUTTONS_RUN = "RV_TOOLBAR_BUTTONS_RUN";
    public static final String RV_TOOLBAR_BUTTONS_DRILLUP = "RV_TOOLBAR_BUTTONS_DRILLUP";
    public static final String RV_TOOLBAR_BUTTONS_DRILLDOWN = "RV_TOOLBAR_BUTTONS_DRILLDOWN";
    public static final String RV_TOOLBAR_BUTTONS_GOTO = "RV_TOOLBAR_BUTTONS_GOTO";
    public static final String RV_TOOLBAR_BUTTONS_GOTO_RELATED_LINKS = "RV_TOOLBAR_BUTTONS_GOTO_RELATED_LINKS";
    public static final String RV_TOOLBAR_BUTTONS_HTML = "RV_TOOLBAR_BUTTONS_HTML";
    public static final String RV_TOOLBAR_BUTTONS_PDF = "RV_TOOLBAR_BUTTONS_PDF";
    public static final String RV_TOOLBAR_BUTTONS_XML = "RV_TOOLBAR_BUTTONS_XML";
    public static final String RV_TOOLBAR_BUTTONS_XLS = "RV_TOOLBAR_BUTTONS_XLS";
    public static final String RV_TOOLBAR_BUTTONS_XLS_SINGLEXLS = "RV_TOOLBAR_BUTTONS_XLS_SINGLEXLS";
    public static final String RV_TOOLBAR_BUTTONS_XLS_XLS = "RV_TOOLBAR_BUTTONS_XLS_XLS";
    public static final String RV_TOOLBAR_BUTTONS_XLS_XLWA = "RV_TOOLBAR_BUTTONS_XLS_XLWA";
    public static final String RV_TOOLBAR_BUTTONS_XLS_SPREADSHEETML = "RV_TOOLBAR_BUTTONS_XLS_SPREADSHEETML";
    public static final String RV_TOOLBAR_BUTTONS_XLS_SPREADSHEETML_DATA = "RV_TOOLBAR_BUTTONS_XLS_SPREADSHEETML_DATA";
    public static final String RV_TOOLBAR_BUTTONS_XLS_CSV = "RV_TOOLBAR_BUTTONS_XLS_CSV";
    public static final String RV_TOOLBAR_BUTTONS_SAVE = "RV_TOOLBAR_BUTTONS_SAVE";
    public static final String RV_TOOLBAR_BUTTONS_SAVEAS = "RV_TOOLBAR_BUTTONS_SAVEAS";
    public static final String RV_TOOLBAR_BUTTONS_REPORT_VIEW_SAVE = "RV_TOOLBAR_BUTTONS_REPORTVIEWSAVE";
    public static final String RV_TOOLBAR_BUTTONS_HISTORY = "RV_TOOLBAR_BUTTONS_HISTORY";
    public static final String RV_TOOLBAR_BUTTONS_FORMATS = "RV_TOOLBAR_BUTTONS_FORMATS";
    public static final String RV_TOOLBAR_BUTTONS_KEEP_THIS_VERSION = "RV_TOOLBAR_BUTTONS_KEEP_THIS_VERSION";
    public static final String RV_TOOLBAR_BUTTONS_ADD_THIS_REPORT = "RV_TOOLBAR_BUTTONS_ADD_THIS_REPORT";
    public static final String RV_TOOLBAR_BUTTONS_ADD_TO_MY_FOLDERS = "RV_TOOLBAR_BUTTONS_ADD_TO_MY_FOLDERS";
    public static final String RV_TOOLBAR_BUTTONS_ADD_TO_MY_BOOKMARKS = "RV_TOOLBAR_BUTTONS_ADD_TO_MY_BOOKMARKS";
    public static final String RV_TOOLBAR_BUTTONS_WATCH_NEW_VERSIONS = "RV_TOOLBAR_BUTTONS_WATCH_NEW_VERSIONS";
    public static final String RV_TOOLBAR_BUTTONS_ALERT_ABOUT_NEW_VERSIONS = "RV_TOOLBAR_BUTTONS_ALERT_ABOUT_NEW_VERSIONS";
    public static final String RV_TOOLBAR_BUTTONS_ALERT_USING_NEW_WATCH_RULE = "RV_TOOLBAR_BUTTONS_ALERT_USING_NEW_WATCH_RULE";
    public static final String RV_TOOLBAR_BUTTONS_RULES = "RV_TOOLBAR_BUTTONS_RULES";
    public static final String RV_TOOLBAR_BUTTONS_RULES_MODIFY = "RV_TOOLBAR_BUTTONS_RULES_MODIFY";
    public static final String RV_TOOLBAR_BUTTONS_RULES_DELETE = "RV_TOOLBAR_BUTTONS_RULES_DELETE";
    public static final String RV_CONTEXT_MENU = "RV_CONTEXT_MENU";
    public static final String RV_CONTEXT_MENU_DOWNLOAD_CHART = "RV_CONTEXT_MENU_DOWNLOAD_CHART";
    public static final String RV_CONTEXT_MENU_DRILL_DOWN = "RV_CONTEXT_MENU_DRILL_DOWN";
    public static final String RV_CONTEXT_MENU_DRILL_UP = "RV_CONTEXT_MENU_DRILL_UP";
    public static final String RV_CONTEXT_MENU_GOTO = "RV_CONTEXT_MENU_GOTO";
    public static final String RV_CONTEXT_MENU_GOTO_RELATED_LINKS = "RV_CONTEXT_MENU_GOTO_RELATED_LINKS";
    public static final String RV_CONTEXT_MENU_ALERT_USING_NEW_WATCH_RULE = "RV_CONTEXT_MENU_ALERT_USING_NEW_WATCH_RULE";
    public static final String RV_CONTEXT_MENU_CALCULATION = "RV_CONTEXT_MENU_CALCULATION";
    public static final String RV_TOOLBAR_BUTTONS_EMAIL = "RV_TOOLBAR_BUTTONS_EMAIL";
    public static final String CC_RUN_OPTIONS_EMAIL_ATTACHMENT = "CC_RUN_OPTIONS_email_attachment";
    private static final String CW_ROLE_OVERRIDE_PATH = "../templates/ps/portal/bux-userRoleOverride.xml";
    private static final String SHOW_ADMINISTRATORS = "Administrators";
    private static final String SHOW_QSUSERS = "QSUsers";
    private static final String SHOW_RSUSERS = "RSUsers";
    private static final String SHOW_CONSUMERS = "Consumers";
    private static final String SHOW_ANONYMOUS = "Anonymous";
    private static final String[] m_asFormats = new String[]{"HTML", "PDF", "spreadsheetML", "XLWA", "singleXLS", "XLS", "CSV", "XML"};
    private static HashMap m_hmURLBasedBlackList = new HashMap();
    private static HashMap m_hmUIBlackList = new HashMap();
    private static HashMap m_hmFormatList = new HashMap();
    private static HashMap<String, CWMenuItem> m_hmCWMenuItemBlacklist = new HashMap();
    private static boolean m_bCafAction = true;
    private ICognosViewerState m_state = null;
    private String m_sBrowser = "";
    private boolean m_bIsNamed = false;
    private boolean m_bInitializedWithSessionInfo = false;
    private boolean m_bURLBlackList = false;
    private String[] m_asSessionUIG = new String[0];

    public CognosViewerBlacklist(ICognosViewerState state, String sBrowser) {
        this.m_state = state;
        this.m_sBrowser = sBrowser;
        if (state != null) {
            this.m_bURLBlackList = state.getSessionManager().getSessionParam("ui").length() > 0 || state.getFormFieldAsString("ui.hide").length() > 0;
        }
    }

    public static void clearCWRolesBlacklist() {
        m_hmCWMenuItemBlacklist.clear();
    }

    public static void initCWRolesBlacklist() {
        CognosViewerBlacklist.updateCWRolesBlacklist(ToolbarFactory.getToolbarSpec("buxToolbar"));
        CognosViewerBlacklist.updateCWRolesBlacklist(ToolbarFactory.getToolbarSpec("buxContextMenu"));
        CognosViewerBlacklist.updateCWRolesBlacklist(ToolbarFactory.getToolbarSpec("buxSavedOutputContextMenu"));
        CognosViewerBlacklist.updateCWRolesBlacklist(ToolbarFactory.getToolbarSpec("buxSavedOutputToolbar"));
        try {
            String sPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(CW_ROLE_OVERRIDE_PATH);
            Document overrideSpec = XMLUtility.createXMLDocument(new File(sPath));
            CognosViewerBlacklist.updateCWRolesBlacklist(overrideSpec.getRootElement());
        }
        catch (Exception e) {
            IPFLogger.getInstance().error("Caught exception in constructor of ToolbarFactory: " + e.toString(), "CognosViewerBlacklist");
        }
    }

    public static void updateCWRolesBlacklist(Element spec) {
        if (spec != null) {
            List menuItems = com.cognos.rap.utility.XMLUtility.selectNodes(spec, ".//item[./hide]");
            for (Element item : menuItems) {
                String itemName = item.elementText("name");
                String itemHideUserRole = item.elementText("hide");
                m_hmCWMenuItemBlacklist.put(itemName, new CWMenuItem(itemHideUserRole));
            }
        }
    }

    public boolean isBlacklistedForCWRole(String itemName) {
        CWMenuItem menuItem = m_hmCWMenuItemBlacklist.get(itemName);
        if (menuItem != null) {
            if ("mobile".equals(this.m_state.getFormFieldAsString("container"))) {
                return menuItem.isBlacklisted("mobile");
            }
            String cwRole = this.m_state.getFormFieldAsString("cv.buxCurrentUserRole");
            return menuItem.isBlacklisted(cwRole);
        }
        return false;
    }

    public static void initViewerBlacklist(Element systemElement) {
        if (!"true".equals(Protect.cafaction("get_configsignedreporturls", "false"))) {
            m_bCafAction = false;
        }
        if (m_hmURLBasedBlackList.isEmpty()) {
            m_hmURLBasedBlackList.put(CRN_HEADER, "h1");
            m_hmURLBasedBlackList.put(CRN_HEADER_TITLE, "t1");
            m_hmURLBasedBlackList.put(CRN_HEADER_OPTIONS, "m1");
            m_hmURLBasedBlackList.put(RV_HEADER, "h2");
            m_hmURLBasedBlackList.put(RV_HEADER_AUTHENTICATION, "t2");
            m_hmURLBasedBlackList.put(RV_HEADER_MENU, "m2");
            m_hmURLBasedBlackList.put(RV_TOOLBAR_BUTTONS, "h4");
        }
        if (systemElement != null) {
            List elementList = systemElement.elements();
            for (int iIndex = 0; iIndex < elementList.size(); ++iIndex) {
                Element currentElement = (Element)elementList.get(iIndex);
                String sNameAttribute = currentElement.attributeValue("name");
                if ("ui_hide".equals(sNameAttribute)) {
                    CognosViewerBlacklist.initSystemUIHide(currentElement);
                    continue;
                }
                if (!"reportFormats".equals(sNameAttribute)) continue;
                CognosViewerBlacklist.initSystemFormatList(currentElement);
            }
        }
    }

    private static void initSystemUIHide(Element hideElement) {
        List uiHideList = hideElement.elements();
        for (int iHideIndex = 0; iHideIndex < uiHideList.size(); ++iHideIndex) {
            Element uiHideElement = (Element)uiHideList.get(iHideIndex);
            String sElementName = uiHideElement.getName().toUpperCase();
            String sShowAttribute = "";
            Attribute showAttribute = uiHideElement.attribute("show");
            if (showAttribute != null) {
                sShowAttribute = showAttribute.getStringValue();
            }
            m_hmUIBlackList.put(sElementName, sShowAttribute);
        }
    }

    private static void initSystemFormatList(Element reportFormats) {
        List formatList = reportFormats.elements();
        String sHashKey = null;
        for (int iFormatIndex = 0; iFormatIndex < formatList.size(); ++iFormatIndex) {
            Element currentElement = (Element)formatList.get(iFormatIndex);
            String sFormatID = "";
            Attribute formatAttribute = currentElement.attribute("id");
            if (formatAttribute != null) {
                sFormatID = formatAttribute.getStringValue();
            }
            if ((sHashKey = CognosViewerBlacklist.getKeyFromFormat(sFormatID)).length() <= 0) continue;
            m_hmFormatList.put(sHashKey, new SystemReportFormat(currentElement));
        }
        for (int iIndex = 0; iIndex < m_asFormats.length; ++iIndex) {
            sHashKey = CognosViewerBlacklist.getKeyFromFormat(m_asFormats[iIndex]);
            if (m_hmFormatList.get(sHashKey) != null) continue;
            m_hmFormatList.put(sHashKey, new SystemReportFormat());
        }
    }

    private void initSessionHelperVariables() {
        if (this.m_state == null) {
            return;
        }
        String sSessionUIG = this.m_state.getSessionManager().getSessionParam("uig");
        if (sSessionUIG.length() > 0) {
            this.m_asSessionUIG = sSessionUIG.split(" ");
        }
        this.m_bIsNamed = this.m_state.getCAMPassport().getId().substring(2, 3).compareTo("1") == 0;
    }

    public boolean isBlacklisted(String sItem) {
        SystemReportFormat systemReportFormat;
        String sShowAttribute;
        if (!m_hmUIBlackList.isEmpty() && (sShowAttribute = (String)m_hmUIBlackList.get(sItem.toUpperCase())) != null) {
            if (sShowAttribute.length() == 0) {
                return true;
            }
            if (this.isBlacklistedForUser(sShowAttribute)) {
                return true;
            }
        }
        if (!m_hmFormatList.isEmpty() && (systemReportFormat = (SystemReportFormat)m_hmFormatList.get(sItem)) != null && systemReportFormat.isBlacklisted(this.m_sBrowser, m_bCafAction)) {
            return true;
        }
        if (this.m_bURLBlackList) {
            return this.isItemURLBlackLised(sItem.toUpperCase());
        }
        return false;
    }

    private boolean isBlacklistedForUser(String sShowAttribute) {
        if (this.m_state == null) {
            return true;
        }
        if (!this.m_bInitializedWithSessionInfo) {
            this.initSessionHelperVariables();
            this.m_bInitializedWithSessionInfo = true;
        }
        Capabilities cvCapabilities = this.m_state.getCapabilities();
        if (sShowAttribute.indexOf(SHOW_ADMINISTRATORS) != -1 && cvCapabilities.hasCapability("canUseAdministrationPortal")) {
            return false;
        }
        if (sShowAttribute.indexOf(SHOW_QSUSERS) != -1 && cvCapabilities.hasCapability("canUseQueryStudio") && cvCapabilities.hasCapability("canUseQueryStudioFileManagement")) {
            return false;
        }
        if (sShowAttribute.indexOf(SHOW_RSUSERS) != -1 && cvCapabilities.hasCapability("canUseReportStudio") && cvCapabilities.hasCapability("canUseReportStudioFileManagement")) {
            return false;
        }
        if (sShowAttribute.indexOf(SHOW_CONSUMERS) != -1 && this.m_bIsNamed) {
            return false;
        }
        if (sShowAttribute.indexOf(SHOW_ANONYMOUS) != -1 && !this.m_bIsNamed) {
            return false;
        }
        for (int iIndex = 0; iIndex < this.m_asSessionUIG.length; ++iIndex) {
            if (this.m_asSessionUIG[iIndex] == null || this.m_asSessionUIG[iIndex].length() <= 0 || sShowAttribute.indexOf(this.m_asSessionUIG[iIndex]) == -1) continue;
            return false;
        }
        return true;
    }

    private boolean isItemURLBlackLised(String sItem) {
        String sUISessionParamKey = (String)m_hmURLBasedBlackList.get(sItem);
        String sUISessionParam = this.m_state.getSessionManager().getSessionParam("ui");
        if (sUISessionParamKey != null && sUISessionParam.indexOf(sUISessionParamKey) != -1) {
            return true;
        }
        if (RV_TOOLBAR_BUTTONS.equals(sItem) && sUISessionParam.indexOf("m4") != -1) {
            return true;
        }
        if (this.m_state.getFormFieldAsString("ui.hide").length() > 0) {
            String sUIHide = this.m_state.getFormFieldAsString("ui.hide").toUpperCase();
            if (sUIHide.indexOf(32) == -1) {
                return sUIHide.equals(sItem);
            }
            return sUIHide.indexOf(sItem + " ") != -1 || sUIHide.endsWith(sItem);
        }
        return false;
    }

    public boolean isDownloadable(String sFormat) {
        String sFormatKey = CognosViewerBlacklist.getKeyFromFormat(sFormat);
        SystemReportFormat systemFormat = (SystemReportFormat)m_hmFormatList.get(sFormatKey);
        if (systemFormat != null) {
            return systemFormat.isDownloadable();
        }
        return false;
    }

    public static String getKeyFromFormat(String sFormat) {
        String sKey = "";
        if ("HTML".equals(sFormat)) {
            sKey = RV_TOOLBAR_BUTTONS_HTML;
        } else if ("PDF".equals(sFormat)) {
            sKey = RV_TOOLBAR_BUTTONS_PDF;
        } else if ("spreadsheetML".equals(sFormat)) {
            sKey = RV_TOOLBAR_BUTTONS_XLS_SPREADSHEETML;
        } else if ("xlsxData".equals(sFormat)) {
            sKey = RV_TOOLBAR_BUTTONS_XLS_SPREADSHEETML_DATA;
        } else if ("XLWA".equals(sFormat)) {
            sKey = RV_TOOLBAR_BUTTONS_XLS_XLWA;
        } else if ("singleXLS".equals(sFormat)) {
            sKey = RV_TOOLBAR_BUTTONS_XLS_SINGLEXLS;
        } else if ("XLS".equals(sFormat)) {
            sKey = RV_TOOLBAR_BUTTONS_XLS_XLS;
        } else if ("CSV".equals(sFormat)) {
            sKey = RV_TOOLBAR_BUTTONS_XLS_CSV;
        } else if ("XML".equals(sFormat)) {
            sKey = RV_TOOLBAR_BUTTONS_XML;
        }
        return sKey;
    }

    public void genJSONBlacklistMember(JSONObject jsonObject) {
        jsonObject.addMember("UIBlacklist", this.genJSONBlacklist(), false, false);
    }

    public String genJSONBlacklist() {
        StringBuffer sBlacklist = new StringBuffer(" ");
        this.writeBlackList(m_hmURLBasedBlackList.keySet().iterator(), sBlacklist);
        this.writeBlackList(m_hmUIBlackList.keySet().iterator(), sBlacklist);
        this.writeBlackList(m_hmFormatList.keySet().iterator(), sBlacklist);
        if (this.m_state != null) {
            if (this.m_state.getFormFieldAsString("ui.hide").length() > 0) {
                String[] uiHideKeys = this.m_state.getFormFieldAsString("ui.hide").split(" ");
                for (int iIndex = 0; iIndex < uiHideKeys.length; ++iIndex) {
                    if (!this.isBlacklisted(uiHideKeys[iIndex])) continue;
                    sBlacklist.append(' ').append(XTSExt.javascriptencode((String)uiHideKeys[iIndex])).append(' ');
                }
            }
            if ("true".equals(this.m_state.getFormFieldAsString("bux"))) {
                String cwRole = this.m_state.getFormFieldAsString("cv.buxCurrentUserRole");
                for (String sKey : m_hmCWMenuItemBlacklist.keySet()) {
                    if (!this.isBlacklistedForCWRole(sKey)) continue;
                    sBlacklist.append(' ').append(sKey).append(' ');
                }
            }
        }
        this.addNoneBuxUIHide(sBlacklist);
        sBlacklist.append(" ");
        return sBlacklist.toString();
    }

    private void addNoneBuxUIHide(StringBuffer sBlacklist) {
        if (this.m_state != null && "view".equals(this.m_state.getAction()) && "true".equals(this.m_state.getFormFieldAsString("bux"))) {
            sBlacklist.append(' ').append(XTSExt.javascriptencode((String)RV_CONTEXT_MENU_CALCULATION)).append(' ');
        }
    }

    private void writeBlackList(Iterator it, StringBuffer sBlacklist) {
        while (it.hasNext()) {
            String sKey = (String)it.next();
            if (!this.isBlacklisted(sKey)) continue;
            sBlacklist.append(' ').append(sKey).append(' ');
        }
    }

    protected static void resetUIBlackList() {
        m_hmURLBasedBlackList.clear();
        m_hmFormatList.clear();
        m_hmUIBlackList.clear();
    }
}

