/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.configuration;

import java.util.HashMap;
import org.dom4j.Attribute;
import org.dom4j.Comment;
import org.dom4j.Element;
import org.dom4j.Node;

public class CognosViewerSystemParams {
    private static HashMap m_systemParams = new HashMap();

    public void initialize(Element systemElement) {
        if (systemElement != null) {
            if (!"system".equals(systemElement.getName())) {
                return;
            }
            Element trimedSystemElement = CognosViewerSystemParams.trimComment(systemElement);
            for (Element parmEle : trimedSystemElement.elements()) {
                String name = parmEle.attributeValue("name");
                if (name == null || name.length() == 0) continue;
                m_systemParams.put(name, parmEle);
            }
        }
    }

    public static String getSystemParam(String sParamName) {
        Element paramElement = CognosViewerSystemParams.getSystemParamNode(sParamName);
        if (paramElement == null) {
            return "";
        }
        String sValue = "";
        if (!"".equals(paramElement.getTextTrim())) {
            sValue = paramElement.getTextTrim();
        }
        return sValue;
    }

    protected static void setSystemParam(String sParamName, Element element) {
        m_systemParams.put(sParamName, element);
    }

    public static Element getSystemParamNode(String sParamName) {
        if (sParamName == null || sParamName.length() == 0) {
            return null;
        }
        return (Element)m_systemParams.get(sParamName);
    }

    public static String getSystemParamAttribute(String sParamName, String sAttributeName) {
        Element paramElement = CognosViewerSystemParams.getSystemParamNode(sParamName);
        if (paramElement == null || sAttributeName == null || sAttributeName.length() == 0) {
            return "";
        }
        String sAttributeValue = "";
        Attribute attribute = paramElement.attribute(sAttributeName);
        if (attribute != null) {
            sAttributeValue = attribute.getStringValue();
        }
        return sAttributeValue;
    }

    private static Element trimComment(Element oEle) {
        int size = oEle.nodeCount();
        int i = 0;
        while (i < size) {
            Node node = oEle.node(i);
            if (node instanceof Comment) {
                node.detach();
            } else if (node instanceof Element) {
                CognosViewerSystemParams.trimComment((Element)node);
                ++i;
            } else {
                ++i;
            }
            size = oEle.nodeCount();
        }
        return oEle;
    }

    protected static void clearSystemParams() {
        m_systemParams.clear();
    }
}

