/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.controller;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionStringArray;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.config.DispatcherListService;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.util.StringUtils;
import com.cognos.rap.controller.RAPConfigProperties;
import com.cognos.viewer.action.ActionFactory;
import com.cognos.viewer.action.CognosViewerAction;
import com.cognos.viewer.action.ICognosViewerAction;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.configuration.CognosViewerBlacklist;
import com.cognos.viewer.configuration.CognosViewerSystemParams;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerCachedState;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ConnectionCleanup;
import com.cognos.viewer.model.FaultResponse;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.toolbar.ToolbarFactory;
import com.cognos.viewer.utility.DebugLogger;
import com.cognos.viewer.utility.FragmentUtility;
import com.cognos.viewer.utility.GZIPCompressorInputStream;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.JSONObject;
import com.cognos.viewer.utility.MessageManager;
import com.cognos.viewer.utility.PropertySet;
import com.cognos.viewer.utility.SharedByteArrayOutputStream;
import com.cognos.viewer.utility.URLValidator;
import com.cognos.viewer.utility.XMLUtility;
import com.cognos.viewer.utility.ZIPIUtility;
import com.cognos.viewer.view.ICognosViewerOutput;
import com.cognos.viewer.view.ICognosViewerOutputResponse;
import com.cognos.viewer.view.OutputFactory;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;
import javax.mail.Header;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.httpclient.Cookie;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class CognosViewerDispatcherHandler
extends BasicHandler {
    private CognosViewerServiceFactory m_serviceFactory = null;
    private ActionFactory m_actionFactory = null;
    private OutputFactory m_outputFactory = null;
    private CognosViewerCachedState m_cognosViewerCachedState = null;
    private static PropertySet m_configValues = new PropertySet();
    private static String m_configJSON = "";
    private static ToolbarFactory m_toolbarFactory = new ToolbarFactory();
    private String m_metadataInformationURI = "";
    private String m_glossaryURI = "";
    private String m_bpmRestURI = "";
    private static String m_sGateway = "";
    private static String dispatcherURI = "";
    static final Logger m_logger = Hierarchy.getDefaultHierarchy().getLoggerFor(CognosViewerDispatcherHandler.class.getName());
    private static String m_sBoundryValue = "";
    private static String m_outputLocation = "";
    private static boolean m_bCMCacheServiceEnabled = false;
    private static boolean m_bAnnotationServiceEnabled = false;
    private static String m_sServiceDefaultAccessibility = "false";
    private static String m_sOverrideAccessibility = "false";
    private static String m_sServiceDefaultFlashCharts = "true";
    private static String m_sOverrideFlashCharts = "true";
    private static boolean m_bGoDBCompatMode = false;
    private static int m_viscoachMode = -1;
    private static boolean m_addLocalizeLabelsAction = true;
    private static boolean m_bSortEnabled = false;
    private static boolean m_bExpandCollapseEnabled = false;
    private static boolean m_bInteractivityEnabled = false;
    private static boolean m_bPageActionEnabled = false;
    private static final String FORCE_DQ_COOKIE = "useDQForReportRun";
    private static final Set<String> compressibleMimeTypes = new HashSet<String>();
    private static final HashMap<String, String> formatCapabilities;

    public CognosViewerDispatcherHandler() {
        super(m_logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void invokeImpl(MessageContext messageContext) {
        IPFLogger logger = IPFLogger.getInstance();
        logger.startOverallPerf(10000, "Perf.VIEWER", "Starting invokeImpl perf logger");
        ICognosViewerActionResponse response = null;
        CognosViewerDispatcherHandlerState cognosViewerState = null;
        try {
            BIBusEnvelope biBusEnvelope = (BIBusEnvelope)messageContext.getProperty("request.envelope");
            this.preProcessMessageContext(messageContext);
            cognosViewerState = this.createDispatcherHandlerState(messageContext);
            cognosViewerState.setHeaders((InternetHeaders)messageContext.getProperty("request.headers"));
            if ("true".equals(cognosViewerState.getFormFieldAsString("cv.reload"))) {
                this.loadViewerConfigProperties();
                CognosViewerBlacklist.clearCWRolesBlacklist();
                CognosViewerBlacklist.initCWRolesBlacklist();
            }
            this.processIncomingFormFields(biBusEnvelope, cognosViewerState);
            cognosViewerState.setIPFLogger(logger);
            if (cognosViewerState.getDebugLogger().causeDebugFault(cognosViewerState)) {
                this.generateNullPointer();
            }
            ZipiTimer timer = null;
            try {
                if (ZIPIUtility.getInstance().isZIPIEnablded()) {
                    timer = this.startZipiTimer(cognosViewerState);
                }
                response = this.handleRequest(cognosViewerState);
                ZIPIUtility.getInstance().stopZipiTimer(timer);
            }
            catch (Throwable throwable) {
                ZIPIUtility.getInstance().stopZipiTimer(timer);
                throw throwable;
            }
            ICognosViewerOutputResponse output = this.handleResponse(cognosViewerState, response);
            BIBusEnvelope requestEnvelope = cognosViewerState.getBusEnvelope();
            if (requestEnvelope == null) {
                requestEnvelope = (BIBusEnvelope)messageContext.getProperty("request.envelope");
            }
            this.setCookie(cognosViewerState, requestEnvelope);
            this.setMessageContextProperties(output, messageContext, requestEnvelope, cognosViewerState);
            this.finalCleanup(messageContext, cognosViewerState, response);
        }
        catch (CognosViewerException cognosViewerException) {
            DebugLogger.logTraceException(cognosViewerException, (BIBusEnvelope)messageContext.getProperty("request.envelope"));
            this.handleException(cognosViewerState, cognosViewerException, messageContext);
            this.finalCleanup(messageContext, cognosViewerState, response);
        }
        catch (Exception exception) {
            DebugLogger.logTraceException(exception, (BIBusEnvelope)messageContext.getProperty("request.envelope"));
            CognosViewerException cognosViewerException2 = this.createCognosViewerException(messageContext, exception);
            this.handleException(cognosViewerState, cognosViewerException2, messageContext);
            this.finalCleanup(messageContext, cognosViewerState, response);
            {
                catch (Throwable throwable) {
                    this.finalCleanup(messageContext, cognosViewerState, response);
                    throw throwable;
                }
            }
        }
        logger.stopOverallPerf(10000, "Perf.VIEWER", "Stopping invokeImpl perf logger");
    }

    protected void writeJsonLogsToCM(CognosViewerDispatcherHandlerState cognosViewerState) {
        if (cognosViewerState != null && cognosViewerState.getDebugLogger() != null) {
            cognosViewerState.getDebugLogger().endTimedEvent("VIEWER");
            cognosViewerState.getDebugLogger().writeTimingLog();
            cognosViewerState.getDebugLogger().writeTraceLog();
            if (cognosViewerState.getDebugLogger().hasJsonLogs() && cognosViewerState.getDebugLogger().isJsonLoggingOn() && !"saveJSONLogs".equals(cognosViewerState.getFormFieldAsString("ui.action"))) {
                try {
                    String originalAction = cognosViewerState.getFormFieldAsString("ui.action");
                    cognosViewerState.setFormFieldFromString("ui.action", "saveJSONLogs");
                    ICognosViewerAction saveJSONLogs = this.m_actionFactory.load("SaveJSONLogs", cognosViewerState);
                    saveJSONLogs.execute();
                    cognosViewerState.setFormFieldFromString("ui.action", originalAction);
                }
                catch (Exception e) {
                    DebugLogger.logTraceException(e, cognosViewerState.getBusEnvelope());
                }
            }
        }
    }

    protected void finalCleanup(MessageContext messageContext, CognosViewerDispatcherHandlerState cognosViewerState, ICognosViewerActionResponse response) {
        if (cognosViewerState != null && cognosViewerState.getDebugLogger() != null && response != null) {
            cognosViewerState.getDebugLogger().cleanDebugLogs(response.getStatus());
        }
        this.writeJsonLogsToCM(cognosViewerState);
    }

    protected void processIncomingFormFields(BIBusEnvelope biBusEnvelope, CognosViewerDispatcherHandlerState cognosViewerState) throws CognosViewerException {
        String format;
        RunOptionStringArray outputFormat;
        String[] asOutputFormat;
        String compressedFormFields;
        String spec;
        if ("true".equals(biBusEnvelope.getCookieValue(FORCE_DQ_COOKIE))) {
            biBusEnvelope.setFormField("_dataServer", "queryService");
        }
        if ((spec = cognosViewerState.getFormFieldAsString("ui.spec")) != null && spec.length() > 0) {
            cognosViewerState.processIncomingReportSpec(spec);
        }
        if ((compressedFormFields = biBusEnvelope.getFormValue("cv.compressedFormFields")) != null && compressedFormFields.length() > 0) {
            String decoded = CognosViewerAction.decodeSignedXML(compressedFormFields);
            CognosViewerAction.deserializeActionState(decoded, null, biBusEnvelope, cognosViewerState);
            biBusEnvelope.setFormField("cv.compressedFormFields", "");
            cognosViewerState.setFormFieldFromString("cv.compressedFormFields", "");
        }
        if ("reload".equals(biBusEnvelope.getFormValue("cv.toolbarxml"))) {
            m_toolbarFactory = new ToolbarFactory();
        }
        if (cognosViewerState.getOptionManager().getOption(RunOptionEnum.outputFormat.getValue()) != null && (asOutputFormat = (outputFormat = (RunOptionStringArray)cognosViewerState.getOptionManager().getOption(RunOptionEnum.outputFormat.getValue())).getValue()).length > 0 && !CognosViewerDispatcherHandler.hasFormatCapability(cognosViewerState, format = asOutputFormat[0])) {
            throw new CognosViewerException(biBusEnvelope, MessageManager.convert("CANNOT_GENERATE_OUTPUT_FORMAT", CognosViewerDispatcherHandlerState.getFaultLocale(biBusEnvelope), new Object[]{format}), null);
        }
    }

    public static boolean hasFormatCapability(ICognosViewerState cognosViewerState, String format) {
        String capabilityToCheck = formatCapabilities.get(format);
        if (capabilityToCheck != null) {
            return cognosViewerState.getCapabilities().hasCapability(capabilityToCheck);
        }
        return true;
    }

    protected void preProcessMessageContext(MessageContext messageContext) throws CognosViewerException {
    }

    private void generateNullPointer() throws Exception {
        throw new NullPointerException("Fake exception for testing. Thrown from CognoViewerDispatcherHandler.generateNullPointer()");
    }

    public CognosViewerDispatcherHandlerState createDispatcherHandlerState(MessageContext messageContext) throws CognosViewerException {
        CognosViewerDispatcherHandlerState cognosViewerState = new CognosViewerDispatcherHandlerState(messageContext, this.m_serviceFactory);
        if (this.m_metadataInformationURI != null && !"".equals(this.m_metadataInformationURI)) {
            cognosViewerState.setFormFieldFromString("metadataInformationURI", this.m_metadataInformationURI);
        }
        if (this.m_glossaryURI != null && !"".equals(this.m_glossaryURI)) {
            cognosViewerState.setFormFieldFromString("glossaryURI", this.m_glossaryURI);
        }
        if (this.m_bpmRestURI != null && !"".equals(this.m_bpmRestURI)) {
            cognosViewerState.setFormFieldFromString("bpmRestURI", this.m_bpmRestURI);
        }
        if (CognosViewerDispatcherHandler.getConfigValues().containsKey("VIEWER_IGNORE_UI_NAME_ON_URL") && CognosViewerDispatcherHandler.getConfigValues().getBoolean("VIEWER_IGNORE_UI_NAME_ON_URL")) {
            cognosViewerState.removeFormField("ui.name");
        }
        return cognosViewerState;
    }

    protected ICognosViewerActionResponse handleRequest(CognosViewerDispatcherHandlerState cognosViewerState) throws CognosViewerException {
        if (FragmentUtility.shouldLoadCache(cognosViewerState)) {
            this.m_cognosViewerCachedState.load(cognosViewerState);
        }
        ICognosViewerAction cognosViewerAction = this.m_actionFactory.load(cognosViewerState);
        cognosViewerAction.setHeaders(cognosViewerState.getHeaders());
        return cognosViewerAction.execute();
    }

    protected ICognosViewerOutputResponse handleResponse(CognosViewerDispatcherHandlerState cognosViewerState, ICognosViewerActionResponse cognosViewerActionResponse) throws CognosViewerException {
        cognosViewerState.processOutgoingFormFields();
        if (cognosViewerState.getDebugLogger() != null && cognosViewerState.getDebugLogger().isDebugEnabled()) {
            cognosViewerState.getDebugLogger().logXML(cognosViewerState.getStateInfo(cognosViewerActionResponse), "viewerState.xml", true, "state");
        }
        this.handleJUnitTesting(cognosViewerState, cognosViewerActionResponse);
        ICognosViewerOutput cognosViewerOutput = this.m_outputFactory.getOutput(cognosViewerActionResponse);
        ICognosViewerOutputResponse cognosViewerOutputResponse = cognosViewerOutput.render(cognosViewerActionResponse);
        if (FragmentUtility.shouldSaveCache(cognosViewerState, cognosViewerActionResponse.getStatus())) {
            this.m_cognosViewerCachedState.save(cognosViewerActionResponse, cognosViewerOutputResponse);
        }
        return cognosViewerOutputResponse;
    }

    protected void handleJUnitTesting(CognosViewerDispatcherHandlerState cognosViewerState, ICognosViewerActionResponse cognosViewerActionResponse) {
        if (CognosViewerDispatcherHandlerState.isMasters()) {
            try {
                Class<?> junitClass = Class.forName("junit.masters.MasterTestHelper");
                Method method = junitClass.getDeclaredMethod("setState", CognosViewerDispatcherHandlerState.class, ICognosViewerActionResponse.class);
                method.invoke(null, cognosViewerState, cognosViewerActionResponse);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void handleException(CognosViewerDispatcherHandlerState cognosViewerState, CognosViewerException exception, MessageContext messageContext) {
        BIBusEnvelope responseEnvelope = exception.getFaultEnvelope();
        String sFailureDetail = exception.getFailureDetail();
        if (sFailureDetail.length() > 0) {
            m_logger.error(sFailureDetail);
        }
        if (cognosViewerState != null) {
            if (cognosViewerState.getDebugLogger() != null) {
                cognosViewerState.getDebugLogger().log(responseEnvelope, "fault.xml", false, null);
            }
            cognosViewerState.getIPFLogger().error(exception.getMessage(), exception, ((Object)((Object)this)).getClass().getName());
        }
        this.setFaultResponse(messageContext, responseEnvelope, cognosViewerState);
    }

    public void setFaultResponse(MessageContext messageContext, BIBusEnvelope busEnvelope, CognosViewerDispatcherHandlerState cognosViewerState) {
        block6: {
            if (cognosViewerState != null && !CognosViewerDispatcherHandler.isSSOAuthenticationFault(busEnvelope)) {
                try {
                    ICognosViewerOutput faultRenderer;
                    ICognosViewerOutputResponse cognosViewerOutputResponse;
                    Element eHdrSession;
                    BIBusEnvelope cleanEnvelope = null;
                    if (busEnvelope != null && (eHdrSession = (cleanEnvelope = (BIBusEnvelope)busEnvelope.clone()).getHdrSession()) != null) {
                        eHdrSession.detach();
                    }
                    if ((cognosViewerOutputResponse = (faultRenderer = this.m_outputFactory.load(cognosViewerState.getResponseFormat(), cognosViewerState)).handleFault(new FaultResponse(cognosViewerState, cleanEnvelope))) != null) {
                        this.setMessageContextProperties(cognosViewerOutputResponse, messageContext, busEnvelope, cognosViewerState);
                        break block6;
                    }
                    this.setFault(messageContext, busEnvelope, null, cognosViewerState);
                }
                catch (Exception exception) {
                    this.setFault(messageContext, busEnvelope, exception, cognosViewerState);
                }
            } else {
                this.setFault(messageContext, busEnvelope, null, cognosViewerState);
            }
        }
    }

    public static boolean isSSOAuthenticationFault(BIBusEnvelope envelope) {
        Element camHeader;
        if (envelope != null && (camHeader = envelope.getCAM()) != null) {
            Element errorCodeString = (Element)camHeader.selectSingleNode("*[local-name()='exception']//*[local-name()='errorCodeString']");
            return errorCodeString != null && "camAuthSystemRecoverable".equals(errorCodeString.getTextTrim());
        }
        return false;
    }

    public void setFault(MessageContext messageContext, BIBusEnvelope busEnvelope, Exception exception, CognosViewerDispatcherHandlerState cognosViewerState) {
        if (cognosViewerState != null) {
            cognosViewerState.releaseConnections();
        }
        Fault fault = new Fault("cognosViewer_fault", (SOAPEnvelope)busEnvelope);
        if (messageContext != null) {
            messageContext.setFault(fault);
        }
        if (exception != null) {
            IPFLogger.getInstance().error(exception.getMessage(), exception, ((Object)((Object)this)).getClass().getName());
        }
    }

    public void setCookie(CognosViewerDispatcherHandlerState cognosViewerState, BIBusEnvelope requestEnvelope) {
        if (cognosViewerState.getSessionManager().isNewSession()) {
            Cookie cookie = new Cookie();
            cookie.setName("viewer_session");
            cookie.setValue(cognosViewerState.getSessionManager().getViewerSession());
            requestEnvelope.addSetCookie(cookie);
            cognosViewerState.getSessionManager().setIsNewSession(false);
        }
        cognosViewerState.addSetCookiesToSOAPHeader(requestEnvelope);
    }

    public void setMessageContextProperties(ICognosViewerOutputResponse cognosViewerOutputResponse, MessageContext messageContext, BIBusEnvelope requestEnvelope, CognosViewerDispatcherHandlerState state) throws Exception, PogoException {
        messageContext.setResponseName("response");
        if (requestEnvelope != null) {
            Element soapBody = requestEnvelope.getBody();
            List elements = soapBody.elements();
            int iListSize = elements.size();
            for (int iIndex = 0; iIndex < iListSize; ++iIndex) {
                Element element = (Element)elements.get(iIndex);
                element.detach();
            }
        }
        messageContext.setProperty("response.envelope", (Object)requestEnvelope);
        messageContext.setProperty("response.status_code", (Object)"200");
        StringBuilder sbOutput = cognosViewerOutputResponse.getStringBufferOutput();
        InternetHeaders requestHeaders = (InternetHeaders)messageContext.getProperty("request.headers");
        boolean gzipResponse = this.clientAcceptsGZipResponse(requestHeaders);
        boolean turnOffIEXSSCheck = CognosViewerDispatcherHandler.getConfigValues().getBoolean("VIEWER_DISABLE_IE_XSS_CHECK");
        InternetHeaders responseHeaders = null;
        if (gzipResponse || turnOffIEXSSCheck) {
            int headerEndPos = sbOutput.indexOf("\r\n\r\n");
            if (headerEndPos > 0) {
                responseHeaders = new InternetHeaders((InputStream)new ByteArrayInputStream(sbOutput.substring(0, headerEndPos + "\r\n\r\n".length()).getBytes("UTF-8")));
                sbOutput.delete(0, headerEndPos + "\r\n\r\n".length());
                String responseContentType = responseHeaders.getHeader("Content-Type", null);
                if (responseContentType != null && !compressibleMimeTypes.contains(new StringTokenizer(responseContentType, ";").nextToken()) || responseHeaders.getHeader("Content-Encoding") != null) {
                    gzipResponse = false;
                }
            } else {
                throw new IllegalStateException(MessageManager.convert("RV_MISSING_CONTENT_TYPE", CognosViewerDispatcherHandlerState.getProductLocale(state)));
            }
        }
        InputStream inStream = null;
        if (state.getAttachmentInputStream() == null) {
            byte[] attachmentBytes = null;
            attachmentBytes = cognosViewerOutputResponse.getStringOutput().getBytes("UTF-8");
            state.getDebugLogger().log(attachmentBytes, "output.txt", true, "output");
            if (gzipResponse && responseHeaders != null) {
                SharedByteArrayOutputStream compressedInStream = this.compress(attachmentBytes);
                responseHeaders.addHeader("Content-Length", Integer.toString(compressedInStream.size()));
                responseHeaders.addHeader("Content-Encoding", "gzip");
                responseHeaders.addHeader("Vary", "Accept-Encoding");
                inStream = compressedInStream.toStream();
            } else {
                inStream = new ByteArrayInputStream(attachmentBytes);
            }
        } else {
            if (state.getDebugLogger().isDebugEnabled()) {
                state.getDebugLogger().log(sbOutput.toString().getBytes("UTF-8"), "output.txt", true, "output");
            }
            String sBeginningHTML = sbOutput.substring(0, sbOutput.indexOf("####attachmentPlaceHolder####"));
            ByteArrayInputStream beginningStream = new ByteArrayInputStream(sBeginningHTML.getBytes("UTF-8"));
            String sEndingHTML = sbOutput.substring(sbOutput.indexOf("####attachmentPlaceHolder####") + "####attachmentPlaceHolder####".length(), sbOutput.length());
            ByteArrayInputStream endingStream = new ByteArrayInputStream(sEndingHTML.getBytes("UTF-8"));
            inStream = new SequenceInputStream(new SequenceInputStream(beginningStream, state.getAttachmentInputStream()), endingStream);
            if (gzipResponse && responseHeaders != null) {
                responseHeaders.addHeader("Content-Encoding", "gzip");
                responseHeaders.addHeader("Vary", "Accept-Encoding");
                inStream = new GZIPCompressorInputStream(inStream);
            }
        }
        if (responseHeaders != null) {
            if (turnOffIEXSSCheck) {
                responseHeaders.addHeader("X-XSS-Protection", "0");
            }
            StringBuilder responseHeaderBuf = new StringBuilder(64);
            Enumeration responseHeaderEnum = responseHeaders.getAllHeaders();
            while (responseHeaderEnum.hasMoreElements()) {
                Header responseHeader = (Header)responseHeaderEnum.nextElement();
                responseHeaderBuf.append(responseHeader.getName());
                responseHeaderBuf.append(": ");
                responseHeaderBuf.append(responseHeader.getValue());
                responseHeaderBuf.append("\r\n");
            }
            responseHeaderBuf.append("\r\n");
            inStream = new SequenceInputStream(new ByteArrayInputStream(responseHeaderBuf.toString().getBytes("UTF-8")), inStream);
        }
        ArrayList<ByteArrayInputStream> attachmentList = new ArrayList<ByteArrayInputStream>();
        attachmentList.add((ByteArrayInputStream)inStream);
        Iterator attachments = attachmentList.iterator();
        messageContext.setProperty("response.attachments", attachments);
        messageContext.setProperty("response.boundary", (Object)CognosViewerDispatcherHandler.getBoundryValue());
        this.handleConnectionCleanup(messageContext, state);
    }

    protected void handleConnectionCleanup(MessageContext messageContext, CognosViewerDispatcherHandlerState state) throws PogoException {
        if (state.getCleanupList() != null && !state.getCleanupList().isEmpty()) {
            List cleanables = (List)messageContext.getProperty("cleanup");
            if (cleanables == null) {
                throw new PogoException(MessageManager.convert("RV_EMPTY_CLEANUPLIST_ERROR", CognosViewerDispatcherHandlerState.getProductLocale(state)));
            }
            cleanables.add(new ConnectionCleanup(state.getCleanupList()));
        }
    }

    private boolean clientAcceptsGZipResponse(InternetHeaders requestHeaders) {
        String acceptEncodings;
        String configValue = CognosViewerDispatcherHandler.getConfigValues().getProperty("VIEWER_NATIVE_COMPRESSION");
        if (configValue != null && configValue.length() > 0) {
            return "true".equalsIgnoreCase(configValue);
        }
        boolean gzipResponse = false;
        if (requestHeaders != null && (acceptEncodings = requestHeaders.getHeader("Accept-Encoding", ",")) != null) {
            StringTokenizer acceptEncodingValues = new StringTokenizer(acceptEncodings, ",");
            while (acceptEncodingValues.hasMoreTokens()) {
                if (!acceptEncodingValues.nextToken().trim().equals("gzip")) continue;
                gzipResponse = true;
                break;
            }
        }
        return gzipResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedByteArrayOutputStream compress(byte[] bytes) throws IOException {
        SharedByteArrayOutputStream bytesOut = new SharedByteArrayOutputStream(1024);
        GZIPOutputStream gzipOut = null;
        try {
            gzipOut = new GZIPOutputStream(bytesOut);
            gzipOut.write(bytes, 0, bytes.length);
            gzipOut.finish();
            gzipOut.close();
            gzipOut = null;
            bytesOut.flush();
        }
        finally {
            if (null != gzipOut) {
                try {
                    gzipOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bytesOut;
    }

    public CognosViewerException createCognosViewerException(MessageContext messageContext, Exception e) {
        if (!MessageManager.isInitialized()) {
            MessageManager.initialize();
        }
        BIBusEnvelope busEnvelope = (BIBusEnvelope)messageContext.getProperty("request.envelope");
        CognosViewerException cognosViewerException = new CognosViewerException(busEnvelope, MessageManager.convert("RV_COGNOS_VIEWER_DISPATCHER_HANDLER_ERROR", CognosViewerDispatcherHandlerState.getFaultLocale(busEnvelope)), e);
        return cognosViewerException;
    }

    public void setToDefaultValidationConfig() {
        m_configValues.setProperty("validationActive", "true");
        m_configValues.setProperty("validationMandatoryRules", "false");
        m_configValues.setProperty("useReportAuthoredStyles", "false");
    }

    private void loadViewerConfigProperties() {
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("viewerconfig.properties");
        this.setToDefaultValidationConfig();
        if (is != null) {
            try {
                m_configValues.load(is);
            }
            catch (IOException ioe) {
                IPFLogger.getInstance().error("Caught exception in loading viewerconfig.properties: " + ioe.getMessage(), ioe, CognosViewerDispatcherHandler.class.getName());
            }
            try {
                DebugLogger.initialize();
            }
            catch (Exception e) {
                IPFLogger.getInstance().error("Caught exception in DebugLogger.initialize(): " + e.getMessage(), e, CognosViewerDispatcherHandler.class.getName());
            }
            try {
                is.close();
            }
            catch (IOException e1) {
                IPFLogger.getInstance().error("Caught exception closing viewerconfig.properties: " + e1.getMessage(), e1, CognosViewerDispatcherHandler.class.getName());
            }
        }
    }

    public void configure(Configuration configuration) {
        this.loadViewerConfigProperties();
        ICCLConfiguration cclConfiguration = configuration.getICCLConfiguration();
        if (cclConfiguration != null) {
            try {
                this.initialize(cclConfiguration);
                this.setRuntimeConfiguration(cclConfiguration);
                MessageManager.initialize();
                this.initializeSystemFile();
                if (m_configValues.getBoolean("validationActive")) {
                    URLValidator.init(m_configValues.getBoolean("validationMandatoryRules"));
                }
                this.updateServiceStatus(configuration);
                CognosViewerBlacklist.initCWRolesBlacklist();
            }
            catch (Exception exception) {
                IPFLogger.getInstance().error("Caught exception in cclConfiguration initialization: " + exception.getMessage(), exception, CognosViewerDispatcherHandler.class.getName());
            }
        }
    }

    public void reconfigure(Configuration configuration) {
        try {
            ICCLConfiguration cclConfiguration = configuration.getICCLConfiguration();
            if (cclConfiguration != null) {
                this.setRuntimeConfiguration(cclConfiguration);
            }
            this.updateServiceStatus(configuration);
        }
        catch (Exception exception) {
            IPFLogger.getInstance().error("Caught exception in reconfigure: " + exception.getMessage(), exception, CognosViewerDispatcherHandler.class.getName());
        }
    }

    public void updateServiceStatus(Configuration configuration) throws Exception {
        ICCLConfiguration cclConfiguration = configuration.getICCLConfiguration();
        Element cmResponse = configuration.getCmResponse();
        Element runningState = (Element)cmResponse.selectSingleNode("./item[contains(@*[local-name()='type'], 'contentManagerCacheService')]/runningState/value");
        if (runningState != null && "running".equals(runningState.getText()) && !"0".equals(cclConfiguration.getValue("cmcsHeapLimit", true))) {
            CognosViewerDispatcherHandler.setCMCacheServiceEnabled(true);
        } else {
            CognosViewerDispatcherHandler.setCMCacheServiceEnabled(false);
        }
        Map<String, Boolean> servicesRunning = this.isServiceRunning(configuration, Collections.singleton("annotationService"));
        if (servicesRunning != null) {
            boolean annotationServiceRunning = servicesRunning.get("annotationService");
            CognosViewerDispatcherHandler.setAnnotationServiceEnabled(annotationServiceRunning);
        }
    }

    protected Map<String, Boolean> isServiceRunning(Configuration configuration, Set<String> serviceNames) {
        DispatcherList dispatcherList = (DispatcherList)configuration.getDispatcherList();
        HashMap<String, Boolean> serviceRunningMap = null;
        if (dispatcherList != null) {
            Iterator dispatchers = dispatcherList.getCompleteDispatcherListElements().iterator();
            serviceRunningMap = new HashMap<String, Boolean>();
            for (String serviceName : serviceNames) {
                serviceRunningMap.put(serviceName, Boolean.FALSE);
            }
            int undeterminedServiceCount = serviceRunningMap.size();
            while (dispatchers.hasNext() && undeterminedServiceCount > 0) {
                DispatcherListElement dispatcher = (DispatcherListElement)dispatchers.next();
                if (!dispatcher.isAvailable()) continue;
                Iterator services = dispatcher.iterator();
                while (services.hasNext() && undeterminedServiceCount > 0) {
                    Object o = services.next();
                    if (!(o instanceof DispatcherListService)) continue;
                    DispatcherListService service = (DispatcherListService)o;
                    String serviceName = service.getName();
                    String componentID = service.getComponentID();
                    if (service.getDisabled()) continue;
                    String key = serviceName;
                    Boolean enabled = (Boolean)serviceRunningMap.get(key);
                    if (enabled == null) {
                        key = componentID;
                        enabled = (Boolean)serviceRunningMap.get(key);
                    }
                    if (enabled == null || enabled.booleanValue()) continue;
                    serviceRunningMap.put(key, Boolean.TRUE);
                    --undeterminedServiceCount;
                }
            }
        }
        return serviceRunningMap;
    }

    private synchronized void setRuntimeConfiguration(ICCLConfiguration cclConfiguration) throws Exception {
        this.m_metadataInformationURI = cclConfiguration.getValue("metadataInformationURI", true);
        this.m_glossaryURI = cclConfiguration.getValue("glossaryURI", true);
        m_outputLocation = cclConfiguration.getValue("temporaryObjectLocation", true);
        this.m_bpmRestURI = cclConfiguration.getValue("bpmRestURI", true);
        this.processAdvancedSettings(cclConfiguration);
        CognosViewerDispatcherHandler.setVisCoachMode();
        CognosViewerDispatcherHandler.setAddLocalizeLabelsAction();
        String sServiceDefaultOptions = cclConfiguration.getValue("serviceDefaultOptions", true);
        m_sServiceDefaultAccessibility = CognosViewerDispatcherHandler.getAccessibilityOption(sServiceDefaultOptions);
        CognosViewerDispatcherHandler.setServiceDefaultFlashCharts(CognosViewerDispatcherHandler.getFlashChartOption(sServiceDefaultOptions));
        String sOverrideOptions = cclConfiguration.getValue("overrideOptions", true);
        m_sOverrideAccessibility = CognosViewerDispatcherHandler.getAccessibilityOption(sOverrideOptions);
        CognosViewerDispatcherHandler.setOverrideFlashCharts(CognosViewerDispatcherHandler.getFlashChartOption(sOverrideOptions));
        CognosViewerDispatcherHandler.setInteractivityEnabled();
        CognosViewerDispatcherHandler.setPageActionsEnabled();
    }

    public static void setInteractivityEnabled() {
        m_bSortEnabled = CognosViewerDispatcherHandler.getConfigValues().getBoolean("VIEWER_ENABLE_SORT");
        m_bExpandCollapseEnabled = CognosViewerDispatcherHandler.getConfigValues().getBoolean("VIEWER_JS_ENABLE_EXPAND_COLLAPSE");
        m_bInteractivityEnabled = m_bSortEnabled || m_bExpandCollapseEnabled;
    }

    public static boolean isInteractivityEnabled() {
        return m_bInteractivityEnabled;
    }

    public static boolean isExpandCollapseEnabled() {
        return m_bExpandCollapseEnabled;
    }

    public static boolean isSortEnabled(ICognosViewerState state) {
        return m_bSortEnabled && !"fragment".equals(state.getResponseFormat());
    }

    public static void setSortEnabled(boolean sortEnabled) {
        m_bSortEnabled = sortEnabled;
    }

    private static void setPageActionsEnabled() {
        m_bPageActionEnabled = CognosViewerDispatcherHandler.getConfigValues().getProperty("VIEWER_PAGING") != null;
    }

    public static boolean isPageActionsEnabled() {
        return m_bPageActionEnabled;
    }

    private static String getFlashChartOption(String sOptions) {
        return CognosViewerDispatcherHandler.getOptions(sOptions, "*[local-name()='value']/*[local-name()='value']/*[local-name()='item' and ./*[local-name()='name'] = 'http://developer.cognos.com/ceba/constants/systemOptionEnum#flashCharts']/*[local-name()='value']");
    }

    private static String getAccessibilityOption(String sOptions) {
        return CognosViewerDispatcherHandler.getOptions(sOptions, "*[local-name()='value']/*[local-name()='value']/*[local-name()='item' and ./*[local-name()='name'] = 'http://developer.cognos.com/ceba/constants/systemOptionEnum#accessibilityFeatures']/*[local-name()='value']");
    }

    private static String getOptions(String sOptions, String sOptionNodeXpath) {
        String sReturn = "";
        if (sOptions != null && sOptions.length() > 0) {
            try {
                boolean bFoundTrue = false;
                boolean bFoundFalse = false;
                Document document = XMLUtility.createXMLDocument(sOptions);
                List accessibilityOption = document.selectNodes(sOptionNodeXpath);
                for (int iIndex = 0; iIndex < accessibilityOption.size(); ++iIndex) {
                    Element option = (Element)accessibilityOption.get(iIndex);
                    if ("true".equals(option.getText())) {
                        bFoundTrue = true;
                        continue;
                    }
                    if (!"false".equals(option.getText())) continue;
                    bFoundFalse = true;
                }
                if (bFoundTrue && bFoundFalse) {
                    return "";
                }
                if (bFoundTrue) {
                    return "true";
                }
                if (bFoundFalse) {
                    return "false";
                }
            }
            catch (Exception ex) {
                IPFLogger.getInstance().debug("Error parsing serviceDefaultOptions option", "CognosViewerDispatcherHandler");
            }
        }
        return sReturn;
    }

    public void initialize(ICCLConfiguration cclConfiguration) throws Exception {
        dispatcherURI = cclConfiguration.getValue("internalDispatcher", true);
        String cmURL = cclConfiguration.getValue("contentManager", true);
        this.initializeFactories(dispatcherURI, cmURL, "ReportServerRequest", "CMServerRequest", "DeliveryServiceRequest", "PowerPlayServerRequest", "CMCacheServerRequest", "AnnotationServiceRequest");
        this.initViewerCachedStateObj();
        m_sGateway = cclConfiguration.getValue("gateway", true);
        this.processAdvancedProperties(cclConfiguration);
        ConfigMgr ccsCfgMgr = ConfigMgr.getInstance();
        if (ccsCfgMgr != null) {
            ccsCfgMgr.populateConfig(cclConfiguration);
        }
    }

    public void initViewerCachedStateObj() {
        this.m_cognosViewerCachedState = new CognosViewerCachedState(this.m_serviceFactory);
    }

    private void processAdvancedProperties(ICCLConfiguration cclConfiguration) throws CCLConfigurationException {
        Element cmAdvancedProperties = cclConfiguration.getValueElement("advancedProperties", false);
        if (cmAdvancedProperties != null) {
            this.processGoDBCompatibilityModeProperty(cmAdvancedProperties);
        }
    }

    private void processAdvancedSettings(ICCLConfiguration cclConfiguration) throws CCLConfigurationException {
        Document document;
        String advancedSettingsText;
        Element advancedSettings = cclConfiguration.getValueElement("advancedSettings", false);
        CognosViewerDispatcherHandler.clearViewerAdvancedProperties();
        if (advancedSettings != null && (advancedSettingsText = advancedSettings.getTextTrim()).length() > 0 && (document = XMLUtility.createXMLDocument(advancedSettingsText)) != null) {
            String[] advancedSettingsArray = new String[]{"ViewerPrimaryWaitThreshold", "ViewerSecondaryWaitThreshold", "restoreOldDrillChartBehavior", "useAlternateErrorCodeRendering", "enableVisCoach", "enableSavedOutputToolbarPrint", "DISP.zipi.enabled", "CWZipiVerboseMode"};
            List<String> advancedSettingsList = Arrays.asList(advancedSettingsArray);
            Element advancedSettingsDoc = document.getRootElement();
            for (String advSetting : advancedSettingsList) {
                this.addAdvancedSettingToConfigValues(advancedSettingsDoc, advSetting);
            }
            CognosViewerDispatcherHandler.addViewerAdvancedProperties(advancedSettingsDoc);
            String mashupProxySettings = this.getAdvancedSetting(advancedSettingsDoc, "VIEWER_WIDGET_PROXY_CONTEXT_ROOT");
            if (mashupProxySettings.length() > 0) {
                String[] aMashupProxy = mashupProxySettings.split(",");
                int proxyLength = aMashupProxy.length;
                for (int i = 0; i < proxyLength; ++i) {
                    String proxySetting = aMashupProxy[i].trim();
                    URLValidator.addProxyPrefix(proxySetting);
                }
            }
            if (m_configValues.containsKey("enableVisCoach") && "false".equals(m_configValues.getProperty("enableVisCoach"))) {
                m_configValues.put("VIEWER_JS_enableVisCoach", "false");
            }
            RAPConfigProperties.initialize(m_configValues);
            CognosViewerDispatcherHandler.genConfigJSONString();
        }
    }

    public static String getConfigJSONString() {
        return m_configJSON;
    }

    private static void genConfigJSONString() {
        StringBuilder sbAdvancedProperties = new StringBuilder(128);
        JSONObject advancedProperties = new JSONObject(sbAdvancedProperties);
        PropertySet configProperties = CognosViewerDispatcherHandler.getConfigValues();
        String passPortletToolbarSettingOnDrillThrough = (String)configProperties.get("VIEWER_PASS_PORTLET_TOOLBAR_STATE_ON_DRILLTHROUGH");
        if (passPortletToolbarSettingOnDrillThrough != null) {
            advancedProperties.addMember("VIEWER_PASS_PORTLET_TOOLBAR_STATE_ON_DRILLTHROUGH", passPortletToolbarSettingOnDrillThrough.equalsIgnoreCase("true"), false);
        }
        for (Map.Entry<Object, Object> entry : configProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("VIEWER_JS")) continue;
            advancedProperties.addMember(key, ((String)configProperties.get(key)).toLowerCase(), true, true);
        }
        m_configJSON = sbAdvancedProperties.length() > 0 ? "{" + sbAdvancedProperties.toString() + "}" : "";
    }

    private String getAdvancedSetting(Element advancedSettings, String propName) {
        String xpath = "./setting[@name='" + propName + "']";
        Element node = (Element)advancedSettings.selectSingleNode(xpath);
        if (null != node) {
            return node.getTextTrim();
        }
        return "";
    }

    private static void clearViewerAdvancedProperties() {
        PropertySet configProperties = CognosViewerDispatcherHandler.getConfigValues();
        Iterator<Object> it = configProperties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith("VIEWER_")) continue;
            it.remove();
        }
    }

    private static void addViewerAdvancedProperties(Element advancedSettings) {
        List settings = com.cognos.rap.utility.XMLUtility.selectNodes(advancedSettings, "./setting");
        for (Element setting : settings) {
            String name;
            if (setting == null || (name = setting.attributeValue("name")) == null || !name.startsWith("VIEWER_")) continue;
            m_configValues.setProperty(name, setting.getTextTrim());
        }
    }

    private void addAdvancedSettingToConfigValues(Element advancedSettings, String propName) {
        String xpath = "./setting[@name='" + propName + "']";
        Element node = (Element)advancedSettings.selectSingleNode(xpath);
        if (null != node) {
            m_configValues.setProperty(propName, node.getTextTrim());
        } else {
            m_configValues.remove(propName);
        }
    }

    private void processGoDBCompatibilityModeProperty(Element cmAdvancedProperties) {
        String dbCompatModeXPath = "./crn:parameter[@name='GoDBCompatMode']/crn:value";
        Element compactModeNode = (Element)cmAdvancedProperties.selectSingleNode(dbCompatModeXPath);
        if (null != compactModeNode && compactModeNode.getText().compareToIgnoreCase("true") == 0) {
            CognosViewerDispatcherHandler.setGoDBCompatMode(true);
        } else {
            CognosViewerDispatcherHandler.setGoDBCompatMode(false);
        }
    }

    public void initializeFactories(String sInternalDispatcher, String sCMURL, String sReportServiceClass, String sContentManagerServiceClass, String sDeliveryServiceClass, String sPowerPlayServiceClass, String sCMCacheServerClass, String sAnnotationServiceClass) throws Exception {
        this.m_serviceFactory = new CognosViewerServiceFactory(sInternalDispatcher, sCMURL);
        this.m_serviceFactory.setService(CognosViewerServiceFactory.REPORTSERVICEREQUEST, sReportServiceClass);
        this.m_serviceFactory.setService(CognosViewerServiceFactory.CMSERVICEREQUEST, sContentManagerServiceClass);
        this.m_serviceFactory.setService(CognosViewerServiceFactory.DELIVERYSERVICEREQUEST, sDeliveryServiceClass);
        this.m_serviceFactory.setService(CognosViewerServiceFactory.POWERPLAYSERVICEREQUEST, sPowerPlayServiceClass);
        this.m_serviceFactory.setService(CognosViewerServiceFactory.CMCACHESERVICEREQUEST, sCMCacheServerClass);
        this.m_serviceFactory.setService(CognosViewerServiceFactory.ANNOTATIONSERVICEREQUEST, sAnnotationServiceClass);
        this.m_actionFactory = new ActionFactory(this.m_serviceFactory);
        this.m_outputFactory = new OutputFactory();
    }

    public CognosViewerServiceFactory getServiceFactory() {
        return this.m_serviceFactory;
    }

    public OutputFactory getOutputFactory() {
        return this.m_outputFactory;
    }

    public ActionFactory getactionFactory() {
        return this.m_actionFactory;
    }

    public CognosViewerCachedState getCognosViewerCachedState() {
        return this.m_cognosViewerCachedState;
    }

    public void initializeSystemFile() throws IOException {
        Document doc;
        File mainSystemFile = new File(CCLConfigurationFactory.getInstance().resolveEffectivePath("../templates/ps/system.xml"));
        File portalSystemFile = new File(CCLConfigurationFactory.getInstance().resolveEffectivePath("../templates/ps/portal/system.xml"));
        File qsSystemFile = new File(CCLConfigurationFactory.getInstance().resolveEffectivePath("../templates/ps/async/system.xml"));
        Element mainSystemElement = null;
        Element portalSystemElement = null;
        Element qsSystemElement = null;
        CognosViewerSystemParams params = new CognosViewerSystemParams();
        try {
            doc = XMLUtility.createXMLDocument(mainSystemFile);
            mainSystemElement = doc.getRootElement();
            mainSystemElement = CognosViewerDispatcherHandler.trimComment(mainSystemElement);
            params.initialize(mainSystemElement);
            CognosViewerBlacklist.initViewerBlacklist(mainSystemElement);
        }
        catch (Exception e) {
            IPFLogger.getInstance().error("Caught exception in initializeSystemFile: " + e.getMessage(), CognosViewerDispatcherHandler.class.getName());
        }
        try {
            doc = XMLUtility.createXMLDocument(portalSystemFile);
            portalSystemElement = doc.getRootElement();
            portalSystemElement = CognosViewerDispatcherHandler.trimComment(portalSystemElement);
            params.initialize(portalSystemElement);
            CognosViewerBlacklist.initViewerBlacklist(portalSystemElement);
        }
        catch (Exception e) {
            IPFLogger.getInstance().error("Caught exception in initializeSystemFile: " + e.getMessage(), CognosViewerDispatcherHandler.class.getName());
        }
        try {
            doc = XMLUtility.createXMLDocument(qsSystemFile);
            qsSystemElement = doc.getRootElement();
            qsSystemElement = CognosViewerDispatcherHandler.trimComment(qsSystemElement);
            params.initialize(qsSystemElement);
        }
        catch (Exception e) {
            IPFLogger.getInstance().warn("Caught exception in initializeSystemFile: " + e.getMessage(), CognosViewerDispatcherHandler.class.getName());
        }
    }

    public static Element trimComment(Element oEle) {
        int size = oEle.nodeCount();
        int i = 0;
        while (i < size) {
            Node node = oEle.node(i);
            if (node instanceof Comment) {
                node.detach();
            } else if (node instanceof Element) {
                CognosViewerDispatcherHandler.trimComment((Element)node);
                ++i;
            } else {
                ++i;
            }
            size = oEle.nodeCount();
        }
        return oEle;
    }

    public static PropertySet getConfigValues() {
        return m_configValues;
    }

    public static void setConfigValues(PropertySet configValues) {
        m_configValues = configValues;
        CognosViewerDispatcherHandler.genConfigJSONString();
    }

    public static String getGateway() {
        if (m_sGateway == null) {
            return "";
        }
        return m_sGateway;
    }

    public static void setGateway(String sGateway) {
        m_sGateway = sGateway;
    }

    public static boolean isCMCacheServiceEnabled() {
        return m_bCMCacheServiceEnabled;
    }

    public static void setCMCacheServiceEnabled(boolean enabled) {
        m_bCMCacheServiceEnabled = enabled;
    }

    public static boolean isAnnotationServiceEnabled() {
        return m_bAnnotationServiceEnabled;
    }

    public static void setAnnotationServiceEnabled(boolean enabled) {
        m_bAnnotationServiceEnabled = enabled;
    }

    public static String getServiceDefaultAccessibility() {
        return m_sServiceDefaultAccessibility;
    }

    public static void setServiceDefaultAccessibility(String sServiceDefaultAccessibility) {
        m_sServiceDefaultAccessibility = sServiceDefaultAccessibility;
    }

    public static String getOverrideAccessibility() {
        return m_sOverrideAccessibility;
    }

    public static void setOverrideAccessibility(String sOverrideAccessibility) {
        m_sOverrideAccessibility = sOverrideAccessibility;
    }

    public static void setServiceDefaultFlashCharts(String sServiceDefaultFlashCharts) {
        m_sServiceDefaultFlashCharts = sServiceDefaultFlashCharts;
    }

    public static String getServiceDefaultFlashCharts() {
        return m_sServiceDefaultFlashCharts;
    }

    public static void setOverrideFlashCharts(String sOverrideFlashCharts) {
        m_sOverrideFlashCharts = sOverrideFlashCharts;
    }

    public static String getOverrideFlashCharts() {
        return m_sOverrideFlashCharts;
    }

    public static void setGoDBCompatMode(boolean bGoDBCompatMode) {
        m_bGoDBCompatMode = bGoDBCompatMode;
    }

    public static boolean getGoDBCompatMode() {
        return m_bGoDBCompatMode;
    }

    public static int getVisCoachMode() {
        if (m_viscoachMode == -1) {
            CognosViewerDispatcherHandler.setVisCoachMode();
        }
        return m_viscoachMode;
    }

    private static void setVisCoachMode() {
        m_viscoachMode = -1;
        if (CognosViewerDispatcherHandler.getConfigValues() != null && CognosViewerDispatcherHandler.getConfigValues().getProperty("enableVisCoach") != null) {
            String sVCMode = CognosViewerDispatcherHandler.getConfigValues().getProperty("enableVisCoach");
            if (sVCMode.compareToIgnoreCase("false") == 0 || sVCMode.compareToIgnoreCase("0") == 0) {
                m_viscoachMode = 0;
            } else if (sVCMode.compareToIgnoreCase("1") == 0) {
                m_viscoachMode = 1;
            } else if (sVCMode.compareToIgnoreCase("2") == 0) {
                m_viscoachMode = 2;
            } else if (sVCMode.compareToIgnoreCase("true") == 0 || sVCMode.compareToIgnoreCase("3") == 0) {
                m_viscoachMode = 3;
            }
        }
        if (m_viscoachMode == -1) {
            m_viscoachMode = 3;
        }
    }

    public static boolean isAddLocalizeLabelsAction() {
        return m_addLocalizeLabelsAction;
    }

    public static void setAddLocalizeLabelsAction() {
        m_addLocalizeLabelsAction = !"false".equalsIgnoreCase(CognosViewerDispatcherHandler.getConfigValues().getProperty("VIEWER_TO_LOCALIZE_LABEL"));
    }

    public static boolean getUseCachedSavedOutputDisabled() {
        return CognosViewerDispatcherHandler.getConfigValues() != null && CognosViewerDispatcherHandler.getConfigValues().containsKey("VIEWER_USE_SAVED_OUTPUT_CACHE_DISABLED") && CognosViewerDispatcherHandler.getConfigValues().getProperty("VIEWER_USE_SAVED_OUTPUT_CACHE_DISABLED").equals("true");
    }

    public static boolean useRestAPI() {
        boolean isCMRestAPIEnabled = true;
        PropertySet values = CognosViewerDispatcherHandler.getConfigValues();
        if (values != null) {
            isCMRestAPIEnabled = !values.getBoolean("VIEWER_USE_REST_API_DISABLED", false);
        }
        return isCMRestAPIEnabled;
    }

    public static ToolbarFactory getToolbarFactory() {
        return m_toolbarFactory;
    }

    public static String getBoundryValue() {
        if ("".equals(m_sBoundryValue)) {
            m_sBoundryValue = StringUtils.getUniqueValue();
        }
        return m_sBoundryValue;
    }

    public static void setBoundryValue(String valueBoundry) {
        m_sBoundryValue = valueBoundry;
    }

    public static String getOutputLocation(ICognosViewerState state) {
        if (state.getFormFieldAsString("m_session").length() > 0 || state.getFormFieldAsString("frag-id").length() > 0 || "fragment".equals(state.getFormFieldAsString("cv.responseFormat"))) {
            return "http://developer.cognos.com/ceba/constants/temporaryObjectLocationEnum#contentStore";
        }
        return m_outputLocation;
    }

    public static void setOutputLocation(String outputLocation) {
        m_outputLocation = outputLocation;
    }

    public String getMetadataInformationURI() {
        return this.m_metadataInformationURI;
    }

    public String getGlossaryURI() {
        return this.m_glossaryURI;
    }

    public String getBPMRestURI() {
        return this.m_bpmRestURI;
    }

    public static String getDispatcherURI() {
        return dispatcherURI;
    }

    public void stop() {
        super.stop();
        DebugLogger.closeTraceOutputStream();
    }

    protected ZipiTimer startZipiTimer(CognosViewerDispatcherHandlerState state) {
        return ZIPIUtility.getInstance().doZIPI(state, null, true);
    }

    static {
        compressibleMimeTypes.add("application/atom+xml");
        compressibleMimeTypes.add("application/javascript");
        compressibleMimeTypes.add("application/json");
        compressibleMimeTypes.add("application/rss+xml");
        compressibleMimeTypes.add("application/xhtml+xml");
        compressibleMimeTypes.add("application/x-javascript");
        compressibleMimeTypes.add("application/xml");
        compressibleMimeTypes.add("text/css");
        compressibleMimeTypes.add("text/html");
        compressibleMimeTypes.add("text/javascript");
        compressibleMimeTypes.add("text/plain");
        compressibleMimeTypes.add("text/xml");
        formatCapabilities = new HashMap();
        formatCapabilities.put("PDF", "canGeneratePDFOutput");
        formatCapabilities.put("XML", "canGenerateXMLOutput");
        formatCapabilities.put("CSV", "canGenerateCSVOutput");
        formatCapabilities.put("xlsxData", "canGenerateXLSOutput");
        formatCapabilities.put("spreadsheetML", "canGenerateXLSOutput");
        formatCapabilities.put("XLWA", "canGenerateXLSOutput");
    }
}

