/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.controller;

import com.cognos.ccs.exceptions.CCSAnnAuthenticationException;
import com.cognos.pogo.bibus.BIBusCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.viewer.model.Capabilities;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class CognosViewerException
extends Exception {
    protected static final Namespace NS_SOAP_ENV = Namespace.get((String)"SOAP-ENV", (String)"http://schemas.xmlsoap.org/soap/envelope/");
    protected static final QName BUS_MESSAGE = new QName("message", BIBusCommand.BUS_NAMESPACE);
    protected static final QName SOAP_ENV_DETAIL = DocumentHelper.createQName((String)"detail", (Namespace)NS_SOAP_ENV);
    protected static final QName BUS_SEVERITY = new QName("severity", BIBusCommand.BUS_NAMESPACE);
    protected static final QName BUS_ERROR_CODE = new QName("errorCode", BIBusCommand.BUS_NAMESPACE);
    protected static final QName BUS_MESSAGE_STRING = new QName("messageString", BIBusCommand.BUS_NAMESPACE);
    protected static final QName BUS_NESTING_LEVEL = new QName("nestingLevel", BIBusCommand.BUS_NAMESPACE);
    public static final QName BUS_ALLOW_RETRY = new QName("allowRetry", BIBusCommand.BUS_NAMESPACE);
    public static final long serialVersionUID = 1538200607134L;
    protected BIBusEnvelope m_faultEnvelope = null;
    protected String m_sErrorMessage = "";
    protected String m_failureDetail = "";

    public CognosViewerException(BIBusEnvelope faultEnvelope) {
        this.m_faultEnvelope = faultEnvelope;
    }

    public CognosViewerException(BIBusEnvelope faultEnvelope, String sErrorMessage, Exception exception) {
        this.m_sErrorMessage = sErrorMessage;
        if ((this.m_sErrorMessage == null || this.m_sErrorMessage.trim().length() == 0) && exception != null) {
            this.m_sErrorMessage = exception.toString();
        }
        this.m_faultEnvelope = faultEnvelope;
        if (faultEnvelope != null) {
            faultEnvelope.setCAFSecureState("");
            Element faultDetail = this.createFaultDetail(this.m_sErrorMessage, exception);
            faultEnvelope.createFaultElement("SOAP-ENV:Client", "Client Error", faultDetail);
        }
        this.initCause(exception);
    }

    public CognosViewerException(BIBusEnvelope faultEnvelope, String sErrorMessage, Exception exception, String failureDetail) {
        this.m_sErrorMessage = sErrorMessage;
        this.m_faultEnvelope = faultEnvelope;
        if (faultEnvelope != null) {
            faultEnvelope.setCAFSecureState("");
            Element faultDetail = this.createFaultDetail(sErrorMessage, exception);
            faultEnvelope.createFaultElement("SOAP-ENV:Client", "Client Error", faultDetail);
        }
        this.m_failureDetail = failureDetail;
        this.initCause(exception);
    }

    public CognosViewerException(BIBusEnvelope faultEnvelope, CCSAnnAuthenticationException authenticationException) {
        this.m_sErrorMessage = authenticationException.getServerLocaleMessage();
        this.m_faultEnvelope = faultEnvelope;
        Element faultDetail = this.createFaultDetail(this.m_sErrorMessage, (Exception)authenticationException);
        this.m_faultEnvelope.createFaultElement("SOAP-ENV:Client", "Client Error", faultDetail);
        Element camException = authenticationException.getCAMException();
        if (camException != null) {
            Element promptInfo;
            Element camElement = DocumentHelper.createElement((QName)new QName("CAM", BIBusCommand.BUS_NAMESPACE));
            Element errorCodeString = camException.element("errorCodeString");
            if (errorCodeString != null) {
                camElement.add(errorCodeString.detach());
            }
            if ((promptInfo = camException.element("promptInfo")) != null) {
                camElement.add(promptInfo.detach());
            }
            this.m_faultEnvelope.setCAM(camElement);
        }
        this.initCause((Throwable)authenticationException);
    }

    @Override
    public String getMessage() {
        return this.m_sErrorMessage;
    }

    public String getFailureDetail() {
        return this.m_failureDetail;
    }

    public BIBusEnvelope getFaultEnvelope() {
        return this.m_faultEnvelope;
    }

    public Element createFaultDetail(String sErrorMessage, Exception exception) {
        Element faultDetail = DocumentHelper.createElement((QName)SOAP_ENV_DETAIL);
        Element busException = faultDetail.addElement(BIBusEnvelope.BUS_EXCEPTION);
        Element busSeverity = busException.addElement(BUS_SEVERITY);
        busSeverity.setText("Error");
        Element busErrorCode = busException.addElement(BUS_ERROR_CODE);
        busErrorCode.setText("0");
        Element busMessage = busException.addElement(BUS_MESSAGE);
        Element busMessageString = busMessage.addElement(BUS_MESSAGE_STRING);
        busMessageString.setText(sErrorMessage);
        Element busNestingLevel = busMessage.addElement(BUS_NESTING_LEVEL);
        busNestingLevel.setText("0");
        if (exception != null) {
            Element detailedErrors = this.getDetailedError(exception);
            if (this.canShowDetailedErrors()) {
                busException.add(detailedErrors);
            } else {
                this.m_failureDetail = faultDetail.asXML() + detailedErrors.asXML();
            }
        }
        return faultDetail;
    }

    private Element getDetailedError(Exception exception) {
        Element detailedError = DocumentHelper.createElement((QName)BUS_MESSAGE);
        Element busMessageString = detailedError.addElement(BUS_MESSAGE_STRING);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        exception.printStackTrace(new PrintStream(outStream));
        busMessageString.addText(outStream.toString());
        Element busNestingLevel = detailedError.addElement(BUS_NESTING_LEVEL);
        busNestingLevel.setText("1");
        return detailedError;
    }

    protected boolean canShowDetailedErrors() {
        if (this.m_faultEnvelope == null) {
            return false;
        }
        Capabilities capabilities = new Capabilities((Element)this.m_faultEnvelope.getBIBusHeader().selectSingleNode("*[local-name()='userCapabilityCache']"));
        return capabilities.hasCapability("canReceiveDetailedErrors");
    }

    protected void setRetryFlag(Element faultDetail, boolean retry) {
        Element retryElement = faultDetail.addElement(BUS_ALLOW_RETRY);
        retryElement.setText(Boolean.toString(retry));
    }

    public void setRetryFlag(boolean retry) {
        Element faultDetail;
        if (this.m_faultEnvelope != null && (faultDetail = this.m_faultEnvelope.getFaultDetail()) != null) {
            this.setRetryFlag(faultDetail, retry);
        }
    }
}

