/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.controller;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.rap.exceptions.ActionControllerException;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.MessageManager;
import com.cognos.viewer.utility.XMLUtility;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class CognosViewerRAPException
extends CognosViewerException {
    public static final long serialVersionUID = 1538200607134L;
    private Document m_actionDoc = null;
    private String m_actionSpec = null;
    private ICognosViewerState m_state = null;
    public static HashMap<String, String> ACTION_LABEL_MAP = new HashMap();

    public CognosViewerRAPException(ICognosViewerState state, Exception exception, String actionSpec) {
        super(state.getBusEnvelope());
        this.m_state = state;
        this.m_actionSpec = actionSpec;
        try {
            this.m_actionDoc = XMLUtility.createXMLDocument(this.m_actionSpec);
            this.createErrorMessage();
        }
        catch (Exception e) {
            this.m_sErrorMessage = MessageManager.convert("IDS_RAP_INVALID_REPORT_ACTIONS_DEFINED", CognosViewerDispatcherHandlerState.getProductLocale(this.m_state));
        }
        if ((this.m_sErrorMessage == null || this.m_sErrorMessage.trim().length() == 0) && exception != null) {
            this.m_sErrorMessage = exception.toString();
        }
        if (this.m_faultEnvelope != null) {
            this.m_faultEnvelope.setCAFSecureState("");
            Element faultDetail = this.createFaultDetail(this.m_sErrorMessage, exception);
            this.m_faultEnvelope.createFaultElement("SOAP-ENV:Client", "Client Error", faultDetail);
        }
        this.initCause(exception);
    }

    private void createErrorMessage() {
        List reportActions = this.m_actionDoc.getRootElement().elements();
        if (reportActions.size() > 0) {
            Element action = (Element)reportActions.get(0);
            String actionType = "reportAction".equals(action.getName()) ? action.attributeValue("name") : action.getName();
            if (actionType != null && "ChangeDataContainerType".equals(actionType)) {
                Element labelE = action.element("label");
                if (labelE == null) {
                    labelE = action.element("target");
                }
                this.m_sErrorMessage = MessageManager.convert("IDS_RAP_DISPLAY_TYPE_NOT_AVAILABLE", CognosViewerDispatcherHandlerState.getProductLocale(this.m_state), new Object[]{labelE.getText()});
            } else if (actionType != null) {
                String actionLabel = ACTION_LABEL_MAP.get(actionType);
                if (actionLabel != null) {
                    actionLabel = MessageManager.convert(actionLabel, CognosViewerDispatcherHandlerState.getProductLocale(this.m_state));
                }
                this.m_sErrorMessage = actionLabel == null || actionLabel.length() == 0 ? MessageManager.convert("IDS_RAP_ACTION_NOT_AVAILABLE", CognosViewerDispatcherHandlerState.getProductLocale(this.m_state)) : MessageManager.convert("IDS_RAP_ACTION_NOT_AVAILABLE_WITH_PARAM", CognosViewerDispatcherHandlerState.getProductLocale(this.m_state), new Object[]{actionLabel});
            }
        } else {
            this.m_sErrorMessage = MessageManager.convert("IDS_RAP_INVALID_REPORT_ACTIONS_DEFINED", CognosViewerDispatcherHandlerState.getProductLocale(this.m_state));
        }
    }

    @Override
    public Element createFaultDetail(String sErrorMessage, Exception exception) {
        Element faultDetail = DocumentHelper.createElement((QName)SOAP_ENV_DETAIL);
        Element busException = faultDetail.addElement(BIBusEnvelope.BUS_EXCEPTION);
        Element busSeverity = busException.addElement(BUS_SEVERITY);
        busSeverity.setText("Error");
        Element busErrorCode = busException.addElement(BUS_ERROR_CODE);
        busErrorCode.setText("0");
        Element busMessage = busException.addElement(BUS_MESSAGE);
        Element busMessageString = busMessage.addElement(BUS_MESSAGE_STRING);
        busMessageString.setText(sErrorMessage);
        Element busNestingLevel = busMessage.addElement(BUS_NESTING_LEVEL);
        busNestingLevel.setText("0");
        boolean canShowDetailedErrors = this.canShowDetailedErrors();
        if (!canShowDetailedErrors) {
            this.m_failureDetail = faultDetail.asXML();
        }
        if (exception != null) {
            this.setDetails(busException, canShowDetailedErrors, this.getDetailedError(exception));
        }
        if (this.m_actionSpec != null) {
            this.setDetails(busException, canShowDetailedErrors, this.getDetailedAction());
        }
        this.setRetryFlag(faultDetail, false);
        return faultDetail;
    }

    private void setDetails(Element busException, boolean canShowDetailedErrors, Element detail) {
        if (canShowDetailedErrors) {
            busException.add(detail);
        } else {
            this.m_failureDetail = this.m_failureDetail + detail.asXML();
        }
    }

    private Element getDetailedAction() {
        Element detailedAction = DocumentHelper.createElement((QName)BUS_MESSAGE);
        Element busMessageString = detailedAction.addElement(BUS_MESSAGE_STRING);
        busMessageString.addText("Detailed Action: \n" + this.m_actionDoc != null ? EncodingUtility.htmlencode(this.m_actionDoc.asXML()) : this.m_actionSpec);
        Element busNestingLevel = detailedAction.addElement(BUS_NESTING_LEVEL);
        busNestingLevel.setText("0");
        return detailedAction;
    }

    private Element getDetailedError(Exception exception) {
        Element detailedError = DocumentHelper.createElement((QName)BUS_MESSAGE);
        Element busMessageString = detailedError.addElement(BUS_MESSAGE_STRING);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        if (exception.getCause() != null && (exception.getClass() == ActionControllerException.class || exception.getClass() == ActionException.class)) {
            this.simplifyRAPStackTrace(exception.getCause(), outStream);
        } else {
            exception.printStackTrace(new PrintStream(outStream));
        }
        busMessageString.addText("========= Stack Information: ==========\n" + outStream.toString());
        Element busNestingLevel = detailedError.addElement(BUS_NESTING_LEVEL);
        busNestingLevel.setText("1");
        return detailedError;
    }

    private void simplifyRAPStackTrace(Throwable exception, ByteArrayOutputStream outStream) {
        StackTraceElement[] trace = exception.getStackTrace();
        for (int inputTraceIdx = 0; inputTraceIdx < trace.length; ++inputTraceIdx) {
            if (!trace[inputTraceIdx].getClassName().contains("ReportActionController")) continue;
            StackTraceElement[] newTrace = new StackTraceElement[inputTraceIdx];
            for (int outputTraceIdx = 0; outputTraceIdx < inputTraceIdx; ++outputTraceIdx) {
                newTrace[outputTraceIdx] = trace[outputTraceIdx];
            }
            exception.setStackTrace(newTrace);
            break;
        }
        exception.printStackTrace(new PrintStream(outStream));
    }

    static {
        ACTION_LABEL_MAP.put("DrillUp", "RV_DRILL_UP");
        ACTION_LABEL_MAP.put("DrillDown", "RV_DRILL_DOWN");
        ACTION_LABEL_MAP.put("Sort", "IDS_JS_SORT");
        ACTION_LABEL_MAP.put("Reorder", "IDS_JS_MOVE");
        ACTION_LABEL_MAP.put("Filter", "IDS_JS_FILTER");
        ACTION_LABEL_MAP.put("Rename", "IDS_JS_RENAME");
        ACTION_LABEL_MAP.put("Delete", "IDS_JS_DELETE");
        ACTION_LABEL_MAP.put("GroupColumn", "IDS_JS_GROUP_UNGROUP");
        ACTION_LABEL_MAP.put("ChangePalette", "IDS_JS_CHANGE_PALETTE");
        ACTION_LABEL_MAP.put("Addition", "IDS_JS_ADDITION");
        ACTION_LABEL_MAP.put("Division", "IDS_JS_DIVISION");
        ACTION_LABEL_MAP.put("Multiplication", "IDS_JS_MULTIPLICATION");
        ACTION_LABEL_MAP.put("Subtraction", "IDS_JS_SUBTRACTION");
        ACTION_LABEL_MAP.put("PercentDifference", "IDS_JS_PERCENT_DIFFERENCE");
    }
}

