/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.controller.expeditor;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.NameValuePair;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.controller.expeditor.DelayedOutput;
import com.cognos.viewer.controller.expeditor.DelayedOutputsCleanupThread;
import com.cognos.viewer.controller.expeditor.DelegateCognosViewerExpeditor;
import com.cognos.viewer.model.AsyncResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.iWidget.IWidgetItemSet;
import com.cognos.viewer.utility.DebugLogger;
import com.cognos.viewer.utility.ZIPIUtility;
import com.cognos.viewer.view.ICognosViewerOutputResponse;
import com.cognos.viewer.view.OutputResponseHelper;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CognosViewerExpeditorDispatcherHandler
extends CognosViewerDispatcherHandler {
    private static ConcurrentHashMap<String, DelayedOutput> _delayedOutputs = new ConcurrentHashMap();
    private static ThreadPoolExecutor _threadPool = null;
    private static LinkedBlockingQueue<Runnable> _queue = new LinkedBlockingQueue();
    private static DelayedOutputsCleanupThread _outputsCleanupThread = new DelayedOutputsCleanupThread();

    @Override
    public void invokeImpl(MessageContext messageContext) {
        DebugLogger.logTrace("CVX handler called ");
        BIBusEnvelope biBusEnvelope = (BIBusEnvelope)messageContext.getProperty("request.envelope");
        if ("false".equals(biBusEnvelope.getFormValue("cv.waitForResponse"))) {
            biBusEnvelope.removeFormValue("cv.waitForResponse");
            DelegateCognosViewerExpeditor delegate = new DelegateCognosViewerExpeditor(this, messageContext);
            _threadPool.execute(delegate);
        } else {
            super.invokeImpl(messageContext);
        }
        DebugLogger.logTrace("CVX handler finished ");
    }

    @Override
    protected void preProcessMessageContext(MessageContext messageContext) throws CognosViewerException {
        DebugLogger.logTrace("preProcessMessageContext function called ");
        BIBusEnvelope biBusEnvelope = (BIBusEnvelope)messageContext.getProperty("request.envelope");
        boolean widgetItemSet = "true".equals(biBusEnvelope.getFormValue("widget.itemSet"));
        this.initDelayedOutput(biBusEnvelope);
        try {
            if (widgetItemSet) {
                IWidgetItemSet.processItemSet(biBusEnvelope);
            }
        }
        catch (IOException exception) {
            throw this.createCognosViewerException(messageContext, exception);
        }
        if (biBusEnvelope.getFormValue("cv.delayedKey") != null && biBusEnvelope.getFormValue("cv.outputKey") != null) {
            DebugLogger.logTrace("Input contained both cv.delayedKey and cv.outputKey", 2);
            biBusEnvelope.removeFormValue("cv.outputKey");
        }
        DebugLogger.logTrace("preProcessMessageContext function done ");
    }

    @Override
    public CognosViewerDispatcherHandlerState createDispatcherHandlerState(MessageContext messageContext) throws CognosViewerException {
        DebugLogger.logTrace("createDispatcherHandlerState function called ");
        BIBusEnvelope biBusEnvelope = (BIBusEnvelope)messageContext.getProperty("request.envelope");
        CognosViewerDispatcherHandlerState cognosViewerState = this.getDelayedState(messageContext, biBusEnvelope);
        if (cognosViewerState == null) {
            String key;
            DelayedOutput delayedOutput;
            cognosViewerState = super.createDispatcherHandlerState(messageContext);
            if (biBusEnvelope.getFormValue("cv.delayedKey") != null && (delayedOutput = _delayedOutputs.get(key = this.getOutputKey(biBusEnvelope))) != null) {
                delayedOutput.setState(cognosViewerState);
                cognosViewerState.setDelayedOutput(delayedOutput);
                DebugLogger.logTrace("createDispatcherHandlerState function saved state ", key);
            }
        } else {
            DebugLogger.logTrace("createDispatcherHandlerState function found cached state");
        }
        DebugLogger.logTrace("createDispatcherHandlerState function done ");
        return cognosViewerState;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CognosViewerDispatcherHandlerState getDelayedState(MessageContext messageContext, BIBusEnvelope biBusEnvelope) throws CognosViewerException {
        CognosViewerDispatcherHandlerState cognosViewerState;
        block18: {
            DebugLogger.logTrace("getDelayedState function called ");
            cognosViewerState = null;
            if (biBusEnvelope.getFormValue("cv.outputKey") != null) {
                String key = this.getOutputKey(biBusEnvelope);
                DebugLogger.logTrace("initOrGetDelayedOutput function returning cached output ", key);
                DelayedOutput delayedOutput = _delayedOutputs.get(key);
                String action = biBusEnvelope.getFormValue("ui.action");
                if (delayedOutput == null && !"wait".equals(action)) {
                    DebugLogger.logTrace("initOrGetDelayedOutput function asked to return delayedOutput but wasn't found in hash ", key, 3);
                    DelayedOutput newDealyedOutput = new DelayedOutput(key);
                    newDealyedOutput.setStatus(DelayedOutput.STATUS_CANCEL_THREAD);
                    DelayedOutput existingDelayedOutput = _delayedOutputs.putIfAbsent(key, newDealyedOutput);
                    if (existingDelayedOutput != null) {
                        delayedOutput = existingDelayedOutput;
                    } else {
                        biBusEnvelope.removeFormValue("cv.outputKey");
                    }
                }
                if (delayedOutput != null && !delayedOutput.isCancellingThread()) {
                    if ("cancel".equals(action) || "release".equals(action)) {
                        DebugLogger.logTrace("getDelayedState function cancelling/releasing request ", key);
                        delayedOutput.setStatus(DelayedOutput.STATUS_CANCELLED);
                        DebugLogger.logTrace("getDelayedState function done ");
                        return null;
                    }
                    try {
                        delayedOutput.lock(false);
                    }
                    catch (DelayedOutput.ThreadLockCognosViewerException e) {
                        biBusEnvelope.setFormField("lockFault", "true");
                        if (delayedOutput.getState() != null) {
                            biBusEnvelope.setFormField("cv.id", delayedOutput.getState().getFormFieldAsString("cv.id"));
                        }
                        DebugLogger.logTrace("getDelayedState function done ", delayedOutput.getKey());
                        return null;
                    }
                    if (_delayedOutputs.containsKey(key)) {
                        delayedOutput.incrementLifeCycle();
                        cognosViewerState = delayedOutput.getState();
                        if (cognosViewerState != null) {
                            this.writeJsonLogsToCM(cognosViewerState);
                            if (biBusEnvelope.getFormValue("cv.responseFormat") != null) {
                                cognosViewerState.setFormFieldFromString("cv.responseFormat", biBusEnvelope.getFormValue("cv.responseFormat"));
                            }
                            if (cognosViewerState.getDebugLogger().isDebugEnabled()) {
                                if (cognosViewerState.getFormFieldAsString("cv.debugDirectory").length() > 0) {
                                    biBusEnvelope.setFormField("cv.debugDirectory", cognosViewerState.getFormFieldAsString("cv.debugDirectory"));
                                }
                                cognosViewerState.getDebugLogger().setRunLocation(biBusEnvelope);
                                cognosViewerState.getDebugLogger().log(biBusEnvelope, "input.xml", true, "input");
                            }
                            if (delayedOutput.tryLockTimeExpired()) {
                                biBusEnvelope.setFormField("widget.reloadToolbar", "true");
                            }
                            this.mergeFormFields(messageContext, biBusEnvelope, cognosViewerState);
                            break block18;
                        } else {
                            DebugLogger.logTrace("getDelayedState function no state found on delayedOutput ", key, 1);
                            if (delayedOutput.getException() != null) {
                                throw delayedOutput.getException();
                            }
                            throw new CognosViewerException(biBusEnvelope, "No state object found for the requested output.", null);
                        }
                    }
                    if (!delayedOutput.isCancelled()) {
                        DebugLogger.logTrace("getDelayedState function delayedOutput removed from hash before lock could be done ", key, 2);
                        delayedOutput.unlock();
                    }
                }
            }
        }
        DebugLogger.logTrace("getDelayedState function done ");
        return cognosViewerState;
    }

    private void mergeFormFields(MessageContext messageContext, BIBusEnvelope biBusEnvelope, CognosViewerDispatcherHandlerState cognosViewerState) throws CognosViewerException {
        DebugLogger.logTrace("mergeFormFields function called ");
        cognosViewerState.validateParameters(messageContext);
        List formFieldVars = biBusEnvelope.getFormFieldValues();
        ListIterator iterator = formFieldVars.listIterator();
        while (iterator.hasNext()) {
            NameValuePair formFieldVar = (NameValuePair)iterator.next();
            String formFieldName = formFieldVar.getName();
            String formFieldValue = formFieldVar.getValue();
            if (formFieldValue.length() == 0 || cognosViewerState.getFormFieldAsString(formFieldName).length() != 0 || formFieldName.startsWith("_")) continue;
            cognosViewerState.setFormFieldFromString(formFieldName, formFieldValue);
        }
        DebugLogger.logTrace("mergeFormFields function done ");
    }

    private void initDelayedOutput(BIBusEnvelope biBusEnvelope) throws CognosViewerException {
        DebugLogger.logTrace("initOrGetDelayedOutput function called ");
        if (biBusEnvelope.getFormValue("cv.delayedKey") != null) {
            String key = this.getOutputKey(biBusEnvelope);
            DebugLogger.logTrace("initOrGetDelayedOutput function creating delayedOutput ", key);
            _outputsCleanupThread.startThread();
            DelayedOutput delayedOutput = new DelayedOutput(key);
            delayedOutput.lock(true);
            DelayedOutput existingDelayedOutput = _delayedOutputs.putIfAbsent(key, delayedOutput);
            if (existingDelayedOutput != null) {
                delayedOutput.unlock();
                if (existingDelayedOutput.isCancellingThread()) {
                    DebugLogger.logTrace("initOrGetDelayedOutput function report execution handled by iWidget http thread", key, 3);
                    DebugLogger.logTrace("Removed delayedOutput from hash ", key);
                    _delayedOutputs.remove(key);
                    throw new StopExecutionCognosViewerException(biBusEnvelope, "Report execution handled by another thread.", null);
                }
                CognosViewerExpeditorDispatcherHandler.logCacheInfo("duplicateKey", DebugLogger.getBaseDebugDirectory(biBusEnvelope));
                DebugLogger.logTrace("Duplicate key ", key, 2);
                throw new StopExecutionCognosViewerException(biBusEnvelope, "Duplicate key, report execution handled by another thread.", null);
            }
        }
        DebugLogger.logTrace("initOrGetDelayedOutput function done ");
    }

    @Override
    protected ICognosViewerActionResponse handleRequest(CognosViewerDispatcherHandlerState cognosViewerState) throws CognosViewerException {
        DebugLogger.logTrace("handleRequest function called ");
        ICognosViewerActionResponse response = null;
        DelayedOutput delayedOutput = cognosViewerState.getDelayedOutput();
        if (delayedOutput != null && delayedOutput.isGetDelayedOutput()) {
            DebugLogger.logTrace("handleRequest function delayedOutput in cache found ", delayedOutput.getKey());
            if (delayedOutput.getException() != null) {
                DebugLogger.logTrace("handleRequest function delayedOutput contained an expection ", delayedOutput.getKey(), 1);
                throw delayedOutput.getException();
            }
            response = delayedOutput.getActionResponse();
            if (cognosViewerState.getDebugLogger() != null && cognosViewerState.getDebugLogger().isDebugEnabled()) {
                cognosViewerState.getDebugLogger().log(response.getBusEnvelope(), "response.xml", true, "cachedResponse");
            }
            this.handleJUnitCachedOutput(response);
        } else if ("true".equals(cognosViewerState.getFormFieldAsString("lockFault"))) {
            DebugLogger.logTrace("handleRequest function thread lock fault detected, returning a 'working' response back to client. ", this.getOutputKey(cognosViewerState.getBusEnvelope()));
            cognosViewerState.removeFormField("lockFault");
            cognosViewerState.getBusEnvelope().removeFormValue("lockFault");
            response = new AsyncResponse(cognosViewerState, cognosViewerState.getBusEnvelope(), null);
            ((AsyncResponse)response).setStatus("working");
        } else {
            response = super.handleRequest(cognosViewerState);
        }
        DebugLogger.logTrace("handleRequest function done ");
        return response;
    }

    private void handleJUnitCachedOutput(ICognosViewerActionResponse cognosViewerActionResponse) {
        if (CognosViewerDispatcherHandlerState.isMasters()) {
            try {
                Class<?> junitClass = Class.forName("junit.masters.MasterTestHelper");
                Method method = junitClass.getDeclaredMethod("compareResponse", ICognosViewerActionResponse.class);
                method.invoke(null, cognosViewerActionResponse);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected ICognosViewerOutputResponse handleResponse(CognosViewerDispatcherHandlerState cognosViewerState, ICognosViewerActionResponse cognosViewerActionResponse) throws CognosViewerException {
        DebugLogger.logTrace("handleResponse function called ");
        DelayedOutput delayedOutput = cognosViewerState.getDelayedOutput();
        ICognosViewerOutputResponse output = null;
        if (delayedOutput != null && delayedOutput.isSavingDelayedOutput()) {
            DebugLogger.logTrace("handleResponse function saving delayedOutput ", delayedOutput.getKey());
            boolean debugLogs = cognosViewerState.getDebugLogger() != null && cognosViewerState.getDebugLogger().isDebugEnabled();
            delayedOutput.setActionResponse(cognosViewerActionResponse);
            boolean working = OutputResponseHelper.isWorking(cognosViewerActionResponse);
            if (!working) {
                delayedOutput.resetLifeCycle();
            }
            delayedOutput.setStatus(working ? DelayedOutput.STATUS_WORKING : DelayedOutput.STATUS_COMPLETE);
            if (debugLogs) {
                cognosViewerState.getDebugLogger().logXML(cognosViewerState.getStateInfo(cognosViewerActionResponse), "viewerState.xml", true, "state");
            }
            this.handleJUnitTesting(cognosViewerState, cognosViewerActionResponse);
            try {
                while (working && !delayedOutput.isCancelled()) {
                    delayedOutput.unlock();
                    DebugLogger.logTrace("handleResponse function status is working ", delayedOutput.getKey());
                    delayedOutput.lock(true);
                    if (debugLogs) {
                        cognosViewerState.getDebugLogger().setRunLocation(cognosViewerState.getBusEnvelope());
                    }
                    cognosViewerState.releaseConnections();
                    cognosViewerState.setFormFieldFromString("m_tracking", OutputResponseHelper.getTracking(cognosViewerActionResponse));
                    cognosViewerState.setFormFieldFromString("ui.action", "wait");
                    cognosViewerActionResponse = super.handleRequest(cognosViewerState);
                    delayedOutput.setActionResponse(cognosViewerActionResponse);
                    working = OutputResponseHelper.isWorking(cognosViewerActionResponse);
                    if (!working) {
                        delayedOutput.resetLifeCycle();
                        delayedOutput.setStatus(DelayedOutput.STATUS_COMPLETE);
                    }
                    if (debugLogs) {
                        cognosViewerState.getDebugLogger().logXML(cognosViewerState.getStateInfo(cognosViewerActionResponse), "viewerState.xml", true, "state");
                    }
                    DebugLogger.logTrace("handleResponse function got response from working request ", delayedOutput.getKey());
                }
            }
            catch (CognosViewerException e) {
                if (delayedOutput.isCancelled()) {
                    throw new StopExecutionCognosViewerException(cognosViewerState.getBusEnvelope(), "Report execution handled by another thread.", null);
                }
                DebugLogger.logTrace("handleResponse function fault from working loop ", delayedOutput.getKey(), 1);
                throw e;
            }
            if (delayedOutput.isCancelled()) {
                delayedOutput.unlock();
                throw new StopExecutionCognosViewerException(cognosViewerState.getBusEnvelope(), "Report execution handled by another thread.", null);
            }
            DebugLogger.logTrace("handleResponse function request complete ", delayedOutput.getKey());
        } else {
            DebugLogger.logTrace("handleResponse function iWidget http request ", delayedOutput == null ? "" : delayedOutput.getKey());
            output = super.handleResponse(cognosViewerState, cognosViewerActionResponse);
        }
        DebugLogger.logTrace("handleResponse function done ");
        return output;
    }

    @Override
    public void setMessageContextProperties(ICognosViewerOutputResponse cognosViewerOutputResponse, MessageContext messageContext, BIBusEnvelope requestEnvelope, CognosViewerDispatcherHandlerState state) throws Exception, PogoException {
        DebugLogger.logTrace("setMessageContextProperties function called");
        if (state.getDelayedOutput() == null) {
            super.setMessageContextProperties(cognosViewerOutputResponse, messageContext, requestEnvelope, state);
        } else {
            DebugLogger.logTraceDelayedOutput(state.getDelayedOutput());
            if (!state.getDelayedOutput().isSavingDelayedOutput()) {
                super.setMessageContextProperties(cognosViewerOutputResponse, messageContext, requestEnvelope, state);
            }
        }
        DebugLogger.logTrace("setMessageContextProperties function done");
    }

    @Override
    protected void handleConnectionCleanup(MessageContext messageContext, CognosViewerDispatcherHandlerState cognosViewerState) throws PogoException {
        DebugLogger.logTrace("handleConnectionCleanup function called");
        if (cognosViewerState != null) {
            if (cognosViewerState.getDelayedOutput() != null) {
                DelayedOutput delayedOutput = cognosViewerState.getDelayedOutput();
                DebugLogger.logTraceDelayedOutput(delayedOutput);
                if (delayedOutput.isDelayedOutputFinished()) {
                    DebugLogger.logTrace("handleConnectionCleanup function releasing connections");
                    super.handleConnectionCleanup(messageContext, cognosViewerState);
                }
            } else {
                DebugLogger.logTrace("handleConnectionCleanup function releasing connections");
                super.handleConnectionCleanup(messageContext, cognosViewerState);
            }
        }
        DebugLogger.logTrace("handleConnectionCleanup function done");
    }

    @Override
    public void handleException(CognosViewerDispatcherHandlerState cognosViewerState, CognosViewerException exception, MessageContext messageContext) {
        DebugLogger.logTrace("handleException function called");
        BIBusEnvelope biBusEnvelope = (BIBusEnvelope)messageContext.getProperty("request.envelope");
        if (exception instanceof StopExecutionCognosViewerException) {
            String key = this.getOutputKey(biBusEnvelope);
            if (cognosViewerState != null) {
                cognosViewerState.releaseConnections();
            }
            DebugLogger.logTrace("handleException function called with a cancel thread status. ", key, 2);
        } else if (exception instanceof DelayedOutput.ThreadLockCognosViewerException && biBusEnvelope.getFormValue("cv.outputKey") != null) {
            DelayedOutput delayedOutput;
            String key = this.getOutputKey(biBusEnvelope);
            DebugLogger.logTrace("handleException function called by a lock thread fault. ", key, 2);
            if (cognosViewerState == null && (delayedOutput = _delayedOutputs.get(key)) != null) {
                cognosViewerState = delayedOutput.getState();
                try {
                    this.mergeFormFields(messageContext, biBusEnvelope, cognosViewerState);
                }
                catch (CognosViewerException e) {
                    DebugLogger.logTraceException(e, biBusEnvelope);
                }
            }
            if (cognosViewerState != null) {
                cognosViewerState.releaseConnections();
            }
            super.handleException(cognosViewerState, exception, messageContext);
        } else {
            if (cognosViewerState != null) {
                DelayedOutput delayedOutput = cognosViewerState.getDelayedOutput();
                if (delayedOutput != null && delayedOutput.isSavingDelayedOutput()) {
                    delayedOutput.setException(exception);
                    delayedOutput.setStatus(DelayedOutput.STATUS_COMPLETE);
                    this.setFault(messageContext, exception.getFaultEnvelope(), exception, cognosViewerState);
                    DebugLogger.logTrace("handleException function done");
                    return;
                }
                cognosViewerState.releaseConnections();
            }
            if (cognosViewerState == null && biBusEnvelope.getFormValue("cv.delayedKey") != null) {
                String key = this.getOutputKey(biBusEnvelope);
                DebugLogger.logTrace("handleException function called with no state. Exception might have happened while building the state. ", key, 1);
                DelayedOutput delayedOutput = new DelayedOutput(key);
                delayedOutput.setStatus(DelayedOutput.STATUS_COMPLETE);
                delayedOutput.setException(exception);
                _delayedOutputs.put(key, delayedOutput);
                DebugLogger.logTrace("handleException function done");
                return;
            }
            super.handleException(cognosViewerState, exception, messageContext);
        }
        DebugLogger.logTrace("handleException function done");
    }

    private String getOutputKey(BIBusEnvelope biBusEnvelope) {
        if (biBusEnvelope.getFormValue("cv.delayedKey") != null) {
            return biBusEnvelope.getPassportID() + biBusEnvelope.getFormValue("cv.delayedKey");
        }
        if (biBusEnvelope.getFormValue("cv.outputKey") != null) {
            return biBusEnvelope.getPassportID() + biBusEnvelope.getFormValue("cv.outputKey");
        }
        return "";
    }

    @Override
    protected void finalCleanup(MessageContext messageContext, CognosViewerDispatcherHandlerState cognosViewerState, ICognosViewerActionResponse response) {
        DelayedOutput delayedOutput;
        String key;
        DebugLogger.logTrace("finalCleanup function called ");
        super.finalCleanup(messageContext, cognosViewerState, response);
        BIBusEnvelope biBusEnvelope = (BIBusEnvelope)messageContext.getProperty("request.envelope");
        if (biBusEnvelope != null && (key = this.getOutputKey(biBusEnvelope)).length() > 0 && (delayedOutput = _delayedOutputs.get(key)) != null) {
            DebugLogger.logTraceDelayedOutput(delayedOutput);
            if (delayedOutput.currentThreadHoldsLock()) {
                if (delayedOutput.isDelayedOutputFinished()) {
                    DebugLogger.logTrace("Removed delayedOutput from hash ", key);
                    _delayedOutputs.remove(key);
                }
                if (delayedOutput.isSavingDelayedOutput()) {
                    this.writeJsonLogsToCM(cognosViewerState);
                }
                delayedOutput.unlock();
            }
        }
        DebugLogger.logTrace("finalCleanup function done ");
    }

    public static ConcurrentHashMap<String, DelayedOutput> getDelayedOutput() {
        return _delayedOutputs;
    }

    public void start() {
        super.start();
        int maxThreads = Integer.MAX_VALUE;
        if (CognosViewerDispatcherHandler.getConfigValues().containsKey("maximumPoolSize")) {
            try {
                maxThreads = Integer.parseInt(CognosViewerDispatcherHandler.getConfigValues().getProperty("maximumPoolSize"));
                if (maxThreads < 1) {
                    maxThreads = Integer.MAX_VALUE;
                }
            }
            catch (NumberFormatException e) {
                maxThreads = Integer.MAX_VALUE;
            }
        }
        _threadPool = new ThreadPoolExecutor(10, maxThreads, 60L, TimeUnit.SECONDS, _queue);
        _threadPool.prestartAllCoreThreads();
    }

    @Override
    public void stop() {
        super.stop();
        _outputsCleanupThread.stopThread();
        _threadPool.shutdown();
        _threadPool.shutdownNow();
    }

    public static void logCacheInfo(String fileNamePostfix, String folderName) {
        if (DebugLogger.isDebugEnabledForAllUsers()) {
            ConcurrentHashMap<String, DelayedOutput> delayedOutputs = CognosViewerExpeditorDispatcherHandler.getDelayedOutput();
            StringBuilder debugInfo = null;
            for (String key : delayedOutputs.keySet()) {
                DelayedOutput delayedOutput;
                if (debugInfo == null) {
                    debugInfo = new StringBuilder("<delayedOutputs>");
                }
                if ((delayedOutput = delayedOutputs.get(key)) == null) continue;
                delayedOutput.debugInfo(debugInfo);
            }
            if (debugInfo != null) {
                debugInfo.append("</delayedOutputs>");
                DebugLogger.logXML(debugInfo.toString(), System.currentTimeMillis() + "_" + fileNamePostfix + ".xml", folderName);
            } else {
                DebugLogger.logXML("<delayedOutputs></delayedOutputs>", System.currentTimeMillis() + "_empty" + ".xml", folderName);
            }
        }
    }

    @Override
    protected ZipiTimer startZipiTimer(CognosViewerDispatcherHandlerState state) {
        if (ZIPIUtility.getInstance().isZIPIEnablded()) {
            boolean isMarkerSkipped = "cvx.high".equals(state.getFormFieldAsString("b_action")) && state.getFormFieldAsString("cv.outputKey") != null;
            return ZIPIUtility.getInstance().doZIPI(state, "bux", !isMarkerSkipped);
        }
        return null;
    }

    public class StopExecutionCognosViewerException
    extends CognosViewerException {
        public static final long serialVersionUID = 1538200607134L;

        public StopExecutionCognosViewerException(BIBusEnvelope faultEnvelope, String sErrorMessage, Exception exception) {
            super(faultEnvelope, sErrorMessage, exception);
        }
    }
}

