/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.controller.expeditor;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.utility.DebugLogger;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.MessageManager;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class DelayedOutput {
    public static String STATUS_NEW = "new";
    public static String STATUS_COMPLETE = "complete";
    public static String STATUS_WORKING = "working";
    public static String STATUS_CANCELLED = "cancelled";
    public static String STATUS_CANCEL_THREAD = "cancelThread";
    private CognosViewerDispatcherHandlerState _cognosViewerState = null;
    private ICognosViewerActionResponse _actionResponse = null;
    private CognosViewerException _exception = null;
    private String _status = STATUS_NEW;
    private AtomicBoolean _savingDelayedOutput = new AtomicBoolean(false);
    private String _key = null;
    private AtomicInteger _lifeCycle = null;
    private String _traceInfo = null;
    private boolean _tryLockTimeExpired = false;
    private ReentrantLock _lock = new ReentrantLock(true);

    public DelayedOutput(String key) {
        this._key = key;
        this._traceInfo = "object id: " + Integer.toString(this.hashCode()) + " key: " + key;
        this.resetLifeCycle();
    }

    public int getLifeCycle() {
        return this._lifeCycle.get();
    }

    public String getStatus() {
        return this._status;
    }

    public String getKey() {
        return this._key;
    }

    public boolean tryLockTimeExpired() {
        return this._tryLockTimeExpired;
    }

    public boolean isCancelled() {
        return STATUS_CANCELLED.equals(this._status);
    }

    public boolean isWorking() {
        return STATUS_WORKING.equals(this._status);
    }

    public boolean isComplete() {
        return STATUS_COMPLETE.equals(this._status);
    }

    public boolean isCancellingThread() {
        return STATUS_CANCEL_THREAD.equals(this._status);
    }

    public void setStatus(String status) {
        this._status = status;
    }

    public void incrementLifeCycle() {
        if (this._lifeCycle.get() < 6) {
            this._lifeCycle.incrementAndGet();
        }
    }

    public void resetLifeCycle() {
        if (CognosViewerDispatcherHandler.getConfigValues().containsKey("VIEWER_CACHE_LIFECYCLE")) {
            int lifeCycle = Integer.parseInt(CognosViewerDispatcherHandler.getConfigValues().getProperty("VIEWER_CACHE_LIFECYCLE"));
            this._lifeCycle = new AtomicInteger(lifeCycle);
        } else {
            this._lifeCycle = new AtomicInteger(2);
        }
    }

    public void lock(boolean savingDelayedOutput) throws ThreadLockCognosViewerException {
        DebugLogger.logTrace("lock function called ", this._traceInfo);
        if (!this._lock.isHeldByCurrentThread()) {
            try {
                int timeout = 120;
                if (CognosViewerDispatcherHandler.getConfigValues().containsKey("VIEWER_THREAD_LOCK_TIMEOUT")) {
                    try {
                        timeout = Integer.parseInt(CognosViewerDispatcherHandler.getConfigValues().getProperty("VIEWER_THREAD_LOCK_TIMEOUT"));
                        if (timeout < 1) {
                            timeout = 120;
                        }
                    }
                    catch (NumberFormatException e) {
                        timeout = 120;
                    }
                }
                if (this._lock.tryLock(timeout, TimeUnit.SECONDS)) {
                    this._savingDelayedOutput.set(savingDelayedOutput);
                    DebugLogger.logTrace("lock function done, lock succeeded ", this._traceInfo);
                    DebugLogger.logTraceDelayedOutput(this);
                    if (this._lock.getHoldCount() > 1) {
                        DebugLogger.logTrace("Hold lock > 1 ", this._traceInfo, 1);
                    }
                    return;
                }
            }
            catch (Exception e) {
                if (savingDelayedOutput) {
                    DebugLogger.logTraceException(e, null);
                    if (DebugLogger.isDebugEnabledForAllUsers()) {
                        StringBuilder debugInfo = new StringBuilder();
                        debugInfo.append("<fault>");
                        debugInfo.append("<delayedOutput>");
                        debugInfo.append("<key>" + this.getKey() + "</key>");
                        debugInfo.append("<fault>" + EncodingUtility.xmlencode(e.toString()) + "</fault>");
                        debugInfo.append("</delayedOutput>");
                        debugInfo.append("</fault>");
                        DebugLogger.logXML(debugInfo.toString(), System.currentTimeMillis() + ".xml", "delayedOutputLockFault");
                    }
                }
                DebugLogger.logTrace("Could not lock in time, RSVP hasn't replied yet.", 2);
            }
            this._tryLockTimeExpired = true;
            if (this._cognosViewerState != null) {
                throw new ThreadLockCognosViewerException(this._cognosViewerState.getBusEnvelope(), MessageManager.convert("RV_FAULT_THREAD_LOCK", CognosViewerDispatcherHandlerState.getProductLocale(this._cognosViewerState)), null);
            }
            throw new ThreadLockCognosViewerException(null, "CV-0013 Could not lock thread.", null);
        }
        DebugLogger.logTrace("lock function called, but current thread already has lock ", this._traceInfo, 1);
    }

    public void unlock() {
        DebugLogger.logTrace("unlock function called ", this._traceInfo);
        if (this._lock.isHeldByCurrentThread()) {
            this._savingDelayedOutput.set(false);
            try {
                this._lock.unlock();
                DebugLogger.logTrace("unlock function done. Unlock succeeded ", this._traceInfo);
            }
            catch (Exception e) {
                DebugLogger.logTraceException(e, null);
                if (DebugLogger.isDebugEnabledForAllUsers()) {
                    StringBuilder debugInfo = new StringBuilder();
                    debugInfo.append("<fault>");
                    debugInfo.append("<delayedOutput>");
                    debugInfo.append("<key>" + this.getKey() + "</key>");
                    debugInfo.append("<fault>" + EncodingUtility.xmlencode(e.toString()) + "</fault>");
                    debugInfo.append("</delayedOutput>");
                    debugInfo.append("</fault>");
                    DebugLogger.logXML(debugInfo.toString(), System.currentTimeMillis() + ".xml", "delayedOutputUnlockFault");
                }
            }
        } else {
            DebugLogger.logTrace("unlock function called on wrong thread ", this._traceInfo, 2);
        }
    }

    public boolean currentThreadHoldsLock() {
        return this._lock.isHeldByCurrentThread();
    }

    public boolean isSavingDelayedOutput() {
        return this._savingDelayedOutput.get();
    }

    public boolean isGetDelayedOutput() {
        return !this._savingDelayedOutput.get();
    }

    public boolean isDelayedOutputFinished() {
        return this.isGetDelayedOutput() && this.isComplete() || this.isCancelled() || this.isCancellingThread();
    }

    public boolean shouldCleanup() {
        if (this._lifeCycle.get() <= 0) {
            return true;
        }
        this._lifeCycle.decrementAndGet();
        return false;
    }

    public void setState(CognosViewerDispatcherHandlerState state) {
        this._cognosViewerState = state;
    }

    public CognosViewerDispatcherHandlerState getState() {
        return this._cognosViewerState;
    }

    public void setActionResponse(ICognosViewerActionResponse response) {
        this._actionResponse = response;
    }

    public ICognosViewerActionResponse getActionResponse() {
        return this._actionResponse;
    }

    public void setException(CognosViewerException exception) {
        this._exception = exception;
    }

    public CognosViewerException getException() {
        return this._exception;
    }

    public void debugInfo(StringBuilder debugInfo) {
        debugInfo.append("<delayedOutput>");
        debugInfo.append("<key>" + this.getKey() + "</key>");
        debugInfo.append("<lifeCycle>" + this.getLifeCycle() + "</lifeCycle>");
        debugInfo.append("<status>" + this.getStatus() + "</status>");
        debugInfo.append("<savingOutput>" + this._savingDelayedOutput.toString() + "</savingOutput>");
        String locked = "false";
        if (this._lock.tryLock()) {
            try {
                locked = "true";
            }
            finally {
                this._lock.unlock();
            }
        }
        debugInfo.append("<locked>" + locked + "</locked>");
        if (this.getState() != null) {
            debugInfo.append("<state>" + this.getState().getStateInfo(this.getActionResponse()) + "</state>");
        }
        debugInfo.append("</delayedOutput>");
    }

    public class ThreadLockCognosViewerException
    extends CognosViewerException {
        public static final long serialVersionUID = 1538200607134L;

        public ThreadLockCognosViewerException(BIBusEnvelope faultEnvelope, String sErrorMessage, Exception exception) {
            super(faultEnvelope, sErrorMessage, exception);
        }
    }
}

