/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.controller.expeditor;

import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.expeditor.CognosViewerExpeditorDispatcherHandler;
import com.cognos.viewer.controller.expeditor.DelayedOutput;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.utility.DebugLogger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class DelayedOutputsCleanupThread
implements Runnable {
    private AtomicBoolean _running = new AtomicBoolean(false);
    private static String _debugFolderName = "cleanupThread";
    private final int CLEANUP_INTERVAL = 30;

    public void startThread() {
        if (!this._running.getAndSet(true)) {
            Thread thread = new Thread(this);
            thread.start();
            if (DebugLogger.isDebugEnabledForAllUsers()) {
                DebugLogger.logXML("<started>true</started>", System.currentTimeMillis() + "cleanupThreadStarted" + ".xml", _debugFolderName);
            }
        }
    }

    public void stopThread() {
        this._running.set(false);
        DebugLogger.logXML("<started>false</started>", System.currentTimeMillis() + "cleanupThreadStopped" + ".xml", _debugFolderName);
    }

    @Override
    public void run() {
        ConcurrentHashMap<String, DelayedOutput> delayedOutputs = CognosViewerExpeditorDispatcherHandler.getDelayedOutput();
        int idleCount = 0;
        while (this._running.get()) {
            try {
                int threadSleepSec = 30;
                if (CognosViewerDispatcherHandler.getConfigValues().containsKey("VIEWER_CACHE_CLEANUP_INTERVAL")) {
                    try {
                        threadSleepSec = Integer.parseInt(CognosViewerDispatcherHandler.getConfigValues().getProperty("VIEWER_CACHE_CLEANUP_INTERVAL"));
                        if (threadSleepSec <= 0) {
                            threadSleepSec = 30;
                        }
                    }
                    catch (NumberFormatException e) {
                        threadSleepSec = 30;
                    }
                }
                Thread.sleep(threadSleepSec * 1000);
                if (delayedOutputs.size() == 0) {
                    if (++idleCount >= 10) {
                        this.stopThread();
                    }
                } else {
                    idleCount = 0;
                    for (String key : delayedOutputs.keySet()) {
                        DelayedOutput delayedOutput = delayedOutputs.get(key);
                        if (!delayedOutput.shouldCleanup()) continue;
                        CognosViewerDispatcherHandlerState state = delayedOutput.getState();
                        String traceInfo = "object id: " + Integer.toString(delayedOutput.hashCode()) + " key: " + key;
                        DebugLogger.logTrace("cleanupThread delayedOutput time has experied ", traceInfo, 2);
                        DebugLogger.logTraceDelayedOutput(delayedOutput);
                        if (state != null) {
                            String status = delayedOutput.getStatus();
                            if (state.isConnectionInUse() && (DelayedOutput.STATUS_NEW.equals(status) || DelayedOutput.STATUS_WORKING.equals(status))) {
                                DebugLogger.logTrace("cleanupThread increasing allowed time for delayedOutput ", traceInfo, 2);
                                delayedOutput.resetLifeCycle();
                                continue;
                            }
                            DebugLogger.logTrace("Removed delayedOutput from hash ", traceInfo, 2);
                            delayedOutput.getState().releaseConnections();
                            delayedOutputs.remove(key);
                            continue;
                        }
                        DebugLogger.logTrace("Removed delayedOutput from hash ", traceInfo, 2);
                        delayedOutputs.remove(key);
                    }
                }
                CognosViewerExpeditorDispatcherHandler.logCacheInfo("", _debugFolderName);
            }
            catch (Exception e) {
                this.stopThread();
            }
        }
    }
}

