/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model;

import com.cognos.rap.utility.RAPMessageManager;
import com.cognos.rap.utility.XMLUtility;
import com.cognos.viewer.model.CellAnnotation;
import com.cognos.viewer.model.Comment;
import com.cognos.viewer.model.ContextItem;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.xts.ext.XTSExt;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class AnnotationJSONSpecification {
    private ICognosViewerState m_state = null;
    private HashMap m_layoutComponentAnnoationList = new HashMap();
    private ArrayList m_widgetLevelAnnotations = new ArrayList();

    public AnnotationJSONSpecification(ICognosViewerState state) {
        this.m_state = state;
    }

    public void initialize(Element annotationResponse) {
        if (annotationResponse != null) {
            Iterator iterator = annotationResponse.elementIterator();
            while (iterator.hasNext()) {
                Element annotationNode = (Element)iterator.next();
                Element layoutComponentIdNode = (Element)annotationNode.selectSingleNode("./*[local-name()='context']/*[local-name()='selections']/*[local-name()='query']/*[local-name()='selection']/*[local-name()='layoutElementId']");
                if (layoutComponentIdNode != null) {
                    String layoutComponentId = layoutComponentIdNode.getText();
                    HashMap layoutComponentAnnotations = (HashMap)this.m_layoutComponentAnnoationList.get(layoutComponentId);
                    if (layoutComponentAnnotations == null) {
                        layoutComponentAnnotations = new HashMap();
                        this.m_layoutComponentAnnoationList.put(layoutComponentId, layoutComponentAnnotations);
                    }
                    this.processAnnotationNode(annotationNode, layoutComponentAnnotations);
                    continue;
                }
                this.processWidgetLevelAnnotation(annotationNode);
            }
        }
    }

    private void processWidgetLevelAnnotation(Element annotationNode) {
        String timeStamp = this.getTextFromNode(annotationNode, "./*[local-name()='lastModificationTime']");
        String locale = this.m_state.getUserPreference("contentLocale");
        String timezone = this.m_state.getUserPreference("timeZoneID");
        try {
            timeStamp = XTSExt.formatDateFromUTC((String)timeStamp, (int)2, (int)3, (String)timezone, (String)locale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String author = this.getTextFromNode(annotationNode, "./*[local-name()='owner']/*[local-name()='CMRef']/*[local-name()='defaultName']");
        String description = this.getTextFromNode(annotationNode, "./*[local-name()='description']");
        if (author.length() == 0) {
            author = RAPMessageManager.convert("UNAVAILABLE", locale);
        }
        this.m_widgetLevelAnnotations.add(new Comment(description, author, timeStamp, null, null, null));
    }

    private void processAnnotationNode(Element annotationNode, HashMap layoutComponentAnnotations) {
        ArrayList contextValues = new ArrayList();
        Element queryNode = (Element)annotationNode.selectSingleNode("./*[local-name()='context']/*[local-name()='selections']/*[local-name()='query']");
        if (queryNode != null) {
            String[] axisItems = new String[]{"measures", "rows", "columns", "sections"};
            for (int index = 0; index < axisItems.length; ++index) {
                String axisItem = axisItems[index];
                Element axisItemNode = (Element)queryNode.selectSingleNode("./*[local-name()='selection']/*[local-name()='" + axisItem + "']");
                if (axisItemNode == null) continue;
                this.processSelectionContextAxis(axisItemNode, contextValues);
            }
            String timeStamp = this.getTextFromNode(annotationNode, "./*[local-name()='lastModificationTime']");
            String locale = this.m_state.getUserPreference("contentLocale");
            String timezone = this.m_state.getUserPreference("timeZoneID");
            try {
                timeStamp = XTSExt.formatDateFromUTC((String)timeStamp, (int)2, (int)3, (String)timezone, (String)locale);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String author = this.getTextFromNode(annotationNode, "./*[local-name()='owner']/*[local-name()='CMRef']/*[local-name()='defaultName']");
            if (author.length() == 0) {
                author = RAPMessageManager.convert("UNAVAILABLE", locale);
            }
            String description = this.getTextFromNode(annotationNode, "./*[local-name()='description']");
            String queryName = queryNode.attributeValue("name");
            String parameterValuesSpec = null;
            String filterDescription = null;
            String sliderDescription = null;
            List tags = XMLUtility.selectNodes(annotationNode, "./*[local-name()='tags']/*[local-name()='tag']");
            for (Element tag : tags) {
                String parameterValues;
                String name = this.getTextFromNode(tag, "./*[local-name()='name']");
                String value = this.getTextFromNode(tag, "./*[local-name()='value']");
                if ("parameterValues".equals(name) && (parameterValues = value) != null) {
                    try {
                        JSONObject paramValues = (JSONObject)JSON.parse((String)parameterValues);
                        parameterValuesSpec = (String)paramValues.get((Object)"parameterValuesSpec");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if ("filterDetails".equals(name)) {
                    filterDescription = value;
                }
                if (!"sliderDetails".equals(name)) continue;
                sliderDescription = value;
            }
            String cellAnnotationKey = queryName + "." + this.buildContextKey(contextValues);
            CellAnnotation cellAnnotation = (CellAnnotation)layoutComponentAnnotations.get(cellAnnotationKey);
            if (cellAnnotation == null) {
                cellAnnotation = new CellAnnotation(queryName, contextValues);
                layoutComponentAnnotations.put(cellAnnotationKey, cellAnnotation);
            }
            cellAnnotation.addComment(description, author, timeStamp, parameterValuesSpec, filterDescription, sliderDescription);
        }
    }

    private String buildContextKey(ArrayList contextValues) {
        StringBuilder key = new StringBuilder("");
        int size = contextValues.size();
        for (int index = 0; index < size; ++index) {
            ContextItem contextItem = (ContextItem)contextValues.get(index);
            if (key.length() != 0) {
                key.append(".");
            }
            key.append(contextItem.getUseValue());
        }
        return key.toString();
    }

    private void processSelectionContextAxis(Element parent, ArrayList contextValues) {
        Iterator axisItemIterator = parent.elementIterator();
        while (axisItemIterator.hasNext()) {
            Element axisItem = (Element)axisItemIterator.next();
            String order = axisItem.attributeValue("order");
            String useValue = this.getTextFromNode(axisItem, "./*[local-name()='item']/*[local-name()='value']/*[local-name()='item']/*[local-name()='use']");
            String displayValue = this.getTextFromNode(axisItem, "./*[local-name()='item']/*[local-name()='value']/*[local-name()='item']/*[local-name()='display']");
            String refDataItem = this.getTextFromNode(axisItem, "./*[local-name()='item']/*[local-name()='name']");
            String usage = axisItem.attributeValue("usage");
            boolean isMeasure = usage.equals("2");
            contextValues.add(new ContextItem(refDataItem, useValue, displayValue, order, isMeasure));
        }
        Collections.sort(contextValues, new ContextItemComparator());
    }

    private String getTextFromNode(Element node, String xPath) {
        Element textNode = (Element)node.selectSingleNode(xPath);
        if (textNode != null) {
            return textNode.getText();
        }
        return "";
    }

    public String toString() {
        return this.toJSON().toString();
    }

    public JSONObject toJSON() {
        JSONObject jsonAnnotationSpecification = new JSONObject();
        JSONArray cellAnnotations = new JSONArray();
        if (this.m_layoutComponentAnnoationList != null) {
            for (String layoutComponentId : this.m_layoutComponentAnnoationList.keySet()) {
                HashMap layoutComponentAnnotations = (HashMap)this.m_layoutComponentAnnoationList.get(layoutComponentId);
                JSONObject jsonAnnotation = new JSONObject();
                jsonAnnotation.put((Object)"layoutComponentId", (Object)layoutComponentId);
                JSONArray jsonCellAnnotations = new JSONArray();
                jsonAnnotation.put((Object)"cellAnnotations", (Object)jsonCellAnnotations);
                for (CellAnnotation cellAnnotation : layoutComponentAnnotations.values()) {
                    jsonCellAnnotations.add((Object)cellAnnotation.toJSON());
                }
                cellAnnotations.add((Object)jsonAnnotation);
            }
        }
        jsonAnnotationSpecification.put((Object)"cellAnnotations", (Object)cellAnnotations);
        JSONArray widetLevelAnnotations = new JSONArray();
        int size = this.m_widgetLevelAnnotations.size();
        for (int index = 0; index < size; ++index) {
            Comment comment = (Comment)this.m_widgetLevelAnnotations.get(index);
            widetLevelAnnotations.add((Object)comment.toJSON());
        }
        jsonAnnotationSpecification.put((Object)"widgetAnnotations", (Object)widetLevelAnnotations);
        return jsonAnnotationSpecification;
    }

    public class ContextItemComparator
    implements Comparator {
        public int compare(Object contextItemOne, Object contextItemTwo) {
            int itemTwoOrderValue;
            int itemOneOrderValue = ((ContextItem)contextItemOne).getOrderValue();
            if (itemOneOrderValue > (itemTwoOrderValue = ((ContextItem)contextItemTwo).getOrderValue())) {
                return 1;
            }
            if (itemOneOrderValue < itemTwoOrderValue) {
                return -1;
            }
            return 0;
        }
    }
}

