/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model;

import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.ConversationContext;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.ConversationMarshaller;
import com.cognos.viewer.utility.FragmentInputStreamReader;
import com.cognos.viewer.utility.MessageManager;
import com.cognos.viewer.utility.StreamUtility;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class AsyncResponse
extends SOAPResponse {
    private AsynchRequest m_conversation = null;
    private Tracking m_tracking = null;
    private CAMPassport m_camPassport = null;
    private String m_sOutputFormat = "";
    private InputStream m_attachmentStream = null;
    private String m_sStatus = null;
    private StringBuilder m_sbBufferedAttachment = null;
    public static final String TRACKING_ID = "id";
    public static final String STATUS = "status";
    public static final String AFFINITY_STRENGTH = "affinityStrength";
    public static final String NODE_ID = "nodeID";
    public static final String PROCESS_ID = "processID";
    public static final String BUS_ASYNCHDETAILREPORTOUTPUT_XPATH = "./*/*[local-name()='result']/*[local-name()='details']/item[@xsi:type='bus:asynchDetailReportOutput']";
    public static final QName BUS_OUTPUTPAGES = DocumentHelper.createQName((String)"outputPages", (Namespace)BIBusEnvelope.NS_BUS);
    public static final String BUS_ASYNCHDETAILCONTEXT_XPATH = "./*/*[local-name()='result']/*[local-name()='details']/item[@xsi:type='bus:asynchDetailContext']";
    public static final QName BUS_CONTEXT = DocumentHelper.createQName((String)"context", (Namespace)BIBusEnvelope.NS_BUS);
    public static final QName BUS_SESSION_CONTEXT = DocumentHelper.createQName((String)"sessionContext", (Namespace)BIBusEnvelope.NS_BUS);
    public static final QName BUS_REQUEST_CONTEXT = DocumentHelper.createQName((String)"requestContext", (Namespace)BIBusEnvelope.NS_BUS);
    private static final String BUS_STATE_DATA_XPATH = "./*/*[local-name()='result']/*[local-name()='primaryRequest']/*[local-name()='stateData']";

    public AsyncResponse(ICognosViewerState state, BIBusEnvelope busResponse, InputStream attachmentStream) throws NullPointerException {
        super(state, busResponse);
        if (state == null || busResponse == null) {
            throw new NullPointerException();
        }
        this.m_attachmentStream = attachmentStream;
    }

    @Override
    public CAMPassport getCAMPassport() {
        Element camId;
        Element camPassport;
        Element cam;
        if (this.m_camPassport == null && (cam = this.m_responseEnvelope.getCAM()) != null && (camPassport = cam.element("CAMPassport")) != null && (camId = camPassport.element(TRACKING_ID)) != null && camId.getText().length() > 0) {
            this.m_camPassport = new CAMPassport();
            this.m_camPassport.setId(camId.getText());
        }
        return this.m_camPassport;
    }

    @Override
    public Tracking getTracking() {
        if (this.m_tracking == null) {
            this.m_tracking = new Tracking();
            Element trackingNode = this.m_responseEnvelope.getTracking();
            if (trackingNode != null) {
                Element conversationContextNode;
                Element sessionContextNode;
                Element requestContextNode = trackingNode.element(BUS_REQUEST_CONTEXT);
                if (requestContextNode != null) {
                    this.m_tracking.setRequestContext(requestContextNode.getText());
                }
                if ((sessionContextNode = trackingNode.element(BUS_SESSION_CONTEXT)) != null) {
                    this.m_tracking.setSessionContext(sessionContextNode.getText());
                }
                if ((conversationContextNode = trackingNode.element(BIBusEnvelope.BUS_CONVERSATION_CONTEXT)) != null) {
                    ConversationContext conversationContext = new ConversationContext();
                    this.m_tracking.setConversationContext(conversationContext);
                    Element affinityStrengthNode = conversationContextNode.element(AFFINITY_STRENGTH);
                    conversationContext.setAffinityStrength(Integer.parseInt(affinityStrengthNode.getText()));
                    Element trackingIdNode = conversationContextNode.element(TRACKING_ID);
                    conversationContext.setId(trackingIdNode.getText());
                    Element nodeIdNode = conversationContextNode.element(NODE_ID);
                    conversationContext.setNodeID(nodeIdNode.getText());
                    Element processIdNode = conversationContextNode.element(PROCESS_ID);
                    conversationContext.setProcessID(Integer.parseInt(processIdNode.getText()));
                    Element statusNode = conversationContextNode.element(STATUS);
                    conversationContext.setStatus(statusNode.getText());
                }
            }
        }
        return this.m_tracking;
    }

    @Override
    public AsynchRequest getConversation() {
        Element asynchRequestNode;
        Element soapBody;
        if (this.m_conversation == null && (soapBody = this.m_responseEnvelope.getBody()) != null && (asynchRequestNode = (Element)soapBody.selectSingleNode("./*/*[local-name()='result']/*[local-name()='primaryRequest']")) != null) {
            ConversationMarshaller conversationMarshaller = new ConversationMarshaller(null);
            try {
                this.m_conversation = conversationMarshaller.unmarshall(asynchRequestNode);
            }
            catch (CognosViewerException ex) {
                this.m_state.getIPFLogger().error(ex.getMessage(), ex, this.getClass().getName());
            }
        }
        return this.m_conversation;
    }

    @Override
    public String getStateData() {
        Element stateDataNode;
        String stateData = "";
        Element soapBody = this.m_responseEnvelope.getBody();
        if (soapBody != null && (stateDataNode = (Element)soapBody.selectSingleNode(BUS_STATE_DATA_XPATH)) != null) {
            stateData = stateDataNode.getText();
        }
        return stateData;
    }

    @Override
    public void getDetailOutput(StringBuilder sbOutput) throws CognosViewerException {
        if (this.m_responseEnvelope != null) {
            if (this.m_attachmentStream != null) {
                String sSession = this.m_state.getFormFieldAsString("m_session");
                boolean bFragmentResponse = "fragment".equals(this.m_state.getFormFieldAsString("cv.responseFormat"));
                boolean bDebugWriteLogs = this.m_state.getDebugLogger().shouldBufferReportHtml();
                if (sSession != null && sSession.length() > 0 || bFragmentResponse || bDebugWriteLogs) {
                    try {
                        int readLimit = -1;
                        String readLimitConfig = CognosViewerDispatcherHandler.getConfigValues().getProperty("VIEWER_PORTLET_BUFFER_MB_READ_LIMIT");
                        if (readLimitConfig != null && readLimitConfig.length() > 0) {
                            readLimit = Integer.parseInt(readLimitConfig);
                        }
                        if (bFragmentResponse && !CognosViewerDispatcherHandler.getConfigValues().getBoolean("VIEWER_ENABLE_OLD_PORTLET_BEHAVIOR")) {
                            if (bDebugWriteLogs) {
                                StringBuilder sbAttachment = StreamUtility.createStringBufferFromInputStream(this.m_attachmentStream, readLimit);
                                if (this.m_state.getDebugLogger().shouldGenerateIntermediateXml()) {
                                    this.writeIntermediateXmlLogs(this.m_sbBufferedAttachment);
                                }
                                byte[] attachment = sbAttachment.toString().getBytes("UTF-8");
                                this.m_state.getDebugLogger().log(attachment, "mimeAttachment.txt", true, "mimeAttachment");
                                this.m_attachmentStream = new ByteArrayInputStream(attachment);
                                sbAttachment.setLength(0);
                                FragmentInputStreamReader fragmentInputStream = new FragmentInputStreamReader(this.m_attachmentStream, this.m_state.getFragmentState());
                                StreamUtility.bufferInputStream(sbAttachment, fragmentInputStream, readLimit);
                                this.m_state.getDebugLogger().log(sbAttachment.toString().getBytes("UTF-8"), "mimeAttachment_postFragmentInputStream.txt", false, "mimeAttachment");
                                sbOutput.append((CharSequence)sbAttachment);
                            }
                            FragmentInputStreamReader fragmentInputStream = new FragmentInputStreamReader(this.m_attachmentStream, this.m_state.getFragmentState());
                            StreamUtility.bufferInputStream(sbOutput, fragmentInputStream, readLimit);
                        }
                        if (this.m_sbBufferedAttachment == null) {
                            this.m_sbBufferedAttachment = StreamUtility.createStringBufferFromInputStream(this.m_attachmentStream, readLimit);
                            if (this.m_state.getDebugLogger().shouldGenerateIntermediateXml()) {
                                this.writeIntermediateXmlLogs(this.m_sbBufferedAttachment);
                            }
                            if (this.m_state.getDebugLogger().isDebugEnabled()) {
                                this.m_state.getDebugLogger().log(this.m_sbBufferedAttachment.toString().getBytes("UTF-8"), "mimeAttachment.txt", true, "mimeAttachment");
                            }
                        }
                        sbOutput.append((CharSequence)this.m_sbBufferedAttachment);
                    }
                    catch (CognosViewerException exception) {
                        CognosViewerException cognosViewerException = new CognosViewerException(this.m_responseEnvelope, MessageManager.convert("RV_EXCEEDED_REPORT_LENGTH", CognosViewerDispatcherHandlerState.getProductLocale(this.m_state)), exception);
                        throw cognosViewerException;
                    }
                    catch (Exception exception) {
                        CognosViewerException cognosViewerException = new CognosViewerException(this.m_responseEnvelope, MessageManager.convert("RV_COGNOS_VIEWER_DISPATCHER_HANDLER_ERROR", CognosViewerDispatcherHandlerState.getProductLocale(this.m_state)), exception);
                        throw cognosViewerException;
                    }
                } else {
                    this.m_state.setAttachmentInputStream(this.m_attachmentStream);
                    sbOutput.append("####attachmentPlaceHolder####");
                }
            } else {
                Element outputPages;
                Element soapBody = this.m_responseEnvelope.getBody();
                Element busAsynchDetailReportOutput = (Element)soapBody.selectSingleNode(BUS_ASYNCHDETAILREPORTOUTPUT_XPATH);
                if (busAsynchDetailReportOutput != null && (outputPages = busAsynchDetailReportOutput.element(BUS_OUTPUTPAGES)) != null) {
                    boolean fragmentOutput = "fragment".equals(this.m_state.getFormFieldAsString("cv.responseFormat")) && !CognosViewerDispatcherHandler.getConfigValues().getBoolean("VIEWER_ENABLE_OLD_PORTLET_BEHAVIOR");
                    Iterator outputPageIterator = outputPages.elementIterator();
                    while (outputPageIterator.hasNext()) {
                        Element outputPageItem = (Element)outputPageIterator.next();
                        Attribute outputPageItemType = outputPageItem.attribute(SOAPEnvelope.XSI_TYPE);
                        if (outputPageItemType == null || outputPageItemType.getValue().indexOf(":string") == -1) continue;
                        if (fragmentOutput) {
                            StringBuilder sbResponse = new StringBuilder(outputPageItem.getText());
                            FragmentInputStreamReader.fragmentizeBuffer(sbResponse, this.m_state.getFragmentState());
                            sbOutput.append((CharSequence)sbResponse);
                            continue;
                        }
                        sbOutput.append(outputPageItem.getText());
                    }
                }
            }
        }
    }

    @Override
    public boolean hasDetailOutput() throws CognosViewerException {
        if (this.m_responseEnvelope != null) {
            Element context;
            Element busAsynchDetailContext;
            Element outputPages;
            if (this.m_attachmentStream != null) {
                return true;
            }
            Element soapBody = this.m_responseEnvelope.getBody();
            Element busAsynchDetailReportOutput = (Element)soapBody.selectSingleNode(BUS_ASYNCHDETAILREPORTOUTPUT_XPATH);
            if (busAsynchDetailReportOutput != null ? (outputPages = busAsynchDetailReportOutput.element(BUS_OUTPUTPAGES)) != null : (busAsynchDetailContext = (Element)soapBody.selectSingleNode(BUS_ASYNCHDETAILCONTEXT_XPATH)) != null && (context = busAsynchDetailContext.element(BUS_CONTEXT)) != null) {
                return true;
            }
        }
        return false;
    }

    private void writeIntermediateXmlLogs(StringBuilder sbAttachment) throws UnsupportedEncodingException {
        int start = sbAttachment.indexOf("####intermediateStart####");
        if (start <= 0) {
            return;
        }
        int end = sbAttachment.indexOf("####intermediateEnd####");
        String intermediateXml = sbAttachment.substring(start + "####intermediateStart####".length(), end);
        this.m_state.getDebugLogger().log(intermediateXml.getBytes("utf-8"), "IntermediateXml.xml", true, "intermediateXml");
        sbAttachment.delete(start, end + "####intermediateEnd####".length());
    }

    public void setStatus(String status) {
        this.m_sStatus = status;
    }

    @Override
    public boolean isConversationComplete() {
        String status = this.getStatus();
        return !"working".equals(status) && !"stillWorking".equals(status) && !"prompting".equals(status);
    }

    @Override
    public String getStatus() {
        if (this.m_sStatus != null) {
            return this.m_sStatus;
        }
        if (this.m_responseEnvelope != null) {
            if (this.m_responseEnvelope.getFault() != null) {
                this.m_sStatus = "fault";
            } else {
                Element soapBody = this.m_responseEnvelope.getBody();
                if (soapBody != null) {
                    Element statusNode;
                    Element asynchDetailStatus = (Element)soapBody.selectSingleNode("./*/*[local-name()='result']/*[local-name()='details']/*[local-name()='item']/*[local-name()='status']");
                    this.m_sStatus = asynchDetailStatus != null && asynchDetailStatus.getText().compareTo("prompting") == 0 ? "prompting" : (soapBody.selectSingleNode("./*[local-name()='cancelResponse']") != null ? "cancel" : ((statusNode = (Element)soapBody.selectSingleNode("./*/*[local-name()='result']/*[local-name()='status']")) != null ? statusNode.getText() : (soapBody.selectSingleNode("./*[local-name()='addResponse']") != null || soapBody.selectSingleNode("./*[local-name()='updateResponse']") != null ? "complete" : "error")));
                }
            }
        } else {
            this.m_sStatus = "fault";
        }
        return this.m_sStatus;
    }

    @Override
    public String[] getAvailableSecondaryRequests() {
        Element secondaryRequests;
        Element soapBody;
        String[] saAvailableSecondaryRequests = null;
        if (this.m_responseEnvelope != null && (soapBody = this.m_responseEnvelope.getBody()) != null && (secondaryRequests = (Element)soapBody.selectSingleNode("./*/*[local-name()='result']/*[local-name()='secondaryRequests']")) != null) {
            List secondaryRequestList = secondaryRequests.elements();
            int iNumberOfSecondaryRequests = secondaryRequestList.size();
            saAvailableSecondaryRequests = new String[iNumberOfSecondaryRequests];
            for (int iIndex = 0; iIndex < iNumberOfSecondaryRequests; ++iIndex) {
                Element secondaryRequestName;
                Element item = (Element)secondaryRequestList.get(iIndex);
                Attribute xsiType = item.attribute(SOAPEnvelope.XSI_TYPE);
                if (xsiType == null || xsiType.getValue().compareTo("bus:asynchSecondaryRequest") != 0 || (secondaryRequestName = item.element("name")) == null) continue;
                saAvailableSecondaryRequests[iIndex] = secondaryRequestName.getText();
            }
        }
        return saAvailableSecondaryRequests;
    }

    @Override
    public String getContentFormat() {
        if (this.m_sOutputFormat.length() == 0) {
            Element outputFormat;
            Element soapBody;
            this.m_sOutputFormat = this.m_state.getFormFieldAsString("run.outputFormat");
            if (this.m_sOutputFormat.length() == 0 && this.m_responseEnvelope != null && (soapBody = this.m_responseEnvelope.getBody()) != null && (outputFormat = (Element)soapBody.selectSingleNode("./*/*[local-name()='result']/*[local-name()='primaryRequest']/*[local-name()='options']/*[local-name()='item'][./*[local-name()='name']='outputFormat']/*[local-name()='value']/*[local-name()='item']")) != null) {
                this.m_sOutputFormat = outputFormat.getText();
            }
            if (this.m_sOutputFormat.indexOf("HTML") != -1) {
                this.m_sOutputFormat = "HTML";
            }
        }
        return this.m_sOutputFormat;
    }
}

