/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model;

import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.http.StandaloneServerConnection;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.transport.DispatcherConnectionManager;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.CognosViewerRequest;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.SOAPRequest;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import java.net.URL;
import org.dom4j.DocumentHelper;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class CMServerRequest
extends SOAPRequest
implements ICognosViewerRequest {
    public static final Namespace NS_CM = Namespace.get((String)"cm1", (String)"http://developer.cognos.com/schemas/contentManagerService/1");
    public static final String QUERY_MULTIPLE_METHOD = "queryMultiple";
    public static final String QUERY_METHOD = "query";
    public static final String UPDATE_METHOD = "update";
    public static final String DELETE_METHOD = "delete";
    public static final String ADD_ANNOTATIONS_METHOD = "addAnnotations";

    public CMServerRequest(URL serverURL) {
        if (serverURL == null) {
            throw new NullPointerException();
        }
        this.setServerURL(serverURL);
    }

    private ServerConnection getConnection(ICognosViewerState state) {
        ServerConnection connection = null;
        if (CognosViewerDispatcherHandlerState.isMasters()) {
            connection = new StandaloneServerConnection("localhost", 9300, false);
        } else {
            connection = DispatcherConnectionManager.getContentManagerConnection();
            state.addToCleanupList(connection);
        }
        return connection;
    }

    @Override
    public SOAPResponse executeRequest(CognosViewerRequest request) throws CognosViewerException {
        QName method = DocumentHelper.createQName((String)request.getMethod(), (Namespace)NS_CM);
        ServerConnection connection = this.getConnection(request.getState());
        BIBusEnvelope SOAPEnvelope2 = this.executeSOAPRequest(connection, CONTENT_MANAGER_SOAP_ACTION, method, request);
        return new CMServerResponse(request.getState(), SOAPEnvelope2);
    }

    @Override
    public SOAPResponse executeRequest(String sMethod, ICognosViewerState state, IArgumentMarshaller[] aArguments, String sAffinity) throws CognosViewerException {
        QName method = DocumentHelper.createQName((String)sMethod, (Namespace)NS_CM);
        ServerConnection connection = this.getConnection(state);
        BIBusEnvelope SOAPEnvelope2 = this.executeSOAPRequest(connection, CONTENT_MANAGER_SOAP_ACTION, method, state, aArguments, sAffinity);
        return new CMServerResponse(state, SOAPEnvelope2);
    }
}

