/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.render.Renderer;
import com.cognos.viewer.render.RendererFactory;
import org.dom4j.Element;
import org.dom4j.Node;

public class CMServerResponse
extends SOAPResponse {
    private static String m_serverInfo = PropertyInserter.getProperty((String)"com.cognos.pogo.serverInfo");
    private static Boolean m_isMIMECompressedSafe = null;
    private static String MULTI_RESPONSE_ROOT_XPATH = "*[local-name()='queryResponse']/returns";
    private String ROOT_XPATH = "*[local-name()='queryResponse']/result/item";
    private Element cmRootResponse = null;
    private Element cmMultiResponseRoot = null;
    private Renderer detailOutputRenderer;

    public CMServerResponse(ICognosViewerState state, BIBusEnvelope responseEnvelope) {
        this(state, responseEnvelope, RendererFactory.getRenderer());
    }

    public CMServerResponse(ICognosViewerState state, BIBusEnvelope responseEnvelope, Renderer renderer) {
        super(state, responseEnvelope);
        if (this.m_responseEnvelope != null && this.m_responseEnvelope.getBody() != null) {
            this.cmRootResponse = (Element)this.m_responseEnvelope.getBody().selectSingleNode(this.ROOT_XPATH);
            this.cmMultiResponseRoot = (Element)this.m_responseEnvelope.getBody().selectSingleNode(MULTI_RESPONSE_ROOT_XPATH);
        }
        this.detailOutputRenderer = renderer;
    }

    public void setRootXPath(String xpath) {
        this.ROOT_XPATH = xpath;
        if (this.m_responseEnvelope != null && this.m_responseEnvelope.getBody() != null) {
            this.cmRootResponse = (Element)this.m_responseEnvelope.getBody().selectSingleNode(this.ROOT_XPATH);
        }
    }

    public String getRootXPath() {
        return this.ROOT_XPATH;
    }

    public String getProperty(String propName) {
        String sPropValue = "";
        if (this.cmRootResponse != null) {
            Element property = (Element)this.cmRootResponse.selectSingleNode(propName + "/value");
            if (property != null) {
                sPropValue = property.getText();
            }
        } else {
            sPropValue = this.getProperty(propName, 1);
        }
        return sPropValue;
    }

    public String getProperty(String propName, int iQueryReply) {
        Element property;
        String sPropValue = "";
        if (this.cmMultiResponseRoot != null && (property = (Element)this.cmMultiResponseRoot.selectSingleNode("item[position() = " + iQueryReply + "]/queryResult/item/" + propName + "/value")) != null) {
            sPropValue = property.getText();
        }
        return sPropValue;
    }

    public Element getComplexProperty(String propName) {
        Element propElement = null;
        if (this.cmRootResponse != null) {
            propElement = (Element)this.cmRootResponse.selectSingleNode(propName);
        }
        if (propElement == null) {
            propElement = this.getComplexProperty(propName, 1);
        }
        return propElement;
    }

    public Element getComplexProperty(String propName, int iQueryReply) {
        Element propElement = null;
        if (this.cmMultiResponseRoot != null) {
            propElement = (Element)this.cmMultiResponseRoot.selectSingleNode("item[position()=" + iQueryReply + "]/queryResult/item/" + propName);
        }
        return propElement;
    }

    public Element queryForNode(String xpath) {
        Element propElement = null;
        if (this.m_responseEnvelope != null && this.m_responseEnvelope.getBody() != null) {
            propElement = (Element)this.m_responseEnvelope.getBody().selectSingleNode(xpath);
        }
        return propElement;
    }

    @Override
    public void getDetailOutput(StringBuilder sbOutput) throws CognosViewerException {
        sbOutput.append(this.detailOutputRenderer.renderDetailOutput(this));
    }

    public ICognosViewerState getState() {
        return this.m_state;
    }

    public static void setServerInfo(String serverInfo) {
        m_serverInfo = serverInfo;
    }

    public static void setMIMECompressedSafe(Boolean isMIMECompressedSafe) {
        m_isMIMECompressedSafe = isMIMECompressedSafe;
    }

    public boolean isAppServerMIMECompressedSafe() {
        if (m_isMIMECompressedSafe == null) {
            m_isMIMECompressedSafe = Boolean.TRUE;
            if (m_serverInfo != null) {
                String[] unsafeAppServers = null;
                String sConfigUnsafeAppServers = CognosViewerDispatcherHandler.getConfigValues().getProperty("unsafeMIMECompressedServers");
                if (sConfigUnsafeAppServers != null && !"".equals(sConfigUnsafeAppServers)) {
                    unsafeAppServers = sConfigUnsafeAppServers.split(",");
                }
                if (unsafeAppServers != null) {
                    for (int i = 0; i < unsafeAppServers.length; ++i) {
                        if (m_serverInfo.indexOf(unsafeAppServers[i]) == -1) continue;
                        m_isMIMECompressedSafe = Boolean.FALSE;
                        break;
                    }
                }
            }
            if (this.m_state.getDebugLogger() != null) {
                String serverIDstring = "server ID string:" + m_serverInfo;
                this.m_state.getDebugLogger().log(serverIDstring.getBytes(), "serverInfoIdString.log", false, null);
                this.m_state.getDebugLogger().log(("isMimeCompressedSafe:" + m_isMIMECompressedSafe.toString()).getBytes(), "serverInfoIdString.log", false, null);
            }
        }
        return m_isMIMECompressedSafe;
    }

    @Override
    public String getStatus() {
        return "complete";
    }

    @Override
    public String getContentFormat() {
        String sFormat = "";
        String sAction = this.m_state.getAction();
        if (sAction.compareTo("view") == 0) {
            String sOutputFormat = this.getProperty("format");
            if (sOutputFormat != null && sOutputFormat.length() != 0) {
                sFormat = sOutputFormat;
            }
        } else {
            String sExecutionFormat = this.getProperty("executionFormat");
            if (sExecutionFormat != null && sExecutionFormat.length() != 0) {
                sFormat = sExecutionFormat;
            }
        }
        if (sFormat.length() == 0 && ((sFormat = this.m_state.getUserPreference("format")) == null || sFormat.length() == 0)) {
            sFormat = "HTML";
        }
        return sFormat;
    }

    @Override
    public String getReRunObj() {
        Node runnableSearchPathNode;
        Element ancestorsNode = this.getComplexProperty("ancestors");
        if (ancestorsNode != null && (runnableSearchPathNode = ancestorsNode.selectSingleNode("value/item[objectClass='report' or objectClass='query' or objectClass='analysis' or objectClass='reportView']/searchPath")) != null) {
            return runnableSearchPathNode.getText();
        }
        return "";
    }

    @Override
    public String getReportVersion() {
        Node reportVersionTitleNode;
        Element ancestorsNode = this.getComplexProperty("ancestors");
        if (ancestorsNode != null && (reportVersionTitleNode = ancestorsNode.selectSingleNode("value/item[objectClass='reportVersion']/title")) != null) {
            return reportVersionTitleNode.getText();
        }
        return "";
    }
}

