/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model;

import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;

public class Capabilities {
    private HashMap m_hmCapabilities = new HashMap();
    private String capabilitiesXML = "";
    public static final String CAN_USE_COGNOS_VIEWER = "canUseCognosViewer";
    public static final String CAN_USE_COGNOS_VIEWER_CONTEXT_MENU = "canUseCognosViewerContextMenu";
    public static final String CAN_USE_COGNOS_VIEWER_RUN_WITH_OPTIONS = "canUseCognosViewerRunWithOptions";
    public static final String CAN_USE_COGNOS_VIEWER_SELECTION = "canUseCognosViewerSelection";
    public static final String CAN_USE_COGNOS_VIEWER_TOOLBAR = "canUseCognosViewerToolbar";
    public static final String CAN_USE_ADMIN_TOOL = "canUseAdministrationPortal";
    public static final String CAN_USE_REPORT_STUDIO = "canUseReportStudio";
    public static final String CAN_USE_REPORT_STUDIO_FILE_MANAGEMENT = "canUseReportStudioFileManagement";
    public static final String CAN_USE_QUERY_STUDIO = "canUseQueryStudio";
    public static final String CAN_USE_QUERY_STUDIO_FILE_MANAGEMENT = "canUseQueryStudioFileManagement";
    public static final String CAN_USE_ANALYSIS_STUDIO = "canUseAnalysisStudio";
    public static final String CAN_USE_INDEX_SEARCH = "canUseIndexSearch";
    public static final String CAN_USE_CONDITIONAL_SUBSCRIPTION = "canUseConditionalSubscriptions";
    public static final String CAN_USE_LINEAGE = "canUseLineage";
    public static final String CAN_USE_GLOSSARY = "canUseGlossary";
    public static final String CAN_USE_DASHBOARD_VIEWER = "canUseDashboardViewer";
    public static final String CAN_USE_ADAPTIVE_ANALYTICS = "canUseAdaptiveAnalytics";
    public static final String CAN_USE_ADAPTIVE_ANALYTICS_ADMINISTRATION = "canUseAdaptiveAnalyticsAdministration";

    public Capabilities(Element userCapabilityCache) {
        this.initialize(userCapabilityCache);
    }

    private void initialize(Element userCapabilityCache) {
        if (userCapabilityCache == null) {
            return;
        }
        this.capabilitiesXML = userCapabilityCache.asXML();
        List userCapabilities = userCapabilityCache.selectNodes("./*[local-name()='userCapabilities']/item");
        for (int iIndex = 0; iIndex < userCapabilities.size(); ++iIndex) {
            Element capability = (Element)userCapabilities.get(iIndex);
            if (capability == null || capability.getTextTrim() == null) continue;
            this.m_hmCapabilities.put(capability.getTextTrim(), "true");
        }
    }

    public boolean hasCapability(String sCapability) {
        if (sCapability == null) {
            return false;
        }
        return this.m_hmCapabilities.get(sCapability) != null;
    }

    public String getCapabilitiesXML() {
        return this.capabilitiesXML;
    }

    public void setCapability(String sCapability, String sValue) {
        this.m_hmCapabilities.put(sCapability, sValue);
    }
}

