/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model;

import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.NameValue;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.rap.controller.CognosServiceOptions;
import com.cognos.rap.controller.CognosServiceResponse;
import com.cognos.rap.controller.ICognosServiceRequest;
import com.cognos.rap.exceptions.CognosServiceRequestAuthException;
import com.cognos.rap.exceptions.CognosServiceRequestException;
import com.cognos.rap.exceptions.CognosServiceRequestWorkingStatusException;
import com.cognos.rap.utility.XMLUtility;
import com.cognos.viewer.action.ActionHelper;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.CognosViewerReportSpecificationFactory;
import com.cognos.viewer.model.CognosViewerRequest;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.OptionManager;
import com.cognos.viewer.model.ParameterValueManager;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.AsynchSpecificationMarshaller;
import com.cognos.viewer.model.marshallers.ConversationMarshaller;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.OptionMarshaller;
import com.cognos.viewer.model.marshallers.ParameterValuesMarshaller;
import com.cognos.viewer.utility.Protect;
import com.cognos.xts.ext.XTSExt;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CognosServiceRequest
implements ICognosServiceRequest {
    public static final String RAP_WAIT = "rapWait";
    public static final String RAP_REQUEST_CACHE = "rapRequestCache";
    public static final String RAP_TIMING_KEY = "RAP";
    private static final String CACHE_ENTRY_TYPE_PROPERTY = "type";
    private static final String CACHE_ENTRY_VALUE_PROPERTY = "value";
    private static final String CACHE_ENTRY_TYPE_RESPONSE = "response";
    private static final String CACHE_ENTRY_TYPE_EXCEPTION = "exception";
    private static final String RAP_TRACKING = "RAP_TRACKING";
    private static final String RAP_PARAMETER_MANAGER = "RAP_PARAMETER_MANAGER";
    private ICognosViewerState state = null;
    private CognosViewerServiceFactory serviceFactory = null;
    private String mainTracking = "";
    private ParameterValueManager parameterValueManager = null;

    public CognosServiceRequest(ICognosViewerState state, CognosViewerServiceFactory serviceFactory) {
        this.state = state;
        this.serviceFactory = serviceFactory;
        if (state.getObject(RAP_PARAMETER_MANAGER) != null) {
            this.parameterValueManager = (ParameterValueManager)state.getObject(RAP_PARAMETER_MANAGER);
        } else if (state.getFormFieldAsString("ui.conversation").length() > 0 && !"false".equals(state.getFormFieldAsString("cv.reUseConversationParameterValues"))) {
            this.parameterValueManager = new ParameterValueManager();
            ParameterValue[] convParameters = state.getConversation().getParameters();
            ActionHelper.addMissingParameterValuesToParameterManager(convParameters, this.parameterValueManager);
            state.addObject(RAP_PARAMETER_MANAGER, this.parameterValueManager);
        } else {
            this.parameterValueManager = state.getParameterValueManager();
        }
    }

    @Override
    public CognosServiceResponse runGetParametersSpecification(String reportSpecification, CognosServiceOptions options) throws CognosServiceRequestException {
        this.prepareForRAPRequest();
        CognosServiceResponse response = this.runGetParametersSpecification(reportSpecification, options, ResponseProcessor.getparameters);
        this.rapRequestFinished();
        return response;
    }

    @Override
    public CognosServiceResponse runMetadataSpecification(String metadataSpecification, CognosServiceOptions options) throws CognosServiceRequestException {
        this.prepareForRAPRequest();
        CognosServiceResponse response = this.runReportSpecification(metadataSpecification, options, ResponseProcessor.metadata);
        this.rapRequestFinished();
        return response;
    }

    @Override
    public CognosServiceResponse runReportSpecification(String reportSpecification, CognosServiceOptions options) throws CognosServiceRequestException {
        this.prepareForRAPRequest();
        CognosServiceResponse response = this.runReportSpecification(reportSpecification, options, ResponseProcessor.specification);
        this.rapRequestFinished();
        return response;
    }

    private void prepareForRAPRequest() {
        if (this.state.getDebugLogger() != null) {
            this.state.getDebugLogger().endTimedEvent(RAP_TIMING_KEY);
        }
        if (this.state.getFormFieldAsString(RAP_WAIT).length() == 0) {
            if (this.state.getBusEnvelope().getFormValue("m_tracking") != null) {
                this.mainTracking = this.state.getBusEnvelope().getFormValue("m_tracking");
            }
            if (this.state.getObject(RAP_TRACKING) != null) {
                this.state.setFormFieldFromString("m_tracking", (String)this.state.getObject(RAP_TRACKING));
            } else {
                this.state.removeFormField("m_tracking");
            }
        }
    }

    private void rapRequestFinished() {
        if (this.state.getFormFieldAsString("mainTracking").length() > 0) {
            this.state.setFormFieldFromString("m_tracking", this.state.getFormFieldAsString("mainTracking"));
            this.state.removeFormField("mainTracking");
        } else if (this.mainTracking != null && this.mainTracking.length() > 0) {
            this.state.setFormFieldFromString("m_tracking", this.mainTracking);
        }
        if (this.state.getFormFieldAsString("mainConversation").length() > 0) {
            this.state.setFormFieldFromString("ui.conversation", this.state.getFormFieldAsString("mainConversation"));
            this.state.removeFormField("mainConversation");
        }
        if (this.state.getDebugLogger() != null) {
            this.state.getDebugLogger().startTimedEvent(RAP_TIMING_KEY, RAP_TIMING_KEY, RAP_TIMING_KEY);
        }
    }

    private void setWaitState(SOAPResponse soapResponse) {
        String sStatus = soapResponse.getStatus();
        if (!"prompting".equals(sStatus)) {
            this.state.setFormFieldFromString(RAP_WAIT, Boolean.TRUE.toString());
            if (this.state.getFormFieldAsString("mainTracking").length() == 0 && this.state.getBusEnvelope().getFormValue("m_tracking") != null) {
                this.state.setFormFieldFromString("mainTracking", this.state.getBusEnvelope().getFormValue("m_tracking"));
            }
            if (this.state.getFormFieldAsString("mainConversation").length() == 0 && this.state.getBusEnvelope().getFormValue("ui.conversation") != null) {
                this.state.setFormFieldFromString("mainConversation", this.state.getBusEnvelope().getFormValue("ui.conversation"));
            }
        }
    }

    private IArgumentMarshaller[] initializeRunReportSpecification(String reportSpecification, CognosServiceOptions options, ResponseProcessor responseProcessor) throws CognosViewerException {
        String sCVId;
        IArgumentMarshaller[] arguments = new IArgumentMarshaller[3];
        CognosViewerReportSpecificationFactory specificationFactory = new CognosViewerReportSpecificationFactory();
        AsynchSpecification asynchSpecification = specificationFactory.load(responseProcessor.getAsyncSpecificationString());
        Specification specification = new Specification();
        specification.set_value(reportSpecification);
        asynchSpecification.setValue(specification);
        arguments[0] = new AsynchSpecificationMarshaller(asynchSpecification);
        arguments[1] = new ParameterValuesMarshaller(this.parameterValueManager.toArray());
        OptionManager optionManager = new OptionManager();
        optionManager.addOption("run.promptFormat", "HTMLFragment");
        optionManager.addOption("run.xslURL", "sa.xsl");
        if (CognosViewerDispatcherHandlerState.isMasters()) {
            optionManager.addOption("asynch.primaryWaitThreshold", "0");
        }
        if ((sCVId = this.state.getFormFieldAsString("cv.id")).length() != 0) {
            NameValue nameValue = new NameValue();
            nameValue.setName("CognosViewerID");
            nameValue.setValue(sCVId);
            optionManager.newRunOptionNameValueArray(RunOptionEnum.xslParameters, new NameValue[]{nameValue});
        }
        if (options == null) {
            optionManager.addOption("run.outputFormat", "XML");
        } else {
            if (optionManager.getOption("run.outputFormat") == null) {
                optionManager.addOption("run.outputFormat", "rawXML");
            }
            for (Map.Entry<String, String> option : options.getOptions()) {
                optionManager.addOption(option.getKey(), option.getValue());
            }
        }
        optionManager.addOption("run.prompt", "false");
        arguments[2] = new OptionMarshaller(optionManager.toArray());
        return arguments;
    }

    private CognosServiceResponse runReportSpecification(String reportSpecification, CognosServiceOptions options, ResponseProcessor responseProcessor) throws CognosServiceRequestException {
        CognosServiceResponse cachedResponse = this.getFromCache(reportSpecification);
        if (cachedResponse != null) {
            return cachedResponse;
        }
        SOAPResponse soapResponse = null;
        try {
            boolean trustedRequest;
            CognosViewerRequest request;
            if (this.state.getFormFieldAsString(RAP_WAIT).length() > 0) {
                CognosServiceResponse response = this.continueRequest(responseProcessor);
                this.addToCache(reportSpecification, response);
                return response;
            }
            IArgumentMarshaller[] arguments = this.initializeRunReportSpecification(reportSpecification, options, responseProcessor);
            ICognosViewerRequest rsRequest = this.serviceFactory.getService(CognosViewerServiceFactory.REPORTSERVICEREQUEST);
            soapResponse = rsRequest.executeRequest(request = new CognosViewerRequest("runSpecification", this.state, arguments, "session", trustedRequest = this.state.getCapabilities().hasCapability("canUseDashboardViewer")));
            if (this.isActionRequestComplete(soapResponse)) {
                CognosServiceResponse response = responseProcessor.processResponse(soapResponse);
                this.addToCache(reportSpecification, response);
                this.setTrackingInState(soapResponse);
                this.state.releaseConnections();
                return response;
            }
            if (options == null || !options.getRapWaitDisabled()) {
                this.setWaitState(soapResponse);
                throw new CognosServiceRequestWorkingStatusException(soapResponse);
            }
        }
        catch (CognosViewerException e) {
            if (e.getFaultEnvelope() != null) {
                this.state.getDebugLogger().log(e.getFaultEnvelope(), "fault.xml", false, null);
            }
            if (CognosViewerDispatcherHandlerState.isAuthenticationFaultEnvelope(e.getFaultEnvelope())) {
                if (this.state.getDebugLogger() != null) {
                    this.state.getDebugLogger().startTimedEvent(RAP_TIMING_KEY, RAP_TIMING_KEY, RAP_TIMING_KEY);
                }
                throw new CognosServiceRequestAuthException(e);
            }
            CognosServiceResponse response = new CognosServiceResponse();
            this.addToCache(reportSpecification, e);
            this.state.setFormFieldFromString(RAP_WAIT, "");
            this.state.releaseConnections();
            return response;
        }
        catch (DocumentException e) {
            if (this.state.getDebugLogger() != null) {
                this.state.getDebugLogger().startTimedEvent(RAP_TIMING_KEY, RAP_TIMING_KEY, RAP_TIMING_KEY);
            }
            throw new CognosServiceRequestException(e);
        }
        return null;
    }

    private void setTrackingInState(SOAPResponse soapResponse) {
        CAMPassport passport = soapResponse.getCAMPassport();
        Element trackingNode = soapResponse.getBusEnvelope().getTracking();
        if (trackingNode != null) {
            Element conversationContextNode = trackingNode.element(BIBusEnvelope.BUS_CONVERSATION_CONTEXT);
            String sTracking = "";
            if (conversationContextNode != null) {
                sTracking = conversationContextNode.asXML();
                this.state.addObject(RAP_TRACKING, Protect.cafaction("sign_wrap_setpassportid_" + passport.getId(), XTSExt.web64encode((String)sTracking, (boolean)true)));
            }
        }
    }

    private CognosServiceResponse runGetParametersSpecification(String reportSpecification, CognosServiceOptions options, ResponseProcessor responseProcessor) throws CognosServiceRequestException {
        CognosServiceResponse cachedResponse = this.getFromCache(reportSpecification);
        if (cachedResponse != null) {
            return cachedResponse;
        }
        SOAPResponse soapResponse = null;
        try {
            CognosViewerRequest request;
            if (this.state.getFormFieldAsString(RAP_WAIT).length() > 0) {
                CognosServiceResponse response = this.continueRequest(responseProcessor);
                this.addToCache(reportSpecification, response);
                return response;
            }
            IArgumentMarshaller[] arguments = this.initializeRunReportSpecification(reportSpecification, options, responseProcessor);
            ICognosViewerRequest rsRequest = this.serviceFactory.getService(CognosViewerServiceFactory.REPORTSERVICEREQUEST);
            soapResponse = rsRequest.executeRequest(request = new CognosViewerRequest("getParametersSpecification", this.state, arguments, "session", this.state.isBUX()));
            if (this.isActionRequestComplete(soapResponse)) {
                CognosServiceResponse response = responseProcessor.processResponse(soapResponse);
                this.addToCache(reportSpecification, response);
                this.setTrackingInState(soapResponse);
                return response;
            }
            this.setWaitState(soapResponse);
            throw new CognosServiceRequestWorkingStatusException(soapResponse);
        }
        catch (CognosViewerException e) {
            if (e.getFaultEnvelope() != null) {
                this.state.getDebugLogger().log(e.getFaultEnvelope(), "fault.xml", false, null);
            }
            if (CognosViewerDispatcherHandlerState.isAuthenticationFaultEnvelope(e.getFaultEnvelope())) {
                throw new CognosServiceRequestAuthException(e);
            }
            CognosServiceResponse response = new CognosServiceResponse();
            this.addToCache(reportSpecification, e);
            this.state.setFormFieldFromString(RAP_WAIT, "");
            return response;
        }
        catch (DocumentException e) {
            throw new CognosServiceRequestException(e);
        }
    }

    private boolean isActionRequestComplete(SOAPResponse soapResponse) {
        String sStatus = soapResponse.getStatus();
        return !"working".equals(sStatus) && !"stillWorking".equals(sStatus) && !"prompting".equals(sStatus);
    }

    private CognosServiceResponse continueRequest(ResponseProcessor responseProcessor) throws CognosViewerException, DocumentException, CognosServiceRequestException {
        SOAPResponse soapResponse = this.doInteruptRequest();
        if (this.isActionRequestComplete(soapResponse)) {
            this.state.setFormFieldFromString(RAP_WAIT, "");
            return responseProcessor.processResponse(responseProcessor.getOutput() ? this.getOutput(soapResponse) : soapResponse);
        }
        this.setWaitState(soapResponse);
        throw new CognosServiceRequestWorkingStatusException(soapResponse);
    }

    private SOAPResponse doInteruptRequest() throws CognosViewerException {
        IArgumentMarshaller[] arguments = new IArgumentMarshaller[]{new ConversationMarshaller(this.state.getConversation()), new ParameterValuesMarshaller(new ParameterValue[0]), new OptionMarshaller(new Option[0])};
        String sAffinity = "absolute";
        ICognosViewerRequest rsRequest = this.serviceFactory.getService(CognosViewerServiceFactory.REPORTSERVICEREQUEST);
        return rsRequest.executeRequest("wait", this.state, arguments, sAffinity);
    }

    private SOAPResponse getOutput(SOAPResponse soapResponse) throws CognosViewerException {
        IArgumentMarshaller[] arguments = new IArgumentMarshaller[]{new ConversationMarshaller(soapResponse.getConversation()), new ParameterValuesMarshaller(new ParameterValue[0]), new OptionMarshaller(new Option[0])};
        ICognosViewerRequest rsRequest = this.serviceFactory.getService(CognosViewerServiceFactory.REPORTSERVICEREQUEST);
        return rsRequest.executeRequest("getOutput", soapResponse, arguments, "absolute");
    }

    private CognosServiceResponse getFromCache(String key) throws CognosServiceRequestException {
        String cacheString = this.state.getFormFieldAsString(RAP_REQUEST_CACHE);
        if (cacheString.length() == 0) {
            return null;
        }
        try {
            JSONObject entry;
            JSONObject cache = JSONObject.parse((String)XTSExt.web64decode((String)cacheString, (boolean)true));
            if (cache != null && (entry = (JSONObject)cache.get((Object)key)) != null) {
                String entryType = (String)entry.get((Object)CACHE_ENTRY_TYPE_PROPERTY);
                String entryValue = (String)entry.get((Object)CACHE_ENTRY_VALUE_PROPERTY);
                if (entryValue != null) {
                    if (CACHE_ENTRY_TYPE_RESPONSE.equals(entryType)) {
                        return CognosServiceResponse.parse(entryValue);
                    }
                    CognosServiceResponse response = new CognosServiceResponse();
                    return response;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new CognosServiceRequestException(e);
        }
    }

    private void addToCache(String key, CognosServiceResponse response) throws CognosServiceRequestException {
        this.addToCache(key, response.toJSONString(), CACHE_ENTRY_TYPE_RESPONSE);
    }

    private void addToCache(String key, String value, String entryType) throws CognosServiceRequestException {
        String cacheString = this.state.getFormFieldAsString(RAP_REQUEST_CACHE);
        JSONObject cache = null;
        if (cacheString.length() == 0) {
            cache = new JSONObject();
        } else {
            try {
                cache = JSONObject.parse((String)XTSExt.web64decode((String)cacheString, (boolean)true));
            }
            catch (IOException e) {
                throw new CognosServiceRequestException(e);
            }
        }
        JSONObject entry = new JSONObject();
        entry.put((Object)CACHE_ENTRY_TYPE_PROPERTY, (Object)entryType);
        entry.put((Object)CACHE_ENTRY_VALUE_PROPERTY, (Object)value);
        cache.put((Object)key, (Object)entry);
        this.state.setFormFieldFromString(RAP_REQUEST_CACHE, XTSExt.web64encode((String)cache.toString(), (boolean)true));
    }

    private void addToCache(String key, Exception exception) throws CognosServiceRequestException {
        this.addToCache(key, exception.getMessage(), CACHE_ENTRY_TYPE_EXCEPTION);
    }

    public static enum ResponseProcessor {
        specification{

            @Override
            public CognosServiceResponse processResponse(SOAPResponse soapResponse) throws DocumentException, CognosServiceRequestException {
                CognosServiceResponse response = new CognosServiceResponse();
                Element soapBody = soapResponse.getBusEnvelope().getBody();
                Element outputPage1 = (Element)soapBody.selectSingleNode(".//*[local-name()='outputPages']/*[local-name()='item']");
                response.setName(soapResponse.getBusEnvelope().getBody().getName());
                try {
                    Document result = DocumentHelper.parseText((String)outputPage1.getText());
                    response.setDOMValue(result.getRootElement());
                }
                catch (DocumentException e) {
                    response.setValue(outputPage1.getText());
                }
                return response;
            }

            @Override
            public String getAsyncSpecificationString() {
                return "reportServiceReportSpecification";
            }

            @Override
            public boolean getOutput() {
                return true;
            }
        }
        ,
        getparameters{

            @Override
            public CognosServiceResponse processResponse(SOAPResponse soapResponse) throws DocumentException, CognosServiceRequestException {
                CognosServiceResponse response = new CognosServiceResponse();
                Element soapBody = soapResponse.getBusEnvelope().getBody();
                List parametersResponse = XMLUtility.selectNodes(soapBody, ".//*[local-name()='details']//*[local-name()='parameters']/*[local-name()='item']");
                response.setName(soapResponse.getBusEnvelope().getBody().getName());
                if (parametersResponse != null && parametersResponse.size() > 0) {
                    JSONObject jsonParams = new JSONObject();
                    for (Element parameter : parametersResponse) {
                        JSONObject jsonParam = new JSONObject();
                        jsonParam.put((Object)"name", (Object)parameter.elementText("name"));
                        jsonParam.put((Object)CognosServiceRequest.CACHE_ENTRY_TYPE_PROPERTY, (Object)parameter.elementText(CognosServiceRequest.CACHE_ENTRY_TYPE_PROPERTY));
                        jsonParam.put((Object)"modelItem", (Object)parameter.elementText("modelFilterItem"));
                        jsonParams.put((Object)parameter.elementText("name"), (Object)jsonParam);
                    }
                    try {
                        response.setValue(jsonParams.serialize());
                    }
                    catch (IOException e) {
                        response.setValue(null);
                    }
                }
                return response;
            }

            @Override
            public String getAsyncSpecificationString() {
                return "reportServiceReportSpecification";
            }

            @Override
            public boolean getOutput() {
                return true;
            }
        }
        ,
        metadata{

            @Override
            public CognosServiceResponse processResponse(SOAPResponse soapResponse) throws DocumentException, CognosServiceRequestException {
                CognosServiceResponse response = new CognosServiceResponse();
                Element soapBody = soapResponse.getBusEnvelope().getBody();
                List metadataElement = XMLUtility.selectNodes(soapBody, ".//*[local-name()='details']//*[local-name()='item']//*[local-name()='metadata']");
                if (metadataElement.size() > 0) {
                    int size = metadataElement.size();
                    ArrayList<Element> domValues = new ArrayList<Element>(size);
                    for (int idx = 0; idx < size; ++idx) {
                        Document result = DocumentHelper.parseText((String)((Element)metadataElement.get(idx)).getText());
                        domValues.add(result.getRootElement());
                    }
                    response.setName(soapResponse.getBusEnvelope().getBody().getName());
                    response.setDOMValues(domValues);
                    return response;
                }
                throw new CognosServiceRequestException(soapResponse);
            }

            @Override
            public String getAsyncSpecificationString() {
                return "reportServiceMetadataSpecification";
            }

            @Override
            public boolean getOutput() {
                return false;
            }
        };


        public abstract CognosServiceResponse processResponse(SOAPResponse var1) throws DocumentException, CognosServiceRequestException;

        public abstract String getAsyncSpecificationString();

        public abstract boolean getOutput();
    }
}

