/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model;

import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerRequest;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.marshallers.AddRequestMarshaller;
import com.cognos.viewer.model.marshallers.ElementMarshaller;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.PropEnumMarshaller;
import com.cognos.viewer.model.marshallers.SearchPathMultipleObjectMarshaller;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.XMLUtility;
import com.cognos.viewer.view.CvOutput;
import com.cognos.viewer.view.ICognosViewerOutputResponse;
import com.cognos.viewer.view.OutputResponseHelper;
import com.cognos.xts.ext.XTSExt;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CognosViewerCachedState {
    CognosViewerServiceFactory m_serviceFactory = null;

    public CognosViewerCachedState(CognosViewerServiceFactory serviceFactory) {
        this.m_serviceFactory = serviceFactory;
    }

    public CognosViewerServiceFactory getServiceFactory() {
        return this.m_serviceFactory;
    }

    public void load(ICognosViewerState state) throws CognosViewerException {
        String sObjName = state.getFormFieldAsString("m_session").length() == 0 ? state.getFormFieldAsString("m_sessionConv") : state.getFormFieldAsString("m_session");
        IArgumentMarshaller[] arguments = new IArgumentMarshaller[]{new SearchPathMultipleObjectMarshaller(new SearchPathMultipleObject("~~/runTimeState[@name='" + sObjName + "']")), new PropEnumMarshaller(new PropEnum[]{PropEnum.state})};
        CognosViewerServiceFactory serviceFactory = this.getServiceFactory();
        ICognosViewerRequest cmRequest = serviceFactory.getService(CognosViewerServiceFactory.CMSERVICEREQUEST);
        CMServerResponse cmResponse = (CMServerResponse)cmRequest.executeRequest("query", state, arguments, "");
        this.processStoredState(state, cmResponse);
    }

    public void processStoredState(ICognosViewerState state, CMServerResponse responseEnvelope) throws CognosViewerException {
        String sStateXMLSpecifcation;
        if (responseEnvelope != null && (sStateXMLSpecifcation = responseEnvelope.getProperty(PropEnum.state.getValue())).length() > 0) {
            try {
                Document document = XMLUtility.createXMLDocument(sStateXMLSpecifcation);
                Element cognosViewerCachedState = document.getRootElement();
                boolean loadConversation = state.getFormFieldAsString("m_sessionConv").length() > 0 && state.getFormFieldAsString("m_session").length() == 0;
                List formFieldParameterList = cognosViewerCachedState.elements("param");
                int iListSize = formFieldParameterList.size();
                for (int iIndex = 0; iIndex < iListSize; ++iIndex) {
                    Element parameter = (Element)formFieldParameterList.get(iIndex);
                    String sName = parameter.attributeValue("name");
                    String sValue = parameter.getText();
                    if ((!loadConversation || !"ui.conversation".equals(sName)) && (loadConversation || "ui.conversation".equals(sName))) continue;
                    state.setFormFieldFromString(sName, sValue);
                }
            }
            catch (Exception exception) {
                CognosViewerException cognosViewerException = new CognosViewerException(null, exception.getMessage(), exception);
                throw cognosViewerException;
            }
        }
    }

    public void save(ICognosViewerActionResponse actionResponse, ICognosViewerOutputResponse outputResponse) throws CognosViewerException {
        CognosViewerServiceFactory serviceFactory = this.getServiceFactory();
        String sCognosViewerCachedState = null;
        if (!"page".equals(actionResponse.getResponseFormat()) && !"fragment".equals(actionResponse.getResponseFormat())) {
            CvOutput pageOutput = new CvOutput();
            sCognosViewerCachedState = this.buildCachedState(pageOutput.render(actionResponse), actionResponse, actionResponse);
        } else {
            sCognosViewerCachedState = this.buildCachedState(outputResponse, actionResponse, actionResponse);
        }
        IArgumentMarshaller[] addObjectsMarshaller = this.getAddObjects(actionResponse.getFormFieldAsString("m_session"), sCognosViewerCachedState);
        AddOptions addOptions = new AddOptions();
        addOptions.setUpdateAction(UpdateActionEnum.update);
        IArgumentMarshaller[] arguments = new IArgumentMarshaller[]{new AddRequestMarshaller("~~", addObjectsMarshaller, addOptions)};
        CognosViewerRequest request = new CognosViewerRequest("add", actionResponse, arguments, "");
        ICognosViewerRequest cmRequest = serviceFactory.getService(CognosViewerServiceFactory.CMSERVICEREQUEST);
        cmRequest.executeRequest(request);
    }

    public IArgumentMarshaller[] getAddObjects(String objectName, String value) throws CognosViewerException {
        StringBuffer addObject = new StringBuffer();
        addObject.append("<item xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xsi:type=\"bus:runTimeState\"><bus:defaultName xsi:type=\"bus:tokenProp\"><bus:value>");
        addObject.append(EncodingUtility.xmlencode(objectName));
        addObject.append("</bus:value></bus:defaultName><bus:state xsi:type=\"bus:anyTypeProp\"><bus:value>");
        addObject.append(EncodingUtility.xmlencode(value));
        addObject.append("</bus:value></bus:state></item>");
        try {
            Element object = DocumentHelper.parseText((String)addObject.toString()).getRootElement();
            IArgumentMarshaller[] addRequestArgumentMarshaller = new IArgumentMarshaller[]{new ElementMarshaller(object)};
            return addRequestArgumentMarshaller;
        }
        catch (DocumentException e) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, e.getMessage(), (Exception)((Object)e));
            throw cognosViewerException;
        }
    }

    public String buildCachedState(ICognosViewerOutputResponse outputResponse, ICognosViewerActionResponse actionResponse, ICognosViewerState state) {
        Element cognosViewerCachedState = DocumentHelper.createElement((String)"CognosViewerCachedState");
        this.addFormFieldParameter(cognosViewerCachedState, "ui.action", "cachedOutput");
        this.addFormFieldParameter(cognosViewerCachedState, "cv.responseFormat", "cached");
        this.addFormFieldParameter(cognosViewerCachedState, "generatedOutput", XTSExt.web64encode((String)outputResponse.getStringOutput(), (boolean)true));
        if (state.getFormFieldAsString("m_sessionConv").length() > 0) {
            this.addFormFieldParameter(cognosViewerCachedState, "ui.conversation", OutputResponseHelper.getConversation(actionResponse));
        }
        return cognosViewerCachedState.asXML();
    }

    public void addFormFieldParameter(Element parentNode, String sName, String sValue) {
        Element param = parentNode.addElement("param");
        param.addAttribute("name", sName);
        param.setText(sValue);
    }
}

