/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model;

import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.ConversationContext;
import com.cognos.developer.schemas.bibus._3.GenericOptionBoolean;
import com.cognos.developer.schemas.bibus._3.NameValue;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionLanguageArray;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.NameValuePair;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.configuration.CognosViewerBlacklist;
import com.cognos.viewer.configuration.CognosViewerSystemParams;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.controller.expeditor.DelayedOutput;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.Capabilities;
import com.cognos.viewer.model.CognosViewerReportSpecificationFactory;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.CognosViewerSessionManager;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.OptionManager;
import com.cognos.viewer.model.ParameterValueManager;
import com.cognos.viewer.model.fragments.FragmentState;
import com.cognos.viewer.model.marshallers.ConversationMarshaller;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.OptionMarshaller;
import com.cognos.viewer.model.marshallers.ParametersMarshaller;
import com.cognos.viewer.model.marshallers.PropEnumMarshaller;
import com.cognos.viewer.model.marshallers.SearchPathMultipleObjectMarshaller;
import com.cognos.viewer.utility.BrowserUtility;
import com.cognos.viewer.utility.DebugLogger;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.FragmentUtility;
import com.cognos.viewer.utility.GlobalViewerTransient;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.MessageManager;
import com.cognos.viewer.utility.Protect;
import com.cognos.viewer.utility.TransientSpec;
import com.cognos.viewer.utility.URLValidator;
import com.cognos.viewer.utility.XMLUtility;
import com.cognos.xts.ext.XTSExt;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.mail.internet.InternetHeaders;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class CognosViewerDispatcherHandlerState
implements ICognosViewerState {
    private BIBusEnvelope m_biBusEnvelope = null;
    private HashMap<String, String> m_urlInterface = new HashMap();
    private CAMPassport m_camPassport = null;
    private TransientSpec m_transientSpec = new TransientSpec(this);
    private GlobalViewerTransient m_globalViewerTransient = new GlobalViewerTransient();
    private ParameterValueManager m_parameterValueManager = new ParameterValueManager();
    private OptionManager m_optionManager = new OptionManager();
    private Capabilities m_capabilities = null;
    private CognosViewerBlacklist m_cognosViewerBlacklist = null;
    private CognosViewerSessionManager m_cognosViewerSessionParams = null;
    private IPFLogger m_ipfLogger = null;
    private DebugLogger m_debugLogger = null;
    private String m_sWebContentRoot = "";
    private AsynchSpecification m_asynchSpecification = null;
    private List m_connectionCleanupList = new ArrayList();
    private InputStream m_attachmentInputStream = null;
    private HashMap m_objects = new HashMap();
    private HashMap<String, Element> m_cookies = new HashMap();
    private boolean m_bIsBux = false;
    private AsynchRequest m_conversation = null;
    private DelayedOutput m_delayedOuptut = null;
    private FragmentState m_fragmentState = new FragmentState();
    private boolean m_bAllowSpecModification = true;
    private InternetHeaders headers = null;

    public CognosViewerDispatcherHandlerState(MessageContext messageContext, CognosViewerServiceFactory serviceFactory) throws CognosViewerException {
        this.m_biBusEnvelope = (BIBusEnvelope)messageContext.getProperty("request.envelope");
        if (this.m_biBusEnvelope != null && CognosViewerDispatcherHandler.getConfigValues() != null) {
            this.m_debugLogger = new DebugLogger(this.m_biBusEnvelope);
            this.m_debugLogger.log(this.m_biBusEnvelope, "input.xml", true, "input");
            this.m_biBusEnvelope.clearConversationContext();
            this.validateParameters(messageContext);
            this.checkForUserPreferences(serviceFactory);
            this.m_cognosViewerSessionParams = new CognosViewerSessionManager(serviceFactory, this);
            this.m_capabilities = new Capabilities((Element)this.m_biBusEnvelope.getBIBusHeader().selectSingleNode("*[local-name()='userCapabilityCache']"));
            if (CognosViewerDispatcherHandler.getConfigValues().getBoolean("checkViewerCapability") && !this.m_capabilities.hasCapability("canUseCognosViewer") && (this.m_biBusEnvelope.getFormValue("cv.responseFormat") == null || !"qs".equals(this.m_biBusEnvelope.getFormValue("cv.responseFormat")) && !"rs".equals(this.m_biBusEnvelope.getFormValue("cv.responseFormat")))) {
                throw new CognosViewerException(this.getBusEnvelope(), MessageManager.convert("RV_SECURITY_EXCEPTION", CognosViewerDispatcherHandlerState.getFaultLocale(this.getBusEnvelope())), null);
            }
            this.initializeFragmentOptions();
            this.initializeFormFields();
            this.initializeWebContentRoot();
            this.initializeCAMPassport();
            this.initializeXslRunOptions();
            this.m_cognosViewerBlacklist = new CognosViewerBlacklist(this, BrowserUtility.getBrowser(this.getEnvironmentVariable("HTTP_USER_AGENT")));
        }
    }

    public void checkForUserPreferences(CognosViewerServiceFactory serviceFactory) throws CognosViewerException {
        Element preferenceVars = this.m_biBusEnvelope.getUserPreferenceVars();
        if (serviceFactory != null && (preferenceVars == null || preferenceVars.elements().size() == 0)) {
            IArgumentMarshaller[] arguments = new IArgumentMarshaller[]{new SearchPathMultipleObjectMarshaller(new SearchPathMultipleObject("~")), new PropEnumMarshaller(new PropEnum[]{PropEnum.searchPath})};
            ICognosViewerRequest cmRequest = serviceFactory.getService(CognosViewerServiceFactory.CMSERVICEREQUEST);
            CMServerResponse cmResponse = (CMServerResponse)cmRequest.executeRequest("query", this, arguments, "");
            Element prefVars = (Element)cmResponse.getBusEnvelope().getUserPreferenceVars().clone();
            this.m_biBusEnvelope.setUserPreferenceVars(prefVars);
            if (CognosViewerDispatcherHandlerState.isMasters()) {
                this.addObject("userPrefs", this.m_biBusEnvelope.getUserPreferenceVars().asXML());
            }
        }
    }

    public void initializeFragmentOptions() throws CognosViewerException {
        String sResponseFormat = this.m_biBusEnvelope.getFormValue("cv.responseFormat");
        if (sResponseFormat != null && "fragment".equals(sResponseFormat)) {
            if (this.m_biBusEnvelope.getFormValue("ui.object") == null) {
                String sFragmentObject = this.m_biBusEnvelope.getFormValue("savedReport");
                if (sFragmentObject == null || sFragmentObject.length() == 0) {
                    sFragmentObject = this.m_biBusEnvelope.getFormValue("fragment.object");
                }
                if (sFragmentObject != null && sFragmentObject.length() > 0) {
                    this.m_biBusEnvelope.setFormField("ui.object", sFragmentObject);
                }
            }
            String sDashboardState = this.m_biBusEnvelope.getFormValue("frag-state");
            String sIgnoreState = this.m_biBusEnvelope.getFormValue("cv.ignoreState");
            if (sDashboardState != null && sDashboardState.length() > 0 && (sIgnoreState == null || "false".equals(sIgnoreState))) {
                this.initialiazeFormFieldsFromState(sDashboardState);
            }
            this.loadTransientSpec();
            this.convertParameterNames();
            this.cleanEnvParams();
            if (this.m_biBusEnvelope.getFormValue("fragment.transientSpecMap") != null) {
                this.m_biBusEnvelope.setFormField("fragment.transientSpecMap", "");
            }
            FragmentUtility.initPortalSessionField(this);
            FragmentUtility.saveInitialParameterParams(this);
        }
    }

    private void cleanEnvParams() {
        List formFieldVars = this.m_biBusEnvelope.getFormFieldValues();
        ListIterator iterator = formFieldVars.listIterator();
        block0: while (iterator.hasNext()) {
            NameValuePair formFieldVar = (NameValuePair)iterator.next();
            String formFieldName = formFieldVar.getName();
            if (!formFieldName.startsWith("p_")) continue;
            String formFieldValue = formFieldVar.getValue();
            ListIterator iterator2 = formFieldVars.listIterator(iterator.nextIndex());
            while (iterator2.hasNext()) {
                NameValuePair formFieldVar2 = (NameValuePair)iterator2.next();
                if (!formFieldName.equals(formFieldVar2.getName()) || !formFieldValue.equals(formFieldVar2.getValue())) continue;
                this.m_biBusEnvelope.removeFormValue(formFieldName);
                continue block0;
            }
        }
    }

    private void initializeIsBux() {
        String sBUX = this.m_biBusEnvelope.getFormValue("bux");
        if ("true".equals(sBUX) && this.getCapabilities().hasCapability("canUseDashboardViewer")) {
            this.setIsBux(true);
        }
    }

    public void setIsBux(boolean isBux) {
        this.m_bIsBux = isBux;
    }

    @Override
    public boolean isBUX() {
        return this.m_bIsBux;
    }

    public String getBUXRTStateInfo() {
        if (this.m_bIsBux) {
            return this.getFormFieldAsString("cv.buxRTStateInfo");
        }
        return null;
    }

    public void convertParameterNames() {
        String sPromptChannel = this.m_biBusEnvelope.getFormValue("fragment.promptChannel");
        if (sPromptChannel != null) {
            sPromptChannel = "PROMPTCHANNEL_" + sPromptChannel;
            List formFieldVars = this.m_biBusEnvelope.getFormFieldValues();
            ListIterator iterator = formFieldVars.listIterator();
            while (iterator.hasNext()) {
                NameValuePair formFieldVar = (NameValuePair)iterator.next();
                String formFieldName = formFieldVar.getName();
                if (!formFieldName.startsWith("p_") || sPromptChannel.length() <= 0 || formFieldName.indexOf(sPromptChannel) == -1) continue;
                this.m_biBusEnvelope.removeFormValue(formFieldName);
                formFieldName = "p_" + formFieldName.substring(formFieldName.indexOf(sPromptChannel) + sPromptChannel.length(), formFieldName.length());
                this.m_biBusEnvelope.setFormField(formFieldName, formFieldVar.getValue());
            }
        }
    }

    private String getFragmentGateway() {
        String gatewayParam = null;
        gatewayParam = "_THIS?frag-urlType=gateway/THIS_";
        return gatewayParam;
    }

    private void initialiazeFormFieldsFromState(String sDashboardState) throws CognosViewerException {
        int i;
        String sCurrentAction;
        String sEncodedDashboardState = XTSExt.web64decode((String)sDashboardState, (boolean)true);
        Document document = null;
        try {
            document = XMLUtility.createXMLDocument(sEncodedDashboardState);
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
        Element stateElement = (Element)document.getRootElement().selectSingleNode("/CognosViewer");
        boolean bFragmentRefresh = false;
        if (FragmentUtility.isPageRefresh(this.m_biBusEnvelope) || FragmentUtility.hasConfigurationChanged(this.m_biBusEnvelope)) {
            bFragmentRefresh = true;
            this.m_biBusEnvelope.setFormField("cv.reUseConversationParameterValues", "false");
        }
        if ((sCurrentAction = this.m_biBusEnvelope.getFormValue("ui.action")) == null) {
            sCurrentAction = "";
        }
        List stateNodes = stateElement.selectNodes("state/*");
        Node stateNode = null;
        String sNodeName = "";
        String sNodeText = "";
        String sConversation = "";
        for (i = 0; i < stateNodes.size(); ++i) {
            stateNode = (Node)stateNodes.get(i);
            sNodeName = stateNode.getName();
            sNodeText = stateNode.getText();
            if (sNodeName == null || sNodeName.length() <= 0) continue;
            if (sNodeText == null) {
                sNodeText = "";
            }
            if ("ui.conversation".equals(sNodeName)) {
                sConversation = sNodeText;
            }
            if ("ui.action".equals(sNodeName) && (!"ui.action".equals(sNodeName) || bFragmentRefresh) || CognosViewerDispatcherHandlerState.isMasters() && (sNodeName.equals("ui.conversation") || sNodeName.equals("m_tracking"))) continue;
            this.m_biBusEnvelope.setFormField(sNodeName, sNodeText);
        }
        stateNodes = stateElement.selectNodes("defaultState/*");
        for (i = 0; i < stateNodes.size(); ++i) {
            stateNode = (Node)stateNodes.get(i);
            sNodeName = stateNode.getName();
            sNodeText = stateNode.getText();
            if (sNodeName == null || sNodeName.length() <= 0 || this.m_biBusEnvelope.getFormValue(sNodeName) != null) continue;
            if (sNodeText == null) {
                sNodeText = "";
            }
            this.m_biBusEnvelope.setFormField(sNodeName, sNodeText);
        }
        List formFieldVars = this.m_biBusEnvelope.getFormFieldValues();
        ListIterator iterator = formFieldVars.listIterator();
        while (iterator.hasNext()) {
            NameValuePair formFieldVar = (NameValuePair)iterator.next();
            String formFieldName = formFieldVar.getName();
            if (!formFieldName.startsWith("p_") || sConversation.length() <= 0 || bFragmentRefresh) continue;
            this.m_biBusEnvelope.setFormField("ui.action", "forward");
        }
        if ("currentPage".equals(this.m_biBusEnvelope.getFormValue("ui.action"))) {
            this.m_biBusEnvelope.setFormField("m_tracking", "");
        }
    }

    public static String getFaultLocale(BIBusEnvelope busEnvelope) {
        String locale = "en";
        if (busEnvelope == null) {
            return locale;
        }
        if (busEnvelope.getFormValue("lang") != null) {
            locale = busEnvelope.getFormValue("lang");
        } else if (busEnvelope.getFormValue("productLocale") != null) {
            locale = busEnvelope.getFormValue("productLocale");
        }
        return locale;
    }

    public static boolean isAuthenticationFaultEnvelope(BIBusEnvelope envelope) {
        if (envelope != null) {
            String sMessageString = envelope.getFaultString();
            Element camHeader = envelope.getCAM();
            Element promptingInfo = null;
            if (camHeader != null) {
                promptingInfo = (Element)camHeader.selectSingleNode("*[local-name()='exception']//*[local-name()='promptInfo']");
            }
            return sMessageString != null && sMessageString.indexOf("QE-DEF-0313") != -1 || promptingInfo != null;
        }
        return false;
    }

    public static String getProductLocale(ICognosViewerState state) {
        String sProductLocale = state.getFormFieldAsString("lang");
        if (sProductLocale.length() == 0 && (sProductLocale = state.getFormFieldAsString("productLocale")).length() == 0) {
            sProductLocale = state.getUserPreference("productLocale");
        }
        return sProductLocale;
    }

    public static String getContentLocale(ICognosViewerState state) {
        String sContentLocale = state.getFormFieldAsString("lang");
        if (sContentLocale.length() == 0) {
            RunOptionLanguageArray contentLocale;
            String[] locales;
            if (state.getOptionManager() != null && state.getOptionManager().getOption(RunOptionEnum.outputLocale.getValue()) != null && (locales = (contentLocale = (RunOptionLanguageArray)state.getOptionManager().getOption(RunOptionEnum.outputLocale.getValue())).getValue()).length > 0) {
                sContentLocale = locales[0];
            }
            if (sContentLocale.length() == 0 && (sContentLocale = state.getFormFieldAsString("ui.contentLocale")).length() == 0) {
                sContentLocale = state.getUserPreference("contentLocale");
            }
        }
        return sContentLocale;
    }

    public static boolean isViewerBidiEnabled(ICognosViewerState state) {
        boolean bIsBidiEnabled = false;
        String sFormField = state.getFormFieldAsString("biDirectional.http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#biDirectionalFeaturesEnabled");
        if (sFormField.length() > 0) {
            return "true".equals(sFormField);
        }
        String bidiUserPref = state.getUserPreference("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#biDirectionalFeaturesEnabled");
        if (bidiUserPref != null && bidiUserPref.equalsIgnoreCase("true")) {
            bIsBidiEnabled = true;
        }
        return bIsBidiEnabled;
    }

    public static String getViewerBaseTextDirection(ICognosViewerState state) {
        String sBaseTextDirection = "";
        String btd = state.getUserPreference("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#baseTextDirection");
        if (btd != null) {
            if (btd.equalsIgnoreCase("http://developer.cognos.com/ceba/constants/baseTextDirectionEnum#LTR")) {
                sBaseTextDirection = "ltr";
            } else if (btd.equalsIgnoreCase("http://developer.cognos.com/ceba/constants/baseTextDirectionEnum#RTL")) {
                sBaseTextDirection = "rtl";
            } else if (btd.equalsIgnoreCase("http://developer.cognos.com/ceba/constants/baseTextDirectionEnum#Auto")) {
                sBaseTextDirection = "auto";
            }
        }
        return sBaseTextDirection;
    }

    public void validateParameters(MessageContext messageContext) throws CognosViewerException {
        if (CognosViewerDispatcherHandler.getConfigValues().getBoolean("validationActive")) {
            URLValidator uv = new URLValidator();
            List formFieldVars = this.m_biBusEnvelope.getFormFieldValues();
            ListIterator iterator = formFieldVars.listIterator();
            while (iterator.hasNext()) {
                NameValuePair formFieldVar = (NameValuePair)iterator.next();
                String formFieldName = formFieldVar.getName();
                String formFieldValue = formFieldVar.getValue();
                try {
                    uv.buildInputData(formFieldName, formFieldValue);
                }
                catch (Exception e) {
                    this.getIPFLogger().error("Caught exception in validateParameters: " + e.getMessage(), e, this.getClass().getName());
                }
            }
            uv.validate(this.m_biBusEnvelope);
        }
    }

    private void initializeWebContentRoot() {
        if (this.getFormFieldAsString("cv.webcontent").length() > 0) {
            this.m_sWebContentRoot = EncodingUtility.htmlencode(this.getFormFieldAsString("cv.webcontent"));
        } else {
            Element headerSession = this.m_biBusEnvelope.getHdrSession();
            if (headerSession != null) {
                Element webContentRoot = (Element)headerSession.selectSingleNode("*[local-name()='environmentVars']/item[name='WEB_CONTENT_ROOT']/value");
                this.m_sWebContentRoot = webContentRoot != null ? webContentRoot.getStringValue() : "..";
            }
        }
    }

    private void initializeFormFields() throws CognosViewerException {
        boolean isModifyReportAction;
        List formFieldVars = this.m_biBusEnvelope.getFormFieldValues();
        ListIterator iterator = formFieldVars.listIterator();
        boolean bURLContainersParameters = false;
        String sAction = this.m_biBusEnvelope.getFormValue("ui.action");
        boolean bl = isModifyReportAction = sAction != null && "modifyReport".equals(sAction);
        while (iterator.hasNext()) {
            NameValuePair formFieldVar = (NameValuePair)iterator.next();
            String formFieldName = formFieldVar.getName();
            String formFieldValue = formFieldVar.getValue();
            if (formFieldValue.length() == 0) continue;
            if (formFieldName.startsWith("generic.") || formFieldName.startsWith("run.") || formFieldName.startsWith("asynch.") || formFieldName.startsWith("drill.") || formFieldName.startsWith("specification.") || formFieldName.startsWith("system.")) {
                this.m_optionManager.addOption(formFieldName, formFieldValue);
                continue;
            }
            if (formFieldName.startsWith("p_")) {
                bURLContainersParameters = true;
                try {
                    this.m_parameterValueManager.addParameterValue(formFieldName, formFieldValue);
                }
                catch (CognosViewerException ex) {
                    this.getIPFLogger().error("Caught exception in initializeFormFields: " + ex.getMessage(), ex, this.getClass().getName());
                }
                continue;
            }
            if (formFieldName.startsWith("cp_")) {
                this.m_parameterValueManager.addParametersToClear(formFieldName);
                continue;
            }
            if (formFieldName.startsWith("_")) continue;
            this.m_urlInterface.put(formFieldName, formFieldValue);
            if (isModifyReportAction || !formFieldName.equals("parameterValues") && !formFieldName.equals("ui.spec") && !formFieldName.equals("authoredDrill.request")) continue;
            this.m_biBusEnvelope.removeFormValue(formFieldName);
        }
        this.initializeIsBux();
        this.initializeCVID();
        if (this.isBUX() && !bURLContainersParameters) {
            this.m_urlInterface.remove("widget.userParameters");
            this.m_biBusEnvelope.removeFormValue("widget.userParameters");
        }
    }

    @Override
    public void setAllowSpecModification(boolean bAllow) {
        this.m_bAllowSpecModification = bAllow;
    }

    @Override
    public boolean getAllowSpecModification() {
        return this.m_bAllowSpecModification;
    }

    public void processIncomingReportSpec(String reportSpec) throws CognosViewerException {
        if (reportSpec != null) {
            boolean isSpecEncoded = !reportSpec.startsWith("<");
            boolean isReportAuthor = this.m_capabilities.hasCapability("canUseReportStudio");
            String sAction = this.m_biBusEnvelope.getFormValue("ui.action");
            if (!isSpecEncoded && !isReportAuthor) {
                this.setAllowSpecModification(false);
            }
            if (isSpecEncoded) {
                this.m_urlInterface.put("ui.spec", XTSExt.web64decode((String)Protect.cafaction("sign_unwrap", reportSpec), (boolean)true));
            } else if (!(!this.isBUX() || isReportAuthor || "bux".equals(sAction) || "runBux".equals(sAction) || "buxRunSpec".equals(sAction))) {
                throw new CognosViewerException(this.getBusEnvelope(), MessageManager.convert("RV_COGNOS_VIEWER_REPORT_SPECIFICATION_FACTORY_ERROR", CognosViewerDispatcherHandlerState.getProductLocale(this)), null);
            }
        }
    }

    public void processOutgoingFormFields() {
        if (!(this.getFormFieldAsString("ui.spec").length() <= 0 || this.isBUX() && this.m_capabilities.hasCapability("canUseReportStudio"))) {
            CAMPassport passport = this.getCAMPassport();
            this.setFormFieldFromString("ui.spec", Protect.cafaction("sign_wrap_setpassportid_" + passport.getId(), XTSExt.web64encode((String)this.getFormFieldAsString("ui.spec"), (boolean)true)));
        }
    }

    @Override
    public void setReportSpecification(String spec) throws CognosViewerException {
        this.setFormFieldFromString("ui.spec", spec);
        if (this.getFormFieldAsString("modelPath").length() == 0 && spec != null && spec.length() > 0) {
            try {
                Document document = XMLUtility.createXMLDocument(spec);
                Element modelPath = (Element)document.getRootElement().selectSingleNode(".//*[local-name()='modelPath']");
                if (modelPath != null) {
                    this.setFormFieldFromString("modelPath", modelPath.getText());
                }
            }
            catch (Exception ex) {
                CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
                throw cognosViewerException;
            }
        }
    }

    public void initializeCVID() {
        String cvId = this.getFormFieldAsString("cv.id");
        if (cvId.length() == 0) {
            String sResponseFormat = this.getFormFieldAsString("cv.responseFormat");
            String sAction = this.getFormFieldAsString("ui.action");
            cvId = "fragment".equals(sResponseFormat) || "view".equals(sAction) ? "_THIS_" : "_NS_";
            this.m_urlInterface.put("cv.id", cvId);
        }
        this.m_urlInterface.put("CV_jsID", "window.oCV" + cvId);
    }

    @Override
    public void initializeXslRunOptions() {
        String sAction = this.getFormFieldAsString("ui.action");
        if ("".equals(sAction) || "output".equals(sAction) || "view".equals(sAction) || "run".equals(sAction) || "runSpecification".equals(sAction) || "new".equals(sAction) || "edit".equals(sAction) || "buxRunSpecification".equals(sAction) || "modifyCMReport".equals(sAction)) {
            String noRsvpGeneratedCtxId;
            String sRSAlias;
            String sCVDrill;
            String sCVContextInfo;
            String sCVSelection;
            String sCVId;
            ArrayList<NameValue> nameValueArrayOptions = new ArrayList<NameValue>();
            NameValue nameValue = new NameValue();
            nameValue.setName("CVObjectRef");
            nameValue.setValue("window.oCV");
            nameValueArrayOptions.add(nameValue);
            nameValue = new NameValue();
            nameValue.setName("webRoot");
            nameValue.setValue(this.getWebContentRoot());
            nameValueArrayOptions.add(nameValue);
            nameValue = new NameValue();
            nameValue.setName("CVSCObjectRef");
            nameValue.setValue("window.oCVSC");
            nameValueArrayOptions.add(nameValue);
            nameValue = new NameValue();
            nameValue.setName("UseCDATASections");
            boolean bUseCDATA = true;
            nameValue.setValue(Boolean.valueOf(bUseCDATA).toString());
            nameValueArrayOptions.add(nameValue);
            if (this.getFormFieldAsString("cv.gateway").length() > 0) {
                nameValue = new NameValue();
                nameValue.setName("CVGateway");
                nameValue.setValue(EncodingUtility.htmlencode(this.getFormFieldAsString("cv.gateway")));
                nameValueArrayOptions.add(nameValue);
            }
            if ((sCVId = this.getFormFieldAsString("cv.id")).length() != 0) {
                nameValue = new NameValue();
                nameValue.setName("CognosViewerID");
                nameValue.setValue(sCVId);
                nameValueArrayOptions.add(nameValue);
                nameValue = new NameValue();
                nameValue.setName("namespaceId");
                nameValue.setValue(sCVId);
                nameValueArrayOptions.add(nameValue);
                if ("_THIS_".equals(sCVId) || this.isBUX()) {
                    nameValue = new NameValue();
                    nameValue.setName("selectorId");
                    nameValue.setValue("#rt" + sCVId);
                    nameValueArrayOptions.add(nameValue);
                }
            }
            if ((sCVSelection = this.getFormFieldAsString("cv.selection")).length() != 0) {
                nameValue = new NameValue();
                nameValue.setName("CVDisableSelection");
                boolean disableSelection = Boolean.valueOf(sCVSelection);
                nameValue.setValue(Boolean.toString(!disableSelection));
                nameValueArrayOptions.add(nameValue);
            }
            if ((sCVContextInfo = this.getFormFieldAsString("cv.contextInfo")).length() != 0) {
                nameValue = new NameValue();
                nameValue.setName("selectionBasedFeatures");
                boolean enableSelection = Boolean.valueOf(sCVContextInfo);
                nameValue.setValue(Boolean.toString(enableSelection));
                nameValueArrayOptions.add(nameValue);
            }
            if ((sCVDrill = this.getFormFieldAsString("cv.drill")).length() != 0) {
                nameValue = new NameValue();
                nameValue.setName("CVDisableDrill");
                boolean disableDrill = Boolean.valueOf(sCVDrill);
                nameValue.setValue(Boolean.toString(!disableDrill));
                nameValueArrayOptions.add(nameValue);
            }
            if ((sRSAlias = this.getFormFieldAsString("rs_aliases")).length() != 0) {
                nameValue = new NameValue();
                nameValue.setName("RSIncludeAlias");
                nameValue.setValue(sRSAlias);
                nameValueArrayOptions.add(nameValue);
            }
            if ("rs".equals(this.getFormFieldAsString("cv.responseFormat")) && !"viewer".equals(this.getFormFieldAsString("cv.rsProfile"))) {
                nameValue = new NameValue();
                nameValue.setName("disableTabs");
                nameValue.setValue("true");
                nameValueArrayOptions.add(nameValue);
            }
            if ("true".equals(this.getFormFieldAsString("HTML5PromptControls")) || "mobile".equals(this.getFormFieldAsString("container"))) {
                nameValue = new NameValue();
                nameValue.setName("HTML5PromptControls");
                nameValue.setValue("true");
                nameValueArrayOptions.add(nameValue);
            }
            String UseFullPrmtCompiled = "qs".equals(this.getFormFieldAsString("cv.responseFormat")) ? "true" : "false";
            nameValue = new NameValue();
            nameValue.setName("UseFullPrmtCompiled");
            nameValue.setValue(UseFullPrmtCompiled);
            nameValueArrayOptions.add(nameValue);
            if (this.getDebugLogger().shouldGenerateIntermediateXml()) {
                nameValue = new NameValue();
                nameValue.setName("genIntermediateXML");
                nameValue.setValue("true");
                nameValueArrayOptions.add(nameValue);
            }
            if ((noRsvpGeneratedCtxId = CognosViewerDispatcherHandler.getConfigValues().getProperty("restoreOldDrillChartBehavior")) != null && noRsvpGeneratedCtxId.length() != 0) {
                nameValue = new NameValue();
                nameValue.setName("restoreOldDrillChartBehavior");
                nameValue.setValue(noRsvpGeneratedCtxId.toLowerCase());
                nameValueArrayOptions.add(nameValue);
            }
            if ("mobile".equals(this.getFormFieldAsString("container"))) {
                nameValue = new NameValue();
                nameValue.setName("container");
                nameValue.setValue(this.getFormFieldAsString("container"));
                nameValueArrayOptions.add(nameValue);
            }
            if (nameValueArrayOptions.size() > 0) {
                OptionManager optionMgr = this.getOptionManager();
                optionMgr.newRunOptionNameValueArray(RunOptionEnum.xslParameters, nameValueArrayOptions.toArray());
            }
        }
    }

    public void loadTransientSpec() throws CognosViewerException {
        this.m_globalViewerTransient.setGlobalViewerTransient(this.m_biBusEnvelope.getFormValue("globalViewerTransient"));
        this.m_globalViewerTransient.setMatchParameterNameOnly(this.m_biBusEnvelope.getFormValue("fragment.matchOnParameterNameOnly"));
        this.m_transientSpec.initialize(this.m_biBusEnvelope.getFormValue("cv.transientSpec"));
        BIBusEnvelope busEnvelope = this.getBusEnvelope();
        if (busEnvelope != null) {
            List burstItemList;
            List reportParameterList;
            String sPromptChannel = busEnvelope.getFormValue("fragment.promptChannel");
            if (sPromptChannel == null) {
                sPromptChannel = "";
            }
            if ((reportParameterList = this.m_transientSpec.getReportParameterList()) != null) {
                int iListSize = reportParameterList.size();
                for (int index = 0; index < iListSize; ++index) {
                    String sParameterValue;
                    Element reportParameter = (Element)reportParameterList.get(index);
                    String sParameterName = reportParameter.attributeValue("parameterName");
                    String formValue = busEnvelope.getFormValue("p_" + sParameterName);
                    if (formValue != null && formValue.length() != 0 || (sParameterValue = this.m_globalViewerTransient.getParameterValue(sPromptChannel, "p_" + sParameterName, this.m_transientSpec)) == null || sParameterValue.length() <= 0) continue;
                    busEnvelope.setFormField("p_" + sParameterName, sParameterValue);
                }
            }
            if ((burstItemList = this.m_transientSpec.getBurstItemList()) != null) {
                int iBurstItemListSize = burstItemList.size();
                for (int index = 0; index < iBurstItemListSize; ++index) {
                    String sParameterValue;
                    Element burstItem = (Element)burstItemList.get(index);
                    String sBurstName = burstItem.attributeValue("burstName");
                    String formValue = busEnvelope.getFormValue("p_" + sBurstName);
                    if (formValue != null && formValue.length() != 0 || (sParameterValue = this.m_globalViewerTransient.getParameterValue(sPromptChannel, "p_" + sBurstName, this.m_transientSpec)) == null || sParameterValue.length() <= 0) continue;
                    busEnvelope.setFormField("p_" + sBurstName, "");
                }
            }
        }
    }

    @Override
    public TransientSpec getTransientSpec() {
        return this.m_transientSpec;
    }

    public void initializeCAMPassport() {
        Element camId;
        Element camPassport;
        Element cam = this.m_biBusEnvelope.getCAM();
        if (cam != null && (camPassport = cam.element("CAMPassport")) != null && (camId = camPassport.element("id")) != null && camId.getText().length() > 0) {
            this.m_camPassport = new CAMPassport();
            this.m_camPassport.setId(camId.getText());
        }
    }

    private Tracking initializeTracking() {
        Tracking tracking = null;
        if (this.m_biBusEnvelope != null) {
            Element sessionContextNode;
            tracking = new Tracking();
            Element trackingNode = this.m_biBusEnvelope.getTracking();
            if (trackingNode == null) {
                return tracking;
            }
            Element requestContextNode = trackingNode.element("requestContext");
            if (requestContextNode != null) {
                tracking.setRequestContext(requestContextNode.getText());
            }
            if ((sessionContextNode = trackingNode.element("sessionContext")) != null) {
                tracking.setSessionContext(sessionContextNode.getText());
            }
        }
        return tracking;
    }

    @Override
    public String getFormFieldAsString(String sFormFieldName) {
        String sFormFieldValue = this.m_urlInterface.get(sFormFieldName);
        if (sFormFieldValue == null) {
            return "";
        }
        return sFormFieldValue;
    }

    @Override
    public void setFormFieldFromString(String sFormFieldName, String sFormFieldValue) {
        this.m_urlInterface.put(sFormFieldName, sFormFieldValue);
    }

    @Override
    public void setFormFieldFromString(String sFormFieldName, String sFormFieldValue, boolean bOverrideExisting) {
        if (this.getFormFieldAsString(sFormFieldName).length() == 0 || bOverrideExisting) {
            this.setFormFieldFromString(sFormFieldName, sFormFieldValue);
        }
    }

    @Override
    public void removeFormField(String sFormFieldName) {
        this.m_urlInterface.remove(sFormFieldName);
    }

    @Override
    public CAMPassport getCAMPassport() {
        return this.m_camPassport;
    }

    @Override
    public Tracking getTracking() {
        String sTracking = this.getFormFieldAsString("m_tracking");
        Tracking tracking = new Tracking();
        if (sTracking.length() > 0) {
            try {
                sTracking = XTSExt.web64decode((String)Protect.cafaction("sign_unwrap", sTracking), (boolean)true);
                Document doc = XMLUtility.createXMLDocument(sTracking);
                Element conversationContextNode = doc.getRootElement();
                if (conversationContextNode != null) {
                    Element status;
                    Element conversationContextAffinityStrength;
                    Element conversationContextProcessId;
                    Element conversationContextNodeId;
                    ConversationContext conversationContext = new ConversationContext();
                    Element conversationContextId = conversationContextNode.element("id");
                    if (conversationContextId != null) {
                        conversationContext.setId(conversationContextId.getText());
                    }
                    if ((conversationContextNodeId = conversationContextNode.element("nodeID")) != null) {
                        conversationContext.setNodeID(conversationContextNodeId.getText());
                    }
                    if ((conversationContextProcessId = conversationContextNode.element("processID")) != null) {
                        conversationContext.setProcessID(Integer.parseInt(conversationContextProcessId.getText()));
                    }
                    if ((conversationContextAffinityStrength = conversationContextNode.element("affinityStrength")) != null) {
                        conversationContext.setAffinityStrength(Integer.parseInt(conversationContextAffinityStrength.getText()));
                    }
                    if ((status = conversationContextNode.element("status")) != null) {
                        conversationContext.setStatus(status.getText());
                    }
                    tracking.setConversationContext(conversationContext);
                }
            }
            catch (Exception exception) {
                this.getIPFLogger().error("Caught exception in getTracking: " + exception.getMessage(), exception, this.getClass().getName());
            }
        } else {
            tracking = this.initializeTracking();
        }
        return tracking;
    }

    @Override
    public void clearConversation() {
        this.m_conversation = null;
    }

    @Override
    public AsynchRequest getConversation() {
        if (this.m_conversation != null) {
            return this.m_conversation;
        }
        String sConversation = this.getFormFieldAsString("ui.conversation");
        if (sConversation.length() > 0) {
            try {
                sConversation = XTSExt.web64decode((String)Protect.cafaction("sign_unwrap", sConversation), (boolean)true);
                Document doc = XMLUtility.createXMLDocument(sConversation);
                Element asynchRequestNode = doc.getRootElement();
                ConversationMarshaller conversationMarshaller = new ConversationMarshaller(null);
                this.m_conversation = conversationMarshaller.unmarshall(asynchRequestNode);
            }
            catch (Exception exception) {
                this.getIPFLogger().error("Caught exception in getConversation: " + exception.getMessage(), exception, this.getClass().getName());
            }
        }
        return this.m_conversation;
    }

    @Override
    public SearchPathSingleObject getObjectPath() {
        SearchPathSingleObject objectPath = new SearchPathSingleObject();
        objectPath.set_value(this.getFormFieldAsString("ui.object"));
        return objectPath;
    }

    @Override
    public void updateSpecificationContents(String updatedSpecification) throws CognosViewerException {
        if (this.m_asynchSpecification != null && this.m_asynchSpecification.getValue() != null) {
            if (updatedSpecification.startsWith("<")) {
                this.m_asynchSpecification.getValue().set_value(updatedSpecification);
            } else {
                this.m_asynchSpecification.getValue().set_value(XTSExt.web64decode((String)Protect.cafaction("sign_unwrap", updatedSpecification), (boolean)true));
            }
        }
        this.setReportSpecification(updatedSpecification);
    }

    @Override
    public AsynchSpecification getSpecification() {
        if (this.m_asynchSpecification != null) {
            return this.m_asynchSpecification;
        }
        String sSpecification = this.getFormFieldAsString("ui.spec");
        if (sSpecification.length() > 0) {
            String sSpecificationType = this.getSpecificationType();
            if (sSpecificationType.length() == 0) {
                sSpecificationType = "reportServiceReportSpecification";
            }
            CognosViewerReportSpecificationFactory specificationFactory = new CognosViewerReportSpecificationFactory();
            try {
                this.m_asynchSpecification = specificationFactory.load(sSpecificationType);
                Specification specification = new Specification();
                specification.set_value(sSpecification);
                this.m_asynchSpecification.setValue(specification);
                return this.m_asynchSpecification;
            }
            catch (CognosViewerException ex) {
                this.m_asynchSpecification = null;
                this.getIPFLogger().error("Caught exception in getSpecification: " + ex.getMessage(), ex, this.getClass().getName());
            }
        }
        return null;
    }

    @Override
    public String getSpecificationType() {
        return this.getFormFieldAsString("specificationType");
    }

    @Override
    public ParameterValueManager getParameterValueManager() {
        return this.m_parameterValueManager;
    }

    @Override
    public void setParmaeterValueManager(ParameterValueManager paramManager) {
        this.m_parameterValueManager = paramManager;
    }

    @Override
    public OptionManager getOptionManager() {
        return this.m_optionManager;
    }

    @Override
    public String getAction() {
        String sAction = this.getFormFieldAsString("ui.action");
        if (!this.isBUX() && sAction.compareTo("run") == 0 && this.getFormFieldAsString("ui.spec").length() != 0) {
            sAction = "runSpecification";
        }
        return sAction;
    }

    @Override
    public String getActionSpecification() {
        return null;
    }

    @Override
    public String getResponseFormat() {
        String sResponseFormat = this.getFormFieldAsString("cv.responseFormat");
        if (sResponseFormat.compareTo("") == 0) {
            String sAction = this.getAction();
            sResponseFormat = sAction.compareTo("view") == 0 ? "view" : "page";
        }
        return sResponseFormat;
    }

    @Override
    public Capabilities getCapabilities() {
        return this.m_capabilities;
    }

    @Override
    public CognosViewerBlacklist getUIBlacklist() {
        return this.m_cognosViewerBlacklist;
    }

    @Override
    public CognosViewerSystemParams getSystemParams() {
        return null;
    }

    @Override
    public String getUserPreference(String sName) {
        String sValue = "";
        if (this.m_biBusEnvelope != null) {
            sValue = this.m_biBusEnvelope.getUserPreferenceValue(sName);
        }
        return sValue;
    }

    @Override
    public String getEnvironmentVariable(String sName) {
        String sValue = "";
        if (this.m_biBusEnvelope != null) {
            String gw;
            sValue = "SCRIPT_NAME".equals(sName) ? ("fragment".equals(this.getResponseFormat()) ? this.getFragmentGateway() : ((gw = this.getFormFieldAsString("cv.gateway")).length() != 0 ? gw : this.m_biBusEnvelope.getEnvironmentValue(sName))) : this.m_biBusEnvelope.getEnvironmentValue(sName);
        }
        if (sValue == null) {
            return "";
        }
        return sValue;
    }

    @Override
    public NameValuePair[] getFormFields() {
        int iNumberOfFormFieldItems = this.m_urlInterface.size();
        NameValuePair[] formFieldItems = new NameValuePair[iNumberOfFormFieldItems];
        Iterator<Map.Entry<String, String>> iterator = this.m_urlInterface.entrySet().iterator();
        int iIndex = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, String> mapEntry = iterator.next();
            formFieldItems[iIndex] = new NameValuePair();
            formFieldItems[iIndex].setName(mapEntry.getKey());
            formFieldItems[iIndex].setValue(mapEntry.getValue());
            ++iIndex;
        }
        return formFieldItems;
    }

    @Override
    public BIBusEnvelope getBusEnvelope() {
        return this.m_biBusEnvelope;
    }

    public void setIPFLogger(IPFLogger ipfLogger) {
        this.m_ipfLogger = ipfLogger;
        this.m_ipfLogger.setDebugLogger(this.m_debugLogger);
    }

    @Override
    public IPFLogger getIPFLogger() {
        if (this.m_ipfLogger == null) {
            this.m_ipfLogger = IPFLogger.getInstance();
        }
        return this.m_ipfLogger;
    }

    @Override
    public CognosViewerSessionManager getSessionManager() {
        return this.m_cognosViewerSessionParams;
    }

    @Override
    public String getWebContentRoot() {
        return this.m_sWebContentRoot;
    }

    @Override
    public DebugLogger getDebugLogger() {
        return this.m_debugLogger;
    }

    @Override
    public boolean useAjax() {
        if (CognosViewerDispatcherHandler.getConfigValues().getProperty("useAjax") != null) {
            return !"false".equals(CognosViewerDispatcherHandler.getConfigValues().getProperty("useAjax"));
        }
        return !"false".equals(this.getFormFieldAsString("cv.useAjax"));
    }

    @Override
    public List getCleanupList() {
        return this.m_connectionCleanupList;
    }

    @Override
    public void addToCleanupList(ServerConnection connection) {
        this.m_connectionCleanupList.add(connection);
    }

    @Override
    public void releaseConnections() {
        for (ServerConnection connection : this.m_connectionCleanupList) {
            connection.release();
        }
        this.m_connectionCleanupList.clear();
    }

    public boolean isConnectionInUse() {
        for (ServerConnection connection : this.m_connectionCleanupList) {
            if (!connection.isConnectionInUse()) continue;
            return true;
        }
        return false;
    }

    @Override
    public InputStream getAttachmentInputStream() {
        return this.m_attachmentInputStream;
    }

    @Override
    public void setAttachmentInputStream(InputStream stream) {
        this.m_attachmentInputStream = stream;
    }

    @Override
    public void setSetCookiesFromSOAPResponse(BIBusEnvelope responseEnvelope) {
        Element setCookieVars = responseEnvelope.getSetCookieVars();
        if (setCookieVars != null) {
            List items = setCookieVars.selectNodes("./*[local-name()='item']");
            for (Element setCookieVar : items) {
                Element name = (Element)setCookieVar.selectSingleNode("./*[local-name()='name']");
                if (name == null) continue;
                this.m_cookies.put(name.getText(), (Element)setCookieVar.clone());
            }
        }
    }

    public void addSetCookiesToSOAPHeader(BIBusEnvelope requestEnvelope) {
        Set<String> cookieKeys = this.m_cookies.keySet();
        for (String sCookieName : cookieKeys) {
            Element setCookieVar = this.m_cookies.get(sCookieName);
            String sCookieValue = "";
            Element cookieValue = (Element)setCookieVar.selectSingleNode("./*[local-name()='value']");
            if (cookieValue != null) {
                sCookieValue = cookieValue.getText();
            }
            int iCookieMaxAge = 0;
            Element maxAge = (Element)setCookieVar.selectSingleNode("./*[local-name()='maxAge']");
            if (maxAge != null) {
                try {
                    iCookieMaxAge = Integer.parseInt(maxAge.getText());
                }
                catch (NumberFormatException e) {
                    iCookieMaxAge = 0;
                    this.getIPFLogger().debug("exception in addSetCookiesToSOAPHeader, cookie age not a valid int - " + maxAge.getText(), this.getClass().getName());
                }
            }
            requestEnvelope.setSetCookie(sCookieName, sCookieValue, iCookieMaxAge);
        }
    }

    @Override
    public void addObject(String key, Object object) {
        this.m_objects.put(key, object);
    }

    @Override
    public Object getObject(String key) {
        return this.m_objects.get(key);
    }

    @Override
    public boolean isAccessibleMode() {
        String sResponseFormat = this.getFormFieldAsString("cv.responseFormat");
        if ("fragment".equals(sResponseFormat) || "rs".equals(sResponseFormat) || "qs".equals(sResponseFormat)) {
            return false;
        }
        if ("false".equals(CognosViewerDispatcherHandler.getOverrideAccessibility())) {
            return false;
        }
        if ("true".equals(CognosViewerDispatcherHandler.getOverrideAccessibility())) {
            return true;
        }
        if (this.m_optionManager.getOption("http://developer.cognos.com/ceba/constants/systemOptionEnum#accessibilityFeatures") != null) {
            return ((GenericOptionBoolean)this.m_optionManager.getOption("http://developer.cognos.com/ceba/constants/systemOptionEnum#accessibilityFeatures")).isValue();
        }
        if (this.getUserPreference("http://developer.cognos.com/ceba/constants/systemOptionEnum#accessibilityFeatures") != null && this.getUserPreference("http://developer.cognos.com/ceba/constants/systemOptionEnum#accessibilityFeatures").length() > 0) {
            return "true".equals(this.getUserPreference("http://developer.cognos.com/ceba/constants/systemOptionEnum#accessibilityFeatures"));
        }
        return "true".equals(CognosViewerDispatcherHandler.getServiceDefaultAccessibility());
    }

    @Override
    public boolean isFlashChartOptionDisabled() {
        return !CognosViewerDispatcherHandler.getGoDBCompatMode();
    }

    @Override
    public int getVisCoachMode() {
        return CognosViewerDispatcherHandler.getVisCoachMode();
    }

    public boolean isAddLocalizeLabelsAction() {
        return CognosViewerDispatcherHandler.isAddLocalizeLabelsAction();
    }

    @Override
    public boolean getDefaultFlashChartOptionValue() {
        GenericOptionBoolean option = (GenericOptionBoolean)this.getOptionManager().getOption("http://developer.cognos.com/ceba/constants/systemOptionEnum#flashCharts");
        boolean bFlashChartOption = false;
        String sFlashChartOption = this.getFormFieldAsString("savedFlashChartOption");
        if (sFlashChartOption.length() == 0) {
            return false;
        }
        bFlashChartOption = "true".equals(sFlashChartOption);
        return bFlashChartOption;
    }

    @Override
    public boolean doParametersNeedCafProtection() {
        boolean result = "true".equals(this.getFormFieldAsString("protectParameters"));
        String responseFormat = this.getResponseFormat();
        if ("qs".equals(responseFormat)) {
            result = true;
        }
        return result;
    }

    public String getStateInfo(ICognosViewerActionResponse actionResponse) {
        StringBuilder sbResult = new StringBuilder();
        sbResult.append("<root>");
        sbResult.append("<formFields>");
        this.outputHashMap(sbResult, "formField", this.m_urlInterface);
        sbResult.append("</formFields>");
        try {
            Element parameters = DocumentHelper.createElement((String)"parameters");
            ParametersMarshaller parametersMarshaller = new ParametersMarshaller(this.getParameterValueManager().toArray());
            parametersMarshaller.marshall(parameters);
            sbResult.append(parameters.asXML());
        }
        catch (Exception e) {
            sbResult.append("<fault>" + EncodingUtility.xmlencode(e.toString()) + "</fault>");
        }
        try {
            Element options = DocumentHelper.createElement((String)"options");
            OptionMarshaller optionMarshaller = new OptionMarshaller(this.getOptionManager().toArray());
            optionMarshaller.marshall(options);
            sbResult.append(options.asXML());
        }
        catch (Exception e) {
            sbResult.append("<fault>" + EncodingUtility.xmlencode(e.toString()) + "</fault>");
        }
        sbResult.append("<objects>");
        this.outputHashMap(sbResult, "object", this.m_objects);
        sbResult.append("</objects>");
        if (this.m_cookies.size() > 0) {
            sbResult.append("<cookies>");
            this.outputHashMap(sbResult, "object", this.m_cookies);
            sbResult.append("</cookies>");
        }
        if (actionResponse != null) {
            CAMPassport passport = actionResponse.getCAMPassport();
            BIBusEnvelope busResponse = actionResponse.getBusEnvelope();
            if (busResponse != null) {
                Element trackingNode;
                Element soapBody = busResponse.getBody();
                if (soapBody != null) {
                    Element asynchRequestNode = (Element)soapBody.selectSingleNode("./*/*[local-name()='result']/*[local-name()='primaryRequest']");
                    String sConversation = "";
                    if (asynchRequestNode != null && passport != null) {
                        sbResult.append("<conversation>");
                        sbResult.append(XTSExt.web64encode((String)asynchRequestNode.asXML(), (boolean)true));
                        sbResult.append("</conversation>");
                    }
                }
                if ((trackingNode = busResponse.getTracking()) != null && !(actionResponse instanceof CMServerResponse)) {
                    Element conversationContextNode = trackingNode.element(BIBusEnvelope.BUS_CONVERSATION_CONTEXT);
                    String sTracking = "";
                    if (conversationContextNode != null && passport != null) {
                        sbResult.append("<tracking>");
                        sbResult.append(XTSExt.web64encode((String)conversationContextNode.asXML(), (boolean)true));
                        sbResult.append("</tracking>");
                    }
                }
            }
        }
        sbResult.append("</root>");
        return sbResult.toString();
    }

    private void outputHashMap(StringBuilder sbResult, String sItemHint, HashMap map) {
        TreeSet sortedSet = new TreeSet(map.keySet());
        for (String key : sortedSet) {
            if ("rapRequestCache".equals(key) || "cv.actionState".equals(key) || "metadataInformationURI".equals(key) || "cv.debugDirectory".equals(key) || "cv.debug".equals(key)) continue;
            sbResult.append("<").append(sItemHint).append(">");
            sbResult.append("<name>");
            sbResult.append(EncodingUtility.xmlencode(key));
            sbResult.append("</name>");
            sbResult.append("<value>");
            Object obj = map.get(key);
            if (obj instanceof String) {
                sbResult.append(EncodingUtility.xmlencode((String)obj));
            } else if (obj instanceof Element) {
                sbResult.append(EncodingUtility.xmlencode(((Element)obj).asXML()));
            } else {
                sbResult.append("Unknown type");
            }
            sbResult.append("</value>");
            sbResult.append("</").append(sItemHint).append(">");
        }
    }

    public static boolean isIROTReport(ICognosViewerState state) {
        return "interactiveReport".equals(state.getFormFieldAsString("ui.objectClass")) || "reportServiceInteractiveReportSpecification".equals(state.getSpecificationType()) || "interactiveReport".equals(state.getFormFieldAsString("baseReportObjectClass"));
    }

    @Override
    public boolean isDroppingReportBUXAction() {
        boolean isDroppingReport = false;
        String dropping_report = this.getFormFieldAsString("ui.reportDrop");
        if (null != dropping_report && dropping_report.length() > 0 && "true".equals(dropping_report)) {
            isDroppingReport = true;
        }
        return isDroppingReport;
    }

    public static boolean isMasters() {
        return "true".equals(System.getProperty("viewerMasters"));
    }

    public void setDelayedOutput(DelayedOutput delayedOutput) {
        this.m_delayedOuptut = delayedOutput;
    }

    public DelayedOutput getDelayedOutput() {
        return this.m_delayedOuptut;
    }

    @Override
    public FragmentState getFragmentState() {
        return this.m_fragmentState;
    }

    @Override
    public String getCookieValue(String name) {
        return this.m_biBusEnvelope.getCookieValue(name);
    }

    public void setHeaders(InternetHeaders headers) {
        this.headers = headers;
    }

    public InternetHeaders getHeaders() {
        return this.headers;
    }
}

