/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model;

import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.utility.MessageManager;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

public class CognosViewerServiceFactory {
    public static final Integer REPORTSERVICEREQUEST = 0;
    public static final Integer CMSERVICEREQUEST = 1;
    public static final Integer DELIVERYSERVICEREQUEST = 2;
    public static final Integer POWERPLAYSERVICEREQUEST = 3;
    public static final Integer CMCACHESERVICEREQUEST = 4;
    public static final Integer ANNOTATIONSERVICEREQUEST = 5;
    private HashMap m_aServices;
    private URL m_serverURL;
    private URL m_cmURL;
    private static HashMap<String, Integer> m_serviceMap = new HashMap();

    public CognosViewerServiceFactory(String sServerURL, String sCMURL) throws CognosViewerException {
        try {
            this.m_serverURL = new URL(sServerURL);
            this.m_cmURL = new URL(sCMURL);
        }
        catch (MalformedURLException mue) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, "The URL is incorrect." + sServerURL + "\t" + mue.getMessage(), mue);
            throw cognosViewerException;
        }
        this.m_aServices = new HashMap();
    }

    public URL getServerURL() {
        return this.m_serverURL;
    }

    public URL getCMURL() {
        return this.m_cmURL;
    }

    public boolean setService(Integer iServiceId, String sService) throws CognosViewerException {
        if (sService != null && sService.length() > 0) {
            try {
                Class<?> serviceClass = null;
                serviceClass = sService.indexOf("MockMaster") >= 0 ? Class.forName("junit.masters." + sService) : (sService.indexOf("Mock") >= 0 ? Class.forName("junit.model." + sService) : Class.forName("com.cognos.viewer.model." + sService));
                Class[] paramTypes = new Class[]{URL.class};
                Constructor<?> serviceConstructor = serviceClass.getConstructor(paramTypes);
                this.m_aServices.put(iServiceId, serviceConstructor);
            }
            catch (Exception ex) {
                Object serviceConstructor = null;
                CognosViewerException cognosViewerException = new CognosViewerException(null, MessageManager.convert("RV_COGNOS_VIEWER_SERVICE_FACTORY_ERROR", "en"), ex);
                throw cognosViewerException;
            }
        }
        return true;
    }

    public Integer getServerIDFromObjectClass(String sObjectClass) {
        if (m_serviceMap.containsKey(sObjectClass)) {
            return m_serviceMap.get(sObjectClass);
        }
        return REPORTSERVICEREQUEST;
    }

    public ICognosViewerRequest getServiceFromObjectClass(String sObjectClass) throws CognosViewerException {
        return this.getService(this.getServerIDFromObjectClass(sObjectClass));
    }

    public ICognosViewerRequest getService(Integer iServiceId) throws CognosViewerException {
        Constructor serviceConstructor = (Constructor)this.m_aServices.get(iServiceId);
        if (serviceConstructor != null) {
            try {
                URL serviceURL = CMSERVICEREQUEST.compareTo(iServiceId) == 0 ? this.m_cmURL : this.m_serverURL;
                Object[] args = new Object[]{serviceURL};
                return (ICognosViewerRequest)serviceConstructor.newInstance(args);
            }
            catch (Exception ex) {
                CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
                throw cognosViewerException;
            }
        }
        return null;
    }

    static {
        m_serviceMap.put("powerPlay8Report", POWERPLAYSERVICEREQUEST);
        m_serviceMap.put("powerPlay8ReportView", POWERPLAYSERVICEREQUEST);
        m_serviceMap.put("powerPlayReport", POWERPLAYSERVICEREQUEST);
    }
}

